/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import org.apache.log4j.Logger;
import org.geotools.geometry.jts.JTS;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpatialUtils {
    private static final Logger logger = Logger.getLogger(SpatialUtils.class);
    private static final Geometry THE_WORLD = JTS.toGeometry((Envelope)new Envelope(-180.0, 180.0, -90.0, 90.0));
    private static final double TO_DEG = Math.toDegrees(1.0);
    public static final double EARTH_RADIUS_MEAN = 6371.0072;
    public static final double EARTH_RADIUS_EQUATORIAL = 6378.137;
    public static final double EARTH_RADIUS_POLAR = 6356.7523;

    @Deprecated
    public static String getInverseWKT(String wkt) {
        try {
            String text = null;
            if (wkt.startsWith("GEOMETRYCOLLECTION")) {
                try {
                    WKTReader r = new WKTReader();
                    GeometryCollection gc = (GeometryCollection)r.read(wkt);
                    Geometry unionGeo = null;
                    for (int i = 0; i < gc.getNumGeometries(); ++i) {
                        Geometry g = gc.getGeometryN(i);
                        unionGeo = unionGeo == null ? g : unionGeo.union(g);
                    }
                    Geometry newOne = THE_WORLD.difference(unionGeo);
                    text = newOne.toText();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                WKTReader r = new WKTReader();
                Geometry g = r.read(wkt);
                Geometry newOne = THE_WORLD.difference(g);
                text = newOne.toText();
            }
            return text.replaceAll("POLYGON ", "POLYGON").replaceAll("MULTIPOLYGON ", "MULTIPOLYGON").replaceAll(", ", ",");
        }
        catch (Exception e) {
            e.printStackTrace();
            return wkt;
        }
    }

    public static void main(String[] args) {
        System.out.println(SpatialUtils.getInverseWKT((String)"POLYGON((140 -37,151 -37,151 -26, 140.1310 -26, 140 -37))"));
        System.out.println(SpatialUtils.convertToDegrees((Float)Float.valueOf(5.0f)));
        System.out.println(SpatialUtils.convertToDegrees((Float)Float.valueOf(1.0f)));
        System.out.println(SpatialUtils.convertToDegrees((Float)Float.valueOf(10.0f)));
        System.out.println(SpatialUtils.degreesLatPerKm((double)-37.0, (double)140.0));
        String wkt = "GEOMETRYCOLLECTION(POLYGON((142.79455566406 -33.134332591089,143.03076171875 -33.134332591089,143.03076171875 -32.940923212969,142.79455566406 -32.940923212969,142.79455566406 -33.134332591089)),MULTIPOLYGON(((143.96459960936 -32.763258819119,144.28320312499 -32.763258819119,144.28320312499 -32.494938181635,143.96459960936 -32.494938181635,143.96459960936 -32.763258819119)),((144.15136718749 -31.881290617098,144.53588867187 -31.881290617098,144.53588867187 -31.58228046593,144.15136718749 -31.58228046593,144.15136718749 -31.881290617098))))";
        System.out.println(SpatialUtils.getWKTQuery((String)"geohash", (String)wkt, (boolean)false));
        System.out.println(SpatialUtils.getWKTQuery((String)"geohash", (String)wkt, (boolean)true));
        System.out.println(SpatialUtils.getInverseWKT((String)wkt));
    }

    public static double radiusAtLocation(double lat, double lon) {
        double cosL = Math.cos(lat);
        double sinL = Math.sin(lat);
        double C1 = cosL * 6378.137;
        double C2 = C1 * 6378.137;
        double C3 = sinL * 6356.7523;
        double C4 = C3 * 6356.7523;
        return Math.sqrt((C2 * C2 + C4 * C4) / (C1 * C1 + C3 * C3));
    }

    public static double degreesLatPerKm(double lat, double lon) {
        return TO_DEG / SpatialUtils.radiusAtLocation((double)lat, (double)lon);
    }

    public static Float convertToDegrees(Float kilometres) {
        if (kilometres != null) {
            return Float.valueOf(0.008995582f * kilometres.floatValue());
        }
        return kilometres;
    }

    public static String getWKTAsUnions(String wkt) {
        if (wkt.startsWith("GEOMETRYCOLLECTION")) {
            try {
                WKTReader r = new WKTReader();
                GeometryCollection gc = (GeometryCollection)r.read(wkt);
                Geometry ugeo = null;
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    Geometry g = gc.getGeometryN(i);
                    ugeo = ugeo == null ? g : ugeo.union(g);
                }
                return ugeo.toText();
            }
            catch (Exception e) {
                e.printStackTrace();
                return wkt;
            }
        }
        return wkt;
    }

    public static String getWKTQuery(String spatialField, String wkt, boolean negated) {
        String field;
        StringBuilder sb = new StringBuilder();
        String operation = negated ? " AND " : " OR ";
        String string = field = negated ? "-" + spatialField : spatialField;
        if (wkt.startsWith("GEOMETRYCOLLECTION")) {
            try {
                WKTReader r = new WKTReader();
                GeometryCollection gc = (GeometryCollection)r.read(wkt);
                sb.append("(");
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    Geometry g = gc.getGeometryN(i);
                    if (i > 0) {
                        sb.append(operation);
                    }
                    sb.append(field).append(":\"Intersects(");
                    sb.append(g.toText());
                    sb.append(")\"");
                }
                sb.append(")");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            sb.append(field).append(":\"Intersects(");
            sb.append(wkt);
            sb.append(")\"");
        }
        return sb.toString();
    }

    public static String simplifyWkt(String wkt, int maxPoints) {
        double distanceFactor = 2.0;
        double distanceInitialPrecision = 1.0E-4;
        double distanceMaxPrecision = 10.0;
        return SpatialUtils.simplifyWkt((String)wkt, (int)maxPoints, (double)2.0, (double)1.0E-4, (double)10.0);
    }

    public static String simplifyWkt(String wkt, int maxPoints, double distanceFactor, double distanceInitialPrecision, double distanceMaxPrecision) {
        WKTReader r = new WKTReader();
        try {
            Geometry g = r.read(wkt);
            if (maxPoints <= 0 || g.getNumPoints() <= maxPoints) {
                return wkt;
            }
            for (double distance = distanceInitialPrecision; distance < distanceMaxPrecision; distance *= distanceFactor) {
                g = TopologyPreservingSimplifier.simplify((Geometry)g, (double)distance);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Simplified geometry to " + g.getNumPoints() + " at distance precision " + distance));
                if (g.getNumPoints() > maxPoints) continue;
                return g.toText();
            }
            logger.warn((Object)("WKT simplification failed to achieve the required precision:  finalNumberOfPoints=" + g.getNumPoints() + " maxPoints=" + maxPoints + " distanceFactor=" + distanceFactor + " distanceInitialPrecision=" + distanceInitialPrecision + " distanceMaxPrecision=" + distanceMaxPrecision));
        }
        catch (Exception e) {
            logger.error((Object)("WKT reduction failed due to an exception: " + e.getMessage()));
        }
        return null;
    }
}

