/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadDoiDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.QualityFilterDTO;
import au.org.ala.biocache.dto.SearchRequestParams;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DataQualityService;
import au.org.ala.biocache.service.DoiService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.EmailService;
import au.org.ala.biocache.service.LoggerService;
import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.util.AlaFileUtils;
import au.org.ala.biocache.util.thread.DownloadControlThread;
import au.org.ala.biocache.util.thread.DownloadCreator;
import au.org.ala.biocache.writer.RecordWriterException;
import au.org.ala.doi.CreateDoiResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.ala.client.model.LogEventVO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.runtime.parser.ParseException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="downloadService")
public class DownloadService
implements ApplicationListener<ContextClosedEvent> {
    public static final String OFFICIAL_DOI_RESOLVER = "https://doi.org/";
    public static final String CSDM_SELECTOR = "csdm";
    public static final String DOI_SELECTOR = "doi";
    public static final String DEFAULT_SELECTOR = "default";
    private static final String DOWNLOAD_FILE_LOCATION = "[url]";
    private static final String OFFICIAL_FILE_LOCATION = "[officialDoiUrl]";
    private static final String START_DATE_TIME = "[date]";
    private static final String QUERY_TITLE = "[queryTitle]";
    private static final String SEARCH_URL = "[searchUrl]";
    private static final String DOI_FAILURE_MESSAGE = "[doiFailureMessage]";
    private static final String BCCVL_IMPORT_ID = "[bccvlImportID]";
    private static final String SUPPORT = "[support]";
    private static final String UNIQUE_ID = "[uniqueId]";
    private static final String MY_DOWNLOADS_URL = "[myDownloadsUrl]";
    private static final String HUB_NAME = "[hubName]";
    protected static final Logger logger = Logger.getLogger(DownloadService.class);
    @Value(value="${concurrent.downloads.json:[{\"label\": \"smallSolr\", \"threads\": 4, \"maxRecords\": 50000, \"type\": \"index\", \"pollDelay\": 10, \"executionDelay\": 10, \"threadPriority\": 5}, {\"label\": \"largeSolr\", \"threads\": 1, \"maxRecords\": 100000000, \"type\": \"index\", \"pollDelay\": 100, \"executionDelay\": 100, \"threadPriority\": 1}, {\"label\": \"smallCassandra\", \"threads\": 1, \"maxRecords\": 50000, \"type\": \"db\", \"pollDelay\": 10, \"executionDelay\": 10, \"threadPriority\": 5}, {\"label\": \"defaultUnrestricted\", \"threads\": 1, \"pollDelay\": 1000, \"executionDelay\": 100, \"threadPriority\": 1}]}")
    protected String concurrentDownloadsJSON;
    @Inject
    protected PersistentQueueDAO persistentQueueDAO;
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected RestOperations restTemplate;
    @Inject
    protected ObjectMapper objectMapper;
    @Inject
    protected EmailService emailService;
    @Inject
    protected LoggerService loggerService;
    @Inject
    protected AbstractMessageSource messageSource;
    @Inject
    protected DoiService doiService;
    @Inject
    protected AuthService authService;
    @Inject
    protected DataQualityService dataQualityService;
    @Value(value="${download.solr.only:false}")
    public Boolean downloadSolrOnly = Boolean.FALSE;
    @Value(value="${webservices.root:http://localhost:8080/biocache-service}")
    public String webservicesRoot = "http://localhost:8080/biocache-service";
    @Value(value="${citations.enabled:true}")
    public Boolean citationsEnabled = Boolean.TRUE;
    @Value(value="${headings.enabled:true}")
    public Boolean headingsEnabled = Boolean.TRUE;
    @Value(value="${download.readme.enabled:true}")
    public Boolean readmeEnabled = Boolean.TRUE;
    @Value(value="${download.support.email.enabled:true}")
    public Boolean supportEmailEnabled = Boolean.TRUE;
    @Value(value="${download.support.email:support@ala.org.au}")
    public String supportEmail = "support@ala.org.au";
    protected final Queue<DownloadDetailsDTO> currentDownloads = new LinkedBlockingQueue();
    @Value(value="${data.description.url:headings.csv}")
    protected String dataFieldDescriptionURL = "headings.csv";
    @Value(value="${registry.url:https://collections.ala.org.au/ws}")
    protected String registryUrl = "https://collections.ala.org.au/ws";
    @Value(value="${citations.url:https://collections.ala.org.au/ws/citations}")
    protected String citationServiceUrl = "https://collections.ala.org.au/ws/citations";
    @Value(value="${download.email.subject:ALA Occurrence Download Complete - [filename]}")
    protected String biocacheDownloadEmailSubject = "ALA Occurrence Download Complete - [filename]";
    @Value(value="${download.email.template:}")
    protected String biocacheDownloadEmailTemplate;
    @Value(value="${download.doi.resolver:https://doi.ala.org.au/doi/}")
    public String alaDoiResolver;
    @Value(value="${my.download.doi.baseUrl:https://doi.ala.org.au/myDownloads}")
    public String myDownloadsUrl;
    @Value(value="${download.support:support@ala.org.au}")
    public String support;
    @Value(value="${download.doi.email.template:}")
    protected String biocacheDownloadDoiEmailTemplate;
    @Value(value="${download.email.subject.failure:Occurrence Download Failed - [filename]}")
    protected String biocacheDownloadEmailSubjectError = "Occurrence Download Failed - [filename]";
    @Value(value="${download.email.body.error:Your [hubName] download has failed.}")
    protected String biocacheDownloadEmailBodyError = "Your [hubName] download has failed.";
    @Value(value="${download.readme.template:}")
    protected String biocacheDownloadReadmeTemplate;
    @Value(value="${download.doi.readme.template:}")
    protected String biocacheDownloadDoiReadmeTemplate;
    @Value(value="${download.doi.failure.message:}")
    protected String biocacheDownloadDoiFailureMessage;
    @Value(value="${download.doi.title.prefix:Occurrence download }")
    protected String biocacheDownloadDoiTitlePrefix = "Occurrence download ";
    @Value(value="${download.doi.landing.page.baseUrl:https://doi-test.ala.org.au/doi/}")
    protected String biocacheDownloadDoiLandingPage = "https://doi-test.ala.org.au/doi/";
    @Value(value="${download.additional.local.files:}")
    protected String biocacheDownloadAdditionalLocalFiles;
    @Value(value="${download.doi.propagation.delay:60000}")
    protected long doiPropagationDelay;
    @Value(value="${download.offline.parallelquery.maxthreads:30}")
    protected Integer maxOfflineParallelQueryDownloadThreads = 30;
    @Value(value="${zip.file.size.mb.max:4000}")
    public Integer maxMB;
    @Value(value="${download.url:https://biocache.ala.org.au/biocache-download}")
    public String biocacheDownloadUrl;
    @Value(value="${download.dir:/data/biocache-download}")
    public String biocacheDownloadDir;
    @Value(value="${download.auth.sensitive:false}")
    private Boolean downloadAuthSensitive;
    @Value(value="${biocache.ui.url:https://biocache.ala.org.au}")
    protected String biocacheUiUrl = "https://biocache.ala.org.au";
    @Value(value="${sensitiveAccessRoles:{\n\n\"ROLE_SDS_ACT\" : \"sensitive:\\\"generalised\\\" AND (cl927:\\\"Australian Captial Territory\\\" OR cl927:\\\"Jervis Bay Territory\\\") AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\"\n\"ROLE_SDS_NSW\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"New South Wales (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_NZ\" : \"sensitive:\\\"generalised\\\" AND (data_resource_uid:dr2707 OR data_resource_uid:dr812 OR data_resource_uid:dr814 OR data_resource_uid:dr808 OR data_resource_uid:dr806 OR data_resource_uid:dr815 OR data_resource_uid:dr802 OR data_resource_uid:dr805 OR data_resource_uid:dr813) AND -cl927:* AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_NT\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Northern Territory (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_QLD\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Queensland (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_SA\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"South Australia (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_TAS\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Tasmania (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_VIC\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Victoria (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_WA\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Western Australia (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_BIRDLIFE\" : \"sensitive:\\\"generalised\\\" AND (data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\"\n\n}}")
    protected String sensitiveAccessRoles = "{}";
    private JSONObject sensitiveAccessRolesToSolrFilters;
    @Value(value="${download.offline.max.url:https://downloads.ala.org.au}")
    public String dowloadOfflineMaxUrl = "https://downloads.ala.org.au";
    @Value(value="${download.offline.max.size:100000000}")
    public Integer dowloadOfflineMaxSize = 100000000;
    @Value(value="${download.offline.msg:Too many records requested. Bulk download files for Lifeforms are available.}")
    public String downloadOfflineMsg = "Too many records requested. Bulk download files for Lifeforms are available.";
    @Value(value="${download.offline.msg:This download is unavailable. Run the download again.}")
    public String downloadOfflineMsgDeleted = "This download is unavailable. Run the download again.";
    @Value(value="${download.qualityFiltersTemplate:classpath:download-email-quality-filter-snippet.html}")
    public Resource downloadQualityFiltersTemplate;
    @Value(value="${download.date.format:dd MMMMM yyyy}")
    public String downloadDateFormat = "dd MMMMM yyyy";
    @Value(value="${download.csdm.email.template:}")
    protected String biocacheDownloadCSDMEmailTemplate;
    public static Boolean downloadShpEnabled;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final CountDownLatch initialisationLatch = new CountDownLatch(1);
    private final Queue<Thread> runningDownloadControllers = new LinkedBlockingQueue();
    private final Queue<DownloadControlThread> runningDownloadControlRunnables = new LinkedBlockingQueue();
    private volatile ExecutorService offlineParallelQueryExecutor;

    @Value(value="${download.shp.enabled:true}")
    public void setDownloadShpEnabled(Boolean downloadShpEnabled) {
        DownloadService.downloadShpEnabled = downloadShpEnabled;
    }

    protected final void afterInitialisation() {
        try {
            this.initialisationLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @PostConstruct
    public void init() throws org.json.simple.parser.ParseException {
        this.sensitiveAccessRolesToSolrFilters = (JSONObject)new JSONParser().parse(this.sensitiveAccessRoles);
        if (this.initialised.compareAndSet(false, true)) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    protected DownloadCreator getNewDownloadCreator() {
        return new DownloadCreatorImpl(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getOfflineThreadPoolExecutor() {
        ExecutorService nextExecutor = this.offlineParallelQueryExecutor;
        if (nextExecutor == null) {
            DownloadService downloadService = this;
            synchronized (downloadService) {
                nextExecutor = this.offlineParallelQueryExecutor;
                if (nextExecutor == null) {
                    nextExecutor = this.offlineParallelQueryExecutor = Executors.newFixedThreadPool(this.getMaxOfflineParallelDownloadThreads(), new ThreadFactoryBuilder().setNameFormat("biocache-query-offline-%d").setPriority(1).build());
                }
            }
        }
        return nextExecutor;
    }

    private int getMaxOfflineParallelDownloadThreads() {
        return this.maxOfflineParallelQueryDownloadThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextClosedEvent event) {
        this.afterInitialisation();
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.persistentQueueDAO.shutdown();
            }
            finally {
                DownloadControlThread nextToCloseRunnable = null;
                while ((nextToCloseRunnable = (DownloadControlThread)this.runningDownloadControlRunnables.poll()) != null) {
                    nextToCloseRunnable.shutdown();
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Thread nextToCloseThread = null;
                ArrayList<Thread> toJoinThreads = new ArrayList<Thread>();
                while ((nextToCloseThread = (Thread)this.runningDownloadControllers.poll()) != null) {
                    if (!nextToCloseThread.isAlive()) continue;
                    toJoinThreads.add(nextToCloseThread);
                }
                if (!toJoinThreads.isEmpty()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    for (Thread nextToJoinThread : toJoinThreads) {
                        if (!nextToJoinThread.isAlive()) continue;
                        nextToJoinThread.interrupt();
                    }
                }
            }
        }
    }

    public DownloadDetailsDTO registerDownload(DownloadRequestParams requestParams, String ip, String userAgent, DownloadDetailsDTO.DownloadType type) {
        this.afterInitialisation();
        DownloadDetailsDTO dd = new DownloadDetailsDTO(requestParams, ip, userAgent, type);
        dd.setRequestParams(requestParams);
        this.currentDownloads.add(dd);
        return dd;
    }

    public void unregisterDownload(DownloadDetailsDTO dd) {
        this.afterInitialisation();
        try {
            this.currentDownloads.remove(dd);
        }
        finally {
            this.persistentQueueDAO.removeDownloadFromQueue(dd);
        }
    }

    public List<DownloadDetailsDTO> getCurrentDownloads() {
        this.afterInitialisation();
        ArrayList result = new ArrayList(this.currentDownloads);
        return Collections.unmodifiableList(result);
    }

    @Deprecated
    public void writeQueryToStream(DownloadDetailsDTO dd, DownloadRequestParams requestParams, String ip, OutputStream out, boolean includeSensitive, boolean fromIndex, boolean limit, boolean zip) throws Exception {
        this.afterInitialisation();
        this.writeQueryToStream(dd, requestParams, ip, out, includeSensitive, fromIndex, limit, zip, this.getOfflineThreadPoolExecutor(), null);
    }

    public void writeQueryToStream(DownloadDetailsDTO dd, DownloadRequestParams requestParams, String ip, OutputStream out, boolean includeSensitive, boolean fromIndex, boolean limit, boolean zip, ExecutorService parallelExecutor, List<CreateDoiResponse> doiResponseList) throws Exception {
        block50: {
            this.afterInitialisation();
            String filename = requestParams.getFile();
            String originalParams = requestParams.toString();
            try (OptionalZipOutputStream sp = new OptionalZipOutputStream(zip ? OptionalZipOutputStream.Type.zipped : OptionalZipOutputStream.Type.unzipped, (OutputStream)new CloseShieldOutputStream(out), this.maxMB);){
                String suffix = requestParams.getFileType().equals("shp") ? "csv" : requestParams.getFileType();
                sp.putNextEntry(filename + "." + suffix);
                if ("all".equals(requestParams.getQa())) {
                    requestParams.setFacets(new String[]{"assertions", "data_resource_uid"});
                } else {
                    requestParams.setFacets(new String[]{"data_resource_uid"});
                }
                ConcurrentMap uidStats = fromIndex ? this.searchDAO.writeResultsFromIndexToStream(requestParams, (OutputStream)sp, includeSensitive, dd, limit, parallelExecutor) : this.searchDAO.writeResultsToStream(requestParams, (OutputStream)sp, 100, includeSensitive, dd, limit);
                sp.closeEntry();
                if (dd.getHeaderMap() != null) {
                    sp.putNextEntry("Shape-README.html");
                    sp.write("The name of features is limited to 10 characters. Listed below are the mappings of feature name to download field:".getBytes(StandardCharsets.UTF_8));
                    sp.write("<table><td><b>Feature</b></td><td><b>Download Field<b></td>".getBytes(StandardCharsets.UTF_8));
                    for (String key : dd.getHeaderMap().keySet()) {
                        sp.write(("<tr><td>" + key + "</td><td>" + (String)dd.getHeaderMap().get(key) + "</td></tr>").getBytes(StandardCharsets.UTF_8));
                    }
                    sp.write("</table>".getBytes(StandardCharsets.UTF_8));
                }
                if (uidStats == null) break block50;
                ArrayList citationsForReadme = new ArrayList();
                Boolean mintDoi = requestParams.getMintDoi();
                CreateDoiResponse doiResponse = null;
                String doi = "";
                Map enabledQualityFiltersByLabel = this.dataQualityService.getEnabledFiltersByLabel((SearchRequestParams)requestParams);
                List qualityFilters = this.getQualityFilterDTOS(enabledQualityFiltersByLabel);
                String searchUrl = this.generateSearchUrl(requestParams, enabledQualityFiltersByLabel);
                String dqFixedSearchUrl = this.dataQualityService.convertDataQualityParameters(searchUrl, enabledQualityFiltersByLabel);
                if (this.citationsEnabled.booleanValue()) {
                    ArrayList datasetMetadata = null;
                    if (mintDoi.booleanValue()) {
                        datasetMetadata = new ArrayList();
                    }
                    sp.putNextEntry("citation.csv");
                    try {
                        this.getCitations(uidStats, (OutputStream)sp, requestParams.getSep().charValue(), requestParams.getEsc().charValue(), citationsForReadme, datasetMetadata);
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    sp.closeEntry();
                    if (mintDoi.booleanValue()) {
                        Map userDetails = this.authService.getUserDetails(dd.getEmail());
                        String requesterId = (String)userDetails.get("userId");
                        String requesterName = userDetails.get("firstName") + " " + userDetails.get("lastName");
                        TreeSet<String> datasetLicences = new TreeSet<String>();
                        for (Map dataset : datasetMetadata) {
                            String licence = (String)dataset.get("licence");
                            if (!StringUtils.isNotBlank((String)licence)) continue;
                            datasetLicences.add(licence);
                        }
                        ArrayList licence = Lists.newArrayList(datasetLicences);
                        try {
                            DownloadDoiDTO doiDetails = new DownloadDoiDTO();
                            doiDetails.setTitle(this.biocacheDownloadDoiTitlePrefix + filename);
                            doiDetails.setApplicationUrl(dqFixedSearchUrl);
                            doiDetails.setRequesterId(requesterId);
                            if (dd.getSensitiveFq() != null) {
                                doiDetails.setAuthorisedRoles(this.getSensitiveRolesForUser(requesterId));
                            }
                            doiDetails.setRequesterName(requesterName);
                            doiDetails.setDatasetMetadata(datasetMetadata);
                            doiDetails.setRequestTime(dd.getStartDateString());
                            doiDetails.setRecordCount(dd.getTotalRecords());
                            doiDetails.setLicence((List)licence);
                            doiDetails.setQueryTitle(requestParams.getDisplayString());
                            doiDetails.setApplicationMetadata(requestParams.getDoiMetadata());
                            if (StringUtils.isNotBlank((String)requestParams.getQualityProfile())) {
                                doiDetails.setDataProfile(this.dataQualityService.getProfileFullName(requestParams.getQualityProfile()));
                            }
                            doiDetails.setQualityFilters(qualityFilters);
                            doiDetails.setDisplayTemplate(requestParams.getDoiDisplayTemplate());
                            doiResponse = this.doiService.mintDoi(doiDetails);
                        }
                        catch (Exception e) {
                            logger.error((Object)"DOI minting failed", (Throwable)e);
                        }
                        if (doiResponse != null) {
                            logger.debug((Object)("DOI minted: " + doiResponse.getDoi()));
                            doiResponseList.add(doiResponse);
                        } else {
                            logger.error((Object)("DOI minting failed for path " + dd.getFileLocation()));
                        }
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not adding citation. Enabled: " + this.citationsEnabled + " uids: " + uidStats));
                }
                if (dd.getRequestParams() == null) {
                    dd.setRequestParams(requestParams);
                }
                if (dd.getFileLocation() == null) {
                    dd.setFileLocation(dqFixedSearchUrl);
                }
                if (this.readmeEnabled.booleanValue()) {
                    String fileLocation;
                    String[] readmeFile;
                    sp.putNextEntry("README.html");
                    String dataProviders = "<ul><li>" + StringUtils.join(citationsForReadme, (String)"</li><li>") + "</li></ul>";
                    if (mintDoi.booleanValue() && doiResponse != null) {
                        readmeFile = this.biocacheDownloadDoiReadmeTemplate;
                        doi = doiResponse.getDoi();
                        fileLocation = OFFICIAL_DOI_RESOLVER + doi;
                    } else {
                        readmeFile = this.biocacheDownloadReadmeTemplate;
                        fileLocation = dd.getFileLocation().replace(this.biocacheDownloadDir, this.biocacheDownloadUrl);
                    }
                    String readmeTemplate = "";
                    if (new File((String)readmeFile).exists()) {
                        readmeTemplate = Files.asCharSource((File)new File((String)readmeFile), (Charset)StandardCharsets.UTF_8).read();
                    }
                    String dataQualityFilters = "";
                    if (!qualityFilters.isEmpty()) {
                        dataQualityFilters = this.getDataQualityFiltersString(qualityFilters);
                    }
                    String readmeContent = readmeTemplate.replace(DOWNLOAD_FILE_LOCATION, fileLocation).replace(START_DATE_TIME, dd.getStartDateString(this.downloadDateFormat)).replace(SEARCH_URL, dqFixedSearchUrl).replace(QUERY_TITLE, dd.getRequestParams().getDisplayString()).replace("[dataProviders]", dataProviders).replace("[dataQualityFilters]", dataQualityFilters);
                    sp.write(readmeContent.getBytes(StandardCharsets.UTF_8));
                    sp.write(("For more information about the fields that are being downloaded please consult <a href='" + this.dataFieldDescriptionURL + "'>Download Fields</a>.").getBytes(StandardCharsets.UTF_8));
                    sp.closeEntry();
                }
                if (mintDoi.booleanValue() && doiResponse != null) {
                    sp.putNextEntry("doi.txt");
                    sp.write((OFFICIAL_DOI_RESOLVER + doiResponse.getDoi()).getBytes(StandardCharsets.UTF_8));
                    sp.write("\n".getBytes(StandardCharsets.UTF_8));
                    sp.closeEntry();
                }
                if (this.headingsEnabled.booleanValue()) {
                    sp.putNextEntry("headings.csv");
                    try {
                        this.getHeadings(uidStats, (OutputStream)sp, requestParams, dd.getMiscFields());
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    sp.closeEntry();
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not adding header. Enabled: " + this.headingsEnabled + " uids: " + uidStats));
                }
                if (this.biocacheDownloadAdditionalLocalFiles != null && !this.biocacheDownloadAdditionalLocalFiles.isEmpty()) {
                    String[] localFiles;
                    for (String localFile : localFiles = this.biocacheDownloadAdditionalLocalFiles.split(",")) {
                        File f = new File(localFile);
                        if (!f.exists()) continue;
                        sp.putNextEntry(f.getName());
                        sp.write(IOUtils.toByteArray((InputStream)new FileInputStream(f)));
                        sp.closeEntry();
                    }
                }
                sp.flush();
                String sourceUrl = originalParams.contains("qid:") ? this.webservicesRoot + "?" + requestParams.toString() : this.webservicesRoot + "?" + originalParams;
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String key : uidStats.keySet()) {
                    if (((AtomicInteger)uidStats.get(key)).get() >= 0) continue;
                    toRemove.add(key);
                }
                for (String key : toRemove) {
                    uidStats.remove(key);
                }
                LogEventVO vo = new LogEventVO(1002, requestParams.getReasonTypeId(), requestParams.getSourceTypeId(), requestParams.getEmail(), requestParams.getReason(), ip, dd.getUserAgent(), null, uidStats, sourceUrl);
                this.loggerService.logEvent(vo);
            }
            catch (RecordWriterException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        }
    }

    private List<QualityFilterDTO> getQualityFilterDTOS(Map<String, String> filtersByLabel) {
        return filtersByLabel.entrySet().stream().map(e -> new QualityFilterDTO((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }

    @VisibleForTesting
    String getDataQualityFiltersString(List<QualityFilterDTO> qualityFilters) throws IOException, ParseException {
        RuntimeServices runtimeServices = RuntimeSingleton.getRuntimeServices();
        runtimeServices.setProperty("runtime.log.logsystem.class", (Object)Log4JLogChute.class.getName());
        runtimeServices.setProperty("runtime.log.logsystem.log4j.logger", (Object)"velocity");
        InputStreamReader reader = new InputStreamReader(this.downloadQualityFiltersTemplate.getInputStream(), StandardCharsets.UTF_8);
        Template template = new Template();
        template.setRuntimeServices(runtimeServices);
        template.setData((Object)runtimeServices.parse((Reader)reader, "download-quality-filters-template"));
        template.initDocument();
        StringWriter sw = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("qualityFilters", qualityFilters);
        template.merge((Context)context, (Writer)sw);
        String dataQualityFilters = sw.toString();
        return dataQualityFilters;
    }

    @Deprecated
    public void writeQueryToStream(DownloadRequestParams requestParams, HttpServletResponse response, String ip, String userAgent, OutputStream out, boolean includeSensitive, boolean fromIndex, boolean zip) throws Exception {
        this.afterInitialisation();
        this.writeQueryToStream(requestParams, response, ip, userAgent, out, includeSensitive, fromIndex, zip, this.getOfflineThreadPoolExecutor());
    }

    public void writeQueryToStream(DownloadRequestParams requestParams, HttpServletResponse response, String ip, String userAgent, OutputStream out, boolean includeSensitive, boolean fromIndex, boolean zip, ExecutorService parallelQueryExecutor) throws Exception {
        this.afterInitialisation();
        String filename = requestParams.getFile();
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        if (zip) {
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".zip");
            response.setContentType("application/zip");
        } else {
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".txt");
            response.setContentType("text/plain");
        }
        DownloadDetailsDTO.DownloadType type = fromIndex ? DownloadDetailsDTO.DownloadType.RECORDS_INDEX : DownloadDetailsDTO.DownloadType.RECORDS_DB;
        DownloadDetailsDTO dd = this.registerDownload(requestParams, ip, userAgent, type);
        this.writeQueryToStream(dd, requestParams, ip, (OutputStream)new CloseShieldOutputStream(out), includeSensitive, fromIndex, true, zip, parallelQueryExecutor, null);
    }

    public void getCitations(ConcurrentMap<String, AtomicInteger> uidStats, OutputStream out, char sep, char esc, List<String> readmeCitations, List<Map<String, String>> datasetMetadata) throws IOException {
        if (this.citationsEnabled.booleanValue()) {
            this.afterInitialisation();
            if (uidStats == null) {
                logger.error((Object)"Unable to generate citations: logger statistics was null", new Exception().fillInStackTrace());
                return;
            }
            if (out == null) {
                logger.error((Object)"Unable to generate citations: output stream was null", new Exception().fillInStackTrace());
                return;
            }
            try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(out), StandardCharsets.UTF_8), sep, '\"', esc);){
                writer.writeNext(new String[]{this.messageSource.getMessage("citation.uid", null, "UID", null), this.messageSource.getMessage("citation.name", null, "Name", null), this.messageSource.getMessage("citation.doi", null, "DOI", null), this.messageSource.getMessage("citation.citation", null, "Citation", null), this.messageSource.getMessage("citation.rights", null, "Rights", null), this.messageSource.getMessage("citation.link", null, "More Information", null), this.messageSource.getMessage("citation.dataGeneralizations", null, "Data generalisations", null), this.messageSource.getMessage("citation.informationWithheld", null, "Information withheld", null), this.messageSource.getMessage("citation.downloadLimit", null, "Download limit", null), this.messageSource.getMessage("citation.count", null, "Number of Records in Download", null)});
                if (!uidStats.isEmpty()) {
                    List entities = (List)this.restTemplate.postForObject(this.citationServiceUrl, uidStats.keySet(), List.class, new Object[0]);
                    boolean UID = false;
                    boolean NAME = true;
                    int CITATION = 3;
                    int RIGHTS = 4;
                    int LINK = 5;
                    int COUNT = 9;
                    for (Map record : entities) {
                        if (record != null) {
                            Object value = record.get("uid");
                            if (value != null) {
                                AtomicInteger uidRecordCount = (AtomicInteger)uidStats.get(value);
                                String count = Optional.ofNullable(uidRecordCount).orElseGet(() -> new AtomicInteger(0)).toString();
                                String[] row = new String[]{this.getOrElse(record, "uid", ""), this.getOrElse(record, "name", ""), this.getOrElse(record, "DOI", ""), this.getOrElse(record, "citation", ""), this.getOrElse(record, "rights", ""), this.getOrElse(record, "link", ""), this.getOrElse(record, "dataGeneralizations", ""), this.getOrElse(record, "informationWithheld", ""), this.getOrElse(record, "downloadLimit", ""), count};
                                writer.writeNext(row);
                                if (readmeCitations != null) {
                                    readmeCitations.add(row[3] + " (" + row[4] + "). " + row[5]);
                                }
                                if (datasetMetadata == null) continue;
                                HashMap<String, String> dataSet = new HashMap<String, String>();
                                dataSet.put("uid", row[0]);
                                dataSet.put("name", row[1]);
                                dataSet.put("licence", row[4]);
                                dataSet.put("count", row[9]);
                                datasetMetadata.add(dataSet);
                                continue;
                            }
                            logger.error((Object)("Record did not have a uid attribute: " + record));
                            continue;
                        }
                        logger.error((Object)("A null record was returned from the collectory citation service: " + entities + ", collected stats were: " + uidStats));
                    }
                } else {
                    logger.warn((Object)"No collected stats for a download");
                }
                writer.flush();
            }
        }
    }

    public void getHeadings(ConcurrentMap<String, AtomicInteger> uidStats, OutputStream out, DownloadRequestParams params, String[] miscHeaders) throws Exception {
        if (this.headingsEnabled.booleanValue()) {
            this.afterInitialisation();
            if (out == null) {
                logger.error((Object)"Unable to generate headings info: output stream was null", new Exception().fillInStackTrace());
                return;
            }
            try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(out), StandardCharsets.UTF_8), params.getSep().charValue(), '\"', params.getEsc().charValue());){
                Set indexedFields = this.searchDAO.getIndexedFields();
                writer.writeNext(new String[]{"Column name", "Requested field", "DwC Name", "Field name", "Field description", "Download field name", "Download field description", "More information"});
                String[] fieldsRequested = null;
                String[] headerOutput = null;
                for (Map.Entry e : uidStats.entrySet()) {
                    if (((AtomicInteger)e.getValue()).get() == -1) {
                        fieldsRequested = ((String)e.getKey()).split(",");
                        continue;
                    }
                    if (((AtomicInteger)e.getValue()).get() != -2) continue;
                    headerOutput = ((String)e.getKey()).split(",");
                }
                if (fieldsRequested != null && headerOutput != null) {
                    for (int i = 1; i < fieldsRequested.length; ++i) {
                        IndexFieldDTO ifdto = null;
                        for (IndexFieldDTO f : indexedFields) {
                            if (!fieldsRequested[i].equalsIgnoreCase(f.getDownloadName())) continue;
                            ifdto = f;
                            break;
                        }
                        if (ifdto == null) {
                            for (IndexFieldDTO f : indexedFields) {
                                if (!fieldsRequested[i].equalsIgnoreCase(f.getName())) continue;
                                ifdto = f;
                                break;
                            }
                        }
                        if (ifdto != null && StringUtils.isNotEmpty((String)headerOutput[i])) {
                            writer.writeNext(new String[]{headerOutput[i], fieldsRequested[i], ifdto.getDwcTerm() != null ? ifdto.getDwcTerm() : "", ifdto.getName() != null ? ifdto.getName() : "", ifdto.getDescription() != null ? ifdto.getDescription() : "", ifdto.getDownloadName() != null ? ifdto.getDownloadName() : "", ifdto.getDownloadDescription() != null ? ifdto.getDownloadDescription() : "", ifdto.getInfo() != null ? ifdto.getInfo() : ""});
                            continue;
                        }
                        if (!StringUtils.isNotEmpty((String)headerOutput[i])) continue;
                        String info = this.messageSource.getMessage("description." + fieldsRequested[i], null, "", null);
                        writer.writeNext(new String[]{headerOutput[i], fieldsRequested[i], "", "", "", "", "", info != null ? info : ""});
                    }
                }
                if (miscHeaders != null) {
                    String defaultDescription = this.messageSource.getMessage("description.", null, "Raw field from data provider.", null);
                    for (int i = 0; i < miscHeaders.length; ++i) {
                        writer.writeNext(new String[]{miscHeaders[i], "", "", "", "", "", this.messageSource.getMessage("description." + miscHeaders[i], null, defaultDescription, null)});
                    }
                }
                writer.flush();
            }
        }
    }

    private String getOrElse(Map<String, Object> map, String key, String defaultValue) {
        return map.getOrDefault(key, defaultValue).toString();
    }

    public String generateSearchUrl(DownloadRequestParams params) {
        return this.generateSearchUrl(params, null);
    }

    public String generateSearchUrl(DownloadRequestParams params, @Nullable Map<String, String> enabledQualityFiltersByLabel) {
        if (params.getSearchUrl() != null) {
            return params.getSearchUrl();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.biocacheUiUrl + "/occurrences/search?");
        if (params.getQId() != null) {
            try {
                sb.append("qid=").append(URLEncoder.encode("" + params.getQId(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (params.getQ() != null) {
            try {
                sb.append("&q=").append(URLEncoder.encode(params.getQ(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (params.getFq().length > 0) {
            for (String fq2 : params.getFq()) {
                if (!StringUtils.isNotEmpty((String)fq2)) continue;
                try {
                    sb.append("&fq=").append(URLEncoder.encode(fq2, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (params.isDisableAllQualityFilters()) {
            sb.append("&disableAllQualityFilters=true");
        } else {
            sb.append("&disableAllQualityFilters=true");
            if (enabledQualityFiltersByLabel == null) {
                enabledQualityFiltersByLabel = this.dataQualityService.getEnabledFiltersByLabel((SearchRequestParams)params);
            }
            enabledQualityFiltersByLabel.forEach((label, fq) -> {
                try {
                    sb.append("&fq=").append(URLEncoder.encode(fq, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            });
        }
        if (StringUtils.isNotEmpty((String)params.getQc())) {
            try {
                sb.append("&qc=").append(URLEncoder.encode(params.getQc(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)params.getWkt())) {
            try {
                sb.append("&wkt=").append(URLEncoder.encode(params.getWkt(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (params.getLat() != null && params.getLon() != null && params.getRadius() != null) {
            sb.append("&lat=").append(params.getLat());
            sb.append("&lon=").append(params.getLon());
            sb.append("&radius=").append(params.getRadius());
        }
        return sb.toString();
    }

    private void insertMiscHeader(DownloadDetailsDTO download) {
        if (download.getMiscFields() != null && download.getMiscFields().length > 0 && download.getRequestParams() != null) {
            try {
                File unzipDir = new File(download.getFileLocation() + ".dir" + File.separator);
                unzipDir.mkdirs();
                AlaFileUtils.unzip((String)unzipDir.getPath(), (String)download.getFileLocation());
                for (File f : unzipDir.listFiles()) {
                    if (!f.getName().endsWith(".csv") && !f.getName().endsWith(".tsv") || "headings.csv".equals(f.getName())) continue;
                    try (FileReader fileReader = new FileReader(f);
                         BufferedReader bufferedReader = new BufferedReader(fileReader);){
                        File fnew = new File(f.getPath() + ".new");
                        try (FileWriter fw = new FileWriter(fnew);){
                            String line;
                            int row = 0;
                            while ((line = bufferedReader.readLine()) != null) {
                                if (row == 0) {
                                    String[] miscHeader = download.getMiscFields();
                                    if ("csv".equals(download.getRequestParams().getFileType())) {
                                        CSVReader reader = new CSVReader((Reader)new StringReader(line));
                                        String[] header = reader.readNext();
                                        reader.close();
                                        String[] newHeader = new String[header.length + miscHeader.length];
                                        if (header.length > 0) {
                                            System.arraycopy(header, 0, newHeader, 0, header.length);
                                        }
                                        if (miscHeader.length > 0) {
                                            System.arraycopy(miscHeader, 0, newHeader, header.length, miscHeader.length);
                                        }
                                        StringWriter sw = new StringWriter();
                                        try (CSVWriter writer = new CSVWriter((Writer)sw, download.getRequestParams().getSep().charValue(), '\"', download.getRequestParams().getEsc().charValue());){
                                            writer.writeNext(newHeader);
                                        }
                                        line = sw.toString().trim();
                                    } else {
                                        for (int i = 0; i < miscHeader.length; ++i) {
                                            line = line + '\t';
                                            line = line + miscHeader[i].replace("\r", "").replace("\n", "").replace("\t", "");
                                        }
                                        line = line + '\n';
                                    }
                                } else {
                                    fw.write("\n");
                                }
                                fw.write(line);
                                ++row;
                            }
                        }
                        FileUtils.copyFile((File)fnew, (File)f);
                        fnew.delete();
                    }
                }
                FileUtils.deleteQuietly((File)new File(download.getFileLocation()));
                AlaFileUtils.createZip((String)unzipDir.getPath(), (String)download.getFileLocation());
                FileUtils.deleteDirectory((File)unzipDir);
            }
            catch (Exception e) {
                logger.error((Object)"failed to append misc header", (Throwable)e);
            }
        }
    }

    public String getSensitiveFq(String userId) {
        if (this.downloadAuthSensitive == null || !this.downloadAuthSensitive.booleanValue()) {
            return null;
        }
        String sensitiveFq = "";
        for (String sensitiveRole : this.getSensitiveRolesForUser(userId)) {
            if (sensitiveFq.length() > 0) {
                sensitiveFq = sensitiveFq + " OR ";
            }
            sensitiveFq = sensitiveFq + "(" + this.sensitiveAccessRolesToSolrFilters.get((Object)sensitiveRole) + ")";
        }
        if (sensitiveFq.length() == 0) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sensitiveOnly download requested for user: " + userId + ", using fq: " + sensitiveFq));
        }
        return sensitiveFq;
    }

    public List<String> getSensitiveRolesForUser(String userId) {
        List userRoles = this.authService.getUserRoles(userId);
        ArrayList<String> result = new ArrayList<String>(this.sensitiveAccessRolesToSolrFilters.keySet());
        result.retainAll(userRoles);
        return result;
    }

    private Thread newRetryThread(DownloadDetailsDTO currentDownload) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ ExecutorService access$000(DownloadService x0) {
        return x0.getOfflineThreadPoolExecutor();
    }

    static /* synthetic */ Queue access$100(DownloadService x0) {
        return x0.runningDownloadControllers;
    }

    static /* synthetic */ Queue access$200(DownloadService x0) {
        return x0.runningDownloadControlRunnables;
    }

    static /* synthetic */ CountDownLatch access$300(DownloadService x0) {
        return x0.initialisationLatch;
    }

    static /* synthetic */ void access$500(DownloadService x0, DownloadDetailsDTO x1) {
        x0.insertMiscHeader(x1);
    }

    static /* synthetic */ Thread access$600(DownloadService x0, DownloadDetailsDTO x1) {
        return x0.newRetryThread(x1);
    }
}

