/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.outliers.JackKnifeStats;
import au.org.ala.biocache.outliers.RecordJackKnifeStats;
import au.org.ala.biocache.util.SearchUtils;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OutlierController {
    @Inject
    private SearchUtils searchUtils;

    @RequestMapping(value={"/outlierInfo/**"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, JackKnifeStats> getJackKnifeStats(HttpServletRequest request) throws Exception {
        String guid = this.searchUtils.getGuidFromPath(request);
        return Store.getJackKnifeStatsFor((String)guid);
    }

    @RequestMapping(value={"/outlier/record/{uuid}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<RecordJackKnifeStats> getOutlierForUUid(@PathVariable(value="uuid") String recordUuid) throws Exception {
        return Store.getJackKnifeRecordDetailsFor((String)recordUuid);
    }
}

