/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.web.AbstractSecureController;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocumentList;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DownloadController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(DownloadController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected PersistentQueueDAO persistentQueueDAO;
    @Inject
    protected AuthService authService;
    @Inject
    protected DownloadService downloadService;
    @Value(value="${download.auth.role:ROLE_USER}")
    String downloadRole;

    @RequestMapping(value={"occurrences/offline/download/stats"}, method={RequestMethod.GET})
    @ResponseBody
    public List getCurrentDownloads(HttpServletResponse response, @RequestParam(value="apiKey", required=true) String apiKey) throws Exception {
        if (apiKey != null && this.shouldPerformOperation(apiKey, response, false)) {
            JsonConfig config = new JsonConfig();
            config.setJsonPropertyFilter((PropertyFilter)new /* Unavailable Anonymous Inner Class!! */);
            JSONArray ja = JSONArray.fromObject((Object)this.persistentQueueDAO.getAllDownloads(), (JsonConfig)config);
            for (Object jo : ja) {
                String id = (String)((net.sf.json.JSONObject)jo).get("uniqueId");
                ((net.sf.json.JSONObject)jo).put((Object)"cancelURL", (Object)(this.downloadService.webservicesRoot + "/occurrences/offline/cancel/" + id + "?apiKey=" + apiKey));
            }
            return ja;
        }
        return null;
    }

    @RequestMapping(value={"occurrences/offline/{type}/download*"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Object occurrenceDownload(DownloadRequestParams requestParams, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="email", required=true) String email, @PathVariable(value="type") String type, HttpServletResponse response, HttpServletRequest request) throws Exception {
        DownloadDetailsDTO.DownloadType downloadType = "index".equals(type.toLowerCase()) ? DownloadDetailsDTO.DownloadType.RECORDS_INDEX : DownloadDetailsDTO.DownloadType.RECORDS_DB;
        return this.download(requestParams, ip, this.getUserAgent(request), apiKey, email, response, request, downloadType);
    }

    @RequestMapping(value={"occurrences/offline/download*"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Object occurrenceDownload(DownloadRequestParams requestParams, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="email", required=true) String email, HttpServletResponse response, HttpServletRequest request) throws Exception {
        if (StringUtils.isEmpty((String)email)) {
            response.sendError(400, "Required parameter 'email' is not present");
            return null;
        }
        try {
            String fields;
            boolean hasDBColumn;
            boolean bl = hasDBColumn = this.downloadService.downloadSolrOnly == false && requestParams.getIncludeMisc() != false;
            if (!this.downloadService.downloadSolrOnly.booleanValue() && (fields = requestParams.getFields() + "," + requestParams.getExtra()).length() > 1) {
                Set indexedFields = this.searchDAO.getIndexedFields();
                for (String column : fields.split(",")) {
                    for (IndexFieldDTO field : indexedFields) {
                        if (field.isStored() || field.getDownloadName() == null || !field.getDownloadName().equals(column)) continue;
                        hasDBColumn = true;
                        break;
                    }
                    if (hasDBColumn) break;
                }
            }
            DownloadDetailsDTO.DownloadType downloadType = hasDBColumn ? DownloadDetailsDTO.DownloadType.RECORDS_DB : DownloadDetailsDTO.DownloadType.RECORDS_INDEX;
            return this.download(requestParams, ip, this.getUserAgent(request), apiKey, email, response, request, downloadType);
        }
        catch (Exception e) {
            logger.error((Object)"download exception: ", (Throwable)e);
            throw e;
        }
    }

    private Object download(DownloadRequestParams requestParams, String ip, String userAgent, String apiKey, String email, HttpServletResponse response, HttpServletRequest request, DownloadDetailsDTO.DownloadType downloadType) throws Exception {
        if (StringUtils.isEmpty((String)email)) {
            response.sendError(412, "Unable to perform an offline download without an email address");
            return null;
        }
        try {
            Map userDetails = this.authService.getUserDetails(email);
            if (userDetails == null) {
                response.sendError(403, "Unable to perform an offline download, user not recognised");
                return null;
            }
            boolean activated = userDetails.getOrDefault("activated", false);
            boolean locked = userDetails.getOrDefault("locked", true);
            boolean hasRole = false;
            if (this.downloadRole == null) {
                hasRole = true;
            } else {
                List roles = (List)userDetails.get("roles");
                boolean bl = hasRole = roles == null ? false : roles.stream().anyMatch(this.downloadRole::equals);
            }
            if (!activated || locked || !hasRole) {
                response.sendError(403, "Unable to perform an offline download, insufficient privileges");
                return null;
            }
        }
        catch (Exception e) {
            response.sendError(403, "Unable to perform an offline download, unable to verify user details");
            return null;
        }
        boolean includeSensitive = false;
        if (apiKey != null && this.shouldPerformOperation(apiKey, response, false)) {
            includeSensitive = true;
        }
        String sensitiveFq = null;
        if (!includeSensitive) {
            sensitiveFq = this.getSensitiveFq(request);
        }
        ip = ip == null ? request.getRemoteAddr() : ip;
        DownloadDetailsDTO dd = new DownloadDetailsDTO(requestParams, ip, userAgent, downloadType);
        dd.setIncludeSensitive(includeSensitive);
        dd.setSensitiveFq(sensitiveFq);
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(false));
        SolrDocumentList result = this.searchDAO.findByFulltext((SpatialSearchRequestParams)requestParams);
        dd.setTotalRecords(result.getNumFound());
        LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
        DownloadDetailsDTO d = this.persistentQueueDAO.isInQueue(dd);
        if (d != null) {
            status.put("message", "Already in queue.");
            status.put("status", "inQueue");
            status.put("queueSize", this.persistentQueueDAO.getTotalDownloads());
            status.put("statusUrl", this.downloadService.webservicesRoot + "/occurrences/offline/status/" + d.getUniqueId());
        } else if (dd.getTotalRecords() > (long)this.downloadService.dowloadOfflineMaxSize.intValue()) {
            File file = new File(this.downloadService.biocacheDownloadDir + File.separator + UUID.nameUUIDFromBytes(dd.getEmail().getBytes(StandardCharsets.UTF_8)) + File.separator + dd.getStartTime() + File.separator + "tooLarge");
            FileUtils.forceMkdir((File)file.getParentFile());
            FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8");
            status.put("downloadUrl", this.downloadService.biocacheDownloadUrl);
            status.put("status", "skipped");
            status.put("message", this.downloadService.downloadOfflineMsg);
            status.put("error", "Requested to many records (" + dd.getTotalRecords() + "). The maximum is (" + this.downloadService.dowloadOfflineMaxSize + ")");
        } else {
            this.persistentQueueDAO.addDownloadToQueue(dd);
            status.put("status", "inQueue");
            status.put("queueSize", this.persistentQueueDAO.getTotalDownloads());
            status.put("statusUrl", this.downloadService.webservicesRoot + "/occurrences/offline/status/" + dd.getUniqueId());
        }
        status.put("searchUrl", this.downloadService.generateSearchUrl(dd.getRequestParams()));
        this.writeStatusFile(dd.getUniqueId(), status);
        return status;
    }

    @RequestMapping(value={"occurrences/offline/status"}, method={RequestMethod.GET})
    @ResponseBody
    public Object allOccurrenceDownloadStatus() throws Exception {
        ArrayList allStatus = new ArrayList();
        Map userIdLookup = this.authService.getMapOfEmailToId();
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
            String id = dd.getUniqueId();
            if (dd.getFileLocation() == null) {
                status.put("status", "inQueue");
            } else {
                status.put("status", "running");
                status.put("records", dd.getRecordsDownloaded());
            }
            status.put("id", id);
            status.put("totalRecords", dd.getTotalRecords());
            status.put("downloadParams", dd.getDownloadParams());
            status.put("startDate", dd.getStartDateString());
            status.put("thread", dd.getProcessingThreadName());
            if (userIdLookup != null) {
                status.put("userId", this.authService.getMapOfEmailToId().get(dd.getEmail()));
            }
            status.put("statusUrl", this.downloadService.webservicesRoot + "/occurrences/offline/status/" + id);
            this.setStatusIfEmpty(id, status);
            allStatus.add(status);
        }
        return allStatus;
    }

    private void setStatusIfEmpty(String id, Map<String, Object> status) throws UnsupportedEncodingException {
        if (!status.containsKey("status")) {
            int sep = id.lastIndexOf(45);
            File dir = new File(this.downloadService.biocacheDownloadDir + File.separator + id.substring(0, sep) + File.separator + id.substring(sep + 1));
            if (dir.isDirectory() && dir.exists()) {
                for (File file : dir.listFiles()) {
                    if (file.isFile() && file.getPath().endsWith(".zip") && file.length() > 0L) {
                        status.put("status", "finished");
                        status.put("downloadUrl", this.downloadService.biocacheDownloadUrl + File.separator + URLEncoder.encode(file.getPath().replace(this.downloadService.biocacheDownloadDir + "/", ""), "UTF-8").replace("%2F", "/").replace("+", "%20"));
                    }
                    if (!file.isFile() || !"tooLarge".equals(file.getName())) continue;
                    status.put("status", "skipped");
                    status.put("message", this.downloadService.downloadOfflineMsg);
                    status.put("downloadUrl", this.downloadService.dowloadOfflineMaxUrl);
                }
                if (!status.containsKey("status")) {
                    status.put("status", "failed");
                }
            }
        }
        if (!status.containsKey("status")) {
            status.put("status", "invalidId");
        }
    }

    private void writeStatusFile(String id, Map status) throws IOException {
        File statusDir = new File(this.downloadService.biocacheDownloadDir + "/" + id.replaceAll("-([0-9]*)$", "/$1"));
        statusDir.mkdirs();
        String json = net.sf.json.JSONObject.fromObject((Object)status).toString();
        FileUtils.writeStringToFile((File)new File(statusDir.getPath() + "/status.json"), (String)json, (String)"UTF-8");
    }

    @RequestMapping(value={"occurrences/offline/status/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object occurrenceDownloadStatus(@PathVariable(value="id") String id) throws Exception {
        File file;
        LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            if (!id.equals(dd.getUniqueId())) continue;
            if (dd.getFileLocation() == null) {
                status.put("status", "inQueue");
            } else {
                status.put("status", "running");
                status.put("records", dd.getRecordsDownloaded());
            }
            status.put("totalRecords", dd.getTotalRecords());
            status.put("statusUrl", this.downloadService.webservicesRoot + "/occurrences/offline/status/" + id);
            if (this.authService.getMapOfEmailToId() == null) break;
            status.put("userId", this.authService.getMapOfEmailToId().get(dd.getEmail()));
            break;
        }
        String cleanId = id.replaceAll("[^a-z\\-0-9]", "");
        cleanId = cleanId.replaceAll("-([0-9]*)$", "/$1");
        if (!status.containsKey("status")) {
            File dir = new File(this.downloadService.biocacheDownloadDir + File.separator + cleanId);
            if (dir.isDirectory() && dir.exists()) {
                for (File file2 : dir.listFiles()) {
                    if (file2.isFile() && file2.getPath().endsWith(".zip") && file2.length() > 0L) {
                        status.put("status", "finished");
                        status.put("downloadUrl", this.downloadService.biocacheDownloadUrl + File.separator + URLEncoder.encode(file2.getPath().replace(this.downloadService.biocacheDownloadDir + "/", ""), "UTF-8").replace("%2F", "/").replace("+", "%20"));
                    }
                    if (!file2.isFile() || !"tooLarge".equals(file2.getName())) continue;
                    status.put("status", "skipped");
                    status.put("message", this.downloadService.downloadOfflineMsg);
                    status.put("downloadUrl", this.downloadService.dowloadOfflineMaxUrl);
                    status.put("error", "requested to many records. The upper limit is (" + this.downloadService.dowloadOfflineMaxSize + ")");
                }
                if (!status.containsKey("status")) {
                    status.put("status", "failed");
                }
            }
            if (status.containsKey("status")) {
                this.writeStatusFile(cleanId, status);
            }
        }
        if (!status.containsKey("status") && (file = new File(this.downloadService.biocacheDownloadDir + File.separator + cleanId + "/status.json")).exists()) {
            JSONParser jp = new JSONParser();
            status.putAll((Map<String, Object>)((JSONObject)jp.parse(FileUtils.readFileToString((File)file, (String)"UTF-8"))));
            status.put("status", "unavailable");
            status.put("message", "This download is unavailable.");
        }
        if (!status.containsKey("status")) {
            status.put("status", "invalidId");
        }
        return status;
    }

    @RequestMapping(value={"occurrences/offline/cancel/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object occurrenceDownloadCancel(@PathVariable(value="id") String id, HttpServletResponse response, @RequestParam(value="apiKey", required=true) String apiKey) throws Exception {
        if (apiKey == null || !this.shouldPerformOperation(apiKey, response, false)) {
            return null;
        }
        LinkedHashMap<String, String> status = new LinkedHashMap<String, String>();
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            if (!id.equals(dd.getUniqueId())) continue;
            this.persistentQueueDAO.removeDownloadFromQueue(dd);
            status.put("cancelled", "true");
            status.put("status", "notInQueue");
            break;
        }
        if (!status.containsKey("status")) {
            status.put("cancelled", "false");
            status.put("status", "notInQueue");
        }
        return status;
    }

    private String getSensitiveFq(HttpServletRequest request) throws ParseException {
        if (!this.isValidKey(request.getHeader("apiKey"))) {
            return null;
        }
        String xAlaUserIdHeader = request.getHeader("X-ALA-userId");
        if (xAlaUserIdHeader == null) {
            return null;
        }
        return this.downloadService.getSensitiveFq(xAlaUserIdHeader);
    }
}

