/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dto.DownloadDoiDTO;
import au.org.ala.doi.CreateDoiRequest;
import au.org.ala.doi.CreateDoiResponse;
import au.org.ala.doi.Doi;
import au.org.ala.doi.DoiApiService;
import au.org.ala.doi.UpdateDoiRequest;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Component(value="doiService")
public class DoiService {
    private static final Logger logger = Logger.getLogger(DoiService.class);
    public static final String DISPLAY_TEMPLATE_BIOCACHE = "biocache";
    public static final String DISPLAY_TEMPLATE_CSDM = "csdm";
    @Value(value="${doi.service.url:https://devt.ala.org.au/doi-service/api/}")
    private String doiServiceUrl;
    @Value(value="${doi.service.apiKey:Provide a valid key}")
    private String doiServiceApiKey;
    @Value(value="${doi.service.readTimeout:900000}")
    private long doiServiceReadTimeout;
    @Value(value="${doi.service.writeTimeout:30000}")
    private long doiServiceWriteTimeout;
    @Value(value="${doi.author:Atlas Of Living Australia}")
    private String doiAuthor;
    @Value(value="${doi.description:ALA occurrence record download}")
    private String doiDescription;
    @Value(value="${doi.resourceText:Species information}")
    private String doiResourceText;
    @Value(value="${doi.provider:ALA}")
    private String provider;
    private DoiApiService doiApiService;

    @PostConstruct
    public void init() {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor((Interceptor)new /* Unavailable Anonymous Inner Class!! */);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.doiServiceUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(httpClient.writeTimeout(this.doiServiceWriteTimeout, TimeUnit.MILLISECONDS).readTimeout(this.doiServiceReadTimeout, TimeUnit.MILLISECONDS).build()).build();
        this.doiApiService = (DoiApiService)retrofit.create(DoiApiService.class);
    }

    public Doi getDoi(String doi) throws IOException {
        String doiStr = UrlEscapers.urlPathSegmentEscaper().escape(doi);
        Call doiCall = this.doiApiService.getEncoded(doiStr);
        Response response = doiCall.execute();
        if (response.isSuccessful()) {
            return (Doi)response.body();
        }
        logger.error((Object)("Error while getting doi " + doi + ":" + response.errorBody().string()));
        return null;
    }

    public CreateDoiResponse mintDoi(CreateDoiRequest request) throws IOException {
        request.setProvider(this.provider);
        Response response = this.doiApiService.create(request).execute();
        if (response.isSuccessful()) {
            return (CreateDoiResponse)response.body();
        }
        logger.error((Object)("Error creating DOI for request " + request + ":" + response.errorBody().string()));
        throw new RuntimeException("Unable to mint DOI for " + request.getApplicationUrl());
    }

    public CreateDoiResponse mintDoi(DownloadDoiDTO downloadInfo) throws IOException {
        CreateDoiRequest request = new CreateDoiRequest();
        request.setAuthors(this.doiAuthor);
        request.setTitle(downloadInfo.getTitle());
        request.setApplicationUrl(downloadInfo.getApplicationUrl());
        request.setDescription(this.doiDescription);
        request.setLicence(downloadInfo.getLicence());
        request.setUserId(downloadInfo.getRequesterId());
        request.setAuthorisedRoles(downloadInfo.getAuthorisedRoles());
        request.setProvider(this.provider);
        request.setFileUrl(downloadInfo.getFileUrl());
        request.setDisplayTemplate(downloadInfo.getDisplayTemplate());
        Map providerMetadata = this.generateProviderMetadataPayload(downloadInfo);
        request.setProviderMetadata(providerMetadata);
        Map applicationMetadata = this.generateApplicationMetadataPayload(downloadInfo);
        request.setApplicationMetadata(applicationMetadata);
        request.setActive(Boolean.valueOf(false));
        return this.mintDoi(request);
    }

    private Map<String, Object> generateApplicationMetadataPayload(DownloadDoiDTO downloadInfo) {
        HashMap<String, Object> applicationMetadata = new HashMap<String, Object>();
        if (downloadInfo.getApplicationMetadata() != null) {
            applicationMetadata.putAll(downloadInfo.getApplicationMetadata());
        }
        applicationMetadata.put("searchUrl", downloadInfo.getApplicationUrl());
        applicationMetadata.put("datasets", downloadInfo.getDatasetMetadata());
        applicationMetadata.put("requestedOn", downloadInfo.getRequestTime());
        applicationMetadata.put("recordCount", Long.toString(downloadInfo.getRecordCount()));
        applicationMetadata.put("queryTitle", downloadInfo.getQueryTitle());
        applicationMetadata.put("qualityFilters", downloadInfo.getQualityFilters());
        return applicationMetadata;
    }

    private Map<String, Object> generateProviderMetadataPayload(DownloadDoiDTO downloadInfo) {
        HashMap<String, Object> providerMetadata = new HashMap<String, Object>();
        ArrayList<String> authorsList = new ArrayList<String>();
        authorsList.add(this.doiAuthor);
        providerMetadata.put("authors", authorsList);
        providerMetadata.put("publisher", this.doiAuthor);
        providerMetadata.put("title", downloadInfo.getTitle());
        providerMetadata.put("resourceType", "Text");
        providerMetadata.put("resourceText", this.doiResourceText);
        ArrayList contributorsList = new ArrayList();
        HashMap<String, String> contributorMap = new HashMap<String, String>();
        contributorMap.put("name", downloadInfo.getRequesterName());
        contributorMap.put("type", "Distributor");
        contributorsList.add(contributorMap);
        providerMetadata.put("contributors", contributorsList);
        ArrayList descriptionsList = new ArrayList();
        HashMap<String, String> descriptionMap = new HashMap<String, String>();
        descriptionMap.put("text", this.doiDescription);
        descriptionMap.put("type", "Other");
        descriptionsList.add(descriptionMap);
        providerMetadata.put("descriptions", descriptionsList);
        ArrayList creators = new ArrayList();
        for (Map datasetProvider : downloadInfo.getDatasetMetadata()) {
            HashMap creator = new HashMap();
            creator.put("name", datasetProvider.get("name"));
            creator.put("type", "Producer");
            creators.add(creator);
        }
        providerMetadata.put("creator", creators);
        return providerMetadata;
    }

    public Doi updateFile(String id, String fileUrl) throws IOException {
        UpdateDoiRequest updateRequest = new UpdateDoiRequest();
        updateRequest.setFileUrl(fileUrl);
        updateRequest.setActive(Boolean.valueOf(true));
        File file = new File(fileUrl);
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestFile);
        Response updateResponse = this.doiApiService.updateMultipart(id, body, updateRequest).execute();
        if (updateResponse.isSuccessful()) {
            return (Doi)updateResponse.body();
        }
        logger.error((Object)("Error updating DOI for id " + id + ":" + updateResponse.errorBody().string()));
        throw new RuntimeException("Unable to update file for DOI uuid: " + id + ", with URL: " + fileUrl);
    }

    static /* synthetic */ String access$000(DoiService x0) {
        return x0.doiServiceApiKey;
    }
}

