/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import java.math.BigDecimal;

public enum PointType {
    POINT_1("point-1", Float.valueOf(1.0f), 0),
    POINT_01("point-0.1", Float.valueOf(0.1f), 1),
    POINT_001("point-0.01", Float.valueOf(0.01f), 2),
    POINT_0001("point-0.001", Float.valueOf(0.001f), 3),
    POINT_00001("point-0.0001", Float.valueOf(1.0E-4f), 4),
    POINT_RAW("lat_long", Float.valueOf(0.0f), 4);

    private String label;
    private Float value;
    private int rounding;

    private PointType(String label, Float value, int rounding) {
        this.label = label;
        this.value = value;
        this.rounding = rounding;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Float getValue() {
        return this.value;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public double roundDownToPointType(double value) {
        BigDecimal bd = new BigDecimal(value);
        BigDecimal rounded = bd.setScale(this.rounding, 3);
        return rounded.floatValue();
    }

    public double roundUpToPointType(double value) {
        BigDecimal bd = new BigDecimal(value);
        BigDecimal rounded = bd.setScale(this.rounding, 2);
        return rounded.floatValue();
    }

    public double roundToPointType(double value) {
        BigDecimal bd = new BigDecimal(value);
        BigDecimal rounded = bd.setScale(this.rounding, 4);
        return rounded.floatValue();
    }
}

