/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.beans.Field;
import org.codehaus.jackson.map.ObjectMapper;

public class OccurrenceIndex {
    protected static final Logger logger = Logger.getLogger(OccurrenceIndex.class);
    @Field(value="id")
    String uuid;
    @Field(value="occurrence_id")
    String occurrenceID;
    @Field(value="data_hub_uid")
    String[] dataHubUid;
    @Field(value="data_hub")
    String dataHub;
    @Field(value="institution_uid")
    String institutionUid;
    @Field(value="institution_code")
    String raw_institutionCode;
    @Field(value="institution_name")
    String institutionName;
    @Field(value="collection_uid")
    String collectionUid;
    @Field(value="collection_code")
    String raw_collectionCode;
    @Field(value="collection_name")
    String collectionName;
    @Field(value="catalogue_number")
    String raw_catalogNumber;
    @Field(value="taxon_concept_lsid")
    String taxonConceptID;
    @Field(value="occurrence_date")
    Date eventDate;
    @Field(value="occurrence_date_end_dt")
    Date eventDateEnd;
    @Field(value="occurrence_year")
    Date occurrenceYear;
    @Field(value="taxon_name")
    String scientificName;
    @Field(value="common_name")
    String vernacularName;
    @Field(value="rank")
    String taxonRank;
    @Field(value="rank_id")
    Integer taxonRankID;
    @Field(value="country_code")
    String raw_countryCode;
    @Field(value="country")
    String country;
    @Field(value="kingdom")
    String kingdom;
    @Field(value="phylum")
    String phylum;
    @Field(value="class")
    String classs;
    @Field(value="order")
    String order;
    @Field(value="family")
    String family;
    @Field(value="genus")
    String genus;
    @Field(value="genus_guid")
    String genusGuid;
    @Field(value="species")
    String species;
    @Field(value="species_guid")
    String speciesGuid;
    @Field(value="subspecies")
    String subspecies;
    @Field(value="subspecies_guid")
    String subspeciesGuid;
    @Field(value="state")
    String stateProvince;
    @Field(value="latitude")
    Double decimalLatitude;
    @Field(value="longitude")
    Double decimalLongitude;
    @Field(value="coordinate_uncertainty")
    Double coordinateUncertaintyInMeters;
    @Field(value="year")
    Integer year;
    @Field(value="month")
    String month;
    @Field(value="basis_of_record")
    String basisOfRecord;
    @Field(value="type_status")
    String typeStatus;
    @Field(value="location_remarks")
    String raw_locationRemarks;
    @Field(value="occurrence_remarks")
    String raw_occurrenceRemarks;
    @Field(value="lft")
    Integer left;
    @Field(value="rgt")
    Integer right;
    @Field(value="ibra")
    String ibra;
    @Field(value="imcra")
    String imcra;
    @Field(value="places")
    String lga;
    @Field(value="data_provider_uid")
    String dataProviderUid;
    @Field(value="data_provider")
    String dataProviderName;
    @Field(value="data_resource_uid")
    String dataResourceUid;
    @Field(value="data_resource")
    String dataResourceName;
    @Field(value="assertions")
    String[] assertions;
    @Field(value="user_assertions")
    String hasUserAssertions;
    @Field(value="species_group")
    String[] speciesGroups;
    @Field(value="image_url")
    String image;
    @Field(value="all_image_url")
    String[] images;
    @Field(value="geospatial_kosher")
    String geospatialKosher;
    @Field(value="taxonomic_kosher")
    String taxonomicKosher;
    @Field(value="collector")
    String collector;
    @Field(value="collectors")
    String[] collectors;
    @Field(value="raw_taxon_name")
    String raw_scientificName;
    @Field(value="raw_basis_of_record")
    String raw_basisOfRecord;
    @Field(value="raw_type_status")
    String raw_typeStatus;
    @Field(value="raw_common_name")
    String raw_vernacularName;
    @Field(value="lat_long")
    String latLong;
    @Field(value="point-1")
    String point1;
    @Field(value="point-0.1")
    String point01;
    @Field(value="point-0.01")
    String point001;
    @Field(value="point-0.001")
    String point0001;
    @Field(value="point-0.0001")
    String point00001;
    @Field(value="names_and_lsid")
    String namesLsid;
    @Field(value="multimedia")
    String[] multimedia;
    @Field(value="license")
    String license;
    @Field(value="identification_verification_status")
    String identificationVerificationStatus;
    @Field(value="aust_conservation")
    String austConservation;
    @Field(value="state_conservation")
    String stateConservation;
    @Field(value="sensitive")
    String sensitive;
    @Field(value="record_number")
    String recordNumber;
    @Field(value="occurrence_details")
    String occurrenceDetails;
    @Field(value="rights")
    String rights;
    @Field(value="photographer_s")
    String photographer;
    @Field(value="grid_ref")
    String gridReference;
    @Field(value="*_s")
    Map<String, Object> miscStringProperties;
    @Field(value="*_i")
    Map<String, Object> miscIntProperties;
    @Field(value="*_d")
    Map<String, Object> miscDoubleProperties;
    @Field(value="*_dt")
    Map<String, Object> miscDateProperties;
    List<Map<String, Object>> imageMetadata;
    String imageUrl;
    String largeImageUrl;
    String smallImageUrl;
    String thumbnailUrl;
    String[] imageUrls;
    @JsonIgnore
    public static String defaultFields = StringUtils.join(new OccurrenceIndex().indexToJsonMap().keySet(), (String)",");

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setLargeImageUrl(String largeImageUrl) {
        this.largeImageUrl = largeImageUrl;
    }

    public void setSmallImageUrl(String smallImageUrl) {
        this.smallImageUrl = smallImageUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String[] getImageUrls() {
        return this.imageUrls;
    }

    public String getLargeImageUrl() {
        return this.largeImageUrl;
    }

    public void setImageUrls(String[] urls) {
        this.imageUrls = urls;
    }

    public String getSmallImageUrl() {
        return this.smallImageUrl;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    private void addToMapIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null && value != "") {
            map.put(key, value);
        }
    }

    private String safeDblToString(Double d) {
        if (d != null) {
            return d.toString();
        }
        return null;
    }

    private String safeIntToString(Integer d) {
        if (d != null) {
            return d.toString();
        }
        return null;
    }

    private String arrToString(String[] arr) {
        try {
            if (arr != null) {
                ObjectMapper o = new ObjectMapper();
                return o.writeValueAsString((Object)arr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @JsonIgnore
    public Map<String, String> toMap() {
        String sdate = null;
        if (this.eventDate != null) {
            sdate = DateFormatUtils.format((Date)this.eventDate, (String)"yyyy-MM-dd");
        }
        Object sdateEnd = null;
        if (this.eventDateEnd != null) {
            sdate = DateFormatUtils.format((Date)this.eventDateEnd, (String)"yyyy-MM-dd");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (java.lang.reflect.Field f : OccurrenceIndex.class.getDeclaredFields()) {
            Field annotation = f.getAnnotation(Field.class);
            if (annotation == null || annotation.value().contains("*")) continue;
            try {
                String value = null;
                if (f.getType() == Integer.class) {
                    value = this.safeIntToString((Integer)f.get(this));
                } else if (f.getType() == Double.class) {
                    value = this.safeDblToString((Double)f.get(this));
                } else if (f.getType() == Date.class) {
                    value = DateFormatUtils.format((Date)((Date)f.get(this)), (String)"yyyy-MM-dd");
                } else if (f.getType() == String.class) {
                    value = (String)f.get(this);
                } else if (f.getType() == new String[0].getClass()) {
                    value = this.arrToString((String[])f.get(this));
                } else {
                    logger.error((Object)new Exception("Field type not yet implemented in OccurrenceIndex.toMap: " + f.getType().getName() + " " + f.getName()));
                }
                this.addToMapIfNotNull(map, annotation.value(), value);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
        }
        return map;
    }

    @JsonIgnore
    public Map<String, String> indexToJsonMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (java.lang.reflect.Field f : OccurrenceIndex.class.getDeclaredFields()) {
            Field annotation = f.getAnnotation(Field.class);
            if (annotation == null || annotation.value().contains("*")) continue;
            map.put(annotation.value(), f.getName());
        }
        return map;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getOccurrenceID() {
        return this.occurrenceID;
    }

    public void setOccurrenceID(String occurrenceID) {
        this.occurrenceID = occurrenceID;
    }

    public String[] getDataHubUid() {
        return this.dataHubUid;
    }

    public void setDataHubUid(String[] dataHubUid) {
        this.dataHubUid = dataHubUid;
    }

    public String getDataHub() {
        return this.dataHub;
    }

    public void setDataHub(String dataHub) {
        this.dataHub = dataHub;
    }

    public String getInstitutionUid() {
        return this.institutionUid;
    }

    public void setInstitutionUid(String institutionUid) {
        this.institutionUid = institutionUid;
    }

    public String getRaw_institutionCode() {
        return this.raw_institutionCode;
    }

    public void setRaw_institutionCode(String raw_institutionCode) {
        this.raw_institutionCode = raw_institutionCode;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public String getCollectionUid() {
        return this.collectionUid;
    }

    public void setCollectionUid(String collectionUid) {
        this.collectionUid = collectionUid;
    }

    public String getRaw_collectionCode() {
        return this.raw_collectionCode;
    }

    public void setRaw_collectionCode(String raw_collectionCode) {
        this.raw_collectionCode = raw_collectionCode;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getRaw_catalogNumber() {
        return this.raw_catalogNumber;
    }

    public void setRaw_catalogNumber(String raw_catalogNumber) {
        this.raw_catalogNumber = raw_catalogNumber;
    }

    public String getTaxonConceptID() {
        return this.taxonConceptID;
    }

    public void setTaxonConceptID(String taxonConceptID) {
        this.taxonConceptID = taxonConceptID;
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public Date getEventDateEnd() {
        return this.eventDateEnd;
    }

    public void setEventDateEnd(Date eventDateEnd) {
        this.eventDateEnd = eventDateEnd;
    }

    public Date getOccurrenceYear() {
        return this.occurrenceYear;
    }

    public void setOccurrenceYear(Date occurrenceYear) {
        this.occurrenceYear = occurrenceYear;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    public String getVernacularName() {
        return this.vernacularName;
    }

    public void setVernacularName(String vernacularName) {
        this.vernacularName = vernacularName;
    }

    public String getTaxonRank() {
        return this.taxonRank;
    }

    public void setTaxonRank(String taxonRank) {
        this.taxonRank = taxonRank;
    }

    public Integer getTaxonRankID() {
        return this.taxonRankID;
    }

    public void setTaxonRankID(Integer taxonRankID) {
        this.taxonRankID = taxonRankID;
    }

    public String getRaw_countryCode() {
        return this.raw_countryCode;
    }

    public void setRaw_countryCode(String raw_countryCode) {
        this.raw_countryCode = raw_countryCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getKingdom() {
        return this.kingdom;
    }

    public void setKingdom(String kingdom) {
        this.kingdom = kingdom;
    }

    public String getPhylum() {
        return this.phylum;
    }

    public void setPhylum(String phylum) {
        this.phylum = phylum;
    }

    public String getClasss() {
        return this.classs;
    }

    public void setClasss(String classs) {
        this.classs = classs;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getGenus() {
        return this.genus;
    }

    public void setGenus(String genus) {
        this.genus = genus;
    }

    public String getGenusGuid() {
        return this.genusGuid;
    }

    public void setGenusGuid(String genusGuid) {
        this.genusGuid = genusGuid;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getSpeciesGuid() {
        return this.speciesGuid;
    }

    public void setSpeciesGuid(String speciesGuid) {
        this.speciesGuid = speciesGuid;
    }

    public String getSubspecies() {
        return this.subspecies;
    }

    public void setSubspecies(String subspecies) {
        this.subspecies = subspecies;
    }

    public String getSubspeciesGuid() {
        return this.subspeciesGuid;
    }

    public void setSubspeciesGuid(String subspeciesGuid) {
        this.subspeciesGuid = subspeciesGuid;
    }

    public String getStateProvince() {
        return this.stateProvince;
    }

    public void setStateProvince(String stateProvince) {
        this.stateProvince = stateProvince;
    }

    public Double getDecimalLatitude() {
        return this.decimalLatitude;
    }

    public void setDecimalLatitude(Double decimalLatitude) {
        this.decimalLatitude = decimalLatitude;
    }

    public Double getDecimalLongitude() {
        return this.decimalLongitude;
    }

    public void setDecimalLongitude(Double decimalLongitude) {
        this.decimalLongitude = decimalLongitude;
    }

    public Double getCoordinateUncertaintyInMeters() {
        return this.coordinateUncertaintyInMeters;
    }

    public void setCoordinateUncertaintyInMeters(Double coordinateUncertaintyInMeters) {
        this.coordinateUncertaintyInMeters = coordinateUncertaintyInMeters;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getBasisOfRecord() {
        return this.basisOfRecord;
    }

    public void setBasisOfRecord(String basisOfRecord) {
        this.basisOfRecord = basisOfRecord;
    }

    public String getTypeStatus() {
        return this.typeStatus;
    }

    public void setTypeStatus(String typeStatus) {
        this.typeStatus = typeStatus;
    }

    public String getRaw_locationRemarks() {
        return this.raw_locationRemarks;
    }

    public void setRaw_locationRemarks(String raw_locationRemarks) {
        this.raw_locationRemarks = raw_locationRemarks;
    }

    public String getRaw_occurrenceRemarks() {
        return this.raw_occurrenceRemarks;
    }

    public void setRaw_occurrenceRemarks(String raw_occurrenceRemarks) {
        this.raw_occurrenceRemarks = raw_occurrenceRemarks;
    }

    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public Integer getRight() {
        return this.right;
    }

    public void setRight(Integer right) {
        this.right = right;
    }

    public String getIbra() {
        return this.ibra;
    }

    public void setIbra(String ibra) {
        this.ibra = ibra;
    }

    public String getImcra() {
        return this.imcra;
    }

    public void setImcra(String imcra) {
        this.imcra = imcra;
    }

    public String getLga() {
        return this.lga;
    }

    public void setLga(String lga) {
        this.lga = lga;
    }

    public String getDataProviderUid() {
        return this.dataProviderUid;
    }

    public void setDataProviderUid(String dataProviderUid) {
        this.dataProviderUid = dataProviderUid;
    }

    public String getDataProviderName() {
        return this.dataProviderName;
    }

    public void setDataProviderName(String dataProviderName) {
        this.dataProviderName = dataProviderName;
    }

    public String getDataResourceUid() {
        return this.dataResourceUid;
    }

    public void setDataResourceUid(String dataResourceUid) {
        this.dataResourceUid = dataResourceUid;
    }

    public String getDataResourceName() {
        return this.dataResourceName;
    }

    public void setDataResourceName(String dataResourceName) {
        this.dataResourceName = dataResourceName;
    }

    public String[] getAssertions() {
        return this.assertions;
    }

    public void setAssertions(String[] assertions) {
        this.assertions = assertions;
    }

    public String getHasUserAssertions() {
        return this.hasUserAssertions;
    }

    public void setHasUserAssertions(String hasUserAssertions) {
        this.hasUserAssertions = hasUserAssertions;
    }

    public String[] getSpeciesGroups() {
        return this.speciesGroups;
    }

    public void setSpeciesGroups(String[] speciesGroups) {
        this.speciesGroups = speciesGroups;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String[] getImages() {
        return this.images;
    }

    public void setImages(String[] images) {
        this.images = images;
    }

    public String getGeospatialKosher() {
        return this.geospatialKosher;
    }

    public void setGeospatialKosher(String geospatialKosher) {
        this.geospatialKosher = geospatialKosher;
    }

    public String getTaxonomicKosher() {
        return this.taxonomicKosher;
    }

    public void setTaxonomicKosher(String taxonomicKosher) {
        this.taxonomicKosher = taxonomicKosher;
    }

    public String getCollector() {
        return this.collector;
    }

    public void setCollector(String collector) {
        this.collector = collector;
    }

    public String getRaw_scientificName() {
        return this.raw_scientificName;
    }

    public void setRaw_scientificName(String raw_scientificName) {
        this.raw_scientificName = raw_scientificName;
    }

    public String getRaw_basisOfRecord() {
        return this.raw_basisOfRecord;
    }

    public void setRaw_basisOfRecord(String raw_basisOfRecord) {
        this.raw_basisOfRecord = raw_basisOfRecord;
    }

    public String getRaw_typeStatus() {
        return this.raw_typeStatus;
    }

    public void setRaw_typeStatus(String raw_typeStatus) {
        this.raw_typeStatus = raw_typeStatus;
    }

    public String getRaw_vernacularName() {
        return this.raw_vernacularName;
    }

    public void setRaw_vernacularName(String raw_vernacularName) {
        this.raw_vernacularName = raw_vernacularName;
    }

    public String getLatLong() {
        return this.latLong;
    }

    public void setLatLong(String latLong) {
        this.latLong = latLong;
    }

    public String getPoint1() {
        return this.point1;
    }

    public void setPoint1(String point1) {
        this.point1 = point1;
    }

    public String getPoint01() {
        return this.point01;
    }

    public void setPoint01(String point01) {
        this.point01 = point01;
    }

    public String getPoint001() {
        return this.point001;
    }

    public void setPoint001(String point001) {
        this.point001 = point001;
    }

    public String getPoint0001() {
        return this.point0001;
    }

    public void setPoint0001(String point0001) {
        this.point0001 = point0001;
    }

    public String getPoint00001() {
        return this.point00001;
    }

    public void setPoint00001(String point00001) {
        this.point00001 = point00001;
    }

    public String getNamesLsid() {
        return this.namesLsid;
    }

    public void setNamesLsid(String namesLsid) {
        this.namesLsid = namesLsid;
    }

    public String[] getMultimedia() {
        return this.multimedia;
    }

    public void setMultimedia(String[] multimedia) {
        this.multimedia = multimedia;
    }

    public String getAustConservation() {
        return this.austConservation;
    }

    public void setAustConservation(String austConservation) {
        this.austConservation = austConservation;
    }

    public String getStateConservation() {
        return this.stateConservation;
    }

    public void setStateConservation(String stateConservation) {
        this.stateConservation = stateConservation;
    }

    public String getSensitive() {
        return this.sensitive;
    }

    public void setSensitive(String sensitive) {
        this.sensitive = sensitive;
    }

    public String[] getCollectors() {
        return this.collectors;
    }

    public void setCollectors(String[] collectors) {
        this.collectors = collectors;
    }

    public String getRecordNumber() {
        return this.recordNumber;
    }

    public void setRecordNumber(String recordNumber) {
        this.recordNumber = recordNumber;
    }

    public String getOccurrenceDetails() {
        return this.occurrenceDetails;
    }

    public void setOccurrenceDetails(String occurrenceDetails) {
        this.occurrenceDetails = occurrenceDetails;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public String getPhotographer() {
        return this.photographer;
    }

    public void setPhotographer(String photographer) {
        this.photographer = photographer;
    }

    public List<Map<String, Object>> getImageMetadata() {
        return this.imageMetadata;
    }

    public void setImageMetadata(List<Map<String, Object>> imageMetadata) {
        this.imageMetadata = imageMetadata;
    }

    public Map<String, Object> getMiscStringProperties() {
        return this.miscStringProperties;
    }

    public void setMiscStringProperties(Map<String, Object> miscStringProperties) {
        this.miscStringProperties = miscStringProperties;
    }

    public Map<String, Object> getMiscIntProperties() {
        return this.miscIntProperties;
    }

    public void setMiscIntProperties(Map<String, Object> miscIntProperties) {
        this.miscIntProperties = miscIntProperties;
    }

    public Map<String, Object> getMiscDoubleProperties() {
        return this.miscDoubleProperties;
    }

    public void setMiscDoubleProperties(Map<String, Object> miscDoubleProperties) {
        this.miscDoubleProperties = miscDoubleProperties;
    }

    public String getGridReference() {
        return this.gridReference;
    }

    public void setGridReference(String gridReference) {
        this.gridReference = gridReference;
    }

    public Map<String, Object> getMiscDateProperties() {
        return this.miscDateProperties;
    }

    public void setMiscDateProperties(Map<String, Object> miscDateProperties) {
        this.miscDateProperties = miscDateProperties;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getIdentificationVerificationStatus() {
        return this.identificationVerificationStatus;
    }

    public void setIdentificationVerificationStatus(String identificationVerificationStatus) {
        this.identificationVerificationStatus = identificationVerificationStatus;
    }
}

