/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.Config;
import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.QidDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.model.Qid;
import au.org.ala.biocache.service.DataQualityService;
import au.org.ala.biocache.util.QidMissingException;
import au.org.ala.biocache.util.QidSizeException;
import au.org.ala.biocache.util.SpatialUtils;
import com.googlecode.ehcache.annotations.Cacheable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="qidCacheDao")
public class QidCacheDAOImpl
implements QidCacheDAO {
    private final Logger logger = Logger.getLogger(QidCacheDAOImpl.class);
    @Value(value="${qid.cache.size.max:104857600}")
    long maxCacheSize;
    @Value(value="${qid.cache.size.min:52428800}")
    long minCacheSize;
    @Value(value="${qid.cache.largestCacheableSize:5242880}")
    long largestCacheableSize;
    @Value(value="${qid.wkt.maxPoints:5000}")
    private int maxWktPoints;
    @Value(value="${qid.wkt.simplification.factor:2.0}")
    private double wktSimplificationFactor;
    @Value(value="${qid.wkt.simplification.initialprecision:0.0001}")
    private double wktSimplificationInitialPrecision;
    @Value(value="${qid.wkt.simplification.maxprecision:10.0}")
    private double wktSimplificationMaxPrecision;
    @Inject
    private DataQualityService dataQualityService;
    private ConcurrentMap<String, Qid> cache = new ConcurrentHashMap();
    private final Object counterLock = new Object();
    private long cacheSize;
    private CountDownLatch counter;
    private long triggerCleanSize = this.minCacheSize + (this.maxCacheSize - this.minCacheSize) / 2L;
    private Thread cacheCleaner;
    @Inject
    private SearchDAO searchDAO;
    protected QidDAO qidDao = (QidDAO)Config.getInstance(QidDAO.class);

    public QidCacheDAOImpl() {
        this.counter = new CountDownLatch(1);
        this.cacheCleaner = new /* Unavailable Anonymous Inner Class!! */;
        this.cacheCleaner.setName("qid-cache-cleaner");
        this.cacheCleaner.start();
        try {
            this.updateTriggerCleanSize();
            this.logger.info((Object)("maxCacheSize > " + this.maxCacheSize));
            this.logger.info((Object)("minCacheSize > " + this.minCacheSize));
        }
        catch (Exception e) {
            this.logger.error((Object)"cannot load qid.properties", (Throwable)e);
        }
    }

    public String put(String q, String displayQ, String wkt, double[] bbox, String[] fqs, long maxAge, String source) throws QidSizeException {
        Qid qid = new Qid(null, q, displayQ, wkt, bbox, 0L, fqs, maxAge, source);
        if ((long)qid.size() > this.largestCacheableSize) {
            throw new QidSizeException((long)qid.size());
        }
        this.save(qid);
        while (!this.put(qid)) {
        }
        return qid.getRowKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean put(Qid qid) {
        boolean runCleaner = false;
        Object object = this.counterLock;
        synchronized (object) {
            this.logger.debug((Object)("new cache size: " + this.cacheSize));
            if (this.cacheSize + (long)qid.size() > this.maxCacheSize) {
                runCleaner = true;
                this.logger.debug((Object)"not putting qid");
            } else {
                if (this.cacheSize + (long)qid.size() > this.triggerCleanSize) {
                    this.counter.countDown();
                }
                this.cacheSize += (long)qid.size();
                this.logger.debug((Object)"putting qid");
                this.cache.put(qid.getRowKey(), qid);
            }
        }
        if (runCleaner) {
            this.logger.debug((Object)"cleaning qid cache");
            this.cleanCache();
            return false;
        }
        return true;
    }

    public Qid get(String key) throws QidMissingException {
        Qid obj = (Qid)this.cache.get(key);
        if (obj == null && (obj = this.load(key)) != null) {
            this.cache.put(key, obj);
            if (obj.getQ() != null && obj.getQ().indexOf(92) >= 0) {
                obj.setQ(this.removeSolrEscaping(obj.getQ()));
            }
        }
        if (obj == null) {
            throw new QidMissingException(key);
        }
        obj.setLastUse(System.currentTimeMillis());
        return obj;
    }

    private String removeSolrEscaping(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        char c = ' ';
        int len = s.length() - 1;
        for (int i = 0; i < len; ++i) {
            char a = s.charAt(i);
            c = s.charAt(i + 1);
            if (a == '\\' && (c == 92 || c == 43 || c == 45 || c == 33 || c == 40 || c == 41 || c == 58 || c == 94 || c == 91 || c == 93 || c == 34 || c == 123 || c == 125 || c == 126 || c == 42 || c == 63 || c == 124 || c == 38 || c == 59 || c == 47 || Character.isWhitespace(c))) continue;
            sb.append(a);
        }
        sb.append(c);
        return sb.toString();
    }

    public Qid getQidFromQuery(String query) throws QidMissingException {
        Matcher matcher;
        Qid qid = null;
        if (query.contains("qid:") && (matcher = qidPattern.matcher(query)).find()) {
            String value = matcher.group();
            qid = this.get(value.substring(4));
        }
        return qid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanCache() {
        this.updateTriggerCleanSize();
        if (this.cacheSize < this.triggerCleanSize) {
            return;
        }
        ArrayList entries = new ArrayList(this.cache.entrySet());
        Collections.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
        long size = 0L;
        int numberRemoved = 0;
        for (int i = 0; i < entries.size(); ++i) {
            if (size + (long)((Qid)((Map.Entry)entries.get(i)).getValue()).size() > this.minCacheSize) {
                String key = (String)((Map.Entry)entries.get(i)).getKey();
                this.cache.remove(key);
                ++numberRemoved;
                continue;
            }
            size += (long)((Qid)((Map.Entry)entries.get(i)).getValue()).size();
        }
        Object object = this.counterLock;
        synchronized (object) {
            this.cacheSize -= this.minCacheSize - size;
            size = this.cacheSize;
        }
        this.logger.debug((Object)("removed " + numberRemoved + " cached qids, new cache size " + size));
    }

    void save(Qid value) {
        try {
            this.qidDao.put(value);
        }
        catch (Exception e) {
            this.logger.error((Object)"faild to save qid to db", (Throwable)e);
        }
    }

    Qid load(String key) throws QidMissingException {
        try {
            return this.qidDao.get(key);
        }
        catch (Exception e) {
            this.logger.error((Object)("failed to find qid:" + key), (Throwable)e);
            throw new QidMissingException(key);
        }
    }

    public void setMaxCacheSize(long sizeInBytes) {
        this.maxCacheSize = sizeInBytes;
        this.updateTriggerCleanSize();
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMinCacheSize(long sizeInBytes) {
        this.minCacheSize = sizeInBytes;
        this.updateTriggerCleanSize();
    }

    public long getMinCacheSize() {
        return this.minCacheSize;
    }

    public void setLargestCacheableSize(long sizeInBytes) {
        this.largestCacheableSize = sizeInBytes;
    }

    public long getLargestCacheableSize() {
        return this.largestCacheableSize;
    }

    public long getSize() {
        return this.cacheSize;
    }

    void updateTriggerCleanSize() {
        this.triggerCleanSize = this.minCacheSize + (this.maxCacheSize - this.minCacheSize) / 2L;
        this.logger.debug((Object)("triggerCleanSize=" + this.triggerCleanSize + " minCacheSize=" + this.minCacheSize + " maxCacheSize=" + this.maxCacheSize));
    }

    public String[] getFq(SpatialSearchRequestParams requestParams) {
        int requestParamsFqLength = requestParams.getFq() != null ? requestParams.getFq().length : 0;
        String[] qidFq = null;
        int qidFqLength = 0;
        String q = requestParams.getQ();
        if (q.startsWith("qid:")) {
            try {
                qidFq = this.get(q.substring(4)).getFqs();
                if (qidFq != null) {
                    qidFqLength = qidFq.length;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (requestParamsFqLength + qidFqLength == 0) {
            return null;
        }
        String[] allFqs = new String[requestParamsFqLength + qidFqLength];
        if (requestParamsFqLength > 0) {
            System.arraycopy(requestParams.getFq(), 0, allFqs, 0, requestParamsFqLength);
        }
        if (qidFqLength > 0) {
            System.arraycopy(qidFq, 0, allFqs, requestParamsFqLength, qidFqLength);
        }
        return allFqs;
    }

    @Cacheable(cacheName="qidGeneration")
    public String generateQid(SpatialSearchRequestParams requestParams, String bbox, String title, Long maxage, String source) {
        try {
            String[] fqs;
            String wkt = requestParams.getWkt();
            if (wkt != null && wkt.length() > 0) {
                if ((wkt = this.fixWkt(wkt)) == null) {
                    return null;
                }
                requestParams.setWkt(wkt);
            }
            double[] bb = null;
            if (bbox != null && bbox.equals("true")) {
                bb = this.searchDAO.getBBox(requestParams);
            } else {
                requestParams.setPageSize(Integer.valueOf(0));
                requestParams.setFacet(Boolean.valueOf(false));
                this.searchDAO.findByFulltext(requestParams);
            }
            if (title == null) {
                title = requestParams.getDisplayString();
            }
            if ((fqs = this.dataQualityService.generateCombinedFqs(requestParams)).length == 0 || fqs.length == 1 && fqs[0].length() == 0) {
                fqs = null;
            }
            String qid = this.put(requestParams.getQ(), title, requestParams.getWkt(), bb, fqs, maxage.longValue(), source);
            return qid;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error generating QID for q = " + requestParams.getQ() + ", fq = " + requestParams.getFq()), (Throwable)e);
            return null;
        }
    }

    @Cacheable(cacheName="fixWkt")
    private String fixWkt(String wkt) {
        return SpatialUtils.simplifyWkt((String)wkt, (int)this.maxWktPoints, (double)this.wktSimplificationFactor, (double)this.wktSimplificationInitialPrecision, (double)this.wktSimplificationMaxPrecision);
    }

    static /* synthetic */ CountDownLatch access$000(QidCacheDAOImpl x0) {
        return x0.counter;
    }

    static /* synthetic */ Object access$100(QidCacheDAOImpl x0) {
        return x0.counterLock;
    }

    static /* synthetic */ long access$202(QidCacheDAOImpl x0, long x1) {
        x0.cacheSize = x1;
        return x0.cacheSize;
    }

    static /* synthetic */ CountDownLatch access$002(QidCacheDAOImpl x0, CountDownLatch x1) {
        x0.counter = x1;
        return x0.counter;
    }

    static /* synthetic */ Logger access$300(QidCacheDAOImpl x0) {
        return x0.logger;
    }
}

