/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.FacetThemes;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.util.QueryFormatUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SearchRequestParams {
    protected Long qId = null;
    protected String formattedQuery = null;
    protected String q = "*:*";
    protected String[] fq = new String[0];
    protected String[] formattedFq = new String[0];
    protected String fl = OccurrenceIndex.defaultFields;
    protected String[] facets = FacetThemes.getAllFacetsLimited();
    protected Integer start = 0;
    protected Integer facetsMax = FacetThemes.getFacetsMax();
    protected Integer flimit = 30;
    protected String fsort = "";
    protected Integer foffset = 0;
    protected String fprefix = "";
    protected Integer pageSize = 10;
    protected String sort = "score";
    protected String dir = "asc";
    private String displayString;
    protected Boolean includeMultivalues = false;
    protected String qc = "";
    protected Boolean facet = FacetThemes.getFacetDefault();
    private static final Logger logger = Logger.getLogger(SearchRequestParams.class);

    public String toString() {
        return this.toString(Boolean.valueOf(false));
    }

    public String getEncodedParams() {
        return this.toString(Boolean.valueOf(true));
    }

    protected String toString(Boolean encodeParams) {
        StringBuilder req = new StringBuilder();
        boolean isFacet = this.getFacet() == null ? true : this.getFacet();
        req.append("q=").append(this.conditionalEncode(this.q, encodeParams));
        if (this.fq.length > 0) {
            for (String it : this.fq) {
                req.append("&fq=").append(this.conditionalEncode(it, encodeParams));
            }
        }
        req.append("&start=").append(this.start);
        req.append("&pageSize=").append(this.pageSize);
        req.append("&sort=").append(this.sort);
        req.append("&dir=").append(this.dir);
        req.append("&qc=").append(this.qc);
        if (this.facets != null && this.facets.length > 0 && isFacet) {
            for (String f : this.facets) {
                req.append("&facets=").append(this.conditionalEncode(f, encodeParams));
            }
        }
        if (this.flimit != 30) {
            req.append("&flimit=").append(this.flimit);
        }
        if (this.fl.length() > 0) {
            req.append("&fl=").append(this.conditionalEncode(this.fl, encodeParams));
        }
        if (StringUtils.isNotEmpty((String)this.formattedQuery)) {
            req.append("&formattedQuery=").append(this.conditionalEncode(this.formattedQuery, encodeParams));
        }
        req.append("&facet=" + isFacet);
        if (!"".equals(this.fsort)) {
            req.append("&fsort=").append(this.fsort);
        }
        if (this.foffset > 0) {
            req.append("&foffset=").append(this.foffset);
        }
        if (!"".equals(this.fprefix)) {
            req.append("&fprefix=").append(this.fprefix);
        }
        return req.toString();
    }

    protected String conditionalEncode(String input, Boolean isEncoded) {
        String output;
        if (isEncoded.booleanValue()) {
            try {
                output = URIUtil.encodeWithinQuery((String)input, (String)"UTF-8");
            }
            catch (URIException e) {
                logger.warn((Object)("URIUtil encoding error: " + e.getMessage()), (Throwable)e);
                output = input;
            }
        } else {
            output = input;
        }
        return output;
    }

    public String getUrlParams() {
        StringBuilder req = new StringBuilder();
        if (this.qId != null) {
            req.append("?q=qid:").append(this.conditionalEncode(this.qId.toString(), Boolean.valueOf(true)));
        } else {
            req.append("?q=").append(this.conditionalEncode(this.q, Boolean.valueOf(true)));
        }
        for (String f : this.fq) {
            if (f.length() <= 0 || f.equals(this.qc)) continue;
            req.append("&fq=").append(this.conditionalEncode(f, Boolean.valueOf(true)));
        }
        if (this.qc != "") {
            req.append("&qc=").append(this.conditionalEncode(this.qc, Boolean.valueOf(true)));
        }
        return req.toString();
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String query) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"q", (String)query);
        this.q = query;
    }

    public Long getQId() {
        return this.qId;
    }

    public void setQId(Long qId) {
        this.qId = qId;
    }

    public String[] getFq() {
        return this.fq;
    }

    public void setFq(String[] filterQuery) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"fq", (String[])filterQuery);
        this.fq = filterQuery;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public void setStartIndex(Integer startIndex) {
        this.start = startIndex;
    }

    public Integer getStartIndex() {
        return this.start;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"sort", (String)sort);
        this.sort = sort;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String sortDirection) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"sortDirection", (String)sortDirection);
        this.dir = sortDirection;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public void setDisplayString(String displayString) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"displayString", (String)displayString);
        this.displayString = displayString;
    }

    public String[] getFacets() {
        return this.facets;
    }

    public void setFacets(String[] facets) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"facets", (String[])facets);
        if (facets != null && facets.length == 1 && facets[0].contains(",")) {
            facets = facets[0].split(",");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (facets != null) {
            for (String f : facets) {
                if (!StringUtils.isNotEmpty((String)f) || list.size() >= this.facetsMax) continue;
                list.add(f);
            }
        }
        this.facets = list.toArray(new String[0]);
    }

    public Integer getFlimit() {
        return this.flimit;
    }

    public void setFlimit(Integer flimit) {
        this.flimit = flimit;
    }

    public String getQc() {
        return this.qc;
    }

    public void setQc(String qc) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"qc", (String)qc);
        this.qc = qc;
    }

    public String getFl() {
        return this.fl;
    }

    public void setFl(String fl) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"fl", (String)fl);
        this.fl = fl;
    }

    public String getFormattedQuery() {
        return this.formattedQuery;
    }

    public void setFormattedQuery(String formattedQuery) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"formattedQuery", (String)formattedQuery);
        this.formattedQuery = formattedQuery;
    }

    public Boolean getFacet() {
        return this.facet;
    }

    public void setFacet(Boolean facet) {
        this.facet = facet;
    }

    public String getFsort() {
        return this.fsort;
    }

    public void setFsort(String fsort) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"fsort", (String)fsort);
        this.fsort = fsort;
    }

    public Integer getFoffset() {
        return this.foffset;
    }

    public void setFoffset(Integer foffset) {
        this.foffset = foffset;
    }

    public String getFprefix() {
        return this.fprefix;
    }

    public void setFprefix(String fprefix) {
        this.fprefix = fprefix;
    }

    public Boolean getIncludeMultivalues() {
        return this.includeMultivalues;
    }

    public void setIncludeMultivalues(Boolean includeMultivalues) {
        this.includeMultivalues = includeMultivalues;
    }

    public String[] getFormattedFq() {
        return this.formattedFq;
    }

    public void setFormattedFq(String[] formattedFq) {
        QueryFormatUtils.assertNoSensitiveValues(SearchRequestParams.class, (String)"formattedFq", (String[])formattedFq);
        this.formattedFq = formattedFq;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dir == null ? 0 : this.dir.hashCode());
        result = 31 * result + (this.displayString == null ? 0 : this.displayString.hashCode());
        result = 31 * result + (this.facet == null ? 0 : this.facet.hashCode());
        result = 31 * result + Arrays.hashCode(this.facets);
        result = 31 * result + (this.fl == null ? 0 : this.fl.hashCode());
        result = 31 * result + (this.flimit == null ? 0 : this.flimit.hashCode());
        result = 31 * result + (this.foffset == null ? 0 : this.foffset.hashCode());
        result = 31 * result + (this.formattedQuery == null ? 0 : this.formattedQuery.hashCode());
        result = 31 * result + (this.fprefix == null ? 0 : this.fprefix.hashCode());
        result = 31 * result + Arrays.hashCode(this.fq);
        result = 31 * result + (this.fsort == null ? 0 : this.fsort.hashCode());
        result = 31 * result + (this.pageSize == null ? 0 : this.pageSize.hashCode());
        result = 31 * result + (this.q == null ? 0 : this.q.hashCode());
        result = 31 * result + (this.qc == null ? 0 : this.qc.hashCode());
        result = 31 * result + (this.sort == null ? 0 : this.sort.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }
}

