/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.RestartDataService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractMessageSource;

public class DownloadFields {
    private static final Logger logger = LoggerFactory.getLogger(DownloadFields.class);
    private AbstractMessageSource messageSource;
    private LayersService layersService;
    private Properties layerProperties = (Properties)RestartDataService.get((Object)this, (String)"layerProperties", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, Properties.class);
    private Map<String, IndexFieldDTO> indexFieldMaps;
    private Map<String, IndexFieldDTO> indexByDwcMaps;
    private Long lastUpdate = 0L;
    private Thread updateThread = null;

    public DownloadFields(Set<IndexFieldDTO> indexFields, AbstractMessageSource messageSource, LayersService layersService) {
        this.messageSource = messageSource;
        this.layersService = layersService;
        this.update(indexFields);
    }

    private synchronized void updateLayerNames() {
        if (this.layerProperties == null || this.layerProperties.size() == 0 || System.currentTimeMillis() > this.lastUpdate + 3600000L) {
            if (this.updateThread != null && this.updateThread.isAlive()) {
                this.updateThread.interrupt();
            }
            this.lastUpdate = System.currentTimeMillis();
            this.updateThread = new /* Unavailable Anonymous Inner Class!! */;
            if (this.layerProperties == null || this.layerProperties.size() == 0) {
                this.updateThread.run();
            } else {
                this.updateThread.start();
            }
        }
    }

    public String[] getHeader(String[] values, boolean useSuffix, boolean dwcHeaders) {
        this.updateLayerNames();
        String[] header = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            String v = dwcHeaders ? values[i] : this.layerProperties.getProperty(values[i], this.messageSource.getMessage(values[i], null, this.generateTitle(values[i], useSuffix), Locale.getDefault()));
            String dwc = dwcHeaders ? this.messageSource.getMessage("dwc." + values[i], null, "", Locale.getDefault()) : null;
            header[i] = dwc != null && dwc.length() > 0 ? dwc : v;
        }
        return header;
    }

    private String generateTitle(String value, boolean useSuffix) {
        String suffix = "";
        if (value.endsWith("_p")) {
            suffix = " - Processed";
            value = value.replaceAll("_p", "");
        }
        value = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)value), (String)" ");
        if (useSuffix) {
            value = value + suffix;
        }
        return value;
    }

    public String cleanRequestFieldName(String fieldName) {
        if (fieldName != null && (fieldName.endsWith(".p") || fieldName.endsWith("_p"))) {
            return fieldName.substring(0, fieldName.length() - 2);
        }
        return fieldName;
    }

    public List<String>[] getIndexFields(String[] fieldNames, boolean dwcHeaders, String layersServiceUrl) {
        this.updateLayerNames();
        LinkedList<String> mappedNames = new LinkedList<String>();
        LinkedList<String> headers = new LinkedList<String>();
        LinkedList<String> unmappedNames = new LinkedList<String>();
        LinkedList<String> originalName = new LinkedList<String>();
        LinkedList<String> analysisHeaders = new LinkedList<String>();
        LinkedList<String> analysisLayers = new LinkedList<String>();
        for (String fieldName : fieldNames) {
            String indexName = this.cleanRequestFieldName(fieldName);
            IndexFieldDTO field = (IndexFieldDTO)this.indexFieldMaps.get(indexName);
            if (field == null) {
                field = (IndexFieldDTO)this.indexByDwcMaps.get(indexName);
            }
            if (field != null && field.isStored() || fieldName.startsWith("sensitive")) {
                String fieldNameToUse = field != null ? field.getName() : fieldName;
                mappedNames.add(fieldNameToUse);
                String header = dwcHeaders && field != null && field.isStored() && !this.isSpatialField(field.getName()) ? field.getName() : this.layerProperties.getProperty(fieldNameToUse, this.messageSource.getMessage(fieldNameToUse, null, this.generateTitle(fieldNameToUse, true), Locale.getDefault()));
                String dwcHeader = dwcHeaders ? this.messageSource.getMessage("dwc." + fieldNameToUse, null, "", Locale.getDefault()) : null;
                headers.add(dwcHeader != null && dwcHeader.length() > 0 ? dwcHeader : header);
                originalName.add(fieldNameToUse);
                continue;
            }
            if (field == null && this.layersService.findAnalysisLayerName(indexName, layersServiceUrl) != null) {
                analysisLayers.add(indexName);
                analysisHeaders.add(this.layersService.findAnalysisLayerName(indexName, layersServiceUrl));
                continue;
            }
            unmappedNames.add(indexName);
        }
        return new List[]{mappedNames, unmappedNames, headers, originalName, analysisHeaders, analysisLayers};
    }

    private boolean isSpatialField(String name) {
        return name.matches("((cl)|(el))[0-9]+");
    }

    public void update(Set<IndexFieldDTO> indexedFields) {
        try {
            TreeMap<String, IndexFieldDTO> map = new TreeMap<String, IndexFieldDTO>();
            TreeMap<String, IndexFieldDTO> mapByDwC = new TreeMap<String, IndexFieldDTO>();
            for (IndexFieldDTO field : indexedFields) {
                map.put(field.getName(), field);
                if (field.getDwcTerm() == null) continue;
                mapByDwC.put(field.getDwcTerm(), field);
            }
            this.indexFieldMaps = map;
            this.indexByDwcMaps = mapByDwC;
            this.updateLayerNames();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ Properties access$002(DownloadFields x0, Properties x1) {
        x0.layerProperties = x1;
        return x0.layerProperties;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }
}

