/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.stream;

import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.writer.RecordWriterError;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class OptionalZipOutputStream
extends OutputStream {
    private static final String UNZIPPED_ENTRY_SEPARATOR = "------------------------------------------------------\n";
    private Type type;
    private OutputStream out;
    private ZipOutputStream zop;
    private String currentEntry;
    private long currentEntryLength;
    private int splitCount;
    private Integer maxMB;

    public boolean isNewFile(Object writer, long length) throws IOException {
        boolean isNewFile = false;
        if (this.type == Type.zipped) {
            this.currentEntryLength += length;
            if (this.currentEntryLength >= (long)this.maxMB.intValue() * 1024L * 1024L) {
                if (writer instanceof RecordWriterError) {
                    ((RecordWriterError)writer).flush();
                }
                this.closeEntry();
                this.currentEntryLength = 0L;
                ++this.splitCount;
                String[] parts = this.currentEntry.split("\\.(?=[^\\.]+$)");
                this.zop.putNextEntry(new ZipEntry(parts[0] + "_part" + this.splitCount + "." + parts[1]));
                isNewFile = true;
            }
        }
        return isNewFile;
    }

    public OptionalZipOutputStream(Type type, OutputStream out, Integer maxZipFileMB) {
        this.type = type;
        this.out = out;
        this.maxMB = maxZipFileMB;
        if (type == Type.zipped) {
            this.zop = new ZipOutputStream(out);
        }
    }

    public void putNextEntry(String name) throws IOException {
        this.currentEntry = name;
        this.currentEntryLength = 0L;
        this.splitCount = 1;
        if (this.type == Type.zipped) {
            this.zop.putNextEntry(new ZipEntry(name));
        } else {
            this.out.write(UNZIPPED_ENTRY_SEPARATOR.getBytes(StandardCharsets.UTF_8));
            this.out.write((name + "\n").getBytes(StandardCharsets.UTF_8));
        }
    }

    public void closeEntry() throws IOException {
        if (this.type == Type.zipped) {
            this.zop.closeEntry();
        } else {
            this.out.write("\n".getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.type == Type.zipped) {
            this.zop.write(b);
        } else {
            this.out.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.type == Type.zipped) {
            this.zop.write(b);
        } else {
            this.out.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.type == Type.zipped) {
            this.zop.close();
        } else {
            this.out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.type == Type.zipped) {
            this.zop.flush();
        } else {
            this.out.flush();
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getCurrentEntry() {
        return this.currentEntry;
    }
}

