/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.dao.TaxonDAO;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.springframework.stereotype.Component;

@Component(value="taxonDao")
public class TaxonDAOImpl
implements TaxonDAO {
    private static final Logger logger = Logger.getLogger(TaxonDAOImpl.class);
    protected SolrClient server;
    @Inject
    private SolrClient solrClient;

    public void extractBySpeciesGroups(String metadataUrl, String q, String[] fq, Writer writer) throws Exception {
        List speciesGroups = this.extractFacet(q, fq, "species_group");
        for (FacetField.Count spg : speciesGroups) {
            if (spg.getName() == null) continue;
            List orders = this.extractFacet(q, (String[])ArrayUtils.add((Object[])fq, (Object)("species_group:" + spg.getName())), "order");
            for (FacetField.Count o : orders) {
                if (o.getName() == null) continue;
                this.outputNestedMappableLayerStart("order", o.getName(), writer);
                List families = this.extractFacet(q, (String[])ArrayUtils.add((Object[])fq, (Object)("order:" + o.getName())), "family");
                for (FacetField.Count f : families) {
                    if (f.getName() == null) continue;
                    this.outputNestedMappableLayerStart("family", f.getName(), writer);
                    List genera = this.extractFacet(q, (String[])ArrayUtils.addAll((Object[])fq, (Object[])new String[]{"family:" + f.getName(), "species_group:" + spg.getName()}), "genus");
                    for (FacetField.Count g : genera) {
                        if (g.getName() == null) continue;
                        this.outputNestedMappableLayerStart("genus", g.getName(), writer);
                        List species = this.extractFacet(q, (String[])ArrayUtils.addAll((Object[])fq, (Object[])new String[]{"genus:" + g.getName(), "species_group:" + spg.getName(), "family:" + f.getName()}), "species");
                        for (FacetField.Count s : species) {
                            if (s.getName() == null) continue;
                            this.outputLayer(metadataUrl, "species", s.getName(), writer);
                        }
                        this.outputNestedLayerEnd(writer);
                    }
                    this.outputNestedLayerEnd(writer);
                }
                this.outputNestedLayerEnd(writer);
            }
            this.outputNestedLayerEnd(writer);
        }
    }

    public void extractHierarchy(String metadataUrl, String q, String[] fq, Writer writer) throws Exception {
        List kingdoms = this.extractFacet(q, fq, "kingdom");
        for (FacetField.Count k : kingdoms) {
            if (k.getName() == null) continue;
            this.outputNestedLayerStart(k.getName(), writer);
            List phyla = this.extractFacet(q, (String[])ArrayUtils.add((Object[])fq, (Object)("kingdom:" + k.getName())), "phylum");
            for (FacetField.Count p : phyla) {
                if (p.getName() == null) continue;
                this.outputNestedMappableLayerStart("phylum", p.getName(), writer);
                List classes = this.extractFacet(q, (String[])ArrayUtils.add((Object[])fq, (Object)("phylum:" + p.getName())), "class");
                for (FacetField.Count c : classes) {
                    if (c.getName() == null) continue;
                    this.outputNestedMappableLayerStart("class", c.getName(), writer);
                    List orders = this.extractFacet(q, (String[])ArrayUtils.add((Object[])fq, (Object)("class:" + c.getName())), "order");
                    for (FacetField.Count o : orders) {
                        if (o.getName() == null) continue;
                        this.outputNestedMappableLayerStart("order", o.getName(), writer);
                        List families = this.extractFacet(q, (String[])ArrayUtils.addAll((Object[])fq, (Object[])new String[]{"order:" + o.getName(), "kingdom:" + k.getName()}), "family");
                        for (FacetField.Count f : families) {
                            if (f.getName() == null) continue;
                            this.outputNestedMappableLayerStart("family", f.getName(), writer);
                            List genera = this.extractFacet(q, (String[])ArrayUtils.addAll((Object[])fq, (Object[])new String[]{"family:" + f.getName(), "kingdom:" + k.getName()}), "genus");
                            for (FacetField.Count g : genera) {
                                if (g.getName() == null) continue;
                                this.outputNestedMappableLayerStart("genus", g.getName(), writer);
                                List species = this.extractFacet(q, (String[])ArrayUtils.addAll((Object[])fq, (Object[])new String[]{"genus:" + g.getName(), "kingdom:" + k.getName(), "family:" + f.getName()}), "species");
                                for (FacetField.Count s : species) {
                                    if (s.getName() == null) continue;
                                    this.outputLayer(metadataUrl, "species", s.getName(), writer);
                                }
                                this.outputNestedLayerEnd(writer);
                            }
                            this.outputNestedLayerEnd(writer);
                        }
                        this.outputNestedLayerEnd(writer);
                    }
                    this.outputNestedLayerEnd(writer);
                }
                this.outputNestedLayerEnd(writer);
            }
            this.outputNestedLayerEnd(writer);
        }
    }

    void outputNestedMappableLayerStart(String rank, String taxon, Writer out) throws Exception {
        out.write("<Layer queryable=\"1\"><Name>" + rank + ":" + taxon + "</Name><Title>" + taxon + "</Title>");
        out.flush();
    }

    void outputNestedLayerStart(String layerName, Writer out) throws Exception {
        out.write("<Layer><Name>" + layerName + "</Name><Title>" + layerName + "</Title>\n\t");
        out.flush();
    }

    void outputNestedLayerEnd(Writer out) throws Exception {
        out.write("</Layer>");
        out.flush();
    }

    void outputLayer(String metadataUrlRoot, String rank, String taxon, Writer out) throws Exception {
        String normalised = taxon.replaceFirst("\\([A-Za-z]*\\) ", "").replace(" ", "_").replace("&", "&amp;");
        String normalisedTitle = taxon.replaceFirst("\\([A-Za-z]*\\) ", "").replace("&", "&amp;");
        out.write("<Layer queryable=\"1\"><Name>" + rank + ":" + normalised + "</Name><Title>" + rank + ":" + normalisedTitle + "</Title><MetadataURL type=\"TC211\">\n<Format>text/html</Format>\n<OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + metadataUrlRoot + "?q=" + rank + ":" + URLEncoder.encode(taxon, "UTF-8") + "\"/>\n</MetadataURL></Layer>");
        out.flush();
    }

    private List<FacetField.Count> extractFacet(String queryString, String[] filterQueries, String facetName) throws Exception {
        QueryResponse response;
        ArrayList fc;
        SolrQuery query = new SolrQuery(queryString);
        query.setFacet(true);
        query.addFacetField(new String[]{facetName});
        query.setRows(Integer.valueOf(0));
        query.setFacetLimit(200000);
        query.setStart(Integer.valueOf(0));
        query.setFacetMinCount(1);
        query.setFacetSort("index");
        if (filterQueries != null) {
            for (String fq : filterQueries) {
                query.addFilterQuery(new String[]{fq});
            }
        }
        if ((fc = (response = this.solrClient.query((SolrParams)query)).getFacetField(facetName).getValues()) == null) {
            fc = new ArrayList();
        }
        return fc;
    }
}

