/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.FieldStatsItem;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.web.AbstractSecureController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import net.sf.ehcache.CacheManager;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.common.util.NamedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Api(basePath="/", value="/", description="Home Controller")
public class ChartController
extends AbstractSecureController
implements Serializable {
    private static final Logger logger = Logger.getLogger(ChartController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Autowired
    private ServletContext servletContext;
    @Resource(name="cacheManager")
    private CacheManager cacheManager;
    @Value(value="${charts.series.max:5}")
    private Integer maxSeriesFacets;
    @Value(value="${charts.facets.string.max:50}")
    private Integer maxStringFacets;
    @Value(value="${charts.facets.number.max:50}")
    private Integer maxNumberFacets;

    @ApiOperation(value="Standard charting", notes="Generate data for a standard chart", response=FieldStatsItem.class, responseContainer="List")
    @RequestMapping(value={"/chart"}, method={RequestMethod.GET})
    @ResponseBody
    public Map chart(SpatialSearchRequestParams searchParams, @RequestParam(value="x", required=false) String x, @RequestParam(value="xranges", required=false) String xranges, @RequestParam(value="stats", required=false) String stats, @RequestParam(value="series", required=false) String series, @RequestParam(value="seriesranges", required=false) String seriesranges, @RequestParam(value="seriesother", required=false, defaultValue="false") Boolean seriesother, @RequestParam(value="xother", required=false, defaultValue="true") Boolean xother, @RequestParam(value="seriesmissing", required=false, defaultValue="false") Boolean seriesmissing, @RequestParam(value="xmissing", required=false, defaultValue="true") Boolean xmissing, @RequestParam(value="fsort", required=false, defaultValue="index") String fsort) throws Exception {
        List seriesFqs = this.produceSeriesFqs(searchParams, x, series, seriesranges, seriesother, seriesmissing);
        StringBuilder inverseXranges = new StringBuilder();
        StringBuilder xRanges = new StringBuilder();
        xranges = this.produceLimitingXRanges(searchParams, x, xranges, xmissing, xRanges, inverseXranges);
        if (!xother.booleanValue()) {
            xRanges = new StringBuilder();
            inverseXranges = new StringBuilder();
        }
        boolean date = this.isDate(x);
        for (Map seriesq : seriesFqs) {
            String[] fqBackup = searchParams.getFq();
            if (seriesq.containsKey("fq")) {
                this.appendFq(searchParams, seriesq.get("fq").toString());
            }
            List<FieldResultDTO> data = new ArrayList();
            if (xranges == null && stats == null) {
                List l;
                searchParams.setFacet(Boolean.valueOf(true));
                searchParams.setFlimit(this.maxStringFacets);
                searchParams.setFsort(fsort);
                searchParams.setFacets(new String[]{x});
                if (xRanges.length() > 0) {
                    this.appendFq(searchParams, xRanges.toString());
                }
                if ((l = this.searchDAO.findByFulltextSpatialQuery(searchParams, null).getFacetResults()).size() > 0) {
                    data = ((FacetResultDTO)l.iterator().next()).getFieldResult();
                    if (!xmissing.booleanValue()) {
                        for (int i = data.size() - 1; i >= 0; --i) {
                            if (!StringUtils.isEmpty((CharSequence)((FieldResultDTO)data.get(i)).getLabel())) continue;
                            data.remove(i);
                        }
                    }
                }
                if (inverseXranges.length() > 0) {
                    searchParams.setFq(fqBackup);
                    if (seriesq.containsKey("fq")) {
                        this.appendFq(searchParams, seriesq.get("fq").toString());
                    }
                    searchParams.setFacet(Boolean.valueOf(false));
                    this.appendFq(searchParams, inverseXranges.toString());
                    SearchResultDTO sr = this.searchDAO.findByFulltextSpatialQuery(searchParams, null);
                    if (sr != null) {
                        data.add(new FieldResultDTO("Other", "Other", sr.getTotalRecords()));
                    }
                }
            } else if (xranges == null && stats != null) {
                if (xRanges.length() > 0) {
                    this.appendFq(searchParams, xRanges.toString());
                }
                data = this.searchDAO.searchStat(searchParams, stats, x);
                if (!xmissing.booleanValue()) {
                    for (int i = data.size() - 1; i >= 0; --i) {
                        if (!StringUtils.isEmpty((CharSequence)((FieldStatsItem)data.get(i)).getLabel())) continue;
                        data.remove(i);
                    }
                }
                if (inverseXranges.length() > 0) {
                    searchParams.setFq(fqBackup);
                    if (seriesq.containsKey("fq")) {
                        this.appendFq(searchParams, seriesq.get("fq").toString());
                    }
                    searchParams.setFacet(Boolean.valueOf(false));
                    this.appendFq(searchParams, inverseXranges.toString());
                    List d = this.searchDAO.searchStat(searchParams, stats, null);
                    if (d != null && d.size() > 0) {
                        ((FieldStatsItem)d.get(0)).setLabel("Other");
                        data.add((FieldResultDTO)d.get(0));
                    }
                }
            } else if (xranges != null && stats == null) {
                searchParams.setFacet(Boolean.valueOf(false));
                String[] xrangessplit = xranges.split(",");
                String[] fqBackup2 = searchParams.getFq();
                String[] xrangesFqs = new String[searchParams.getFq().length + 1];
                if (searchParams.getFq().length > 0) {
                    System.arraycopy(searchParams.getFq(), 0, xrangesFqs, 0, searchParams.getFq().length);
                }
                ArrayList<FieldResultDTO> output = new ArrayList<FieldResultDTO>();
                for (int i = 0; i < xrangessplit.length - 1; ++i) {
                    Map m = this.makeRangeMap(i == 0, x, xrangessplit[i], xrangessplit[i + 1], date);
                    xrangesFqs[fqBackup2.length] = m.get("fq").toString();
                    searchParams.setFq(xrangesFqs);
                    SearchResultDTO l = this.searchDAO.findByFulltextSpatialQuery(searchParams, null);
                    if (l == null) continue;
                    String label = m.get("label").toString();
                    FieldResultDTO fr = new FieldResultDTO(label, label, l.getTotalRecords(), m.get("fq").toString());
                    output.add(fr);
                }
                searchParams.setFq(fqBackup2);
                data = output;
            } else if (xranges != null && stats != null) {
                String[] fqs = new String[searchParams.getFq().length + 1];
                if (searchParams.getFq().length > 0) {
                    System.arraycopy(searchParams.getFq(), 0, fqs, 0, searchParams.getFq().length);
                }
                String[] r = xranges.split(",");
                ArrayList output = new ArrayList(r.length - 1);
                for (int i = 0; i < r.length; ++i) {
                    if (i >= r.length - 1) continue;
                    Map m = this.makeRangeMap(i == 0, x, r[i], r[i + 1], date);
                    fqs[fqs.length - 1] = m.get("fq").toString();
                    searchParams.setFq(fqs);
                    List result = this.searchDAO.searchStat(searchParams, stats, null);
                    if (result.size() <= 0) continue;
                    ((FieldStatsItem)result.iterator().next()).setFq(fqs[fqs.length - 1]);
                    ((FieldStatsItem)result.iterator().next()).setLabel(m.get("label").toString());
                    output.addAll(result);
                }
                data = output;
            }
            seriesq.put("data", data);
            searchParams.setFq(fqBackup);
        }
        this.insertZeros(seriesFqs);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("data", seriesFqs);
        m.put("x", x);
        m.put("series", series);
        m.put("value", stats);
        m.put("xLabel", this.getFieldDescription(x));
        m.put("seriesLabel", this.getFieldDescription(series));
        m.put("valueLabel", this.getFieldDescription(stats));
        return m;
    }

    private void insertZeros(List<Map> seriesFqs) {
        if (seriesFqs.size() > 1) {
            ArrayList<String> all = new ArrayList<String>();
            for (Map s : seriesFqs) {
                List data = (List)s.get("data");
                for (Object o : data) {
                    if (o instanceof FieldStatsItem) {
                        all.add(((FieldStatsItem)o).getLabel());
                        continue;
                    }
                    if (!(o instanceof FieldResultDTO)) continue;
                    all.add(((FieldResultDTO)o).getLabel());
                }
            }
            HashMap<String, Long> m = new HashMap<String, Long>();
            m.put("count", 0L);
            for (Map s : seriesFqs) {
                HashSet current = new HashSet(all);
                List data = (List)s.get("data");
                boolean fieldStatsItem = false;
                for (Object o : data) {
                    if (o instanceof FieldStatsItem) {
                        fieldStatsItem = true;
                        current.remove(((FieldStatsItem)o).getLabel());
                        continue;
                    }
                    if (!(o instanceof FieldResultDTO)) continue;
                    current.remove(((FieldResultDTO)o).getLabel());
                }
                for (String c : current) {
                    if (fieldStatsItem) {
                        data.add(new FieldStatsItem(new FieldStatsInfo(new NamedList(m), c)));
                        continue;
                    }
                    data.add(new FieldResultDTO(c, c, 0L));
                }
                Collections.sort(data, new /* Unavailable Anonymous Inner Class!! */);
                s.put("data", data);
            }
        }
    }

    private String produceLimitingXRanges(SpatialSearchRequestParams searchParams, String x, String xranges, Boolean xmissing, StringBuilder query, StringBuilder inverse) throws Exception {
        if (xranges == null && x != null) {
            List fqs = this.makeSeriesFacets(x, searchParams, null, xmissing);
            boolean date = this.isDate(x);
            if (fqs.size() > 0 && (this.isNumber(x) || date)) {
                String newXRanges = "";
                for (int i = 0; i < fqs.size(); ++i) {
                    if (i > 0) {
                        newXRanges = newXRanges + ",";
                    }
                    newXRanges = newXRanges + ((Map)fqs.get(i)).get("label").toString().split(" - ")[0];
                    if (!date) continue;
                    newXRanges = newXRanges + "T00:00:00Z";
                }
                String[] lastElement = ((Map)fqs.get(fqs.size() - 1)).get("label").toString().split(" - ");
                if (lastElement != null && lastElement.length > 1) {
                    newXRanges = newXRanges + "," + ((Map)fqs.get(fqs.size() - 1)).get("label").toString().split(" - ")[1];
                }
                if (date) {
                    newXRanges = newXRanges + "T00:00:00Z";
                }
                xranges = newXRanges;
            } else if (fqs.size() > 0) {
                inverse.append(this.fqFromSeriesFacets(fqs, false));
                query.append(this.fqFromSeriesFacets(fqs, true));
            }
        }
        return xranges;
    }

    private List<Map> produceSeriesFqs(SpatialSearchRequestParams searchParams, String x, String series, String seriesranges, Boolean includeMissing, Boolean other) throws Exception {
        ArrayList<Map> seriesFqs = new ArrayList<Map>();
        boolean date = this.isDate(series);
        if (series != null && seriesranges != null) {
            String[] sr = seriesranges.split(",");
            for (int i = 0; i < sr.length - 1; ++i) {
                seriesFqs.add(this.makeRangeMap(i == 0, series, sr[i], sr[i + 1], date));
            }
        } else if (series != null) {
            seriesFqs.addAll(this.makeSeriesFacets(series, searchParams, this.maxSeriesFacets, includeMissing));
            if (!this.isNumber(series) && !date && other.booleanValue()) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("fq", this.fqFromSeriesFacets(seriesFqs, true));
                m.put("label", "Other");
                seriesFqs.add(m);
            }
        } else {
            HashMap<String, String> sm = new HashMap<String, String>();
            sm.put("label", x);
            seriesFqs.add(sm);
        }
        return seriesFqs;
    }

    private boolean isNumber(String field) throws Exception {
        Object[] numberType = new String[]{"int", "tint", "double", "tdouble", "long", "tlong", "float", "tfloat"};
        for (IndexFieldDTO f : this.searchDAO.getIndexedFields()) {
            if (!f.getName().equalsIgnoreCase(field) || !ArrayUtils.contains((Object[])numberType, (Object)f.getDataType())) continue;
            return true;
        }
        return false;
    }

    private boolean isDecimal(String field) throws Exception {
        Object[] numberType = new String[]{"double", "tdouble", "float", "tfloat"};
        for (IndexFieldDTO f : this.searchDAO.getIndexedFields()) {
            if (!f.getName().equalsIgnoreCase(field) || !ArrayUtils.contains((Object[])numberType, (Object)f.getDataType())) continue;
            return true;
        }
        return false;
    }

    private boolean isDate(String field) throws Exception {
        for (IndexFieldDTO f : this.searchDAO.getIndexedFields()) {
            if (!f.getName().equalsIgnoreCase(field) || !f.getDataType().equalsIgnoreCase("tdate")) continue;
            return true;
        }
        return false;
    }

    private String getFieldDescription(String field) throws Exception {
        for (IndexFieldDTO f : this.searchDAO.getIndexedFields()) {
            if (!f.getName().equalsIgnoreCase(field) || f.getDescription() == null) continue;
            return f.getDescription();
        }
        return field;
    }

    private List getSeriesFacets(String series, SpatialSearchRequestParams searchParams, Integer _maxFacets, Boolean includeMissing) throws Exception {
        List l;
        ArrayList seriesFqs = new ArrayList();
        searchParams.setFacet(Boolean.valueOf(true));
        searchParams.setFlimit(_maxFacets);
        searchParams.setFacets(new String[]{series});
        if (!this.isDate(series) && !this.isNumber(series)) {
            searchParams.setFsort("count");
        }
        if ((l = this.searchDAO.findByFulltextSpatialQuery(searchParams, null).getFacetResults()).size() > 0) {
            for (FieldResultDTO f : ((FacetResultDTO)l.iterator().next()).getFieldResult()) {
                if (!includeMissing.booleanValue() && StringUtils.isEmpty((CharSequence)f.getLabel())) continue;
                HashMap<String, String> sm = new HashMap<String, String>();
                sm.put("fq", f.getFq());
                sm.put("label", f.getLabel());
                seriesFqs.add(sm);
            }
        }
        return seriesFqs;
    }

    private List makeSeriesFacets(String series, SpatialSearchRequestParams searchParams, Integer newMax, Boolean includeMissing) throws Exception {
        ArrayList<Map> seriesFqs = new ArrayList<Map>();
        boolean date = this.isDate(series);
        if (this.isNumber(series) || date) {
            int maxSeries = newMax != null ? newMax : this.maxNumberFacets;
            List list = this.getSeriesFacets(series, searchParams, Integer.valueOf(maxSeries + 1), includeMissing);
            if (list.size() > maxSeries + (includeMissing != false ? 1 : 0)) {
                List minMax = (List)this.chart(searchParams, null, null, series, null, null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), "count").get("data");
                if (date) {
                    long i;
                    Long min = ((Date)((FieldStatsItem)((List)((Map)minMax.get(0)).get("data")).get(0)).getMin()).getTime();
                    Long max = ((Date)((FieldStatsItem)((List)((Map)minMax.get(0)).get("data")).get(0)).getMax()).getTime();
                    Long step = (long)(Math.ceil((max - min) / (long)maxSeries / 86400000L) * 8.64E7);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    df.setTimeZone(TimeZone.getTimeZone("UTC"));
                    for (i = 0L; i < (long)(maxSeries - 1) && (double)min.longValue() + (double)step.longValue() * ((double)i + 1.5) < (double)max.longValue(); ++i) {
                        seriesFqs.add(this.makeRangeMap(i == 0L, series, df.format(new Date(min + step * i)), df.format(new Date(min + step * (i + 1L))), date));
                    }
                    seriesFqs.add(this.makeRangeMap(false, series, df.format(new Date(min + step * i)), df.format(new Date(max)), date));
                } else if (this.isDecimal(series)) {
                    int i;
                    Double min = ((Number)((FieldStatsItem)((List)((Map)minMax.get(0)).get("data")).get(0)).getMin()).doubleValue();
                    Double max = ((Number)((FieldStatsItem)((List)((Map)minMax.get(0)).get("data")).get(0)).getMax()).doubleValue();
                    Double step = (max - min) / (double)maxSeries;
                    for (i = 0; i < maxSeries - 1 && min + step * ((double)i + 1.5) < max; ++i) {
                        seriesFqs.add(this.makeRangeMap(i == 0, series, String.valueOf(min + step * (double)i), String.valueOf(min + step * (double)(i + 1)), date));
                    }
                    seriesFqs.add(this.makeRangeMap(false, series, String.valueOf(min + step * (double)i), String.valueOf(max), date));
                } else {
                    int i;
                    Long min = ((Number)((FieldStatsItem)((List)((Map)minMax.get(0)).get("data")).get(0)).getMin()).longValue();
                    Long max = ((Number)((FieldStatsItem)((List)((Map)minMax.get(0)).get("data")).get(0)).getMax()).longValue();
                    Long step = (long)Math.ceil((double)(max - min) / (double)maxSeries);
                    for (i = 0; i < maxSeries - 1 && (double)min.longValue() + (double)step.longValue() * ((double)i + 1.5) < (double)max.longValue(); ++i) {
                        seriesFqs.add(this.makeRangeMap(i == 0, series, String.valueOf(min + step * (long)i), String.valueOf(min + step * (long)(i + 1)), date));
                    }
                    seriesFqs.add(this.makeRangeMap(false, series, String.valueOf(min + step * (long)i), String.valueOf(max), date));
                }
            } else {
                seriesFqs.addAll(list);
            }
        } else {
            int maxSeries = newMax != null ? newMax : this.maxStringFacets;
            List list = this.getSeriesFacets(series, searchParams, Integer.valueOf(maxSeries + 1), includeMissing);
            if (list.size() > maxSeries + (includeMissing != false ? 1 : 0)) {
                seriesFqs.addAll(list);
            }
        }
        return seriesFqs;
    }

    private Map makeRangeMap(boolean first, String field, String start, String end, boolean date) {
        HashMap<String, String> sm = new HashMap<String, String>();
        String separator = start.contains(":") ? "\"" : "";
        sm.put("fq", field + ":[" + start + " TO " + end + "]" + (first ? "" : " AND -(" + field + ":" + separator + start + separator + ")"));
        if (date) {
            sm.put("label", start.substring(0, 10) + " - " + end.substring(0, 10));
        } else {
            sm.put("label", start + " - " + end);
        }
        return sm;
    }

    private String fqFromSeriesFacets(List fqs, boolean invert) {
        String fq = "";
        for (int i = 0; i < fqs.size(); ++i) {
            if (((Map)fqs.get(i)).get("fq").toString().startsWith("-")) continue;
            if (fq.length() > 0) {
                fq = fq + " OR ";
            }
            fq = fq + ((Map)fqs.get(i)).get("fq");
        }
        if (invert) {
            return "-(" + fq.substring(0, fq.indexOf(58)) + ":* AND -" + fq.replace(" OR ", " AND -") + ");";
        }
        return fq;
    }

    private void appendFq(SpatialSearchRequestParams searchParams, String fq) {
        String[] seriesqFqs = new String[searchParams.getFq().length + 1];
        if (searchParams.getFq().length > 0) {
            System.arraycopy(searchParams.getFq(), 0, seriesqFqs, 0, searchParams.getFq().length);
        }
        seriesqFqs[searchParams.getFq().length] = fq;
        searchParams.setFq(seriesqFqs);
    }
}

