/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.BreakdownRequestParams;
import au.org.ala.biocache.dto.TaxaRankCountDTO;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class BreakdownController {
    private static final Logger logger = Logger.getLogger(BreakdownController.class);
    @Inject
    protected SearchDAO searchDAO;

    @RequestMapping(value={"/breakdown/collections/{uid}*"}, method={RequestMethod.GET})
    @ResponseBody
    public TaxaRankCountDTO breakdownByCollection(BreakdownRequestParams requestParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("collection_uid", uid, requestParams, response);
    }

    @RequestMapping(value={"/breakdown/institutions/{uid}*"}, method={RequestMethod.GET})
    @ResponseBody
    public TaxaRankCountDTO breakdownByInstitution(BreakdownRequestParams requestParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("institution_uid", uid, requestParams, response);
    }

    @RequestMapping(value={"/breakdown/dataResources/{uid}*"}, method={RequestMethod.GET})
    @ResponseBody
    public TaxaRankCountDTO breakdownByDataResource(BreakdownRequestParams requestParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("data_resource_uid", uid, requestParams, response);
    }

    @RequestMapping(value={"/breakdown/dataProviders/{uid}*"}, method={RequestMethod.GET})
    @ResponseBody
    public TaxaRankCountDTO breakdownByDataProvider(BreakdownRequestParams requestParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("data_provider_uid", uid, requestParams, response);
    }

    @RequestMapping(value={"/breakdown/dataHubs/{uid}*"}, method={RequestMethod.GET})
    @ResponseBody
    public TaxaRankCountDTO breakdownByDataHub(BreakdownRequestParams requestParams, @PathVariable(value="uid") String uid, HttpServletResponse response) throws Exception {
        return this.performBreakdown("data_hub_uid", uid, requestParams, response);
    }

    @RequestMapping(value={"/breakdown*"}, method={RequestMethod.GET})
    @ResponseBody
    public TaxaRankCountDTO breakdownByQuery(BreakdownRequestParams breakdownParams, HttpServletResponse response) throws Exception {
        logger.debug((Object)breakdownParams);
        if (StringUtils.isNotEmpty((String)breakdownParams.getQ())) {
            if (breakdownParams.getMax() != null || StringUtils.isNotEmpty((String)breakdownParams.getRank()) || StringUtils.isNotEmpty((String)breakdownParams.getLevel())) {
                return this.searchDAO.calculateBreakdown(breakdownParams);
            }
            response.sendError(400, "No context provided for breakdown.  Please supply either max, rank or level as a minimum");
        } else {
            response.sendError(400, "No query provided for breakdown");
        }
        return null;
    }

    private TaxaRankCountDTO performBreakdown(String source, String uid, BreakdownRequestParams requestParams, HttpServletResponse response) throws Exception {
        StringBuilder sb = new StringBuilder("(");
        for (String u : uid.split(",")) {
            if (sb.length() > 1) {
                sb.append(" OR ");
            }
            sb.append(source).append(":").append(u);
        }
        sb.append(")");
        requestParams.setQ(sb.toString());
        return this.breakdownByQuery(requestParams, response);
    }

    @RequestMapping(value={"/breakdown/institutions*", "/breakdown/collections*", "/breakdown/data-resources*", "/breakdowns/data-providers*", "/breakdowns/data-hubs*"}, method={RequestMethod.GET})
    @ResponseBody
    public TaxaRankCountDTO limitBreakdown(BreakdownRequestParams requestParams, HttpServletResponse response) throws Exception {
        return this.performBreakdown("*", "*", requestParams, response);
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }
}

