/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import com.google.common.collect.ImmutableBiMap;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;

@Component(value="rangeBasedFacets")
public class RangeBasedFacets {
    @Inject
    private AbstractMessageSource messageSource;
    private Map<String, ImmutableBiMap<String, String>> rangeFacets = new HashMap();

    public Map<String, String> getRangeMap(String name) {
        this.init();
        if (this.rangeFacets.containsKey(name)) {
            return (Map)this.rangeFacets.get(name);
        }
        return null;
    }

    public Map<String, String> getTitleMap(String name) {
        this.init();
        if (this.rangeFacets.containsKey(name)) {
            return ((ImmutableBiMap)this.rangeFacets.get(name)).inverse();
        }
        return null;
    }

    private void init() {
        String less_than = this.messageSource.getMessage("rangefacet.less_than", null, "less than {0}", null);
        String between = this.messageSource.getMessage("rangefacet.between", null, "between {0} and {1}", null);
        String greater_than = this.messageSource.getMessage("rangefacet.greater_than", null, "greater than {0}", null);
        String unknown = this.messageSource.getMessage("rangefacet.unknown", null, "Unknown", null);
        ImmutableBiMap map = new ImmutableBiMap.Builder().put((Object)"coordinate_uncertainty:[0 TO 100]", (Object)MessageFormat.format(less_than, "100")).put((Object)"coordinate_uncertainty:[101 TO 500]", (Object)MessageFormat.format(between, "100", "500")).put((Object)"coordinate_uncertainty:[501 TO 1000]", (Object)MessageFormat.format(between, "500", "1000")).put((Object)"coordinate_uncertainty:[1001 TO 5000]", (Object)MessageFormat.format(between, "1000", "5000")).put((Object)"coordinate_uncertainty:[5001 TO 10000]", (Object)MessageFormat.format(between, "5000", "10000")).put((Object)"coordinate_uncertainty:[10001 TO *]", (Object)MessageFormat.format(greater_than, "10000")).put((Object)"-coordinate_uncertainty:[* TO *]", (Object)unknown).build();
        this.rangeFacets.put("uncertainty", map);
    }
}

