/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.SpeciesCountDTO;
import au.org.ala.biocache.service.UpdateThread;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="SpeciesCountsService")
public class SpeciesCountsService {
    private static final Logger logger = Logger.getLogger(SpeciesCountsService.class);
    @Inject
    protected SearchDAO searchDAO;
    @Value(value="${species.counts.cache.minage:1800000}")
    protected Long cacheMinAge;
    @Value(value="${autocomplete.species.counts.enabled:true}")
    private Boolean enabled;
    final Object cacheLock = new Object();
    LRUMap cache = new LRUMap();
    final Object updatelock = new Object();
    final Object updatingLock = new Object();
    Map<Integer, Boolean> updatingList = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpeciesCountDTO getCounts(String[] filterQuery) {
        SpeciesCountDTO counts;
        if (!this.enabled.booleanValue()) {
            return null;
        }
        SpatialSearchRequestParams params = new SpatialSearchRequestParams();
        StringBuilder fq = new StringBuilder();
        if (filterQuery == null || filterQuery.length == 0) {
            params.setQ("*:*");
            fq.append("*:*");
        } else {
            params.setQ(filterQuery[0]);
            fq.append(filterQuery[0]);
            if (filterQuery.length > 1) {
                String[] fqs = Arrays.copyOfRange(filterQuery, 1, filterQuery.length);
                params.setFacets(fqs);
                for (String s : fqs) {
                    fq.append(s);
                }
            }
        }
        params.setPageSize(Integer.valueOf(0));
        params.setFacet(Boolean.valueOf(true));
        params.setFacets(new String[]{"lft"});
        params.setFlimit(Integer.valueOf(-1));
        int hashCode = fq.toString().hashCode();
        Object object = this.cacheLock;
        synchronized (object) {
            counts = (SpeciesCountDTO)this.cache.get((Object)hashCode);
        }
        long indexVersion = this.searchDAO.getIndexVersion(Boolean.valueOf(false));
        if (counts == null || this.cacheMinAge + counts.getAge() < System.currentTimeMillis() && indexVersion != counts.getIndexVersion()) {
            Object object2 = this.updatingLock;
            synchronized (object2) {
                Boolean updating = (Boolean)this.updatingList.get(hashCode);
                if (updating == null) {
                    this.updatingList.put(hashCode, true);
                    UpdateThread updateThread = new UpdateThread(this, hashCode, params);
                    updateThread.start();
                }
            }
        }
        return counts;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getCount(SpeciesCountDTO counts, long left, long right) {
        if (counts == null || counts.getLft() == null) {
            return 0L;
        }
        long[] lft = counts.getLft();
        long[] count = counts.getCounts();
        int pos = Arrays.binarySearch(lft, left);
        if (pos < 0) {
            pos = -1 * pos - 1;
        }
        long sum = 0L;
        while (pos < lft.length && lft[pos] <= right) {
            sum += count[pos++];
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cache.clear();
        }
    }
}

