/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.LoggerRestService;
import au.org.ala.biocache.service.LoggerService;
import au.org.ala.biocache.service.RestartDataService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="loggerRestService")
public class LoggerRestService
implements LoggerService {
    private static final Logger logger = Logger.getLogger(LoggerRestService.class);
    private List<Map<String, Object>> loggerReasons = (List)RestartDataService.get((Object)this, (String)"loggerReasons", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private List<Map<String, Object>> loggerSources = (List)RestartDataService.get((Object)this, (String)"loggerSources", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private List<Integer> reasonIds = (List)RestartDataService.get((Object)this, (String)"reasonIds", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private List<Integer> sourceIds = (List)RestartDataService.get((Object)this, (String)"sourceIds", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private CountDownLatch initialised = new CountDownLatch(1);
    @Value(value="${logger.service.url:http://logger.ala.org.au/service/logger/}")
    protected String loggerUriPrefix;
    @Value(value="${caches.log.enabled:true}")
    protected Boolean enabled = null;
    @Inject
    private RestOperations restTemplate;

    public List<Map<String, Object>> getReasons() {
        this.isReady();
        return this.loggerReasons;
    }

    public List<Map<String, Object>> getSources() {
        this.isReady();
        return this.loggerSources;
    }

    public List<Integer> getReasonIds() {
        this.isReady();
        return this.reasonIds;
    }

    public List<Integer> getSourceIds() {
        this.isReady();
        return this.sourceIds;
    }

    private void isReady() {
        try {
            this.initialised.await();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Scheduled(fixedDelay=43200000L)
    public void reloadCache() {
        this.init();
    }

    @PostConstruct
    public void init() {
        if (this.loggerReasons.size() > 0) {
            this.initialised.countDown();
        }
        if (this.enabled.booleanValue()) {
            logger.info((Object)"Refreshing the log sources and reasons");
            List list = this.getEntities(LoggerType.reasons);
            if (list.size() > 0) {
                this.loggerReasons = list;
            }
            if ((list = this.getEntities(LoggerType.sources)).size() > 0) {
                this.loggerSources = list;
            }
            if ((list = this.getIdList(this.loggerReasons)).size() > 0) {
                this.reasonIds = list;
            }
            if ((list = this.getIdList(this.loggerSources)).size() > 0) {
                this.sourceIds = list;
            }
        } else if (this.reasonIds == null) {
            logger.info((Object)"Providing some sensible default values for the log cache");
            this.reasonIds = new ArrayList();
            this.sourceIds = new ArrayList();
            Integer i = 0;
            while (i < 11) {
                this.reasonIds.add(i);
                if (i < 8) {
                    this.sourceIds.add(i);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        this.initialised.countDown();
    }

    protected List<Integer> getIdList(List<Map<String, Object>> list) {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (Map<String, Object> value : list) {
            returnList.add((Integer)value.get("id"));
        }
        return returnList;
    }

    protected List<Map<String, Object>> getEntities(LoggerType type) {
        List<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        try {
            String jsonUri = this.loggerUriPrefix + type.name();
            logger.info((Object)("Requesting " + type.name() + " via: " + jsonUri));
            entities = (List)this.restTemplate.getForObject(jsonUri, List.class, new Object[0]);
            logger.info((Object)("The values : " + entities));
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
        }
        return entities;
    }
}

