/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.SearchRequestParams;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public class SpatialSearchRequestParams
extends SearchRequestParams {
    public static final String[] gkFq = new String[]{"geospatial_kosher:true"};
    protected Float radius = null;
    protected Float lat = null;
    protected Float lon = null;
    protected String wkt = "";
    protected Boolean gk = false;

    public String toString() {
        return this.addSpatialParams(super.toString(), Boolean.valueOf(false));
    }

    public String getEncodedParams() {
        return this.addSpatialParams(super.getEncodedParams(), Boolean.valueOf(true));
    }

    protected String addSpatialParams(String paramString, Boolean encodeParams) {
        StringBuilder req = new StringBuilder(paramString);
        if (this.lat != null && this.lon != null && this.radius != null) {
            req.append("&lat=").append(this.lat);
            req.append("&lon=").append(this.lon);
            req.append("&radius=").append(this.radius);
        }
        if (this.wkt != null && this.wkt.length() > 0) {
            req.append("&wkt=").append(super.conditionalEncode(this.wkt, encodeParams));
        }
        if (this.gk.booleanValue()) {
            req.append("&gk=true");
        }
        return req.toString();
    }

    public String getUrlParams() {
        StringBuilder req = new StringBuilder(super.getUrlParams());
        if (this.lat != null && this.lon != null && this.radius != null) {
            req.append("&lat=").append(this.lat);
            req.append("&lon=").append(this.lon);
            req.append("&radius=").append(this.radius);
        }
        if (this.wkt != null && this.wkt.length() > 0) {
            req.append("&wkt=").append(this.wkt);
        }
        return req.toString();
    }

    public Float getLat() {
        return this.lat;
    }

    public void setLat(Float lat) {
        this.lat = lat;
    }

    public Float getLon() {
        return this.lon;
    }

    public void setLon(Float lon) {
        this.lon = lon;
    }

    public Float getRadius() {
        return this.radius;
    }

    public void setRadius(Float radius) {
        this.radius = radius;
    }

    public String getWkt() {
        return this.wkt;
    }

    public void setWkt(String wkt) {
        this.wkt = wkt;
        if (wkt != null) {
            this.wkt = wkt.replace(':', ' ');
        }
    }

    public Boolean getGk() {
        return this.gk;
    }

    public void setGk(Boolean gk) {
        this.gk = gk;
    }

    public String[] getFq() {
        if (this.gk.booleanValue()) {
            return (String[])ArrayUtils.addAll((Object[])this.fq, (Object[])gkFq);
        }
        return this.fq;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.gk == null ? 0 : this.gk.hashCode());
        result = 31 * result + Arrays.hashCode(gkFq);
        result = 31 * result + (this.lat == null ? 0 : this.lat.hashCode());
        result = 31 * result + (this.lon == null ? 0 : this.lon.hashCode());
        result = 31 * result + (this.radius == null ? 0 : this.radius.hashCode());
        result = 31 * result + (this.wkt == null ? 0 : this.wkt.hashCode());
        return result;
    }
}

