/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.SpeciesGroupDTO;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.model.Qid;
import au.org.ala.biocache.vocab.SpeciesGroup;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="exploreController")
public class ExploreController {
    private static final Logger logger = Logger.getLogger(ExploreController.class);
    @Inject
    protected SearchDAO searchDao;
    private final String DEFAULT_LOCATION = "Clunies Ross St, Black Mountain, ACT";
    private final String POINTS_GEOJSON = "json/pointsGeoJson";
    @Inject
    protected QidCacheDAO qidCacheDao;
    public static final HashMap<Float, Integer> radiusToZoomLevelMap = new HashMap();

    @RequestMapping(value={"/explore/hierarchy"}, method={RequestMethod.GET})
    public void getHierarchy(HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(Store.retrieveSubgroupsConfig().getBytes("UTF-8"));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/explore/hierarchy/groups*"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<SpeciesGroupDTO> yourHierarchicalAreaView(SpatialSearchRequestParams requestParams, String speciesGroup) throws Exception {
        List ssgs = Store.retrieveSpeciesSubgroups();
        LinkedHashMap<String, SpeciesGroupDTO> parentGroupMap = new LinkedHashMap<String, SpeciesGroupDTO>();
        HashMap<String, String> parentLookup = new HashMap<String, String>();
        for (SpeciesGroup sg : ssgs) {
            if (sg.parent() == null || sg.parent() == "") continue;
            parentLookup.put(sg.name().toLowerCase(), sg.parent());
            if (parentGroupMap.get(sg.parent()) != null) continue;
            parentGroupMap.put(sg.parent(), new SpeciesGroupDTO(sg.parent(), 0L, 0L, 1));
        }
        requestParams.setFormattedQuery(null);
        requestParams.setFacets(new String[]{"species_subgroup"});
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFlimit(Integer.valueOf(-1));
        if (StringUtils.isNotBlank((String)speciesGroup)) {
            requestParams.setFq(new String[]{"species_group:\"" + speciesGroup + "\""});
        }
        SearchResultDTO speciesSubgroupCounts = this.searchDao.findByFulltextSpatialQuery(requestParams, null);
        HashMap<String, Long> occurrenceCounts = new HashMap<String, Long>();
        if (speciesSubgroupCounts.getFacetResults().size() > 0) {
            FacetResultDTO result = (FacetResultDTO)speciesSubgroupCounts.getFacetResults().iterator().next();
            for (FieldResultDTO fr : result.getFieldResult()) {
                occurrenceCounts.put(fr.getLabel(), fr.getCount());
            }
        }
        for (String ssg : occurrenceCounts.keySet()) {
            requestParams.setQ("species_subgroup:\"" + ssg + "\"");
            requestParams.setFormattedQuery(null);
            requestParams.setFacets(new String[]{"taxon_name"});
            List facetResultDTO = this.searchDao.getFacetCounts(requestParams);
            if (facetResultDTO.size() <= 0) continue;
            FacetResultDTO result = (FacetResultDTO)facetResultDTO.get(0);
            String parentName = (String)parentLookup.get(ssg.toLowerCase());
            SpeciesGroupDTO parentGroup = (SpeciesGroupDTO)parentGroupMap.get(parentName);
            if (parentGroup != null) {
                if (parentGroup.getChildGroups() == null) {
                    parentGroup.setChildGroups(new ArrayList());
                }
                parentGroup.getChildGroups().add(new SpeciesGroupDTO(ssg, (long)result.getCount().intValue(), ((Long)occurrenceCounts.get(ssg)).longValue(), 2));
                parentGroup.setSpeciesCount(parentGroup.getSpeciesCount() + (long)result.getCount().intValue());
                parentGroup.setCount(parentGroup.getCount() + (Long)occurrenceCounts.get(ssg));
                continue;
            }
            logger.warn((Object)("Parent group lookup failed for: " + parentName + ", ssg: " + ssg));
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String parentName : parentGroupMap.keySet()) {
            if (((SpeciesGroupDTO)parentGroupMap.get(parentName)).getChildGroups() != null && ((SpeciesGroupDTO)parentGroupMap.get(parentName)).getChildGroups().size() != 0) continue;
            toRemove.add(parentName);
        }
        for (String key : toRemove) {
            parentGroupMap.remove(key);
        }
        return parentGroupMap.values();
    }

    @RequestMapping(value={"/explore/groups*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SpeciesGroupDTO> yourAreaView(SpatialSearchRequestParams requestParams) throws Exception {
        List sgs = Store.retrieveSpeciesGroups();
        ArrayList<SpeciesGroupDTO> speciesGroups = new ArrayList<SpeciesGroupDTO>();
        SpeciesGroupDTO all = new SpeciesGroupDTO();
        String originalQ = requestParams.getQ();
        all.setName("ALL_SPECIES");
        all.setLevel(0);
        Integer[] counts = this.getYourAreaCount(requestParams, "ALL_SPECIES");
        all.setCount((long)counts[0].intValue());
        all.setSpeciesCount((long)counts[1].intValue());
        speciesGroups.add(all);
        String oldName = null;
        String kingdom = null;
        for (SpeciesGroup sg : sgs) {
            logger.debug((Object)("name: " + sg.name() + " parent: " + sg.parent()));
            int level = 3;
            SpeciesGroupDTO sdto = new SpeciesGroupDTO();
            sdto.setName(sg.name());
            if (oldName != null && sg.parent() != null && sg.parent().equals(kingdom)) {
                level = 2;
            }
            oldName = sg.name();
            if (sg.parent() == null) {
                level = 1;
                kingdom = sg.name();
            }
            sdto.setLevel(level);
            requestParams.setQ(originalQ);
            counts = this.getYourAreaCount(requestParams, sg.name());
            sdto.setCount((long)counts[0].intValue());
            sdto.setSpeciesCount((long)counts[1].intValue());
            speciesGroups.add(sdto);
        }
        return speciesGroups;
    }

    @RequestMapping(value={"/explore/counts/group/{group}*"}, method={RequestMethod.GET})
    @ResponseBody
    public Integer[] getYourAreaCount(SpatialSearchRequestParams requestParams, @PathVariable(value="group") String group) throws Exception {
        this.addGroupFilterToQuery(requestParams, group);
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacets(new String[]{"taxon_name"});
        requestParams.setFlimit(Integer.valueOf(-1));
        SearchResultDTO results = this.searchDao.findByFulltextSpatialQuery(requestParams, null);
        Integer speciesCount = 0;
        if (results.getFacetResults().size() > 0) {
            List fieldResults = ((FacetResultDTO)results.getFacetResults().iterator().next()).getFieldResult();
            int count = 0;
            for (FieldResultDTO fr : fieldResults) {
                if (fr.getCount() == 0L || fr.getLabel().equalsIgnoreCase("Unknown")) continue;
                ++count;
            }
            speciesCount = count;
        }
        return new Integer[]{(int)results.getTotalRecords(), speciesCount};
    }

    private void addGroupFilterToQuery(SpatialSearchRequestParams requestParams, String group) {
        this.addFacetFilterToQuery(requestParams, "species_group", group);
    }

    private void addFacetFilterToQuery(SpatialSearchRequestParams requestParams, String facetName, String facetValue) {
        StringBuilder sb = new StringBuilder();
        if (requestParams.getQ() != null && !requestParams.getQ().isEmpty()) {
            sb.append(requestParams.getQ());
        } else {
            sb.append("*:*");
        }
        if (!facetValue.equals("ALL_SPECIES")) {
            sb.append(" " + facetName + ":").append(facetValue);
        }
        sb.append(" -rank:kingdom -rank:phylum -rank:class -rank:order -rank:family -rank:genus");
        requestParams.setQ(sb.toString());
        requestParams.setFormattedQuery(null);
    }

    @RequestMapping(value={"/geojson/radius-points"}, method={RequestMethod.GET})
    public String radiusPointsGeoJson(SpatialSearchRequestParams requestParams, @RequestParam(value="zoom", required=false, defaultValue="0") Integer zoomLevel, @RequestParam(value="bbox", required=false) String bbox, @RequestParam(value="group", required=false, defaultValue="ALL_SPECIES") String speciesGroup, Model model) throws Exception {
        this.addGroupFilterToQuery(requestParams, speciesGroup);
        PointType pointType = PointType.POINT_00001;
        pointType = this.getPointTypeForZoomLevel(zoomLevel);
        logger.info((Object)("PointType for zoomLevel (" + zoomLevel + ") = " + pointType.getLabel()));
        List points = this.searchDao.findRecordsForLocation(requestParams, pointType);
        logger.info((Object)("Points search for " + pointType.getLabel() + " - found: " + points.size()));
        model.addAttribute("points", (Object)points);
        return "json/pointsGeoJson";
    }

    protected PointType getPointTypeForZoomLevel(Integer zoomLevel) {
        PointType pointType = null;
        if (zoomLevel != null) {
            pointType = zoomLevel >= 0 && zoomLevel <= 6 ? PointType.POINT_1 : (zoomLevel > 6 && zoomLevel <= 8 ? PointType.POINT_01 : (zoomLevel > 8 && zoomLevel <= 10 ? PointType.POINT_001 : (zoomLevel > 10 && zoomLevel <= 13 ? PointType.POINT_0001 : (zoomLevel > 13 && zoomLevel <= 15 ? PointType.POINT_00001 : PointType.POINT_RAW))));
        }
        return pointType;
    }

    private void applyFacetForCounts(SpatialSearchRequestParams requestParams, boolean useCommonName) {
        if (useCommonName) {
            requestParams.setFacets(new String[]{"common_name_and_lsid"});
        } else {
            requestParams.setFacets(new String[]{"names_and_lsid"});
        }
    }

    @RequestMapping(value={"/explore/group/{group}/download*"}, method={RequestMethod.GET})
    public void yourAreaDownload(DownloadRequestParams requestParams, @PathVariable(value="group") String group, @RequestParam(value="common", required=false, defaultValue="false") boolean common, HttpServletResponse response) throws Exception {
        String filename = requestParams.getFile() != null ? requestParams.getFile() : "data";
        logger.debug((Object)"Downloading the species in your area... ");
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        response.setContentType("application/vnd.ms-excel");
        this.addGroupFilterToQuery((SpatialSearchRequestParams)requestParams, group);
        this.applyFacetForCounts((SpatialSearchRequestParams)requestParams, common);
        try {
            ServletOutputStream out = response.getOutputStream();
            int count = this.searchDao.writeSpeciesCountByCircleToStream((SpatialSearchRequestParams)requestParams, group, out);
            logger.debug((Object)("Exported " + count + " species records in the requested area"));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/explore/group/{group}*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TaxaCountDTO> listSpeciesForHigherTaxa(SpatialSearchRequestParams requestParams, @PathVariable(value="group") String group, @RequestParam(value="common", required=false, defaultValue="false") boolean common, Model model) throws Exception {
        this.addGroupFilterToQuery(requestParams, group);
        this.applyFacetForCounts(requestParams, common);
        return this.searchDao.findAllSpeciesByCircleAreaAndHigherTaxa(requestParams, group);
    }

    @RequestMapping(value={"/explore/counts/endemic*"}, method={RequestMethod.GET})
    @ResponseBody
    public int getSpeciesCountOnlyInWKT(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        List list = this.getSpeciesOnlyInWKT(requestParams, response);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    @RequestMapping(value={"/explore/endemic/species*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldResultDTO> getSpeciesOnlyInWKT(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        String wkt;
        Qid qid = this.qidCacheDao.getQidFromQuery(requestParams.getQ());
        String string = wkt = StringUtils.isNotBlank((String)requestParams.getWkt()) ? requestParams.getWkt() : qid.getWkt();
        if (qid != null) {
            requestParams.setQ(qid.getQ());
            requestParams.setWkt(qid.getWkt());
            requestParams.setFq(qid.getFqs());
        }
        if (StringUtils.isNotBlank((String)wkt)) {
            if (requestParams.getFacets() != null && requestParams.getFacets().length == 1) {
                return this.searchDao.getEndemicSpecies(requestParams);
            }
            response.sendError(400, "Please supply only one facet.");
        } else {
            response.sendError(400, "Please supply a WKT area.");
        }
        return null;
    }

    @RequestMapping(value={"/explore/endemic/species/{subQueryQid}*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FieldResultDTO> getSpeciesOnlyInOneQuery(SpatialSearchRequestParams parentQuery, @PathVariable(value="subQueryQid") Long subQueryQid, HttpServletResponse response) throws Exception {
        Qid qid = this.qidCacheDao.getQidFromQuery("qid:" + subQueryQid);
        SpatialSearchRequestParams subQuery = new SpatialSearchRequestParams();
        subQuery.setQ(qid.getQ());
        subQuery.setFacets(qid.getFqs());
        subQuery.setWkt(qid.getWkt());
        if (parentQuery.getQ() == null) {
            parentQuery.setQ("geospatial_kosher:*");
        }
        if (parentQuery.getFacets() == null || parentQuery.getFacets().length == 0) {
            parentQuery.setFacets(new String[]{"names_and_lsid"});
        }
        if (subQuery != null) {
            if (parentQuery.getFacets() != null && parentQuery.getFacets().length == 1) {
                return this.searchDao.getSubquerySpeciesOnly(subQuery, parentQuery);
            }
            response.sendError(400, "Please supply only one facet.");
        } else {
            response.sendError(400, "Please supply a valid sub query qid.");
        }
        return null;
    }

    @RequestMapping(value={"/explore/endemic/speciescount/{subQueryQid}*"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getSpeciesOnlyInOneCountQuery(SpatialSearchRequestParams parentQuery, @PathVariable(value="subQueryQid") Long subQueryQid, HttpServletResponse response) throws Exception {
        List items = this.getSpeciesOnlyInOneQuery(parentQuery, subQueryQid, response);
        HashMap<String, Integer> m = null;
        if (items != null) {
            m = new HashMap<String, Integer>();
            m.put("count", items.size());
        }
        return m;
    }

    @RequestMapping(value={"/explore/endemic/species.csv"}, method={RequestMethod.GET})
    public void getEndemicSpeciesCSV(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        requestParams.setFacets(new String[]{"names_and_lsid"});
        requestParams.setFq((String[])ArrayUtils.add((Object[])requestParams.getFq(), (Object)"species_guid:[* TO *]"));
        List list = this.getSpeciesOnlyInWKT(requestParams, response);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        writer.write("Family,Scientific name,Common name,Taxon rank,LSID,# Occurrences");
        for (FieldResultDTO item : list) {
            String[] values;
            String s = item.getLabel();
            if (s.startsWith("\"") && s.endsWith("\"") && s.length() > 2) {
                s = s.substring(1, s.length() - 1);
            }
            if ((values = s.split("\\|", 6)).length < 5) continue;
            writer.write("\n" + values[4] + ",\"" + values[0] + "\",\"" + values[2] + "\",," + values[1] + "," + item.getCount());
        }
        writer.flush();
        writer.close();
    }

    @RequestMapping(value={"/explore/endemic/species/{subQueryQid}.csv"}, method={RequestMethod.GET})
    public void getSpeciesOnlyInOneQueryCSV(SpatialSearchRequestParams parentQuery, @PathVariable(value="subQueryQid") Long subQueryQid, @RequestParam(value="count", required=false, defaultValue="false") boolean includeCount, @RequestParam(value="lookup", required=false, defaultValue="false") boolean lookupName, @RequestParam(value="synonym", required=false, defaultValue="false") boolean includeSynonyms, @RequestParam(value="lists", required=false, defaultValue="false") boolean includeLists, @RequestParam(value="file", required=false, defaultValue="") String file, HttpServletResponse response) throws Exception {
        Qid qid = this.qidCacheDao.getQidFromQuery("qid:" + subQueryQid);
        SpatialSearchRequestParams subQuery = new SpatialSearchRequestParams();
        subQuery.setQ(qid.getQ());
        subQuery.setFacets(qid.getFqs());
        subQuery.setWkt(qid.getWkt());
        if (parentQuery.getQ() == null) {
            parentQuery.setQ("geospatial_kosher:*");
        }
        if (parentQuery.getFacets() == null || parentQuery.getFacets().length == 0) {
            parentQuery.setFacets(new String[]{"names_and_lsid"});
        }
        if (subQuery != null) {
            if (parentQuery.getFacets() != null && parentQuery.getFacets().length == 1) {
                String filename = StringUtils.isNotEmpty((String)file) ? file : parentQuery.getFacets()[0];
                response.setHeader("Cache-Control", "must-revalidate");
                response.setHeader("Pragma", "must-revalidate");
                response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".csv");
                response.setContentType("text/csv");
                try {
                    this.searchDao.writeEndemicFacetToStream(subQuery, parentQuery, includeCount, lookupName, includeSynonyms, includeLists, (OutputStream)response.getOutputStream());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                response.sendError(400, "Please supply only one facet.");
            }
        } else {
            response.sendError(400, "Please supply a valid sub query qid.");
        }
    }

    public void setSearchDao(SearchDAO searchDao) {
        this.searchDao = searchDao;
    }

    static {
        radiusToZoomLevelMap.put(Float.valueOf(1.0f), 14);
        radiusToZoomLevelMap.put(Float.valueOf(5.0f), 12);
        radiusToZoomLevelMap.put(Float.valueOf(10.0f), 11);
        radiusToZoomLevelMap.put(Float.valueOf(50.0f), 9);
    }
}

