/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.RestartDataService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractMessageSource;

public class DownloadFields {
    private static final Logger logger = LoggerFactory.getLogger(DownloadFields.class);
    private AbstractMessageSource messageSource;
    private LayersService layersService;
    private Properties layerProperties = (Properties)RestartDataService.get((Object)this, (String)"layerProperties", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, Properties.class);
    private Map<String, IndexFieldDTO> indexFieldMaps;
    private Long lastUpdate = 0L;
    private Thread updateThread = null;

    public DownloadFields(Set<IndexFieldDTO> indexFields, AbstractMessageSource messageSource, LayersService layersService) {
        this.messageSource = messageSource;
        this.layersService = layersService;
        this.update(indexFields);
    }

    private synchronized void updateLayerNames() {
        if (this.layerProperties == null || this.layerProperties.size() == 0 || System.currentTimeMillis() > this.lastUpdate + 3600000L) {
            if (this.updateThread != null && this.updateThread.isAlive()) {
                this.updateThread.interrupt();
            }
            this.lastUpdate = System.currentTimeMillis();
            this.updateThread = new /* Unavailable Anonymous Inner Class!! */;
            if (this.layerProperties == null || this.layerProperties.size() == 0) {
                this.updateThread.run();
            } else {
                this.updateThread.start();
            }
        }
    }

    public String[] getHeader(String[] values, boolean useSuffix, boolean dwcHeaders) {
        this.updateLayerNames();
        String[] header = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            String v = dwcHeaders ? values[i] : this.layerProperties.getProperty(values[i], this.messageSource.getMessage(values[i], null, this.generateTitle(values[i], useSuffix), Locale.getDefault()));
            String dwc = dwcHeaders ? this.messageSource.getMessage("dwc." + values[i], null, "", Locale.getDefault()) : null;
            header[i] = dwc != null && dwc.length() > 0 ? dwc : v;
        }
        return header;
    }

    private String generateTitle(String value, boolean useSuffix) {
        String suffix = "";
        if (value.endsWith("_p")) {
            suffix = " - Processed";
            value = value.replaceAll("_p", "");
        }
        value = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)value), (String)" ");
        if (useSuffix) {
            value = value + suffix;
        }
        return value;
    }

    public List<String>[] getIndexFields(String[] values, boolean dwcHeaders, String layersServiceUrl) {
        this.updateLayerNames();
        LinkedList<String> mappedNames = new LinkedList<String>();
        LinkedList<String> headers = new LinkedList<String>();
        LinkedList<String> unmappedNames = new LinkedList<String>();
        LinkedList<String> originalName = new LinkedList<String>();
        LinkedList<String> analysisHeaders = new LinkedList<String>();
        LinkedList<String> analysisLayers = new LinkedList<String>();
        Map storageFieldMap = Store.getStorageFieldMap();
        for (String value : values) {
            String indexName = storageFieldMap.containsKey(value) ? (String)storageFieldMap.get(value) : value;
            IndexFieldDTO field = (IndexFieldDTO)this.indexFieldMaps.get(indexName);
            if (field != null && field.isStored() || value.startsWith("sensitive")) {
                mappedNames.add(indexName);
                String v = dwcHeaders && field != null && field.isStored() && !this.isSpatialField(field.getName()) ? value : this.layerProperties.getProperty(value, this.messageSource.getMessage(value, null, this.generateTitle(value, true), Locale.getDefault()));
                String dwc = dwcHeaders ? this.messageSource.getMessage("dwc." + value, null, "", Locale.getDefault()) : null;
                headers.add(dwc != null && dwc.length() > 0 ? dwc : v);
                originalName.add(value);
                continue;
            }
            if (field == null && this.layersService.findAnalysisLayerName(value, layersServiceUrl) != null) {
                analysisLayers.add(value);
                analysisHeaders.add(this.layersService.findAnalysisLayerName(value, layersServiceUrl));
                continue;
            }
            unmappedNames.add(indexName);
        }
        return new List[]{mappedNames, unmappedNames, headers, originalName, analysisHeaders, analysisLayers};
    }

    private boolean isSpatialField(String name) {
        return name.matches("((cl)|(el))[0-9]+");
    }

    public void update(Set<IndexFieldDTO> indexedFields) {
        try {
            TreeMap<String, IndexFieldDTO> map = new TreeMap<String, IndexFieldDTO>();
            for (IndexFieldDTO field : indexedFields) {
                map.put(field.getName(), field);
            }
            this.indexFieldMaps = map;
            this.updateLayerNames();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ Properties access$002(DownloadFields x0, Properties x1) {
        x0.layerProperties = x1;
        return x0.layerProperties;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }
}

