/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config;
import au.org.ala.biocache.ObserverCallback;
import au.org.ala.biocache.Store;
import au.org.ala.biocache.parser.DateParser;
import au.org.ala.biocache.web.UploadStatus;
import au.org.ala.biocache.web.UploaderThread;
import au.org.ala.layers.dao.IntersectCallback;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

class UploaderThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(UploaderThread.class);
    public String status = "LOADING";
    protected Boolean reload;
    protected String[] headers;
    protected String datasetName = "";
    protected CSVReader csvData;
    protected int lineCount = 0;
    protected boolean firstLineIsData;
    protected String tempUid;
    protected String uploadStatusDir;
    protected Integer recordsToLoad = null;
    protected String[] customIndexFields = null;
    protected Integer threads = 4;
    protected String alaId = null;
    private ObjectMapper om = new ObjectMapper();

    UploaderThread() {
    }

    @Override
    public void run() {
        File statusFile = null;
        HashSet userProvidedTypeList = new HashSet();
        HashSet intList = new HashSet();
        HashSet floatList = new HashSet();
        HashSet dateList = new HashSet();
        HashSet stringList = new HashSet();
        statusFile = this.createStatusFile();
        try {
            FileUtils.writeStringToFile((File)statusFile, (String)this.om.writeValueAsString((Object)new UploadStatus("STARTING", "Starting...", Integer.valueOf(0))), (String)"UTF-8");
            if (this.reload.booleanValue()) {
                FileUtils.writeStringToFile((File)statusFile, (String)this.om.writeValueAsString((Object)new UploadStatus("DELETING_EXISTING", "Deleting existing data...", Integer.valueOf(0))), (String)"UTF-8");
                Store.deleteRecords((String)this.tempUid, null, (boolean)true, (boolean)true);
            }
            FileUtils.writeStringToFile((File)statusFile, (String)this.om.writeValueAsString((Object)new UploadStatus("LOADING", "Loading...", Integer.valueOf(0))), (String)"UTF-8");
            Integer recordCount = this.lineCount;
            if (!this.firstLineIsData) {
                Integer n = recordCount;
                Integer n2 = recordCount = Integer.valueOf(recordCount - 1);
            }
            this.loadRecords(statusFile, intList, floatList, stringList, dateList, userProvidedTypeList, recordCount);
            this.status = "PROCESSING";
            logger.debug((Object)("Processing " + this.tempUid));
            FileUtils.writeStringToFile((File)statusFile, (String)this.om.writeValueAsString((Object)new UploadStatus("PROCESSING", "Starting", Integer.valueOf(25))), (String)"UTF-8");
            DefaultObserverCallback processingCallback = new DefaultObserverCallback(this, "PROCESSING", recordCount, statusFile, Integer.valueOf(25), "processed");
            Store.process((String)this.tempUid, (int)this.threads, (ObserverCallback)processingCallback);
            this.status = "SAMPLING";
            UploadIntersectCallback u = new UploadIntersectCallback(this, statusFile);
            FileUtils.writeStringToFile((File)statusFile, (String)this.om.writeValueAsString((Object)new UploadStatus("SAMPLING", "Starting environmental and contextual sampling", Integer.valueOf(50))), (String)"UTF-8");
            Store.sample((String)this.tempUid, (IntersectCallback)u);
            this.status = "INDEXING";
            Set suffixedCustIndexFields = this.getSuffixedCustomIndexFields(intList, floatList, dateList, stringList);
            logger.debug((Object)("Indexing " + this.tempUid + " " + suffixedCustIndexFields));
            FileUtils.writeStringToFile((File)statusFile, (String)this.om.writeValueAsString((Object)new UploadStatus("INDEXING", "Starting", Integer.valueOf(75))), (String)"UTF-8");
            DefaultObserverCallback indexingCallback = new DefaultObserverCallback(this, "INDEXING", recordCount, statusFile, Integer.valueOf(75), "indexed");
            Store.index((String)this.tempUid, (String[])suffixedCustIndexFields.toArray(new String[0]), (String[])userProvidedTypeList.toArray(new String[0]), (ObserverCallback)indexingCallback);
            this.status = "COMPLETE";
            FileUtils.writeStringToFile((File)statusFile, (String)this.om.writeValueAsString((Object)new UploadStatus(this.status, "Loading complete", Integer.valueOf(100))), (String)"UTF-8");
        }
        catch (Exception ex) {
            try {
                this.status = "FAILED";
                FileUtils.writeStringToFile((File)statusFile, (String)this.om.writeValueAsString((Object)new UploadStatus(this.status, "The system was unable to load this data.", Integer.valueOf(0))), (String)"UTF-8");
            }
            catch (IOException ioe) {
                logger.error((Object)("Loading failed and failed to update the status: " + ex.getMessage()), (Throwable)ex);
            }
            logger.error((Object)("Loading failed: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private Set<String> getSuffixedCustomIndexFields(Set<String> intList, Set<String> floatList, Set<String> dateList, Set<String> stringList) {
        HashSet<String> suffixedCustIndexFields = new HashSet<String>();
        for (String field : intList) {
            suffixedCustIndexFields.add(field + "_i");
        }
        for (String field : floatList) {
            suffixedCustIndexFields.add(field + "_d");
        }
        for (String field : dateList) {
            if (intList.contains(field)) continue;
            suffixedCustIndexFields.add(field + "_dt");
        }
        for (String field : stringList) {
            if (intList.contains(field) || dateList.contains(field) || floatList.contains(field)) continue;
            suffixedCustIndexFields.add(field);
        }
        return suffixedCustIndexFields;
    }

    private File createStatusFile() {
        File statusFile;
        try {
            File statusDir = new File(this.uploadStatusDir);
            if (!statusDir.exists()) {
                FileUtils.forceMkdir((File)statusDir);
            }
            statusFile = new File(this.uploadStatusDir + File.separator + this.tempUid);
            statusFile.createNewFile();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new RuntimeException(e1);
        }
        return statusFile;
    }

    private void loadRecords(File statusFile, Set<String> intList, Set<String> floatList, Set<String> stringList, Set<String> dateList, Set<String> userProvidedTypeList, Integer recordCount) throws IOException {
        Integer counter = 0;
        try {
            String[] currentLine = this.csvData.readNext();
            ArrayList<String> automaticFieldList = new ArrayList<String>();
            for (String customField : this.customIndexFields) {
                if (customField.endsWith("_i") || customField.endsWith("_d") || customField.endsWith("_s") || customField.endsWith("_dt")) {
                    userProvidedTypeList.add(customField);
                    continue;
                }
                automaticFieldList.add(customField);
            }
            CollectionUtils.addAll(intList, automaticFieldList.iterator());
            CollectionUtils.addAll(dateList, automaticFieldList.iterator());
            FileWriter rowkeyFile = new FileWriter(Config.tmpWorkDir() + "/row_key_" + this.tempUid + ".csv", true);
            if (this.firstLineIsData) {
                this.addRecord(this.tempUid, this.datasetName, currentLine, this.headers, intList, floatList, stringList, dateList, rowkeyFile);
            }
            Integer percentComplete = 0;
            while ((currentLine = this.csvData.readNext()) != null) {
                Integer n = counter;
                Integer n2 = counter = Integer.valueOf(counter + 1);
                this.addRecord(this.tempUid, this.datasetName, currentLine, this.headers, intList, floatList, stringList, dateList, rowkeyFile);
                if (counter % 100 != 0) continue;
                Integer percentageComplete = 0;
                if (counter != 0) {
                    percentageComplete = (int)((float)(counter + 1) / (float)recordCount.intValue() * 25.0f);
                }
                FileUtils.writeStringToFile((File)statusFile, (String)this.om.writeValueAsString((Object)new UploadStatus("LOADING", String.format("%d of %d records loaded.", counter, recordCount), percentageComplete)));
            }
            rowkeyFile.flush();
            rowkeyFile.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.csvData.close();
        }
    }

    private void addRecord(String tempUid, String datasetName, String[] currentLine, String[] headers, Set<String> intList, Set<String> floatList, Set<String> stringList, Set<String> dateList, FileWriter rowkeyWriter) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < headers.length && i < currentLine.length; ++i) {
            String fieldValue;
            if (currentLine[i] == null || (fieldValue = currentLine[i].trim()).length() <= 0) continue;
            String currentHeader = headers[i];
            map.put(currentHeader, fieldValue);
            if (intList.contains(currentHeader)) {
                try {
                    Integer.parseInt(fieldValue);
                }
                catch (Exception e) {
                    intList.remove(currentHeader);
                    floatList.add(currentHeader);
                }
            }
            if (floatList.contains(currentHeader)) {
                try {
                    Float.parseFloat(fieldValue);
                }
                catch (Exception e) {
                    floatList.remove(currentHeader);
                    stringList.add(currentHeader);
                }
            }
            if (!dateList.contains(currentHeader)) continue;
            try {
                if (!DateParser.parseDate((String)fieldValue, null, null).isEmpty()) continue;
                dateList.remove(currentHeader);
                stringList.add(currentHeader);
                continue;
            }
            catch (Exception e) {
                dateList.remove(currentHeader);
                stringList.add(currentHeader);
            }
        }
        map.put("datasetName", datasetName);
        if (this.alaId != null) {
            map.put("userId", this.alaId);
        }
        if (!map.isEmpty()) {
            String rowKey = Store.loadRecord((String)tempUid, map, (boolean)true);
            rowkeyWriter.write(rowKey);
            rowkeyWriter.write("\n");
        }
        rowkeyWriter.flush();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

