/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

final class ParsedGridRef {
    public final String chars;
    public final int northing;
    public final int easting;

    public ParsedGridRef(String chars, int easting, int northing) {
        this.chars = chars;
        this.easting = easting;
        this.northing = northing;
    }

    public String getGridRef() {
        return this.chars + this.easting + this.northing;
    }

    public String getGridRef100() {
        return this.chars + this.pad100(this.easting / 100) + this.pad100(this.northing / 100);
    }

    public String getGridRef1000() {
        return this.chars + this.pad10(this.easting / 1000) + this.pad10(this.northing / 1000);
    }

    public String getGridRef2000() {
        int tetradE = this.easting % 10000 / 1000;
        int tetradN = this.northing % 10000 / 1000;
        int code = tetradN / 2 + 1 + tetradE / 2 * 5;
        int tetrad = 64;
        tetrad = code <= 14 ? (int)((char)(tetrad + code)) : (int)((char)(tetrad + (code + 1)));
        return this.chars + this.easting / 10000 + this.northing / 10000 + (char)tetrad;
    }

    public String getGridRef10000() {
        return this.chars + this.easting / 10000 + this.northing / 10000;
    }

    public String getGridRef100000() {
        return new String(this.chars);
    }

    public String pad10(int eastingOrNorthing) {
        if (eastingOrNorthing < 10) {
            return "0" + eastingOrNorthing;
        }
        return "" + eastingOrNorthing;
    }

    public String pad100(int eastingOrNorthing) {
        if (eastingOrNorthing > 0 && eastingOrNorthing < 100) {
            return "0" + eastingOrNorthing;
        }
        if (eastingOrNorthing < 10) {
            return "00" + eastingOrNorthing;
        }
        return "" + eastingOrNorthing;
    }
}

