/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import java.io.InputStream;
import java.net.URL;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.w3c.dom.Document;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class GeospatialController {
    private static final Logger logger = Logger.getLogger(GeospatialController.class);
    @Inject
    protected SearchDAO searchDAO;

    @RequestMapping(value={"/occurrences/spatial*"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO listWktOccurrences(SpatialSearchRequestParams requestParams, @RequestParam(value="url", required=false) String url) throws Exception {
        requestParams.setQ("*:*");
        requestParams.setFlimit(Integer.valueOf(-1));
        if (url != null && url.length() > 0) {
            logger.info((Object)("Loading the WKT from " + url));
            URL xmlUrl = new URL(url);
            InputStream in = xmlUrl.openStream();
            Document doc = GeospatialController.parse((InputStream)in);
            try {
                String geoJson = doc.getElementsByTagName("entry").item(0).getChildNodes().item(0).getNodeValue();
                requestParams.setWkt(GeospatialController.wktFromJSON((String)geoJson));
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse the supplied URL for a WKT", (Throwable)e);
            }
        }
        return this.searchDAO.findByFulltextSpatialQuery(requestParams, null);
    }

    private static String wktFromJSON(String json) {
        try {
            logger.info((Object)("The json:" + json));
            JSONObject obj = JSONObject.fromObject((Object)json);
            String coords = obj.getString("coordinates");
            if (obj.getString("type").equalsIgnoreCase("multipolygon")) {
                return coords.replace("]]],[[[", "))*((").replace("]],[[", "))*((").replace("],[", "*").replace(",", " ").replace("*", ",").replace("[[[[", "MULTIPOLYGON(((").replace("]]]]", ")))");
            }
            return coords.replace("],[", "*").replace(",", " ").replace("*", ",").replace("[[[[", "POLYGON((").replace("]]]]", "))").replace("],[", "),(");
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to get JSON", (Throwable)e);
            return "none";
        }
    }

    public static Document parse(InputStream is) {
        Document ret = null;
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setValidating(false);
            domFactory.setNamespaceAware(false);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            ret = builder.parse(is);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }
}

