/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import java.math.BigDecimal;
import org.apache.solr.client.solrj.response.FieldStatsInfo;

public class StatsIndexFieldDTO {
    private FieldStatsInfo stats;
    private String dataType;
    private Number start;
    private Number end;
    private Number gap;

    public StatsIndexFieldDTO() {
    }

    public StatsIndexFieldDTO(FieldStatsInfo stats, String type) {
        this.dataType = type;
        this.setStats(stats);
    }

    private void generateRange() {
        if (this.stats.getStddev() > 1.0) {
            BigDecimal sd = new BigDecimal(this.stats.getStddev());
            int sdint = sd.intValue();
            int length = Integer.toString(sdint).length() - 1;
            int mult = (int)Math.pow(10.0, length);
            int igap = Math.round(sdint / mult) * mult;
            long lstart = Math.round((Double)this.stats.getMin() / (double)mult) * (long)mult;
            long lend = Math.round((Double)this.stats.getMax() / (double)mult) * (long)mult;
            if (this.dataType.equals("int")) {
                this.gap = new Integer(igap);
                this.start = new Integer((int)lstart);
                this.end = new Integer((int)lend);
            } else {
                this.gap = new Double(igap);
                this.start = new Double(lstart);
                this.end = new Double(lend);
            }
        } else if (this.stats.getStddev() == 0.0) {
            if (this.dataType.equals("int")) {
                this.gap = new Integer(0);
                this.start = new Integer(((Double)this.stats.getMin()).intValue());
                this.end = new Integer(((Double)this.stats.getMax()).intValue());
            } else {
                this.gap = new Double(0.0);
                this.start = new Double((Double)this.stats.getMin());
                this.end = new Double((Double)this.stats.getMax());
            }
        } else if (this.dataType.equals("int")) {
            this.start = new Integer(((Double)this.stats.getMin()).intValue());
            this.end = new Integer(((Double)this.stats.getMax()).intValue());
            this.gap = new Integer(this.end.intValue() - this.start.intValue() + 1);
        } else {
            this.gap = new Double(0.5);
            this.start = (Double)this.stats.getMin();
            this.end = (Double)this.stats.getMax();
        }
    }

    public String toString() {
        String value = "stats: " + this.stats.toString() + "\ngap: " + this.gap + " start " + this.start + " end " + this.end;
        return value;
    }

    public FieldStatsInfo getStats() {
        return this.stats;
    }

    public void setStats(FieldStatsInfo stats) {
        this.stats = stats;
        this.generateRange();
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public Number getStart() {
        return this.start;
    }

    public void setStart(Number start) {
        this.start = start;
    }

    public Number getEnd() {
        return this.end;
    }

    public void setEnd(Number end) {
        this.end = end;
    }

    public Number getGap() {
        return this.gap;
    }

    public void setGap(Number gap) {
        this.gap = gap;
    }
}

