/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.util.WMSTile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="WMSCache")
public class WMSCache {
    private final Logger logger = Logger.getLogger(WMSCache.class);
    @Value(value="${wms.cache.size.max:104857600}")
    long maxCacheSize;
    @Value(value="${wms.cache.size.min:52428800}")
    long minCacheSize;
    @Value(value="${wms.cache.age.max:3600000}")
    long maxAge;
    ConcurrentHashMap<String, WMSTile> cache = new ConcurrentHashMap();
    final Object counterLock = new Object();
    long cacheSize;
    CountDownLatch counter;
    final Thread cacheCleaner;
    final Object getLock = new Object();
    long triggerCleanSize = this.minCacheSize + (this.maxCacheSize - this.minCacheSize) / 2L;

    public WMSCache() {
        this.counter = new CountDownLatch(1);
        this.cacheCleaner = new /* Unavailable Anonymous Inner Class!! */;
        this.cacheCleaner.start();
        this.logger.info((Object)("maxCacheSize > " + this.maxCacheSize));
        this.logger.info((Object)("minCacheSize > " + this.minCacheSize));
        this.logger.info((Object)("maxAge > " + this.maxAge));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String q, String colourMode, PointType pointType, WMSTile wco) {
        if (this.isFull() || !this.isEnabled()) {
            return false;
        }
        wco.updateSize();
        Object object = this.counterLock;
        synchronized (object) {
            if (this.cacheSize + wco.getSize() > this.maxCacheSize) {
                return false;
            }
            this.cache.put(this.getKey(q, colourMode, pointType), wco);
            this.cacheSize += wco.getSize();
            this.logger.debug((Object)("new cache size: " + this.cacheSize));
            this.updateTriggerCleanSize();
            if (this.cacheSize > this.triggerCleanSize) {
                this.counter.countDown();
            }
        }
        wco.setCached(true);
        return true;
    }

    public String getKey(String query, String colourmode, PointType pointType) {
        return query + "|" + colourmode + "|" + pointType.getLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WMSTile get(String query, String colourmode, PointType pointType) {
        String key = this.getKey(query, colourmode, pointType);
        WMSTile obj = null;
        Object object = this.getLock;
        synchronized (object) {
            obj = (WMSTile)this.cache.get(key);
            if (obj != null && obj.getCreated() + this.maxAge < System.currentTimeMillis()) {
                this.cache.remove(key);
                obj = null;
            }
            if (obj == null) {
                obj = new WMSTile();
                this.cache.put(key, obj);
            }
        }
        if (obj != null) {
            obj.lastUse = System.currentTimeMillis();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WMSTile getTest(String query, String colourmode, PointType pointType) {
        Object object = this.getLock;
        synchronized (object) {
            return (WMSTile)this.cache.get(this.getKey(query, colourmode, pointType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanCache() {
        this.updateTriggerCleanSize();
        ArrayList entries = new ArrayList(this.cache.entrySet());
        Collections.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
        long size = 0L;
        int numberRemoved = 0;
        for (int i = 0; i < entries.size(); ++i) {
            if (size + ((WMSTile)((Map.Entry)entries.get(i)).getValue()).getSize() > this.minCacheSize) {
                String key = (String)((Map.Entry)entries.get(i)).getKey();
                this.cache.remove(key);
                ++numberRemoved;
                continue;
            }
            size += ((WMSTile)((Map.Entry)entries.get(i)).getValue()).getSize();
        }
        Object object = this.counterLock;
        synchronized (object) {
            this.cacheSize -= this.minCacheSize - size;
            size = this.cacheSize;
        }
        this.logger.debug((Object)("removed " + numberRemoved + " cached wms points, new cache size " + size));
    }

    public boolean isEnabled() {
        return this.maxCacheSize > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void empty() {
        Object object = this.counterLock;
        synchronized (object) {
            this.cacheSize = 0L;
            this.counter = new CountDownLatch(1);
            this.cache.clear();
        }
    }

    public void remove(String q, String colourMode, PointType pointType) {
        this.cache.remove(this.getKey(q, colourMode, pointType));
    }

    public boolean isFull() {
        return this.cacheSize >= this.maxCacheSize;
    }

    public void setMaxCacheSize(long sizeInBytes) {
        this.maxCacheSize = sizeInBytes;
        this.updateTriggerCleanSize();
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMinCacheSize(long sizeInBytes) {
        this.minCacheSize = sizeInBytes;
        this.updateTriggerCleanSize();
    }

    public long getMinCacheSize() {
        return this.minCacheSize;
    }

    long getSize() {
        return this.cacheSize;
    }

    public long getMaxCacheAge() {
        return this.maxAge;
    }

    public void setMaxCacheAge(long maxCacheAge) {
        this.maxAge = maxCacheAge;
    }

    void updateTriggerCleanSize() {
        this.triggerCleanSize = this.minCacheSize + (this.maxCacheSize - this.minCacheSize) / 2L;
        this.logger.debug((Object)("triggerCleanSize=" + this.triggerCleanSize + " minCacheSize=" + this.minCacheSize + " maxCacheSize=" + this.maxCacheSize));
    }

    static /* synthetic */ Logger access$000(WMSCache x0) {
        return x0.logger;
    }
}

