/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dto.ContactDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="contactUtils")
public class ContactUtils {
    private static final Logger logger = LoggerFactory.getLogger(ContactUtils.class);
    @Value(value="${registry.url:http://collections.ala.org.au}")
    protected String registryUrl;
    @Value(value="${contacts.url:http://collections.ala.org.au/ws/collection}")
    protected String collectionContactsUrl;
    @Inject
    private RestOperations restTemplate;

    public List<ContactDTO> getContactsForUID(String collectionUid) {
        if (collectionUid == null) {
            return new ArrayList<ContactDTO>();
        }
        ArrayList<ContactDTO> contactDTOs = new ArrayList<ContactDTO>();
        String jsonUri = this.collectionContactsUrl + "/" + collectionUid + "/contacts.json";
        List contacts = (List)this.restTemplate.getForObject(jsonUri, List.class, new Object[0]);
        logger.debug("number of contacts = " + contacts.size());
        for (Map contact : contacts) {
            Map details = (Map)contact.get("contact");
            String email = (String)details.get("email");
            String title = (String)details.get("title");
            String firstName = (String)details.get("firstName");
            String lastName = (String)details.get("lastName");
            String phone = (String)details.get("phone");
            logger.debug("email = " + email);
            ContactDTO c = new ContactDTO();
            c.setEmail(email);
            StringBuffer sb = new StringBuffer();
            if (StringUtils.isNotEmpty((String)title)) {
                sb.append(title);
                sb.append(" ");
            }
            sb.append(firstName);
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(lastName);
            c.setDisplayName(sb.toString());
            c.setPhone(phone);
            c.setRole((String)contact.get("role"));
            contactDTOs.add(c);
        }
        return contactDTOs;
    }

    public ContactDTO getContactForEmailAndUid(String email, String uid) {
        if (email == null) {
            return null;
        }
        List contacts = this.getContactsForUID(uid);
        for (ContactDTO contact : contacts) {
            if (!email.toLowerCase().equals(contact.getEmail().toLowerCase())) continue;
            return contact;
        }
        return null;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }
}

