/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.writer.RecordWriterError;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSVRecordWriter
implements RecordWriterError {
    private static final Logger logger = LoggerFactory.getLogger(TSVRecordWriter.class);
    private final OutputStream outputStream;
    private final String[] header;
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final AtomicBoolean finalised = new AtomicBoolean(false);
    private final AtomicBoolean finalisedComplete = new AtomicBoolean(false);
    private final AtomicBoolean writerError = new AtomicBoolean(false);
    private final List<Throwable> errors = new ArrayList();

    public TSVRecordWriter(OutputStream out, String[] header) {
        this.outputStream = out;
        this.header = header;
    }

    public void write(String[] record) {
        if (!this.initialised.get()) {
            throw new IllegalStateException("Must call initialise method before calling write.");
        }
        StringBuilder line = new StringBuilder(256);
        for (int i = 0; i < record.length; ++i) {
            if (i > 0) {
                line.append('\t');
            }
            line.append(record[i].replace("\r", "").replace("\n", "").replace("\t", ""));
        }
        line.append("\n");
        try {
            String str = line.toString();
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            this.outputStream.write(bytes);
            if (this.outputStream instanceof OptionalZipOutputStream && ((OptionalZipOutputStream)this.outputStream).isNewFile((Object)this, (long)bytes.length)) {
                this.write(this.header);
            }
        }
        catch (IOException e) {
            logger.error("Found error writing to TSV file", (Throwable)e);
            this.errors.add(e);
            this.writerError.set(true);
        }
    }

    public void initialise() {
        if (this.initialised.compareAndSet(false, true)) {
            this.write(this.header);
        }
    }

    public void finalise() {
        if (this.finalised.compareAndSet(false, true)) {
            try {
                this.flush();
            }
            finally {
                this.finalisedComplete.set(true);
            }
        }
    }

    public boolean finalised() {
        return this.finalisedComplete.get();
    }

    public boolean hasError() {
        return this.writerError.get();
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.errors.add(e);
            this.writerError.set(true);
        }
    }

    public void close() throws IOException {
        this.finalise();
    }
}

