/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.util.AlaFileUtils;
import au.org.ala.biocache.writer.RecordWriterError;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeFileRecordWriter
implements RecordWriterError {
    private static final Logger logger = LoggerFactory.getLogger(ShapeFileRecordWriter.class);
    private final int maxCollectionSize = 10000;
    private final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    private final ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
    private final String tmpFilename;
    private final String tmpDownloadDirectory;
    private final SimpleFeatureBuilder featureBuilder;
    private final SimpleFeatureType simpleFeature;
    private final OutputStream outputStream;
    private final ListFeatureCollection collection;
    private final Map<String, String> headerMappings;
    private final String[] originalHeader;
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final AtomicBoolean finalised = new AtomicBoolean(false);
    private final AtomicBoolean finalisedComplete = new AtomicBoolean(false);
    private final AtomicBoolean writerError = new AtomicBoolean(false);
    private final List<Throwable> errors = new ArrayList();
    private final int latIdx;
    private final int longIdx;
    private volatile Transaction transaction;
    private volatile File temporaryShapeFile;
    private volatile ShapefileDataStore newDataStore;
    private volatile String typeName;
    private volatile SimpleFeatureSource featureSource;
    private volatile SimpleFeatureStore featureStore;

    public ShapeFileRecordWriter(String tmpdir, String filename, OutputStream out, String[] header) {
        this.tmpDownloadDirectory = tmpdir;
        this.tmpFilename = filename;
        this.originalHeader = header;
        this.headerMappings = AlaFileUtils.generateShapeHeader((String[])header);
        this.outputStream = out;
        if (ArrayUtils.indexOf((Object[])header, (Object)"latitude") < 0 || ArrayUtils.indexOf((Object[])header, (Object)"longitude") < 0) {
            this.latIdx = ArrayUtils.indexOf((Object[])header, (Object)"decimalLatitude_p");
            this.longIdx = ArrayUtils.indexOf((Object[])header, (Object)"decimalLongitude_p");
        } else {
            this.latIdx = ArrayUtils.indexOf((Object[])header, (Object)"latitude");
            this.longIdx = ArrayUtils.indexOf((Object[])header, (Object)"longitude");
        }
        this.simpleFeature = this.createFeatureType(this.headerMappings.keySet(), null);
        this.featureBuilder = new SimpleFeatureBuilder(this.simpleFeature);
        this.collection = new ListFeatureCollection(this.featureBuilder.getFeatureType());
    }

    private SimpleFeatureType createFeatureType(Set<String> features, Class<?>[] types) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Occurrence");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("the_geom", Point.class);
        int i = 0;
        for (String feature : features) {
            Class<String> type;
            Class clazz = type = types != null ? types[i] : String.class;
            if (i != this.longIdx && i != this.latIdx) {
                builder.add(feature, type);
            }
            ++i;
        }
        builder.setDefaultGeometry("the_geom");
        SimpleFeatureType LOCATION = builder.buildFeatureType();
        if (logger.isDebugEnabled()) {
            logger.debug("FEATURES IN HEADER::: " + StringUtils.join(features, (String)"|"));
            logger.debug("LOCATION INFO:::" + LOCATION.getAttributeCount() + " " + i + " " + LOCATION.getAttributeDescriptors());
        }
        return LOCATION;
    }

    public void initialise() {
        if (this.initialised.compareAndSet(false, true)) {
            try {
                if (this.latIdx < 0 || this.longIdx < 0) {
                    logger.error("The invalid header..." + StringUtils.join((Object[])this.originalHeader, (String)"|"));
                    throw new IllegalArgumentException("A Shape File Export needs to include latitude and longitude in the headers: " + StringUtils.join((Object[])this.originalHeader, (String)"|"));
                }
                this.temporaryShapeFile = new File(this.tmpDownloadDirectory + File.separator + System.currentTimeMillis() + File.separator + this.tmpFilename + File.separator + this.tmpFilename + ".shp");
                FileUtils.forceMkdir((File)this.temporaryShapeFile.getParentFile());
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put("url", this.temporaryShapeFile.toURI().toURL());
                params.put("create spatial index", Boolean.TRUE);
                this.transaction = new DefaultTransaction("create");
                this.newDataStore = (ShapefileDataStore)this.dataStoreFactory.createNewDataStore(params);
                this.newDataStore.createSchema(this.simpleFeature);
                this.typeName = this.newDataStore.getTypeNames()[0];
                this.featureSource = this.newDataStore.getFeatureSource(this.typeName);
                if (this.featureSource instanceof SimpleFeatureStore) {
                    this.featureStore = (SimpleFeatureStore)this.featureSource;
                    this.featureStore.setTransaction(this.transaction);
                } else {
                    this.writerError.set(true);
                    logger.error(this.typeName + " is not currently supported for read/write access");
                }
                if (this.outputStream instanceof OptionalZipOutputStream) {
                    this.outputStream.write("latitude,longitude\n".getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                logger.error("Unable to create ShapeFile", (Throwable)e);
                this.writerError.set(true);
                this.errors.add(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void finalise() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void write(String[] record) {
        if (!this.initialised.get()) {
            throw new IllegalStateException("Must call initialise method before calling write.");
        }
        if (StringUtils.isNotBlank((String)record[this.longIdx]) && StringUtils.isNotBlank((String)record[this.latIdx])) {
            double longitude = Double.parseDouble(record[this.longIdx]);
            double latitude = Double.parseDouble(record[this.latIdx]);
            Point point = this.geometryFactory.createPoint(new Coordinate(longitude, latitude));
            this.featureBuilder.add((Object)point);
            int i = 0;
            int max = this.simpleFeature.getAttributeCount() + 2;
            for (String value : record) {
                if (i != this.longIdx && i != this.latIdx && i < max) {
                    this.featureBuilder.add((Object)value);
                }
                ++i;
            }
            SimpleFeature feature = this.featureBuilder.buildFeature(null);
            this.collection.add(feature);
            try {
                if (this.collection.size() > 10000) {
                    if (this.featureStore != null) {
                        this.featureStore.addFeatures((FeatureCollection)this.collection);
                    }
                    this.collection.clear();
                }
                if (this.outputStream instanceof OptionalZipOutputStream) {
                    this.outputStream.write((latitude + "," + longitude + "\n").getBytes("UTF-8"));
                }
            }
            catch (IOException | ArrayIndexOutOfBoundsException e) {
                logger.error("Unable to write an entry to Shapefile", (Throwable)e);
                this.errors.add(e);
                this.writerError.set(true);
            }
        } else {
            logger.debug("Not adding record with missing lat/long: {}", (Object)record[0]);
        }
    }

    public Map<String, String> getHeaderMappings() {
        return this.headerMappings;
    }

    public boolean finalised() {
        return this.finalisedComplete.get();
    }

    public boolean hasError() {
        return this.writerError.get();
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (Exception e) {
            this.writerError.set(true);
            this.errors.add(e);
        }
    }

    public void close() throws IOException {
        this.finalise();
    }
}

