/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class AbstractSecureController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSecureController.class);
    @Value(value="${api.check.url:https://auth.ala.org.au/apikey/ws/check?apikey=}")
    protected String apiCheckUrl;
    @Value(value="${api.check.enabled:true}")
    protected Boolean apiKeyCheckedEnabled = true;
    private static Set<String> apiKeyCache = new ConcurrentHashSet();

    public boolean shouldPerformOperation(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String apiKey = request.getParameter("apiKey");
        return this.shouldPerformOperation(apiKey, response, true);
    }

    public boolean shouldPerformOperation(String apiKey, HttpServletResponse response) throws Exception {
        return this.shouldPerformOperation(apiKey, response, true);
    }

    public boolean isValidKey(String keyToTest) {
        if (!this.apiKeyCheckedEnabled.booleanValue()) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)keyToTest)) {
            return false;
        }
        if (apiKeyCache.contains(keyToTest)) {
            return true;
        }
        try {
            logger.debug("Checking api key: {}", (Object)keyToTest);
            String url = this.apiCheckUrl + keyToTest;
            ObjectMapper om = new ObjectMapper();
            Map response = (Map)om.readValue(new URL(url), Map.class);
            boolean isValid = (Boolean)response.get("valid");
            logger.debug("Checking api key: {}, valid: {}", (Object)keyToTest, (Object)isValid);
            if (isValid) {
                apiKeyCache.add(keyToTest);
            }
            return isValid;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean shouldPerformOperation(String apiKey, HttpServletResponse response, boolean checkReadOnly) throws Exception {
        if (checkReadOnly && Store.isReadOnly()) {
            response.sendError(409, "Server is in read only mode.  Try again later.");
            return false;
        }
        if (!this.isValidKey(apiKey)) {
            response.sendError(403, "An invalid API Key was provided.");
            return false;
        }
        return !response.isCommitted();
    }
}

