/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="persistentQueueDao")
public class JsonPersistentQueueDAOImpl
implements PersistentQueueDAO {
    private static final Logger logger = Logger.getLogger(JsonPersistentQueueDAOImpl.class);
    @Value(value="${download.cache.dir:/data/cache/downloads}")
    protected String cacheDirectory = "/data/cache/downloads";
    private static final String FILE_PREFIX = "offline";
    @Value(value="${download.dir:/data/biocache-download}")
    protected String biocacheDownloadDir;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final Queue<DownloadDetailsDTO> offlineDownloadList = new LinkedBlockingQueue();
    private final Object listLock = new Object();
    private final AtomicBoolean closed = new AtomicBoolean(true);
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final CountDownLatch initialisationLatch = new CountDownLatch(1);

    private final void afterInitialisation() {
        try {
            this.initialisationLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @PostConstruct
    public void init() {
        if (this.initialised.compareAndSet(false, true)) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private File getFile(long key) {
        return new File(this.cacheDirectory + File.separator + FILE_PREFIX + key + ".json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadToQueue(DownloadDetailsDTO download) {
        this.afterInitialisation();
        if (!this.closed.get()) {
            Object object = this.listLock;
            synchronized (object) {
                boolean allGood = false;
                try {
                    DownloadDetailsDTO inQueue = this.isInQueue(download);
                    if (inQueue != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Did not add download to queue as it was already in the queue: " + download.toString()));
                        }
                        return;
                    }
                    File f = this.getFile(download.getStartTime());
                    this.jsonMapper.writeValue(f, (Object)download);
                    allGood = true;
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to store download details to persistent storage: ", (Throwable)e);
                }
                finally {
                    if (allGood) {
                        this.offlineDownloadList.add(download);
                    } else {
                        logger.error((Object)("Download could not be added to the queue: " + download.toString()));
                    }
                }
            }
        }
        logger.error((Object)("Download could not be added to the queue because the queue has been closed: " + download.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadDetailsDTO getNextDownload() {
        this.afterInitialisation();
        Object object = this.listLock;
        synchronized (object) {
            for (DownloadDetailsDTO dd : this.offlineDownloadList) {
                if (dd.getFileLocation() != null) continue;
                dd.setFileLocation(this.biocacheDownloadDir + File.separator + UUID.nameUUIDFromBytes(dd.getEmail().getBytes(StandardCharsets.UTF_8)) + File.separator + dd.getStartTime() + File.separator + dd.getRequestParams().getFile() + ".zip");
                return dd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadDetailsDTO getNextDownload(Integer maxRecords, DownloadDetailsDTO.DownloadType type) {
        this.afterInitialisation();
        Object object = this.listLock;
        synchronized (object) {
            for (DownloadDetailsDTO dd : this.offlineDownloadList) {
                if (dd.getFileLocation() != null || maxRecords != null && dd.getTotalRecords() > (long)maxRecords.intValue() || type != null && !dd.getDownloadType().equals((Object)type)) continue;
                UUID emailUUID = UUID.nameUUIDFromBytes(dd.getEmail().getBytes(StandardCharsets.UTF_8));
                long startTime = dd.getStartTime();
                DownloadRequestParams requestParams = dd.getRequestParams();
                String file = requestParams.getFile();
                dd.setFileLocation(this.biocacheDownloadDir + File.separator + emailUUID + File.separator + startTime + File.separator + file + ".zip");
                return dd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalDownloads() {
        this.afterInitialisation();
        Object object = this.listLock;
        synchronized (object) {
            return this.offlineDownloadList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadFromQueue(DownloadDetailsDTO download) {
        this.afterInitialisation();
        Object object = this.listLock;
        synchronized (object) {
            logger.debug((Object)"Removing the download from the queue");
            try {
                File f = this.getFile(download.getStartTime());
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Deleting " + f.getAbsolutePath() + " " + f.exists()));
                }
                FileUtils.deleteQuietly((File)f);
            }
            finally {
                this.offlineDownloadList.remove(download);
                download.getInterrupt().set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadDetailsDTO> getAllDownloads() {
        this.afterInitialisation();
        Object object = this.listLock;
        synchronized (object) {
            ArrayList result = new ArrayList(this.offlineDownloadList);
            return Collections.unmodifiableList(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFromPersistent() {
        if (!this.closed.get()) {
            Object object = this.listLock;
            synchronized (object) {
                this.offlineDownloadList.clear();
                File file = new File(this.cacheDirectory);
                File[] files = file.listFiles();
                if (files != null) {
                    Arrays.sort(files, new /* Unavailable Anonymous Inner Class!! */);
                    for (File f : files) {
                        if (!f.isFile()) continue;
                        try {
                            DownloadDetailsDTO dd = (DownloadDetailsDTO)this.jsonMapper.readValue(f, DownloadDetailsDTO.class);
                            String previousFileLocation = dd.getFileLocation();
                            dd.setFileLocation(null);
                            if (previousFileLocation != null) {
                                FileUtils.deleteQuietly((File)new File(previousFileLocation));
                            }
                            this.offlineDownloadList.add(dd);
                        }
                        catch (Exception e) {
                            logger.error((Object)("Unable to load cached download " + f.getAbsolutePath()), (Throwable)e);
                        }
                    }
                }
            }
        } else {
            logger.error((Object)"Could not refresh from persistent storage because the queue has been closed", new Throwable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadDetailsDTO isInQueue(DownloadDetailsDTO dd) {
        this.afterInitialisation();
        Object object = this.listLock;
        synchronized (object) {
            for (DownloadDetailsDTO d : this.offlineDownloadList) {
                if (!d.getEmail().equalsIgnoreCase(d.getEmail()) || !d.getDownloadParams().equalsIgnoreCase(dd.getDownloadParams())) continue;
                return d;
            }
        }
        return null;
    }

    public void shutdown() {
        this.closed.set(true);
    }

    static /* synthetic */ Object access$000(JsonPersistentQueueDAOImpl x0) {
        return x0.listLock;
    }

    static /* synthetic */ ObjectMapper access$100(JsonPersistentQueueDAOImpl x0) {
        return x0.jsonMapper;
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }

    static /* synthetic */ AtomicBoolean access$300(JsonPersistentQueueDAOImpl x0) {
        return x0.closed;
    }

    static /* synthetic */ CountDownLatch access$400(JsonPersistentQueueDAOImpl x0) {
        return x0.initialisationLatch;
    }
}

