/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.config;

import au.org.ala.biocache.Config;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.index.SolrIndexDAO;
import au.org.ala.biocache.service.RestartDataService;
import au.org.ala.biocache.service.SpeciesLookupIndexService;
import au.org.ala.biocache.service.SpeciesLookupRestService;
import au.org.ala.biocache.service.SpeciesLookupService;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.web.client.RestOperations;

@Configuration
public class AppConfig {
    private static final Logger logger = Logger.getLogger(AppConfig.class);
    @Inject
    private AbstractMessageSource messageSource;
    @Value(value="${name.index.dir:/data/lucene/namematching}")
    protected String nameIndexLocation;
    @Inject
    @Qualifier(value="restTemplate")
    private RestOperations restTemplate;
    @Value(value="${service.bie.ws.url:https://bie.ala.org.au/ws}")
    protected String bieUriPrefix;
    @Value(value="${service.bie.enabled:false}")
    protected Boolean enabled;
    @Value(value="${service.autocomplete.local.enabled:true}")
    protected Boolean autocompleteLocalEnabled;
    @Value(value="${facet.config:/data/biocache/config/facets.json}")
    protected String facetConfig;
    @Value(value="${facets.max:4}")
    protected Integer facetsMax;
    @Value(value="${facet.default:true}")
    protected Boolean facetDefault;

    @Value(value="${restart.data.dir:/tmp}")
    public void setDatabase(String dir) {
        logger.debug((Object)("setting RestartDataService.dir: " + dir));
        RestartDataService.dir = dir;
    }

    protected SpeciesLookupService getSpeciesLookupRestService() {
        logger.info((Object)"Initialising rest-based species lookup services.");
        SpeciesLookupRestService service = new SpeciesLookupRestService();
        service.setBieUriPrefix(this.bieUriPrefix);
        service.setEnabled(this.enabled);
        service.setRestTemplate(this.restTemplate);
        service.setMessageSource(this.messageSource);
        return service;
    }

    protected SpeciesLookupService getSpeciesLookupIndexService() {
        logger.info((Object)"Initialising local index-based species lookup services.");
        SpeciesLookupIndexService service = new SpeciesLookupIndexService();
        service.setNameIndexLocation(this.nameIndexLocation);
        service.setMessageSource(this.messageSource);
        return service;
    }

    @Bean(name={"speciesLookupService"})
    public SpeciesLookupService speciesLookupServiceBean() {
        logger.info((Object)"Initialising species lookup services.");
        if (this.enabled.booleanValue()) {
            return this.getSpeciesLookupRestService();
        }
        return this.getSpeciesLookupIndexService();
    }

    @Bean(name={"speciesLookupIndexService"})
    public SpeciesLookupService speciesLookupIndexService() {
        logger.info((Object)"Initialising species lookup services.");
        try {
            if (this.autocompleteLocalEnabled.booleanValue()) {
                return this.getSpeciesLookupIndexService();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to initialise local species lookup service for use with the species autocomplete ws. Attempting to use BIE instead.");
        }
        if (this.enabled.booleanValue()) {
            return this.getSpeciesLookupRestService();
        }
        return null;
    }

    @Bean(name={"solrClient"})
    public SolrClient solrClientBean() {
        SolrIndexDAO dao = (SolrIndexDAO)Config.getInstance(IndexDAO.class);
        dao.init();
        SolrClient result = dao.solrServer();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("solrClient initialised, Type: " + result.getClass()));
        }
        return result;
    }
}

