/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.util.AlaFileUtils;
import au.org.ala.biocache.writer.RecordWriterError;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeFileRecordWriter
implements RecordWriterError {
    private static final Logger logger = LoggerFactory.getLogger(ShapeFileRecordWriter.class);
    private final int maxCollectionSize = 10000;
    private String tmpDownloadDirectory;
    private ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
    private SimpleFeatureBuilder featureBuilder;
    private SimpleFeatureType simpleFeature;
    private OutputStream outputStream;
    private File temporaryShapeFile;
    private int latIdx;
    private int longIdx;
    private DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
    private Map<String, String> headerMappings = null;
    private final AtomicBoolean finalised = new AtomicBoolean(false);
    private final AtomicBoolean finalisedComplete = new AtomicBoolean(false);
    private boolean writerError = false;
    private ShapefileDataStore newDataStore;
    private String typeName;
    private SimpleFeatureSource featureSource;
    private SimpleFeatureStore featureStore;
    GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

    public ShapeFileRecordWriter(String tmpdir, String filename, OutputStream out, String[] header) {
        this.tmpDownloadDirectory = tmpdir;
        this.headerMappings = AlaFileUtils.generateShapeHeader((String[])header);
        this.outputStream = out;
        this.temporaryShapeFile = new File(this.tmpDownloadDirectory + File.separator + System.currentTimeMillis() + File.separator + filename + File.separator + filename + ".shp");
        try {
            FileUtils.forceMkdir((File)this.temporaryShapeFile.getParentFile());
            this.latIdx = ArrayUtils.indexOf((Object[])header, (Object)"latitude");
            this.longIdx = ArrayUtils.indexOf((Object[])header, (Object)"longitude");
            if (this.latIdx < 0 || this.longIdx < 0) {
                this.latIdx = ArrayUtils.indexOf((Object[])header, (Object)"decimalLatitude_p");
                this.longIdx = ArrayUtils.indexOf((Object[])header, (Object)"decimalLongitude_p");
            }
            this.simpleFeature = this.createFeatureType(this.headerMappings.keySet(), null);
            this.featureBuilder = new SimpleFeatureBuilder(this.simpleFeature);
            if (this.latIdx < 0 || this.longIdx < 0) {
                logger.error("The invalid header..." + StringUtils.join((Object[])header, (String)"|"));
                throw new IllegalArgumentException("A Shape File Export needs to include latitude and longitude in the headers.");
            }
        }
        catch (IOException e) {
            logger.error("Unable to create ShapeFile", (Throwable)e);
            this.writerError = true;
        }
        this.initShapefile();
    }

    private void initShapefile() {
        try {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", this.temporaryShapeFile.toURI().toURL());
            params.put("create spatial index", Boolean.TRUE);
            this.newDataStore = (ShapefileDataStore)this.dataStoreFactory.createNewDataStore(params);
            this.newDataStore.createSchema(this.simpleFeature);
            this.typeName = this.newDataStore.getTypeNames()[0];
            this.featureSource = this.newDataStore.getFeatureSource(this.typeName);
            if (this.featureSource instanceof SimpleFeatureStore) {
                this.featureStore = (SimpleFeatureStore)this.featureSource;
            } else {
                this.writerError = true;
                logger.error(this.typeName + " does not support read/write access");
            }
            if (this.outputStream instanceof OptionalZipOutputStream) {
                this.outputStream.write("latitude,longitude\n".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            logger.error("Unable to create ShapeFile", (Throwable)e);
            this.writerError = true;
        }
    }

    private SimpleFeatureType createFeatureType(Set<String> features, Class[] types) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Occurrence");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("Location", Point.class);
        int i = 0;
        for (String feature : features) {
            Class type;
            Class clazz = type = types != null ? types[i] : String.class;
            if (i != this.longIdx && i != this.latIdx) {
                builder.add(feature, type);
            }
            ++i;
        }
        SimpleFeatureType LOCATION = builder.buildFeatureType();
        if (logger.isDebugEnabled()) {
            logger.debug("FEATURES IN HEADER::: " + StringUtils.join(features, (String)"|"));
            logger.debug("LOCATION INFO:::" + LOCATION.getAttributeCount() + " " + i + " " + LOCATION.getAttributeDescriptors());
        }
        return LOCATION;
    }

    public ShapeFileRecordWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalise() {
        if (this.finalised.compareAndSet(false, true)) {
            try {
                if (this.collection.size() > 0) {
                    this.featureStore.addFeatures((FeatureCollection)this.collection);
                    this.collection.clear();
                }
                OptionalZipOutputStream os = null;
                if (this.outputStream instanceof OptionalZipOutputStream) {
                    os = (OptionalZipOutputStream)this.outputStream;
                    String name = os.getCurrentEntry();
                    if (name.contains(".")) {
                        name = name.substring(0, name.lastIndexOf(46));
                    }
                    os = (OptionalZipOutputStream)this.outputStream;
                    this.outputStream.flush();
                    os.closeEntry();
                    os.putNextEntry(name + ".zip");
                }
                String targetZipFile = this.temporaryShapeFile.getParentFile().getParent() + File.separator + this.temporaryShapeFile.getName().replace(".shp", ".zip");
                AlaFileUtils.createZip((String)this.temporaryShapeFile.getParent(), (String)targetZipFile);
                try (FileInputStream inputStream = new FileInputStream(targetZipFile);){
                    logger.info("Copying Shape zip file to outputstream");
                    IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
                    FileUtils.deleteDirectory((File)this.temporaryShapeFile.getParentFile().getParentFile());
                }
                this.outputStream.flush();
            }
            catch (IOException e) {
                logger.error("Unable to create ShapeFile", (Throwable)e);
                this.writerError = true;
            }
            finally {
                this.finalisedComplete.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(String[] record) {
        if (StringUtils.isNotBlank((String)record[this.longIdx]) && StringUtils.isNotBlank((String)record[this.latIdx])) {
            double longitude = Double.parseDouble(record[this.longIdx]);
            double latitude = Double.parseDouble(record[this.latIdx]);
            Point point = this.geometryFactory.createPoint(new Coordinate(longitude, latitude));
            this.featureBuilder.add((Object)point);
            int i = 0;
            int max = this.simpleFeature.getAttributeCount() + 2;
            for (String value : record) {
                if (i != this.longIdx && i != this.latIdx && i < max) {
                    this.featureBuilder.add((Object)value);
                }
                ++i;
            }
            SimpleFeature feature = this.featureBuilder.buildFeature(null);
            this.collection.add(feature);
            try {
                if (this.collection.size() > 10000) {
                    this.featureStore.addFeatures((FeatureCollection)this.collection);
                }
                if (!(this.outputStream instanceof OptionalZipOutputStream)) return;
                this.outputStream.write((latitude + "," + longitude + "\n").getBytes("UTF-8"));
                return;
            }
            catch (IOException e) {
                logger.error("Unable to create ShapeFile", (Throwable)e);
                this.writerError = true;
                return;
            }
            finally {
                if (this.collection.size() > 10000) {
                    this.collection.clear();
                }
            }
        } else {
            logger.debug("Not adding record with missing lat/long: " + record[0]);
        }
    }

    public Map<String, String> getHeaderMappings() {
        return this.headerMappings;
    }

    public boolean finalised() {
        return this.finalisedComplete.get();
    }

    public boolean hasError() {
        return this.writerError;
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (Exception e) {
            logger.error("Unable to create ShapeFile", (Throwable)e);
            this.writerError = true;
        }
    }
}

