/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.writer.RecordWriterError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVRecordWriter
implements RecordWriterError {
    private static final Logger logger = LoggerFactory.getLogger(CSVRecordWriter.class);
    private CSVWriter csvWriter;
    private OutputStream outputStream;
    private final AtomicBoolean finalised = new AtomicBoolean(false);
    private final AtomicBoolean finalisedComplete = new AtomicBoolean(false);
    private String[] header;

    public CSVRecordWriter(OutputStream out, String[] header) {
        this.outputStream = out;
        this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter(out, Charset.forName("UTF-8")), ',', '\"');
        this.csvWriter.writeNext(header);
        this.header = header;
    }

    public CSVRecordWriter(OutputStream out, String[] header, char sep, char esc) {
        this.outputStream = out;
        this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter(out, Charset.forName("UTF-8")), sep, '\"', esc);
        this.csvWriter.writeNext(header);
        this.header = header;
    }

    public void write(String[] record) {
        this.csvWriter.writeNext(record);
        if (this.outputStream instanceof OptionalZipOutputStream) {
            try {
                long length = 0L;
                for (String s : record) {
                    if (s == null) continue;
                    length += (long)s.getBytes("UTF-8").length;
                }
                if (((OptionalZipOutputStream)this.outputStream).isNewFile((Object)this.csvWriter, length)) {
                    this.write(this.header);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean hasError() {
        return this.csvWriter.checkError();
    }

    public void flush() {
        try {
            this.csvWriter.flush();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public void finalise() {
        if (this.finalised.compareAndSet(false, true)) {
            this.flush();
            this.finalisedComplete.set(true);
        }
    }

    public boolean finalised() {
        return this.finalisedComplete.get();
    }
}

