/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dao.TaxonDAO;
import au.org.ala.biocache.dto.DataProviderCountDTO;
import au.org.ala.biocache.dto.FacetPivotResultDTO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.GroupFacetResultDTO;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.model.Qid;
import au.org.ala.biocache.util.ColorUtil;
import au.org.ala.biocache.util.LegendItem;
import au.org.ala.biocache.util.QueryFormatUtils;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.util.WMSCache;
import au.org.ala.biocache.util.WMSTile;
import au.org.ala.biocache.util.WmsEnv;
import au.org.ala.biocache.web.ImgObj;
import au.org.ala.biocache.web.WMSOSGridController;
import au.org.ala.biocache.web.WMSUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WMSController {
    private final int DEFAULT_PAGE_SIZE = 1000000;
    @Value(value="${wms.colour:0x00000000}")
    private int DEFAULT_COLOUR;
    @Value(value="${wms.image.pixel.count:36000000}")
    private int MAX_IMAGE_PIXEL_COUNT;
    private final String NULL_NAME = "Unknown";
    @Value(value="${wms.uncertainty.max:30000}")
    private double MAX_UNCERTAINTY;
    @Value(value="${wms.highlight.radius:3}")
    private static int HIGHLIGHT_RADIUS;
    @Value(value="${wms.cache.enabled:true}")
    private boolean wmsCacheEnabled;
    private static final Logger logger;
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected QueryFormatUtils queryFormatUtils;
    @Inject
    protected TaxonDAO taxonDAO;
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    protected QidCacheDAO qidCacheDAO;
    @Inject
    protected WMSCache wmsCache;
    static final byte[] blankImageBytes;
    @Value(value="${webservices.root:http://biocache.ala.org.au/ws}")
    protected String baseWsUrl;
    @Value(value="${biocache.ui.url:http://bicoache.ala.org.au}")
    protected String baseUiUrl;
    @Value(value="${geoserver.url:http://spatial.ala.org.au/geoserver}")
    protected String geoserverUrl;
    @Value(value="${organizationName:Atlas of Living Australia}")
    protected String organizationName;
    @Value(value="${orgCity:Canberra}")
    protected String orgCity;
    @Value(value="${orgStateProvince:ACT}")
    protected String orgStateProvince;
    @Value(value="${orgPostcode:2601}")
    protected String orgPostcode;
    @Value(value="${orgCountry:Australia}")
    protected String orgCountry;
    @Value(value="${orgPhone:+61 (0) 2 6246 4400}")
    protected String orgPhone;
    @Value(value="${orgFax:+61 (0) 2 6246 4400}")
    protected String orgFax;
    @Value(value="${orgEmail:support@ala.org.au}")
    protected String orgEmail;
    @Value(value="${service.bie.ws.url:http://bie.ala.org.au/ws}")
    protected String bieWebService;
    @Value(value="${service.bie.ui.url:http://bie.ala.org.au}")
    protected String bieUiUrl;
    @Value(value="${wms.capabilities.focus:latitude:[-90 TO 90] AND longitude:[-180 TO 180]}")
    protected String limitToFocusValue;
    @Value(value="${default.srs:900913}")
    protected String defaultSRS;
    @Value(value="${qid.wkt.maxPoints:5000}")
    private int maxWktPoints;
    @Value(value="${wms.cache.maxLayerPoints:100000}")
    private int wmsCacheMaxLayerPoints;
    @Value(value="${wms.facetPivotCutoff:2000}")
    private int wmsFacetPivotCutoff;
    @Inject
    protected WMSUtils wmsUtils;
    private LRUMap countsCache = new LRUMap(10000);
    private Object countLock = new Object();
    @Inject
    protected WMSOSGridController wmsosGridController;
    @Inject
    EhCacheManagerFactoryBean cacheManager;
    private int map_offset = 0x10000000;
    private double map_radius = (double)this.map_offset / Math.PI;

    @RequestMapping(value={"/webportal/params", "/mapping/params"}, method={RequestMethod.POST})
    public void storeParams(SpatialSearchRequestParams requestParams, @RequestParam(value="bbox", required=false, defaultValue="false") String bbox, @RequestParam(value="title", required=false) String title, @RequestParam(value="maxage", required=false, defaultValue="-1") Long maxage, @RequestParam(value="source", required=false) String source, HttpServletResponse response) throws Exception {
        String qid;
        requestParams.setFl("");
        requestParams.setFacets(new String[0]);
        requestParams.setStart(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(false));
        requestParams.setFlimit(Integer.valueOf(0));
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setSort("score");
        requestParams.setDir("asc");
        requestParams.setFoffset(Integer.valueOf(0));
        requestParams.setFprefix("");
        requestParams.setFsort("");
        requestParams.setIncludeMultivalues(Boolean.valueOf(false));
        if (StringUtils.isNotEmpty((String)requestParams.getQc())) {
            this.queryFormatUtils.addFqs(new String[]{requestParams.getQc()}, requestParams);
            requestParams.setQc("");
        }
        if (requestParams.getLat() != null) {
            String fq = this.queryFormatUtils.latLonPart(requestParams);
            this.queryFormatUtils.addFqs(new String[]{fq}, requestParams);
            requestParams.setLat(null);
            requestParams.setLon(null);
            requestParams.setRadius(null);
        }
        if ((qid = this.qidCacheDAO.generateQid(requestParams, bbox, title, maxage, source)) == null) {
            response.sendError(400, "WKT provided has more than " + this.maxWktPoints + " points and failed to be simplified.");
        } else {
            response.setContentType("text/plain");
            this.writeBytes(response, qid.getBytes());
        }
    }

    @RequestMapping(value={"/webportal/params/{id}", "/mapping/params/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean storeParams(@PathVariable(value="id") Long id) throws Exception {
        return this.qidCacheDAO.get(String.valueOf(id)) != null;
    }

    @RequestMapping(value={"/webportal/params/details/{id}", "/mapping/params/details/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Qid getQid(@PathVariable(value="id") Long id) throws Exception {
        return this.qidCacheDAO.get(String.valueOf(id));
    }

    @RequestMapping(value={"/webportal/species", "/mapping/species"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TaxaCountDTO> listSpecies(SpatialSearchRequestParams requestParams) throws Exception {
        return this.searchDAO.findAllSpecies(requestParams);
    }

    @RequestMapping(value={"/webportal/species.csv", "/mapping/species.csv"}, method={RequestMethod.GET})
    public void listSpeciesCsv(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        List list = this.searchDAO.findAllSpecies(requestParams);
        StringBuilder sb = new StringBuilder();
        sb.append("Family,Scientific name,Common name,Taxon rank,LSID,# Occurrences");
        for (TaxaCountDTO d : list) {
            String family = d.getFamily();
            String name = d.getName();
            String commonName = d.getCommonName();
            String guid = d.getGuid();
            String rank = d.getRank();
            if (family == null) {
                family = "";
            }
            if (name == null) {
                name = "";
            }
            if (commonName == null) {
                commonName = "";
            }
            if (d.getGuid() == null && d.getName() != null) {
                String[] nameLsid = d.getName().split("\\|");
                if (nameLsid.length >= 2) {
                    name = nameLsid[0];
                    guid = nameLsid[1];
                    rank = "scientific name";
                    if (nameLsid.length >= 3) {
                        commonName = nameLsid[2];
                    }
                } else {
                    name = "Unknown";
                }
            }
            if (d.getCount() == null || guid == null) continue;
            sb.append("\n\"").append(family.replace("\"", "\"\"").trim()).append("\",\"").append(name.replace("\"", "\"\"").trim()).append("\",\"").append(commonName.replace("\"", "\"\"").trim()).append("\",").append(rank).append(",").append(guid).append(",").append(d.getCount());
        }
        this.writeBytes(response, sb.toString().getBytes("UTF-8"));
    }

    @RequestMapping(value={"/webportal/legend", "/mapping/legend"}, method={RequestMethod.GET})
    @ResponseBody
    public List<LegendItem> legend(SpatialSearchRequestParams requestParams, @RequestParam(value="cm", required=false, defaultValue="") String colourMode, @RequestParam(value="type", required=false, defaultValue="application/csv") String returnType, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] acceptableTypes = new String[]{"application/json", "application/csv"};
        String accepts = request.getHeader("Accept");
        String string = returnType = StringUtils.isNotEmpty((String)accepts) && !accepts.contains(",") ? accepts : returnType;
        if (!Arrays.asList(acceptableTypes).contains(returnType)) {
            response.sendError(406, "Unable to produce a legend in the supplied \"Accept\" format: " + returnType);
            return null;
        }
        boolean isCsv = returnType.equals("application/csv");
        String[] s = colourMode.split(",");
        String[] cutpoints = null;
        if (s.length > 1) {
            cutpoints = new String[s.length - 1];
            System.arraycopy(s, 1, cutpoints, 0, cutpoints.length);
        }
        requestParams.setFormattedQuery(null);
        List legend = this.searchDAO.getLegend(requestParams, s[0], cutpoints);
        if (cutpoints == null) {
            Collections.sort(legend);
        }
        StringBuilder sb = new StringBuilder();
        if (isCsv) {
            sb.append("name,red,green,blue,count");
        }
        int i = 0;
        int offset = 0;
        for (i = 0; i < legend.size(); ++i) {
            LegendItem li = (LegendItem)legend.get(i);
            String name = li.getName();
            if (StringUtils.isEmpty((String)name)) {
                name = "Unknown";
            }
            int colour = this.DEFAULT_COLOUR;
            if (cutpoints == null) {
                colour = ColorUtil.colourList[Math.min(i, ColorUtil.colourList.length - 1)];
            } else if (cutpoints != null && i - offset < cutpoints.length) {
                if (name.equals("Unknown") || name.startsWith("-")) {
                    ++offset;
                    colour = this.DEFAULT_COLOUR;
                } else {
                    colour = ColorUtil.getRangedColour((int)(i - offset), (int)(cutpoints.length / 2));
                }
            }
            li.setRGB(colour);
            if (!isCsv) continue;
            sb.append("\n\"").append(name.replace("\"", "\"\"")).append("\",").append(ColorUtil.getRGB((int)colour)).append(",").append(((LegendItem)legend.get(i)).getCount());
        }
        if (returnType.equals("application/json")) {
            return legend;
        }
        this.writeBytes(response, sb.toString().getBytes("UTF-8"));
        return null;
    }

    @RequestMapping(value={"/webportal/dataProviders", "/mapping/dataProviders"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DataProviderCountDTO> queryInfo(SpatialSearchRequestParams requestParams) throws Exception {
        return this.searchDAO.getDataProviderList(requestParams);
    }

    @RequestMapping(value={"/webportal/bbox", "/mapping/bbox"}, method={RequestMethod.GET})
    public void boundingBox(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        double[] bbox = null;
        if (bbox == null) {
            bbox = this.searchDAO.getBBox(requestParams);
        }
        this.writeBytes(response, (bbox[0] + "," + bbox[1] + "," + bbox[2] + "," + bbox[3]).getBytes("UTF-8"));
    }

    @RequestMapping(value={"/webportal/bounds", "/mapping/bounds"}, method={RequestMethod.GET})
    @ResponseBody
    public double[] jsonBoundingBox(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        double[] bbox = null;
        String q = requestParams.getQ();
        if (q.startsWith("qid:") && StringUtils.isEmpty((String)requestParams.getWkt()) && (requestParams.getFq().length == 0 || requestParams.getFq().length == 1 && StringUtils.isEmpty((String)requestParams.getFq()[0]))) {
            try {
                bbox = this.qidCacheDAO.get(q.substring(4)).getBbox();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bbox == null) {
            bbox = this.searchDAO.getBBox(requestParams);
        }
        return bbox;
    }

    @RequestMapping(value={"/webportal/occurrences*", "/mapping/occurrences*"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO occurrences(SpatialSearchRequestParams requestParams, Model model) throws Exception {
        SearchResultDTO searchResult = new SearchResultDTO();
        if (StringUtils.isEmpty((String)requestParams.getQ())) {
            return searchResult;
        }
        searchResult = this.searchDAO.findByFulltextSpatialQuery(requestParams, null);
        model.addAttribute("searchResult", (Object)searchResult);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning results set with: " + searchResult.getTotalRecords()));
        }
        return searchResult;
    }

    @RequestMapping(value={"/webportal/occurrences.gz", "/mapping/occurrences.gz"}, method={RequestMethod.GET})
    public void occurrenceGz(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        response.setContentType("text/plain");
        response.setCharacterEncoding("gzip");
        try {
            ServletOutputStream outStream = response.getOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)outStream);
            this.writeOccurrencesCsvToStream(requestParams, (OutputStream)gzip);
            gzip.flush();
            gzip.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void writeOccurrencesCsvToStream(SpatialSearchRequestParams requestParams, OutputStream stream) throws Exception {
        SolrDocumentList sdl = this.searchDAO.findByFulltext(requestParams);
        byte[] bComma = ",".getBytes("UTF-8");
        byte[] bNewLine = "\n".getBytes("UTF-8");
        byte[] bDblQuote = "\"".getBytes("UTF-8");
        if (sdl != null && sdl.size() > 0) {
            int i;
            int i2;
            ArrayList<String> header = new ArrayList<String>();
            if (requestParams.getFl() == null || requestParams.getFl().isEmpty()) {
                TreeSet unique = new TreeSet();
                for (i2 = 0; i2 < sdl.size(); ++i2) {
                    unique.addAll(((SolrDocument)sdl.get(i2)).getFieldNames());
                }
                header = new ArrayList(unique);
            } else {
                String[] fields = requestParams.getFl().split(",");
                for (i2 = 0; i2 < fields.length; ++i2) {
                    if (fields[i2].length() <= 0) continue;
                    header.add(fields[i2]);
                }
            }
            for (i = 0; i < header.size(); ++i) {
                if (i > 0) {
                    stream.write(bComma);
                }
                stream.write(((String)header.get(i)).getBytes("UTF-8"));
            }
            for (i = 0; i < sdl.size(); ++i) {
                stream.write(bNewLine);
                for (int j = 0; j < header.size(); ++j) {
                    if (j > 0) {
                        stream.write(bComma);
                    }
                    if (!((SolrDocument)sdl.get(i)).containsKey(header.get(j))) continue;
                    stream.write(bDblQuote);
                    stream.write(String.valueOf(((SolrDocument)sdl.get(i)).getFieldValue((String)header.get(j))).replace("\"", "\"\"").getBytes("UTF-8"));
                    stream.write(bDblQuote);
                }
            }
        }
    }

    private void writeBytes(HttpServletResponse response, byte[] bytes) throws IOException {
        try {
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(bytes);
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    int convertLatToPixel(double lat) {
        return (int)Math.round((double)this.map_offset - this.map_radius * Math.log((1.0 + Math.sin(lat * Math.PI / 180.0)) / (1.0 - Math.sin(lat * Math.PI / 180.0))) / 2.0);
    }

    int convertLatToPixel4326(double lat, double top, double bottom, int pixelHeight) {
        return (int)((lat - top) / (bottom - top) * (double)pixelHeight);
    }

    int convertLngToPixel4326(double lng, double left, double right, int pixelWidth) {
        return (int)((lng - left) / (right - left) * (double)pixelWidth);
    }

    int convertLngToPixel(double lng) {
        return (int)Math.round((double)this.map_offset + this.map_radius * lng * Math.PI / 180.0);
    }

    double convertMetersToLng(double meters) {
        return meters / 2.0037508342789244E7 * 180.0;
    }

    double convertLngToMeters(double lng) {
        return 111319.49079327358 * lng;
    }

    double convertLatToMeters(double lat) {
        return 6378137.0 * Math.log(Math.tan(Math.PI / 180 * (45.0 + lat / 2.0)));
    }

    double convertMetersToLat(double meters) {
        return 57.29577951308232 * (2.0 * Math.atan(Math.exp(meters / 2.0037508342789244E7 * Math.PI)) - 1.5707963267948966);
    }

    protected PointType getPointTypeForDegreesPerPixel(double resolution) {
        PointType pointType = null;
        pointType = resolution >= 1.0 ? PointType.POINT_1 : (resolution >= 0.1 ? PointType.POINT_01 : (resolution >= 0.01 ? PointType.POINT_001 : (resolution >= 0.001 ? PointType.POINT_0001 : (resolution >= 1.0E-4 ? PointType.POINT_00001 : PointType.POINT_RAW))));
        return pointType;
    }

    void displayBlankImage(HttpServletResponse response) {
        try {
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(blankImageBytes);
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image", (Throwable)e);
        }
    }

    private double getBBoxes(String bboxString, int width, int height, int size, boolean uncertainty, double[] mbbox, double[] bbox, double[] pbbox, double[] tilebbox) {
        String[] splitBBox = bboxString.split(",");
        for (int i = 0; i < 4; ++i) {
            boolean errorInThisPosition = false;
            try {
                if (splitBBox.length > i) {
                    tilebbox[i] = Double.parseDouble(splitBBox[i]);
                    mbbox[i] = tilebbox[i];
                } else {
                    logger.error((Object)("Problem parsing BBOX: '" + bboxString + "' at position " + i));
                    errorInThisPosition = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Problem parsing BBOX: '" + bboxString + "' at position " + i), (Throwable)e);
                errorInThisPosition = true;
            }
            if (!errorInThisPosition) continue;
            tilebbox[i] = 0.0;
            mbbox[i] = 0.0;
        }
        double pixelWidth = (mbbox[2] - mbbox[0]) / (double)width;
        double pixelHeight = (mbbox[3] - mbbox[1]) / (double)height;
        mbbox[0] = mbbox[0] + pixelWidth / 2.0;
        mbbox[2] = mbbox[2] - pixelWidth / 2.0;
        mbbox[1] = mbbox[1] + pixelHeight / 2.0;
        mbbox[3] = mbbox[3] - pixelHeight / 2.0;
        double xoffset = (mbbox[2] - mbbox[0]) / (double)width * (double)size;
        double yoffset = (mbbox[3] - mbbox[1]) / (double)height * (double)size;
        xoffset += pixelWidth;
        yoffset += pixelHeight;
        pbbox[0] = this.convertLngToPixel(this.convertMetersToLng(mbbox[0]));
        pbbox[1] = this.convertLatToPixel(this.convertMetersToLat(mbbox[1]));
        pbbox[2] = this.convertLngToPixel(this.convertMetersToLng(mbbox[2]));
        pbbox[3] = this.convertLatToPixel(this.convertMetersToLat(mbbox[3]));
        bbox[0] = this.convertMetersToLng(mbbox[0] - xoffset);
        bbox[1] = this.convertMetersToLat(mbbox[1] - yoffset);
        bbox[2] = this.convertMetersToLng(mbbox[2] + xoffset);
        bbox[3] = this.convertMetersToLat(mbbox[3] + yoffset);
        double degreesPerPixel = Math.min((this.convertMetersToLng(mbbox[2]) - this.convertMetersToLng(mbbox[0])) / (double)width, (this.convertMetersToLng(mbbox[3]) - this.convertMetersToLng(mbbox[1])) / (double)height);
        return degreesPerPixel;
    }

    private double getBBoxes4326(String bboxString, int width, int height, int size, boolean uncertainty, double[] mbbox, double[] bbox, double[] pbbox, double[] tilebbox) {
        int i = 0;
        for (String s : bboxString.split(",")) {
            try {
                tilebbox[i] = Double.parseDouble(s);
                mbbox[i] = tilebbox[i];
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)("Problem parsing BBOX: '" + bboxString + "'"), (Throwable)e);
            }
        }
        double pixelWidth = (mbbox[2] - mbbox[0]) / (double)width;
        double pixelHeight = (mbbox[3] - mbbox[1]) / (double)height;
        mbbox[0] = mbbox[0] + pixelWidth / 2.0;
        mbbox[2] = mbbox[2] - pixelWidth / 2.0;
        mbbox[1] = mbbox[1] + pixelHeight / 2.0;
        mbbox[3] = mbbox[3] - pixelHeight / 2.0;
        double xoffset = (mbbox[2] - mbbox[0]) / (double)width * (double)size;
        double yoffset = (mbbox[3] - mbbox[1]) / (double)height * (double)size;
        bbox[0] = mbbox[0] - (xoffset += pixelWidth);
        bbox[1] = mbbox[1] - (yoffset += pixelHeight);
        bbox[2] = mbbox[2] + xoffset;
        bbox[3] = mbbox[3] + yoffset;
        double degreesPerPixel = Math.min(pixelWidth, pixelHeight);
        return degreesPerPixel;
    }

    private String getQ(String cql_filter) {
        String q = cql_filter;
        int p1 = cql_filter.indexOf("qid:");
        if (p1 >= 0) {
            int p2 = cql_filter.indexOf(38, p1 + 1);
            if (p2 < 0) {
                p2 = cql_filter.indexOf(59, p1 + 1);
            }
            if (p2 < 0) {
                p2 = cql_filter.length();
            }
            q = cql_filter.substring(p1, p2);
        }
        return q;
    }

    private String convertBBox4326To900913(String bbox) {
        int i = 0;
        Object[] mbbox = new Double[4];
        for (String s : bbox.split(",")) {
            mbbox[i] = i % 2 == 0 ? Double.valueOf(this.convertLngToMeters(Double.parseDouble(s))) : Double.valueOf(this.convertLatToMeters(Double.parseDouble(s)));
            ++i;
        }
        return StringUtils.join((Object[])mbbox, (String)",");
    }

    @RequestMapping(value={"/ogc/getMetadata"}, method={RequestMethod.GET})
    public String getMetadata(@RequestParam(value="LAYER", required=false, defaultValue="") String layer, @RequestParam(value="q", required=false, defaultValue="") String query, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        String[] parts;
        String taxonName = "";
        String rank = "";
        String q = "";
        if (StringUtils.trimToNull((String)layer) != null) {
            parts = layer.split(":");
            taxonName = parts[parts.length - 1];
            if (parts.length > 1) {
                rank = parts[0];
            }
            q = layer;
        } else if (StringUtils.trimToNull((String)query) != null) {
            parts = query.split(":");
            taxonName = parts[parts.length - 1];
            if (parts.length > 1) {
                rank = parts[0];
            }
            q = query;
        } else {
            response.sendError(400);
        }
        ObjectMapper om = new ObjectMapper();
        String guid = null;
        JsonNode guidLookupNode = om.readTree(new URL(this.bieWebService + "/guid/" + URLEncoder.encode(taxonName, "UTF-8")));
        if (guidLookupNode.isArray() && guidLookupNode.size() > 0) {
            JsonNode idNode = guidLookupNode.get(0).get("acceptedIdentifier");
            guid = idNode != null ? idNode.asText() : null;
        }
        String newQuery = "raw_name:" + taxonName;
        if (guid != null) {
            JsonNode authorshipNode;
            JsonNode nameNode;
            String imageUrl;
            model.addAttribute("guid", (Object)guid);
            model.addAttribute("speciesPageUrl", (Object)(this.bieUiUrl + "/species/" + guid));
            JsonNode node = om.readTree(new URL(this.bieWebService + "/species/info/" + guid + ".json"));
            JsonNode tc = node.get("taxonConcept");
            JsonNode imageNode = tc.get("smallImageUrl");
            String string = imageUrl = imageNode != null ? imageNode.asText() : null;
            if (imageUrl != null) {
                model.addAttribute("imageUrl", (Object)imageUrl);
                JsonNode imageMetadataNode = node.get("taxonConcept").get("imageMetadataUrl");
                String imageMetadataUrl = imageMetadataNode != null ? imageMetadataNode.asText() : null;
                JsonNode imageMetadata = om.readTree(new URL(imageMetadataUrl));
                if (imageMetadata != null) {
                    if (imageMetadata.get("http://purl.org/dc/elements/1.1/creator") != null) {
                        model.addAttribute("imageCreator", (Object)imageMetadata.get("http://purl.org/dc/elements/1.1/creator").asText());
                    }
                    if (imageMetadata.get("http://purl.org/dc/elements/1.1/license") != null) {
                        model.addAttribute("imageLicence", (Object)imageMetadata.get("http://purl.org/dc/elements/1.1/license").asText());
                    }
                    if (imageMetadata.get("http://purl.org/dc/elements/1.1/source") != null) {
                        model.addAttribute("imageSource", (Object)imageMetadata.get("http://purl.org/dc/elements/1.1/source").asText());
                    }
                }
            }
            JsonNode leftNode = tc.get("left");
            JsonNode rightNode = tc.get("right");
            newQuery = leftNode != null && rightNode != null ? "lft:[" + leftNode.asText() + " TO " + rightNode.asText() + "]" : "taxon_concept_lsid:" + guid;
            logger.debug((Object)("The new query : " + newQuery));
            JsonNode commonNameNode = tc.get("commonNameSingle");
            if (commonNameNode != null) {
                model.addAttribute("commonName", (Object)commonNameNode.asText());
                logger.debug((Object)("retrieved name: " + commonNameNode.asText()));
            }
            if ((nameNode = tc.get("nameComplete")) != null) {
                model.addAttribute("name", (Object)nameNode.asText());
                logger.debug((Object)("retrieved name: " + nameNode.asText()));
            }
            if ((authorshipNode = node.get("taxonConcept").get("author")) != null) {
                model.addAttribute("authorship", (Object)authorshipNode.asText());
            }
            JsonNode node2 = om.readTree(new URL(this.bieWebService + "/species/" + guid + ".json"));
            JsonNode classificationNode = node2.get("classification");
            model.addAttribute("kingdom", (Object)StringUtils.capitalize((String)classificationNode.get("kingdom").asText().toLowerCase()));
            model.addAttribute("phylum", (Object)StringUtils.capitalize((String)classificationNode.get("phylum").asText().toLowerCase()));
            model.addAttribute("clazz", (Object)StringUtils.capitalize((String)classificationNode.get("clazz").asText().toLowerCase()));
            model.addAttribute("order", (Object)StringUtils.capitalize((String)classificationNode.get("order").asText().toLowerCase()));
            model.addAttribute("family", (Object)StringUtils.capitalize((String)classificationNode.get("family").asText().toLowerCase()));
            model.addAttribute("genus", (Object)classificationNode.get("genus").asText());
            JsonNode taxonNameNode = node2.get("taxonName");
            if (taxonNameNode != null && taxonNameNode.get("specificEpithet") != null) {
                model.addAttribute("specificEpithet", (Object)taxonNameNode.get("specificEpithet").asText());
            }
        }
        SpatialSearchRequestParams searchParams = new SpatialSearchRequestParams();
        searchParams.setQ(newQuery);
        searchParams.setFacets(new String[]{"data_resource"});
        searchParams.setPageSize(Integer.valueOf(0));
        List facets = this.searchDAO.getFacetCounts(searchParams);
        model.addAttribute("query", (Object)newQuery);
        model.addAttribute("dataProviders", (Object)((FacetResultDTO)facets.get(0)).getFieldResult());
        return "metadata/mcp";
    }

    @RequestMapping(value={"/ogc/getFeatureInfo"}, method={RequestMethod.GET})
    public String getFeatureInfo(@RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="BBOX", required=true, defaultValue="0,-90,180,0") String bboxString, @RequestParam(value="WIDTH", required=true, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=true, defaultValue="256") Integer height, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="SRS", required=false, defaultValue="") String srs, @RequestParam(value="QUERY_LAYERS", required=false, defaultValue="") String queryLayers, @RequestParam(value="X", required=true, defaultValue="0") Double x, @RequestParam(value="Y", required=true, defaultValue="0") Double y, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        logger.debug((Object)("WMS - GetFeatureInfo requested for: " + queryLayers));
        if ("EPSG:4326".equals(srs)) {
            bboxString = this.convertBBox4326To900913(bboxString);
        }
        WmsEnv vars = new WmsEnv(env, styles);
        double[] mbbox = new double[4];
        double[] bbox = new double[4];
        double[] pbbox = new double[4];
        double[] tilebbox = new double[4];
        int size = vars.size + (vars.highlight != null ? HIGHLIGHT_RADIUS * 2 + (int)((double)vars.size * 0.2) : 0) + 5;
        double resolution = this.getBBoxes(bboxString, width.intValue(), height.intValue(), size, vars.uncertainty, mbbox, bbox, pbbox, tilebbox);
        PointType pointType = this.getPointTypeForDegreesPerPixel(resolution);
        double longitude = bbox[0] + (bbox[2] - bbox[0]) / (double)width.intValue() * x;
        double latitude = bbox[3] - (bbox[3] - bbox[1]) / (double)height.intValue() * y;
        double roundedLongitude = pointType.roundToPointType(longitude);
        double roundedLatitude = pointType.roundToPointType(latitude);
        double minLng = pointType.roundDownToPointType(roundedLongitude - (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        double maxLng = pointType.roundUpToPointType(roundedLongitude + (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        double minLat = pointType.roundDownToPointType(roundedLatitude - (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        double maxLat = pointType.roundUpToPointType(roundedLatitude + (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        SpatialSearchRequestParams requestParams = new SpatialSearchRequestParams();
        String q = WMSUtils.convertLayersParamToQ((String)queryLayers);
        requestParams.setQ(WMSUtils.convertLayersParamToQ((String)queryLayers));
        logger.debug((Object)("WMS GetFeatureInfo for " + queryLayers + ", longitude:[" + minLng + " TO " + maxLng + "],  latitude:[" + minLat + " TO " + maxLat + "]"));
        String[] fqs = new String[]{"longitude:[" + minLng + " TO " + maxLng + "]", "latitude:[" + minLat + " TO " + maxLat + "]"};
        requestParams.setFq(fqs);
        requestParams.setFacet(Boolean.valueOf(false));
        SolrDocumentList sdl = this.searchDAO.findByFulltext(requestParams);
        String body = "";
        if (sdl != null && sdl.size() > 0) {
            SolrDocument doc = (SolrDocument)sdl.get(0);
            model.addAttribute("record", (Object)doc.getFieldValueMap());
            model.addAttribute("totalRecords", (Object)sdl.getNumFound());
        }
        model.addAttribute("uriUrl", (Object)(this.baseUiUrl + "/occurrences/search?q=" + URLEncoder.encode(q, "UTF-8") + "&fq=" + URLEncoder.encode(fqs[0], "UTF-8") + "&fq=" + URLEncoder.encode(fqs[1], "UTF-8")));
        model.addAttribute("pointType", (Object)pointType.name());
        model.addAttribute("minLng", (Object)minLng);
        model.addAttribute("maxLng", (Object)maxLng);
        model.addAttribute("minLat", (Object)minLat);
        model.addAttribute("maxLat", (Object)maxLat);
        model.addAttribute("latitudeClicked", (Object)latitude);
        model.addAttribute("longitudeClicked", (Object)longitude);
        return "metadata/getFeatureInfo";
    }

    @RequestMapping(value={"/ogc/legendGraphic"}, method={RequestMethod.GET})
    public void getLegendGraphic(@RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="STYLE", required=false, defaultValue="8b0000;opacity=1;size=5") String style, @RequestParam(value="WIDTH", required=false, defaultValue="30") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="20") Integer height, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (StringUtils.trimToNull((String)env) == null && StringUtils.trimToNull((String)style) == null) {
                style = "8b0000;opacity=1;size=5";
            }
            WmsEnv wmsEnv = new WmsEnv(env, style);
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics2D g = (Graphics2D)img.getGraphics();
            int size = width > height ? height : width;
            Color fill = new Color(wmsEnv.colour | wmsEnv.alpha << 24);
            g.setPaint(fill);
            g.fillOval(0, 0, size, size);
            ServletOutputStream out = response.getOutputStream();
            logger.debug((Object)("WMS - GetLegendGraphic requested : " + request.getQueryString()));
            response.setContentType("image/png");
            ImageIO.write((RenderedImage)img, "png", (OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/ogc/ows", "/ogc/capabilities"}, method={RequestMethod.GET})
    public void getCapabilities(SpatialSearchRequestParams requestParams, @RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:900913") String srs, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="STYLE", required=false, defaultValue="") String style, @RequestParam(value="BBOX", required=false, defaultValue="") String bboxString, @RequestParam(value="WIDTH", required=false, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="256") Integer height, @RequestParam(value="CACHE", required=false, defaultValue="default") String cache, @RequestParam(value="REQUEST", required=false, defaultValue="") String requestString, @RequestParam(value="OUTLINE", required=false, defaultValue="false") boolean outlinePoints, @RequestParam(value="OUTLINECOLOUR", required=false, defaultValue="0x000000") String outlineColour, @RequestParam(value="LAYERS", required=false, defaultValue="") String layers, @RequestParam(value="q", required=false, defaultValue="*:*") String query, @RequestParam(value="fq", required=false) String[] filterQueries, @RequestParam(value="X", required=true, defaultValue="0") Double x, @RequestParam(value="Y", required=true, defaultValue="0") Double y, @RequestParam(value="spatiallyValidOnly", required=false, defaultValue="true") boolean spatiallyValidOnly, @RequestParam(value="marineSpecies", required=false, defaultValue="false") boolean marineOnly, @RequestParam(value="terrestrialSpecies", required=false, defaultValue="false") boolean terrestrialOnly, @RequestParam(value="limitToFocus", required=false, defaultValue="false") boolean limitToFocus, @RequestParam(value="useSpeciesGroups", required=false, defaultValue="false") boolean useSpeciesGroups, @RequestParam(value="GRIDDETAIL", required=false, defaultValue="16") int gridDivisionCount, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        if ("GetMap".equalsIgnoreCase(requestString)) {
            this.generateWmsTile(requestParams, cql_filter, env, srs, styles, bboxString, width, height, cache, requestString, outlinePoints, outlineColour, layers, null, Integer.valueOf(gridDivisionCount), request, response);
            return;
        }
        if ("GetLegendGraphic".equalsIgnoreCase(requestString)) {
            this.getLegendGraphic(env, style, Integer.valueOf(30), Integer.valueOf(20), request, response);
            return;
        }
        if ("GetFeatureInfo".equalsIgnoreCase(requestString)) {
            this.getFeatureInfo(cql_filter, env, bboxString, width, height, styles, srs, layers, x, y, request, response, model);
            return;
        }
        response.setContentType("text/xml");
        response.setHeader("Content-Description", "File Transfer");
        response.setHeader("Content-Disposition", "attachment; filename=GetCapabilities.xml");
        response.setHeader("Content-Transfer-Encoding", "binary");
        try {
            String biocacheServerUrl = request.getSession().getServletContext().getInitParameter("webservicesRoot");
            PrintWriter writer = response.getWriter();
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE WMT_MS_Capabilities SYSTEM \"http://spatial.ala.org.au/geoserver/schemas/wms/1.1.1/WMS_MS_Capabilities.dtd\">\n<WMT_MS_Capabilities version=\"1.1.1\" updateSequence=\"28862\">\n  <Service>\n    <Name>OGC:WMS</Name>\n    <Title>" + this.organizationName + "(WMS) - Species occurrences</Title>\n    <Abstract>WMS services for species occurrences.</Abstract>\n    <KeywordList>\n      <Keyword>WMS</Keyword>\n      <Keyword>Species occurrence data</Keyword>\n      <Keyword>ALA</Keyword>\n      <Keyword>CRIS</Keyword>\n    </KeywordList>\n    <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + biocacheServerUrl + "/ogc/wms\"/>\n    <ContactInformation>\n      <ContactPersonPrimary>\n        <ContactPerson>ALA Support</ContactPerson>\n        <ContactOrganization>" + this.organizationName + "</ContactOrganization>\n      </ContactPersonPrimary>\n      <ContactPosition>Support Manager</ContactPosition>\n      <ContactAddress>\n        <AddressType></AddressType>\n        <Address/>\n        <City>" + this.orgCity + "</City>\n        <StateOrProvince>" + this.orgStateProvince + "</StateOrProvince>\n        <PostCode>" + this.orgPostcode + "</PostCode>\n        <Country>" + this.orgCountry + "</Country>\n      </ContactAddress>\n      <ContactVoiceTelephone>" + this.orgPhone + "</ContactVoiceTelephone>\n      <ContactFacsimileTelephone>" + this.orgFax + "</ContactFacsimileTelephone>\n      <ContactElectronicMailAddress>" + this.orgEmail + "</ContactElectronicMailAddress>\n    </ContactInformation>\n    <Fees>NONE</Fees>\n    <AccessConstraints>NONE</AccessConstraints>\n  </Service>\n  <Capability>\n    <Request>\n      <GetCapabilities>\n        <Format>application/vnd.ogc.wms_xml</Format>\n        <DCPType>\n          <HTTP>\n            <Get>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/capabilities?SERVICE=WMS&amp;\"/>\n            </Get>\n            <Post>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/capabilities?SERVICE=WMS&amp;\"/>\n            </Post>\n          </HTTP>\n        </DCPType>\n      </GetCapabilities>\n      <GetMap>\n        <Format>image/png</Format>\n        <DCPType>\n          <HTTP>\n            <Get>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/wms/reflect?SERVICE=WMS&amp;OUTLINE=TRUE&amp;\"/>\n            </Get>\n          </HTTP>\n        </DCPType>\n      </GetMap>\n      <GetFeatureInfo>\n        <Format>text/html</Format>\n        <DCPType>\n          <HTTP>\n            <Get>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/getFeatureInfo\"/>\n            </Get>\n            <Post>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/getFeatureInfo\"/>\n            </Post>\n          </HTTP>\n        </DCPType>\n      </GetFeatureInfo>\n      <GetLegendGraphic>\n        <Format>image/png</Format>\n        <Format>image/jpeg</Format>\n        <Format>image/gif</Format>\n        <DCPType>\n          <HTTP>\n            <Get>\n              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/legendGraphic\"/>\n            </Get>\n          </HTTP>\n        </DCPType>\n      </GetLegendGraphic>\n    </Request>\n    <Exception>\n      <Format>application/vnd.ogc.se_xml</Format>\n      <Format>application/vnd.ogc.se_inimage</Format>\n    </Exception>\n    <Layer>\n      <Title>" + this.organizationName + " - Species occurrence layers</Title>\n      <Abstract>Custom WMS services for " + this.organizationName + " species occurrences</Abstract>\n      <SRS>EPSG:3857</SRS>\n      <SRS>EPSG:900913</SRS>\n      <SRS>EPSG:4326</SRS>\n     <LatLonBoundingBox minx=\"-179.9\" miny=\"-89.9\" maxx=\"179.9\" maxy=\"89.9\"/>\n");
            writer.write(this.generateStylesForPoints());
            if (spatiallyValidOnly) {
                filterQueries = (String[])ArrayUtils.add((Object[])filterQueries, (Object)"geospatial_kosher:true");
            }
            if (marineOnly) {
                filterQueries = (String[])ArrayUtils.add((Object[])filterQueries, (Object)"species_habitats:Marine OR species_habitats:\"Marine and Non-marine\"");
            }
            if (terrestrialOnly) {
                filterQueries = (String[])ArrayUtils.add((Object[])filterQueries, (Object)"species_habitats:\"Non-marine\" OR species_habitats:Limnetic");
            }
            if (limitToFocus) {
                filterQueries = (String[])ArrayUtils.add((Object[])filterQueries, (Object)this.limitToFocusValue);
            }
            query = this.searchUtils.convertRankAndName(query);
            logger.debug((Object)("GetCapabilities query in use: " + query));
            if (useSpeciesGroups) {
                this.taxonDAO.extractBySpeciesGroups(this.baseWsUrl + "/ogc/getMetadata", query, filterQueries, (Writer)writer);
            } else {
                this.taxonDAO.extractHierarchy(this.baseWsUrl + "/ogc/getMetadata", query, filterQueries, (Writer)writer);
            }
            writer.write("</Layer></Capability></WMT_MS_Capabilities>\n");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String generateStylesForPoints() {
        String[] sizes = new String[]{"5", "10", "2"};
        String[] sizesNames = new String[]{"medium", "large", "small"};
        String[] opacities = new String[]{"0.5", "1", "0.2"};
        String[] opacitiesNames = new String[]{"medium", "opaque", "transparency"};
        StringBuffer sb = new StringBuffer();
        int colorIdx = 0;
        int sizeIdx = 0;
        int opIdx = 0;
        for (String color : ColorUtil.colorsNames) {
            for (String size : sizes) {
                for (String opacity : opacities) {
                    sb.append("<Style>\n<Name>" + ColorUtil.colorsCodes[colorIdx] + ";opacity=" + opacity + ";size=" + size + "</Name> \n<Title>" + color + ";opacity=" + opacitiesNames[opIdx] + ";size=" + sizesNames[sizeIdx] + "</Title> \n</Style>\n");
                    ++opIdx;
                }
                opIdx = 0;
                ++sizeIdx;
            }
            sizeIdx = 0;
            ++colorIdx;
        }
        return sb.toString();
    }

    @RequestMapping(value={"/webportal/wms/reflect", "/ogc/wms/reflect", "/mapping/wms/reflect"}, method={RequestMethod.GET})
    public void generateWmsTile(SpatialSearchRequestParams requestParams, @RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:900913") String srs, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="BBOX", required=true, defaultValue="") String bboxString, @RequestParam(value="WIDTH", required=true, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=true, defaultValue="256") Integer height, @RequestParam(value="CACHE", required=true, defaultValue="default") String cache, @RequestParam(value="REQUEST", required=true, defaultValue="") String requestString, @RequestParam(value="OUTLINE", required=true, defaultValue="true") boolean outlinePoints, @RequestParam(value="OUTLINECOLOUR", required=true, defaultValue="0x000000") String outlineColour, @RequestParam(value="LAYERS", required=false, defaultValue="") String layers, @RequestParam(value="HQ", required=false) String[] hqs, @RequestParam(value="GRIDDETAIL", required=false, defaultValue="16") Integer gridDivisionCount, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ImgObj imgObj;
        double[] queryBBox;
        double resolution;
        if (env != null && env.contains("osgrid")) {
            this.wmsosGridController.generateWmsTile(requestParams, cql_filter, env, srs, styles, bboxString, layers, width, height, outlinePoints, outlineColour, request, response);
            return;
        }
        if ("default".equals(cache)) {
            String string = cache = this.wmsCacheEnabled ? "on" : "off";
        }
        if ("GetLegendGraphic".equalsIgnoreCase(requestString)) {
            this.getLegendGraphic(env, styles, Integer.valueOf(30), Integer.valueOf(20), request, response);
            return;
        }
        HashSet<Integer> hq = new HashSet<Integer>();
        if (hqs != null && hqs.length > 0) {
            for (String h : hqs) {
                hq.add(Integer.parseInt(h));
            }
        }
        logger.debug((Object)("WMS tile: " + request.getQueryString()));
        response.setHeader("Cache-Control", "max-age=86400");
        response.setContentType("image/png");
        boolean is4326 = false;
        WmsEnv vars = new WmsEnv(env, styles);
        double[] mbbox = new double[4];
        double[] bbox = new double[4];
        double[] pbbox = new double[4];
        double[] tilebbox = new double[4];
        int steppedSize = (int)(Math.ceil((double)vars.size / 20.0) * 20.0);
        int size = steppedSize + (vars.highlight != null ? HIGHLIGHT_RADIUS * 2 + (int)((double)steppedSize * 0.2) : 0) + 5;
        if ("EPSG:4326".equals(srs)) {
            is4326 = true;
            resolution = this.getBBoxes4326(bboxString, width.intValue(), height.intValue(), size, vars.uncertainty, mbbox, bbox, pbbox, tilebbox);
        } else {
            resolution = this.getBBoxes(bboxString, width.intValue(), height.intValue(), size, vars.uncertainty, mbbox, bbox, pbbox, tilebbox);
        }
        PointType pointType = this.getPointTypeForDegreesPerPixel(resolution);
        logger.debug((Object)("Rendering: " + pointType.name()));
        String q = "";
        if (StringUtils.trimToNull((String)cql_filter) != null) {
            q = WMSUtils.getQ((String)cql_filter);
        } else if (StringUtils.trimToNull((String)layers) != null && !"ALA:Occurrences".equalsIgnoreCase(layers)) {
            q = WMSUtils.convertLayersParamToQ((String)layers);
        }
        String[] boundingBoxFqs = new String[]{String.format("longitude:[%f TO %f]", bbox[0], bbox[2]), String.format("latitude:[%f TO %f]", bbox[1], bbox[3])};
        int pointWidth = vars.size * 2;
        double width_mult = (double)width.intValue() / (pbbox[2] - pbbox[0]);
        double height_mult = (double)height.intValue() / (pbbox[1] - pbbox[3]);
        if (q.length() > 0) {
            requestParams.setQ(q);
        } else {
            q = requestParams.getQ();
        }
        if (q.startsWith("qid:") && StringUtils.isEmpty((String)requestParams.getWkt()) && (requestParams.getFq().length == 0 || requestParams.getFq().length == 1 && StringUtils.isEmpty((String)requestParams.getFq()[0])) && (queryBBox = this.qidCacheDAO.get(q.substring(4)).getBbox()) != null && (queryBBox[0] > bbox[2] || queryBBox[2] < bbox[0] || queryBBox[1] > bbox[3] || queryBBox[3] < bbox[1])) {
            this.displayBlankImage(response);
            return;
        }
        String[] originalFqs = this.qidCacheDAO.getFq(requestParams);
        boolean canCache = this.wmsCache.isEnabled() && cache.equalsIgnoreCase("on");
        WMSTile wco = this.getWMSCacheObject(requestParams, vars, pointType, bbox, originalFqs, boundingBoxFqs, canCache);
        boolean isGrid = vars.colourMode.equals("grid");
        if (isGrid) {
            if (gridDivisionCount > Math.min(width, height)) {
                gridDivisionCount = Math.min(width, height);
            }
            if (gridDivisionCount < 0) {
                gridDivisionCount = 1;
            }
            while (width % gridDivisionCount > 0 || height % gridDivisionCount > 0) {
                Integer n = gridDivisionCount;
                Integer n2 = gridDivisionCount = Integer.valueOf(gridDivisionCount - 1);
            }
        }
        ImgObj imgObj2 = imgObj = wco.getPoints() == null ? null : this.wmsCached(wco, requestParams, vars, pointType, pbbox, bbox, mbbox, width.intValue(), height.intValue(), width_mult, height_mult, pointWidth, originalFqs, hq, boundingBoxFqs, outlinePoints, outlineColour, response, is4326, tilebbox, gridDivisionCount.intValue());
        if (imgObj != null && imgObj.g != null) {
            imgObj.g.dispose();
            try {
                ServletOutputStream outStream = response.getOutputStream();
                ImageIO.write((RenderedImage)imgObj.img, "png", (OutputStream)outStream);
                outStream.flush();
                outStream.close();
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to write image", (Throwable)e);
            }
        } else {
            this.displayBlankImage(response);
        }
    }

    @RequestMapping(value={"/webportal/wms/image", "/mapping/wms/image"}, method={RequestMethod.GET})
    public void generatePublicationMap(SpatialSearchRequestParams requestParams, @RequestParam(value="format", required=false, defaultValue="jpg") String format, @RequestParam(value="extents", required=true) String extents, @RequestParam(value="widthmm", required=false, defaultValue="60") Double widthMm, @RequestParam(value="pradiusmm", required=false, defaultValue="2") Double pointRadiusMm, @RequestParam(value="pradiuspx", required=false) Integer pradiusPx, @RequestParam(value="pcolour", required=false, defaultValue="FF0000") String pointColour, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:900913") String srs, @RequestParam(value="popacity", required=false, defaultValue="0.8") Double pointOpacity, @RequestParam(value="baselayer", required=false, defaultValue="world") String baselayer, @RequestParam(value="scale", required=false, defaultValue="off") String scale, @RequestParam(value="dpi", required=false, defaultValue="300") Integer dpi, @RequestParam(value="baselayerStyle", required=false, defaultValue="") String baselayerStyle, @RequestParam(value="outline", required=true, defaultValue="false") boolean outlinePoints, @RequestParam(value="outlineColour", required=true, defaultValue="#000000") String outlineColour, @RequestParam(value="fileName", required=false) String fileName, @RequestParam(value="baseMap", required=false, defaultValue="ALA") String baseMap, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] bb = extents.split(",");
        double long1 = Double.parseDouble(bb[0]);
        double lat1 = Double.parseDouble(bb[1]);
        double long2 = Double.parseDouble(bb[2]);
        double lat2 = Double.parseDouble(bb[3]);
        if (lat1 <= -90.0) {
            lat1 = -89.999;
        }
        if (lat2 >= 90.0) {
            lat2 = 89.999;
        }
        int pminx = this.convertLngToPixel(long1);
        int pminy = this.convertLatToPixel(lat1);
        int pmaxx = this.convertLngToPixel(long2);
        int pmaxy = this.convertLatToPixel(lat2);
        int width = (int)((double)dpi.intValue() / 25.4 * widthMm);
        int height = (int)Math.round((double)width * ((double)(pminy - pmaxy) / (double)(pmaxx - pminx)));
        if (height * width > this.MAX_IMAGE_PIXEL_COUNT) {
            String errorMessage = "Image size in pixels " + width + "x" + height + " exceeds " + this.MAX_IMAGE_PIXEL_COUNT + " pixels.  Make the image smaller";
            response.sendError(406, errorMessage);
            throw new Exception(errorMessage);
        }
        int pointSize = -1;
        pointSize = pradiusPx != null ? pradiusPx : (int)((double)dpi.intValue() / 25.4 * pointRadiusMm);
        double[] boundingBox = this.transformBbox4326To900913(Double.parseDouble(bb[0]), Double.parseDouble(bb[1]), Double.parseDouble(bb[2]), Double.parseDouble(bb[3]));
        String rendering = "ENV=color%3A" + pointColour + "%3Bname%3Acircle%3Bsize%3A" + pointSize + "%3Bopacity%3A" + pointOpacity;
        if (StringUtils.isNotEmpty((String)env)) {
            rendering = "ENV=" + env;
        }
        String speciesAddress = this.baseWsUrl + "/ogc/wms/reflect?" + rendering + "&SRS=" + srs + "&BBOX=" + boundingBox[0] + "," + boundingBox[1] + "," + boundingBox[2] + "," + boundingBox[3] + "&WIDTH=" + width + "&HEIGHT=" + height + "&OUTLINE=" + outlinePoints + "&OUTLINECOLOUR=" + outlineColour;
        String q = request.getParameter("q");
        String[] fqs = request.getParameterValues("fq");
        if (!StringUtils.isEmpty((String)q)) {
            speciesAddress = speciesAddress + "&q=" + q;
        }
        if (fqs != null && fqs.length != 0) {
            for (String fq : fqs) {
                speciesAddress = speciesAddress + "&fq=" + fq;
            }
        }
        URL speciesURL = new URL(speciesAddress);
        BufferedImage speciesImage = ImageIO.read(speciesURL);
        String layout = "";
        if (!scale.equals("off")) {
            layout = layout + "layout:scale";
        }
        String basemapAddress = this.geoserverUrl + "/wms/reflect?LAYERS=ALA%3A" + baselayer + "&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=" + baselayerStyle + "&FORMAT=image%2Fpng&SRS=" + srs + "&BBOX=" + boundingBox[0] + "," + boundingBox[1] + "," + boundingBox[2] + "," + boundingBox[3] + "&WIDTH=" + width + "&HEIGHT=" + height + "&OUTLINE=" + outlinePoints + "&format_options=dpi:" + dpi + ";" + layout;
        BufferedImage basemapImage = "roadmap".equalsIgnoreCase(baseMap) || "satellite".equalsIgnoreCase(baseMap) || "hybrid".equalsIgnoreCase(baseMap) || "terrain".equalsIgnoreCase(baseMap) ? this.basemapGoogle(width, height, boundingBox, baseMap) : ImageIO.read(new URL(basemapAddress));
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D combined = (Graphics2D)img.getGraphics();
        combined.drawImage(basemapImage, 0, 0, Color.WHITE, null);
        combined.setComposite(AlphaComposite.getInstance(3, 1.0f));
        combined.drawImage(speciesImage, null, 0, 0);
        combined.dispose();
        if (fileName != null) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Description", "File Transfer");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setHeader("Content-Transfer-Encoding", "binary");
        } else if (format.equalsIgnoreCase("png")) {
            response.setContentType("image/png");
        } else {
            response.setContentType("image/jpeg");
        }
        try {
            if (format.equalsIgnoreCase("png")) {
                ServletOutputStream os = response.getOutputStream();
                ImageIO.write((RenderedImage)img, format, (OutputStream)os);
                os.close();
            } else {
                BufferedImage img2 = new BufferedImage(width, height, 1);
                Graphics2D c2 = (Graphics2D)img2.getGraphics();
                c2.drawImage(img, 0, 0, Color.WHITE, null);
                c2.dispose();
                ServletOutputStream os = response.getOutputStream();
                ImageIO.write((RenderedImage)img2, format, (OutputStream)os);
                os.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private BufferedImage basemapGoogle(int width, int height, double[] extents, String maptype) throws Exception {
        int res;
        double[] resolutions = new double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125, 9783.939619140625, 4891.9698095703125, 2445.9849047851562, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135};
        int imgSize = 640;
        int gScale = 2;
        double actualWidth = extents[2] - extents[0];
        double actualHeight = extents[3] - extents[1];
        for (res = 0; res < resolutions.length - 1 && resolutions[res + 1] * (double)imgSize > actualWidth && resolutions[res + 1] * (double)imgSize > actualHeight; ++res) {
        }
        int centerX = (int)((extents[2] - extents[0]) / 2.0 + extents[0]);
        int centerY = (int)((extents[3] - extents[1]) / 2.0 + extents[1]);
        double latitude = this.convertMetersToLat((double)centerY);
        double longitude = this.convertMetersToLng((double)centerX);
        int imgWidth = (int)((extents[2] - extents[0]) / resolutions[res]);
        int imgHeight = (int)((extents[3] - extents[1]) / resolutions[res]);
        String uri = "http://maps.googleapis.com/maps/api/staticmap?";
        String parameters = "center=" + latitude + "," + longitude + "&zoom=" + res + "&scale=" + gScale + "&size=" + imgWidth + "x" + imgHeight + "&maptype=" + maptype;
        BufferedImage img = ImageIO.read(new URL(uri + parameters));
        BufferedImage tmp = new BufferedImage(width, height, 2);
        tmp.getGraphics().drawImage(img, 0, 0, width, height, 0, 0, imgWidth * gScale, imgHeight * gScale, null);
        return tmp;
    }

    private ImgObj wmsCached(WMSTile wco, SpatialSearchRequestParams requestParams, WmsEnv vars, PointType pointType, double[] pbbox, double[] bbox, double[] mbbox, int width, int height, double width_mult, double height_mult, int pointWidth, String[] originalFqs, Set<Integer> hq, String[] boundingBoxFqs, boolean outlinePoints, String outlineColour, HttpServletResponse response, boolean is4326, double[] tilebbox, int gridDivisionCount) throws Exception {
        int y;
        int x;
        ImgObj imgObj = null;
        boolean isGrid = vars.colourMode.equals("grid");
        int divs = gridDivisionCount;
        int[][] gridCounts = isGrid ? new int[divs][divs] : (int[][])null;
        int xstep = width / divs;
        int ystep = height / divs;
        double grid_width_mult = (double)width / (pbbox[2] - pbbox[0]) / (double)(width / divs);
        double grid_height_mult = (double)height / (pbbox[1] - pbbox[3]) / (double)(height / divs);
        if (vars.alpha > 0 && vars.size > 0) {
            List points = wco.getPoints();
            List counts = wco.getCounts();
            List pColour = wco.getColours();
            if (pColour.size() == 1 && vars.colourMode.equals("-1")) {
                pColour.set(0, vars.colour | vars.alpha << 24);
            }
            imgObj = ImgObj.create((int)width, (int)height);
            for (int j = 0; j < points.size(); ++j) {
                float[] ps;
                if (hq != null && hq.contains(j) || (ps = (float[])points.get(j)) == null || ps.length == 0) continue;
                double top = tilebbox[3];
                double bottom = tilebbox[1];
                double left = tilebbox[0];
                double right = tilebbox[2];
                if (isGrid) {
                    int[] count = (int[])counts.get(j);
                    for (int i = 0; i < ps.length; i += 2) {
                        float lng = ps[i];
                        float lat = ps[i + 1];
                        if (!((double)lng >= bbox[0]) || !((double)lng <= bbox[2]) || !((double)lat >= bbox[1]) || !((double)lat <= bbox[3])) continue;
                        if (is4326) {
                            x = this.convertLngToPixel4326((double)lng, left, right, width);
                            y = this.convertLatToPixel4326((double)lat, top, bottom, height);
                        } else {
                            x = (int)(((double)this.convertLngToPixel((double)lng) - pbbox[0]) * grid_width_mult);
                            y = (int)(((double)this.convertLatToPixel((double)lat) - pbbox[3]) * grid_height_mult);
                        }
                        if (x < 0 || x >= divs || y < 0 || y >= divs) continue;
                        int[] nArray = gridCounts[x];
                        int n = y;
                        nArray[n] = nArray[n] + count[i / 2];
                    }
                    continue;
                }
                this.renderPoints(vars, bbox, pbbox, width_mult, height_mult, pointWidth, outlinePoints, outlineColour, pColour, imgObj, j, ps, is4326, tilebbox, height, width);
            }
        }
        if (imgObj == null || imgObj.img == null) {
            if (vars.highlight == null) {
                this.displayBlankImage(response);
                return null;
            }
        } else if (isGrid) {
            for (x = 0; x < divs; ++x) {
                for (y = 0; y < divs; ++y) {
                    int v = gridCounts[x][y];
                    if (v <= 0) continue;
                    if (v > 500) {
                        v = 500;
                    }
                    int colour = (500 - v) / 2 << 8 | vars.alpha << 24 | 0xFF0000;
                    imgObj.g.setColor(new Color(colour));
                    imgObj.g.fillRect(x * xstep, y * ystep, xstep, ystep);
                }
            }
        } else {
            this.drawUncertaintyCircles(requestParams, vars, height, width, pbbox, mbbox, bbox, width_mult, height_mult, imgObj.g, originalFqs, boundingBoxFqs, is4326, tilebbox, pointType);
        }
        if (vars.highlight != null) {
            imgObj = this.drawHighlight(requestParams, vars, pointType, width, height, pbbox, width_mult, height_mult, imgObj, originalFqs, boundingBoxFqs, is4326, tilebbox);
        }
        return imgObj;
    }

    void drawUncertaintyCircles(SpatialSearchRequestParams requestParams, WmsEnv vars, int height, int width, double[] pbbox, double[] mbbox, double[] bbox, double width_mult, double height_mult, Graphics2D g, String[] originalFqs, String[] boundingBoxFqs, boolean is4326, double[] tilebbox, PointType pointType) throws Exception {
        double hmult = (double)height / (mbbox[3] - mbbox[1]);
        double min_uncertainty = (double)(vars.size + 1) / hmult;
        if (vars.uncertainty && this.MAX_UNCERTAINTY > min_uncertainty) {
            Color[] uncertaintyColours = new Color[]{new Color(255, 170, 0, vars.alpha), new Color(255, 255, 100, vars.alpha), new Color(50, 255, 50, vars.alpha)};
            String[] uncertaintyFqs = new String[]{"coordinate_uncertainty:[" + min_uncertainty + " TO " + this.MAX_UNCERTAINTY + "] AND -assertions:uncertaintyNotSpecified", "assertions:uncertaintyNotSpecified", "coordinate_uncertainty:[" + this.MAX_UNCERTAINTY + " TO *]"};
            double[] uncertaintyR = new double[]{-1.0, this.MAX_UNCERTAINTY, this.MAX_UNCERTAINTY};
            String[] fqs = new String[originalFqs.length + 3];
            System.arraycopy(originalFqs, 0, fqs, 3, originalFqs.length);
            fqs[1] = "longitude:[" + (bbox[0] - this.MAX_UNCERTAINTY / 100000.0) + " TO " + (bbox[2] + this.MAX_UNCERTAINTY / 100000.0) + "]";
            fqs[2] = "latitude:[" + (bbox[1] - this.MAX_UNCERTAINTY / 100000.0) + " TO " + (bbox[3] + this.MAX_UNCERTAINTY / 100000.0) + "]";
            requestParams.setPageSize(Integer.valueOf(1000000));
            for (int j = 0; j < uncertaintyFqs.length; ++j) {
                if (j == 1) continue;
                fqs[0] = uncertaintyFqs[j];
                requestParams.setFq(fqs);
                requestParams.setFacets(new String[]{"coordinate_uncertainty", pointType.getLabel()});
                requestParams.setFlimit(Integer.valueOf(-1));
                requestParams.setFormattedQuery(null);
                List qr = this.searchDAO.searchPivot(requestParams);
                if (qr == null || qr.size() <= 0) continue;
                List piv = ((FacetPivotResultDTO)qr.get(0)).getPivotResult();
                double top = tilebbox[3];
                double bottom = tilebbox[1];
                double left = tilebbox[0];
                double right = tilebbox[2];
                int uncertaintyRadius = (int)Math.ceil(uncertaintyR[j] * hmult);
                g.setColor(uncertaintyColours[j]);
                for (FacetPivotResultDTO r : piv) {
                    if (uncertaintyR[j] < 0.0) {
                        uncertaintyRadius = (int)Math.ceil(Double.parseDouble(r.getValue()) * hmult);
                    }
                    for (FacetPivotResultDTO point : r.getPivotResult()) {
                        int y;
                        int x;
                        String[] lat_lng = point.getValue().split(",");
                        double lng = Double.parseDouble(lat_lng[1]);
                        double lat = Double.parseDouble(lat_lng[0]);
                        if (is4326) {
                            x = this.convertLngToPixel4326(lng, left, right, width);
                            y = this.convertLatToPixel4326(lat, top, bottom, height);
                        } else {
                            x = (int)(((double)this.convertLngToPixel(lng) - pbbox[0]) * width_mult);
                            y = (int)(((double)this.convertLatToPixel(lat) - pbbox[3]) * height_mult);
                        }
                        if (uncertaintyRadius > 0) {
                            g.drawOval(x - uncertaintyRadius, y - uncertaintyRadius, uncertaintyRadius * 2, uncertaintyRadius * 2);
                            continue;
                        }
                        g.drawRect(x, y, 1, 1);
                    }
                }
            }
        }
    }

    ImgObj drawHighlight(SpatialSearchRequestParams requestParams, WmsEnv vars, PointType pointType, int width, int height, double[] pbbox, double width_mult, double height_mult, ImgObj imgObj, String[] originalFqs, String[] boundingBoxFqs, boolean is4326, double[] tilebbox) throws Exception {
        String[] fqs = new String[originalFqs.length + 3];
        System.arraycopy(originalFqs, 0, fqs, 3, originalFqs.length);
        fqs[0] = vars.highlight;
        fqs[1] = boundingBoxFqs[0];
        fqs[2] = boundingBoxFqs[1];
        requestParams.setFq(fqs);
        requestParams.setFlimit(Integer.valueOf(-1));
        requestParams.setFormattedQuery(null);
        FacetField ps = this.searchDAO.getFacetPointsShort(requestParams, pointType.getLabel());
        if (ps != null && ps.getValueCount() > 0) {
            if (imgObj == null || imgObj.img == null) {
                imgObj = ImgObj.create((int)width, (int)height);
            }
            int highightRadius = vars.size + HIGHLIGHT_RADIUS;
            int highlightWidth = highightRadius * 2;
            imgObj.g.setStroke(new BasicStroke(2.0f));
            imgObj.g.setColor(new Color(255, 0, 0, 255));
            double top = tilebbox[3];
            double bottom = tilebbox[1];
            double left = tilebbox[0];
            double right = tilebbox[2];
            for (int i = 0; i < ps.getValueCount(); ++i) {
                int y;
                int x;
                if (((FacetField.Count)ps.getValues().get(i)).getName() == null) continue;
                String[] lat_lng = ((FacetField.Count)ps.getValues().get(i)).getName().split(",");
                float lng = Float.parseFloat(lat_lng[1]);
                float lat = Float.parseFloat(lat_lng[0]);
                if (is4326) {
                    x = this.convertLngToPixel4326((double)lng, left, right, width);
                    y = this.convertLatToPixel4326((double)lat, top, bottom, height);
                } else {
                    x = (int)(((double)this.convertLngToPixel((double)lng) - pbbox[0]) * width_mult);
                    y = (int)(((double)this.convertLatToPixel((double)lat) - pbbox[3]) * height_mult);
                }
                imgObj.g.drawOval(x - highightRadius, y - highightRadius, highlightWidth, highlightWidth);
            }
        }
        return imgObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WMSTile getWMSCacheObject(SpatialSearchRequestParams requestParams, WmsEnv vars, PointType pointType, double[] bbox, String[] originalFqs, String[] boundingBoxFqs, boolean canCache) throws Exception {
        if (this.wmsCache.isFull() || !this.wmsCache.isEnabled()) {
            canCache = false;
        }
        Object[] origAndBBoxFqs = null;
        if (originalFqs == null || originalFqs.length == 0) {
            origAndBBoxFqs = boundingBoxFqs;
        } else {
            origAndBBoxFqs = new String[originalFqs.length + 2];
            System.arraycopy(originalFqs, 0, origAndBBoxFqs, 2, originalFqs.length);
            origAndBBoxFqs[0] = boundingBoxFqs[0];
            origAndBBoxFqs[1] = boundingBoxFqs[1];
        }
        String qparam = requestParams.getQ();
        if (qparam.startsWith("qid:")) {
            try {
                Qid qid = this.qidCacheDAO.get(qparam.substring(4));
                if (qid != null) {
                    qparam = qid.getQ() + qid.getWkt() + (qid.getFqs() != null ? StringUtils.join((Object[])qid.getFqs(), (String)",") : "");
                }
            }
            catch (Exception qid) {
                // empty catch block
            }
        }
        String qfull = qparam + StringUtils.join((Object[])requestParams.getFq(), (String)",") + requestParams.getQc() + requestParams.getWkt() + requestParams.getRadius() + requestParams.getLat() + requestParams.getLon();
        String q = String.valueOf(qfull.hashCode());
        String cm = vars.colourMode.equals("-1") || vars.colourMode.equals("grid") ? "-1" : vars.colourMode;
        boolean[] useBbox = new boolean[1];
        Integer count = 0;
        Integer pointsCount = 0;
        if (canCache) {
            count = this.getCachedCount(true, requestParams, q, pointType, useBbox);
            if (count == null || count == 0) {
                return new WMSTile();
            }
            if (count > this.wmsCacheMaxLayerPoints && pointType.getValue().floatValue() > 0.0f && (pointsCount = this.getCachedCount(false, requestParams, q, pointType, useBbox)) != null && pointsCount > this.wmsCacheMaxLayerPoints) {
                q = q + StringUtils.join((Object[])origAndBBoxFqs, (String)",");
                requestParams.setFq((String[])origAndBBoxFqs);
                count = this.getCachedCount(true, requestParams, q, pointType, useBbox);
                requestParams.setFq(originalFqs);
                if (count == null || count == 0) {
                    return new WMSTile();
                }
                useBbox[0] = true;
            }
        } else {
            this.queryFormatUtils.formatSearchQuery(requestParams, false);
        }
        List colours = null;
        int sz = 0;
        WMSTile wco = null;
        if (canCache) {
            for (int i = 0; !useBbox[0] && i < PointType.values().length && wco == null; ++i) {
                if (!(PointType.values()[i].getValue().floatValue() < pointType.getValue().floatValue())) continue;
                wco = this.wmsCache.getTest(q, cm, PointType.values()[i]);
            }
            if (wco == null) {
                requestParams.setFlimit(Integer.valueOf(-1));
                requestParams.setFormattedQuery(null);
                colours = cm.equals("-1") ? null : this.searchDAO.getColours(requestParams, vars.colourMode);
                sz = colours == null ? 1 : colours.size() + 1;
                wco = this.wmsCache.get(q, cm, pointType);
            }
            if (wco.getCached()) {
                return wco;
            }
        } else {
            wco = new WMSTile();
        }
        requestParams.setFormattedQuery(null);
        if (colours == null && !cm.equals("-1")) {
            colours = this.searchDAO.getColours(requestParams, vars.colourMode);
        }
        WMSTile wMSTile = wco;
        synchronized (wMSTile) {
            if (wco.getCached()) {
                return wco;
            }
            if (!(colours != null && colours.size() != 1 || cm.equals("-1"))) {
                String prevColourMode = vars.colourMode;
                vars.colourMode = "-1";
                WMSTile equivalentTile = this.getWMSCacheObject(requestParams, vars, pointType, bbox, originalFqs, boundingBoxFqs, canCache);
                vars.colourMode = prevColourMode;
                ArrayList<Integer> pColour = new ArrayList<Integer>(1);
                pColour.add(colours != null ? ((LegendItem)colours.get(0)).getColour() | vars.alpha << 24 : vars.colour);
                wco.setColours(pColour);
                wco.setBbox(bbox);
                wco.setColourmode(vars.colourMode);
                wco.setCounts(equivalentTile.getCounts());
                wco.setPoints(equivalentTile.getPoints());
                wco.setQuery(q);
            } else {
                if (!canCache || useBbox[0]) {
                    requestParams.setFq((String[])origAndBBoxFqs);
                }
                ArrayList pColour = new ArrayList(sz);
                ArrayList pointsArrays = new ArrayList(sz);
                ArrayList countsArrays = cm.equals("-1") ? new ArrayList(sz) : null;
                this.queryTile(requestParams, vars, pointType, countsArrays, pointsArrays, colours, pColour, bbox, originalFqs, boundingBoxFqs, canCache, count.intValue());
                wco.setBbox(bbox);
                wco.setColourmode(vars.colourMode);
                wco.setColours(pColour);
                if (cm.equals("-1")) {
                    wco.setCounts(countsArrays);
                }
                wco.setPoints(pointsArrays);
                wco.setQuery(q);
            }
            if (canCache) {
                this.wmsCache.put(q, cm, pointType, wco);
            }
            return wco;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getCachedCount(boolean docCount, SpatialSearchRequestParams requestParams, String q, PointType pointType, boolean[] useBbox) throws Exception {
        Integer count = null;
        String tag = docCount ? "" : pointType.getLabel();
        Object object = this.countLock;
        synchronized (object) {
            count = (Integer)this.countsCache.get((Object)(q + tag));
        }
        if (count == null) {
            Object result;
            requestParams.setPageSize(Integer.valueOf(0));
            requestParams.setFacet(Boolean.valueOf(true));
            requestParams.setFlimit(Integer.valueOf(0));
            requestParams.setFacets(new String[]{pointType.getLabel()});
            requestParams.setFormattedQuery(null);
            if (docCount) {
                result = this.searchDAO.findByFulltext(requestParams);
                if (result != null) {
                    Object object2 = this.countLock;
                    synchronized (object2) {
                        count = (int)result.getNumFound();
                        this.countsCache.put((Object)(q + tag), (Object)count);
                    }
                }
            } else {
                result = this.searchDAO.searchGroupedFacets(requestParams);
                if (result != null && result.size() > 0) {
                    Object object3 = this.countLock;
                    synchronized (object3) {
                        count = ((GroupFacetResultDTO)result.get(0)).getCount();
                        this.countsCache.put((Object)(q + tag), (Object)count);
                    }
                }
            }
        } else {
            this.queryFormatUtils.formatSearchQuery(requestParams, false);
        }
        return count;
    }

    private void queryTile(SpatialSearchRequestParams requestParams, WmsEnv vars, PointType pointType, List<int[]> countsArrays, List<float[]> pointsArrays, List<LegendItem> colours, List<Integer> pColour, double[] bbox, String[] originalFqs, String[] boundingBoxFqs, boolean canCache, int docCount) throws Exception {
        if (colours != null && colours.size() > 1) {
            long t1 = System.currentTimeMillis();
            String[] origFqs = requestParams.getFq();
            int colrmax = -1;
            long colrmaxtime = -1L;
            boolean numericalFacetCategories = vars.colourMode.contains(",");
            if (numericalFacetCategories || docCount > this.wmsFacetPivotCutoff || !canCache) {
                String[] fqs = new String[requestParams.getFq() == null ? 1 : requestParams.getFq().length + 1];
                if (requestParams.getFq() != null && requestParams.getFq().length > 0) {
                    System.arraycopy(requestParams.getFq(), 0, fqs, 1, requestParams.getFq().length);
                }
                ArrayList<String> fqsDone = new ArrayList<String>(colours != null ? colours.size() : 0);
                boolean otherPointsAdded = false;
                pointsArrays.add(null);
                pColour.add(null);
                for (int i = 0; i < colours.size(); ++i) {
                    LegendItem li = colours.get(i);
                    fqs[0] = li.getFq();
                    if (StringUtils.isEmpty((String)li.getName())) {
                        fqsDone.add(fqs[0].substring(1));
                    } else if (fqs[0].charAt(0) == '-') {
                        fqsDone.add(fqs[0].substring(1));
                    } else {
                        fqsDone.add("-" + fqs[0]);
                    }
                    requestParams.setFq(fqs);
                    long ms = System.currentTimeMillis();
                    requestParams.setFlimit(Integer.valueOf(-1));
                    requestParams.setFormattedQuery(null);
                    this.makePointsFromFacet(this.searchDAO.getFacetPointsShort(requestParams, pointType.getLabel()), pointsArrays, countsArrays);
                    pColour.add(li.getColour() | vars.alpha << 24);
                    colrmaxtime = System.currentTimeMillis() - ms;
                    if (i != ColorUtil.colourList.length - 2 || colours.size() != ColorUtil.colourList.length - 1) continue;
                    colrmax = i;
                    fqs = new String[(requestParams.getFq() == null ? 0 : requestParams.getFq().length) + fqsDone.size()];
                    if (requestParams.getFq() != null && requestParams.getFq().length > 0) {
                        System.arraycopy(requestParams.getFq(), 0, fqs, fqsDone.size(), requestParams.getFq().length);
                    }
                    System.arraycopy(fqsDone.toArray(new String[0]), 0, fqs, 0, fqsDone.size());
                    requestParams.setFq(origFqs);
                    String prevColourMode = vars.colourMode;
                    vars.colourMode = "-1";
                    WMSTile equivalentTile = this.getWMSCacheObject(requestParams, vars, pointType, bbox, originalFqs, boundingBoxFqs, canCache);
                    vars.colourMode = prevColourMode;
                    if (equivalentTile.getPoints() == null || equivalentTile.getPoints().size() <= 0 || ((float[])equivalentTile.getPoints().get(0)).length <= 0) continue;
                    pointsArrays.set(0, (float[])equivalentTile.getPoints().get(0));
                    pColour.set(0, ColorUtil.colourList[ColorUtil.colourList.length - 1] | vars.alpha << 24);
                    otherPointsAdded = true;
                }
                if (!otherPointsAdded) {
                    pointsArrays.remove(0);
                    pColour.remove(0);
                }
                requestParams.setFq(origFqs);
            }
            long t2 = System.currentTimeMillis();
            if (!numericalFacetCategories && docCount <= this.wmsFacetPivotCutoff && canCache) {
                requestParams.setFacets(new String[]{vars.colourMode + "," + pointType.getLabel()});
                requestParams.setFlimit(Integer.valueOf(-1));
                requestParams.setFormattedQuery(null);
                List qr = this.searchDAO.searchPivot(requestParams);
                if (qr != null && qr.size() > 0) {
                    List piv = ((FacetPivotResultDTO)qr.get(0)).getPivotResult();
                    int lastColour = ColorUtil.colourList[ColorUtil.colourList.length - 1] | vars.alpha << 24;
                    block1: for (int i = 0; i < colours.size(); ++i) {
                        LegendItem li = colours.get(i);
                        for (int j = 0; j < piv.size() && piv.size() > 0; ++j) {
                            FacetPivotResultDTO p = (FacetPivotResultDTO)piv.get(j);
                            if ((!StringUtils.isEmpty((String)li.getName()) || !StringUtils.isEmpty((String)p.getValue())) && (!StringUtils.isNotEmpty((String)li.getName()) || !li.getName().equals(p.getValue()))) continue;
                            this.makePointsFromPivot(p.getPivotResult(), pointsArrays, countsArrays);
                            pColour.add(li.getColour() | vars.alpha << 24);
                            piv.remove(j);
                            continue block1;
                        }
                    }
                    while (piv.size() > 0) {
                        this.makePointsFromPivot(((FacetPivotResultDTO)piv.get(0)).getPivotResult(), pointsArrays, countsArrays);
                        pColour.add(lastColour);
                        piv.remove(0);
                    }
                }
            }
            long t3 = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                int occurrences = 0;
                int points = 0;
                int colourMatches = pointsArrays.size();
                for (int i = 0; i < pointsArrays.size(); ++i) {
                    points += pointsArrays.get(i).length;
                    if (countsArrays == null) continue;
                    for (int j = 0; j < pointsArrays.get(i).length; ++j) {
                        occurrences += countsArrays.get(i)[j];
                    }
                }
                logger.debug((Object)("wms timings: many queries=" + (t2 - t1) + "ms, pivot=" + (t3 - t2) + "ms, colours=" + colours.size() + ", points=" + points + ", occurrences=" + occurrences + ", matchedColours=" + colourMatches + ", max colour idx=" + colrmax + ", max colour request time=" + colrmaxtime + "ms, query docCount=" + docCount));
            }
        }
        if (colours == null || colours.isEmpty() || colours.size() == 1) {
            requestParams.setFlimit(Integer.valueOf(-1));
            requestParams.setFormattedQuery(null);
            this.makePointsFromFacet(this.searchDAO.getFacetPointsShort(requestParams, pointType.getLabel()), pointsArrays, countsArrays);
            if (colours == null || colours.isEmpty()) {
                pColour.add(vars.colour);
            } else {
                pColour.add(colours.get(0).getColour() | vars.alpha << 24);
            }
        }
    }

    private void makePointsFromPivot(List<FacetPivotResultDTO> pivotResult, List gPoints, List gCount) {
        float[] points = new float[2 * pivotResult.size()];
        int[] count = new int[pivotResult.size()];
        int i = 0;
        int j = 0;
        for (FacetPivotResultDTO fpr : pivotResult) {
            String v = fpr.getValue();
            if (StringUtils.isNotEmpty((String)v)) {
                int p = v.indexOf(44);
                points[i++] = Float.parseFloat(v.substring(p + 1));
                points[i++] = Float.parseFloat(v.substring(0, p));
                count[j++] = fpr.getCount();
                continue;
            }
            points[i++] = Float.NaN;
            ++i;
            count[j++] = 0;
        }
        gPoints.add(points);
        if (gCount != null) {
            gCount.add(count);
        }
    }

    private void makePointsFromFacet(FacetField facet, List gPoints, List gCount) {
        float[] points = new float[2 * facet.getValues().size()];
        int[] count = new int[facet.getValues().size()];
        int i = 0;
        int j = 0;
        for (FacetField.Count s : facet.getValues()) {
            try {
                String v = s.getName();
                if (v != null) {
                    int p = v.indexOf(44);
                    float lng = Float.parseFloat(v.substring(p + 1));
                    float lat = Float.parseFloat(v.substring(0, p));
                    int c = (int)s.getCount();
                    points[i++] = lng;
                    points[i++] = lat;
                    count[j++] = c;
                    continue;
                }
                points[i++] = Float.NaN;
                ++i;
                count[j++] = 0;
            }
            catch (Exception exception) {}
        }
        while (i < points.length && i > 1) {
            points[i] = points[i - 2];
            ++i;
        }
        while (j < count.length && j > 0) {
            count[j] = 0;
            ++j;
        }
        gPoints.add(points);
        if (gCount != null) {
            gCount.add(count);
        }
    }

    private void renderPoints(WmsEnv vars, double[] bbox, double[] pbbox, double width_mult, double height_mult, int pointWidth, boolean outlinePoints, String outlineColour, List<Integer> pColour, ImgObj imgObj, int j, float[] ps, boolean is4326, double[] tilebbox, int height, int width) {
        Color currentFill = new Color(pColour.get(j), true);
        imgObj.g.setPaint(currentFill);
        Color oColour = Color.decode(outlineColour);
        double top = tilebbox[3];
        double bottom = tilebbox[1];
        double left = tilebbox[0];
        double right = tilebbox[2];
        for (int i = 0; i < ps.length; i += 2) {
            int y;
            int x;
            float lng = ps[i];
            float lat = ps[i + 1];
            if (!((double)lng >= bbox[0]) || !((double)lng <= bbox[2]) || !((double)lat >= bbox[1]) || !((double)lat <= bbox[3])) continue;
            if (is4326) {
                x = this.convertLngToPixel4326((double)lng, left, right, width);
                y = this.convertLatToPixel4326((double)lat, top, bottom, height);
            } else {
                x = (int)(((double)this.convertLngToPixel((double)lng) - pbbox[0]) * width_mult);
                y = (int)(((double)this.convertLatToPixel((double)lat) - pbbox[3]) * height_mult);
            }
            imgObj.g.fillOval(x - vars.size, y - vars.size, pointWidth, pointWidth);
            if (!outlinePoints) continue;
            imgObj.g.setPaint(oColour);
            imgObj.g.drawOval(x - vars.size, y - vars.size, pointWidth, pointWidth);
            imgObj.g.setPaint(currentFill);
        }
    }

    private double[] transformBbox4326To900913(double long1, double lat1, double long2, double lat2) {
        return new double[]{6378137.0 * long1 * Math.PI / 180.0, 6378137.0 * Math.log(Math.tan(0.7853981633974483 + lat1 * Math.PI / 360.0)), 6378137.0 * long2 * Math.PI / 180.0, 6378137.0 * Math.log(Math.tan(0.7853981633974483 + lat2 * Math.PI / 360.0))};
    }

    public void setTaxonDAO(TaxonDAO taxonDAO) {
        this.taxonDAO = taxonDAO;
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }

    public void setSearchUtils(SearchUtils searchUtils) {
        this.searchUtils = searchUtils;
    }

    public void setBaseWsUrl(String baseWsUrl) {
        this.baseWsUrl = baseWsUrl;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setOrgCity(String orgCity) {
        this.orgCity = orgCity;
    }

    public void setOrgStateProvince(String orgStateProvince) {
        this.orgStateProvince = orgStateProvince;
    }

    public void setOrgPostcode(String orgPostcode) {
        this.orgPostcode = orgPostcode;
    }

    public void setOrgCountry(String orgCountry) {
        this.orgCountry = orgCountry;
    }

    public void setOrgPhone(String orgPhone) {
        this.orgPhone = orgPhone;
    }

    public void setOrgFax(String orgFax) {
        this.orgFax = orgFax;
    }

    public void setOrgEmail(String orgEmail) {
        this.orgEmail = orgEmail;
    }

    static {
        logger = Logger.getLogger(WMSController.class);
        byte[] b = null;
        try {
            RandomAccessFile raf = new RandomAccessFile(WMSController.class.getResource("/blank.png").getFile(), "r");
            b = new byte[(int)raf.length()];
            raf.read(b);
            raf.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open blank image file");
        }
        blankImageBytes = b;
    }
}

