/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Config;
import au.org.ala.biocache.Store;
import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.FacetPivotResultDTO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FacetThemes;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.GroupFacetResultDTO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.MediaDTO;
import au.org.ala.biocache.dto.NativeDTO;
import au.org.ala.biocache.dto.OccurrenceDTO;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.dto.OccurrenceSourceDTO;
import au.org.ala.biocache.dto.SearchRequestParams;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.parser.ProcessedValue;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.ImageMetadataService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.AssertionUtils;
import au.org.ala.biocache.util.ContactUtils;
import au.org.ala.biocache.util.LayersStore;
import au.org.ala.biocache.util.OccurrenceUtils;
import au.org.ala.biocache.util.QidSizeException;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.biocache.web.OccurrenceController;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.ehcache.CacheManager;
import org.ala.client.appender.RestLevel;
import org.ala.client.model.LogEventType;
import org.ala.client.model.LogEventVO;
import org.ala.client.util.RestfulClient;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.gbif.utils.file.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OccurrenceController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(OccurrenceController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    protected RestfulClient restfulClient;
    @Inject
    protected SpeciesLookupService speciesLookupService;
    @Inject
    protected AuthService authService;
    @Inject
    protected ContactUtils contactUtils;
    @Inject
    protected AssertionUtils assertionUtils;
    @Inject
    protected DownloadService downloadService;
    @Inject
    private AbstractMessageSource messageSource;
    @Inject
    private ImageMetadataService imageMetadataService;
    @Autowired
    private Validator validator;
    @Inject
    protected QidCacheDAO qidCacheDao;
    @Inject
    private CacheManager cacheManager;
    private String HOME = "homePage";
    private String VALIDATION_ERROR = "error/validationError";
    @Value(value="${webservices.root:http://localhost:8080/biocache-service}")
    protected String webservicesRoot;
    @Value(value="${taxon.id.pattern:urn:lsid:biodiversity.org.au[a-zA-Z0-9\\.:-]*|http://id.biodiversity.org.au/[a-zA-Z0-9/]*}")
    protected String taxonIDPatternString;
    @Value(value="${native.country:Australia}")
    protected String nativeCountry;
    protected Pattern taxonIDPattern;
    @Value(value="${media.url:http://biocache.ala.org.au/biocache-media/}")
    protected String biocacheMediaUrl;
    @Value(value="${facet.config:/data/biocache/config/facets.json}")
    protected String facetConfig;
    @Value(value="${facets.max:4}")
    protected Integer facetsMax;
    @Value(value="${facets.defaultmax:0}")
    protected Integer facetsDefaultMax;
    @Value(value="${facet.default:true}")
    protected Boolean facetDefault;
    @Value(value="${online.downloadquery.maxthreads:30}")
    protected Integer maxOnlineDownloadThreads = 30;
    private ExecutorService executor;
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final CountDownLatch initialisationLatch = new CountDownLatch(1);

    @PostConstruct
    public void init() {
        if (this.initialised.compareAndSet(false, true)) {
            String nameFormat = "occurrencecontroller-pool-%d";
            this.executor = Executors.newFixedThreadPool(this.maxOnlineDownloadThreads, new ThreadFactoryBuilder().setNameFormat(nameFormat).setPriority(1).build());
            1 initialisationThread = new /* Unavailable Anonymous Inner Class!! */;
            initialisationThread.setPriority(10);
            initialisationThread.setName("biocache-occurrencecontroller-initialisation");
            initialisationThread.start();
        }
    }

    private final void afterInitialisation() {
        try {
            this.initialisationLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Pattern getTaxonIDPattern() {
        if (this.taxonIDPattern == null) {
            this.taxonIDPattern = Pattern.compile(this.taxonIDPatternString);
        }
        return this.taxonIDPattern;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator(this.validator);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String homePageHandler(Model model) {
        model.addAttribute("webservicesRoot", (Object)this.webservicesRoot);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream input = classLoader.getResourceAsStream("/git.properties");
        if (input != null) {
            try {
                Properties versionProperties = new Properties();
                versionProperties.load(input);
                model.addAttribute("versionInfo", (Object)versionProperties);
                StringBuffer sb = new StringBuffer();
                for (String name : versionProperties.stringPropertyNames()) {
                    sb.append(name + " : " + versionProperties.getProperty(name) + "\n");
                }
                model.addAttribute("versionInfoString", (Object)sb.toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.HOME;
    }

    @RequestMapping(value={"/oldapi"}, method={RequestMethod.GET})
    public String oldApiHandler(Model model) {
        model.addAttribute("webservicesRoot", (Object)this.webservicesRoot);
        return "oldapi";
    }

    @RequestMapping(value={"/active/download/stats"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DownloadDetailsDTO> getCurrentDownloads() {
        return this.downloadService.getCurrentDownloads();
    }

    @RequestMapping(value={"/search/facets"}, method={RequestMethod.GET})
    @ResponseBody
    public String[] listAllFacets() {
        this.afterInitialisation();
        return new SearchRequestParams().getFacets();
    }

    @RequestMapping(value={"/search/grouped/facets"}, method={RequestMethod.GET})
    @ResponseBody
    public List groupFacets() throws IOException {
        this.afterInitialisation();
        return FacetThemes.getAllThemes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/facets/i18n{qualifier:.*}*"}, method={RequestMethod.GET})
    public void writei18nPropertiesFile(@PathVariable(value="qualifier") String qualifier, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        qualifier = StringUtils.isNotEmpty((String)qualifier) ? qualifier : ".properties";
        logger.debug((Object)("qualifier = " + qualifier));
        File f = new File("/data/biocache/config/messages" + qualifier);
        try (InputStream is = f.exists() && f.isFile() && f.canRead() ? FileUtils.getInputStream((File)f) : request.getSession().getServletContext().getResourceAsStream("/WEB-INF/messages" + qualifier);
             ServletOutputStream os = response.getOutputStream();){
            if (is != null) {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
            if (StringUtils.isNotEmpty((String)Config.layersServiceUrl())) {
                try {
                    HashMap fields = new LayersStore(Config.layersServiceUrl()).getFieldIdsAndDisplayNames();
                    for (String fieldId : fields.keySet()) {
                        os.write(("\nfield." + fieldId + "=" + (String)fields.get(fieldId)).getBytes("UTF-8"));
                        os.write(("\nfacet." + fieldId + "=" + (String)fields.get(fieldId)).getBytes("UTF-8"));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("failed to add layer names from url: " + Config.layersServiceUrl()), (Throwable)e);
                }
            }
            os.flush();
        }
    }

    @RequestMapping(value={"index/fields"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<IndexFieldDTO> getIndexedFields(@RequestParam(value="fl", required=false) String fields, @RequestParam(value="indexed", required=false) Boolean indexed, @RequestParam(value="stored", required=false) Boolean stored, @RequestParam(value="multivalue", required=false) Boolean multivalue, @RequestParam(value="dataType", required=false) String dataType, @RequestParam(value="classs", required=false) String classs) throws Exception {
        this.afterInitialisation();
        Set<Object> result = fields == null ? this.searchDAO.getIndexedFields() : this.searchDAO.getIndexFieldDetails(fields.split(","));
        if (indexed != null || stored != null || multivalue != null || dataType != null || classs != null) {
            HashSet<IndexFieldDTO> filtered = new HashSet<IndexFieldDTO>();
            HashSet<String> dataTypes = dataType == null ? null : new HashSet<String>(Arrays.asList(dataType.split(",")));
            HashSet<String> classss = classs == null ? null : new HashSet<String>(Arrays.asList(classs.split(",")));
            for (IndexFieldDTO i : result) {
                if (indexed != null && i.isIndexed() != indexed.booleanValue() || stored != null && i.isStored() != stored.booleanValue() || multivalue != null && i.isMultivalue() != multivalue.booleanValue() || dataType != null && !dataTypes.contains(i.getDataType()) || classs != null && !classss.contains(i.getClasss())) continue;
                filtered.add(i);
            }
            result = filtered;
        }
        return result;
    }

    @RequestMapping(value={"index/version"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getIndexedFields(@RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="force", required=false, defaultValue="false") Boolean force, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        Long version = force != false && this.shouldPerformOperation(apiKey, response) ? this.searchDAO.getIndexVersion(force) : this.searchDAO.getIndexVersion(Boolean.valueOf(false));
        return Collections.singletonMap("version", version);
    }

    @RequestMapping(value={"index/maxBooleanClauses"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getIndexedFields() throws Exception {
        int m = this.searchDAO.getMaxBooleanClauses();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("maxBooleanClauses", m);
        return map;
    }

    @RequestMapping(value={"occurrence/facets"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FacetResultDTO> getOccurrenceFacetDetails(SpatialSearchRequestParams requestParams) throws Exception {
        this.afterInitialisation();
        return this.searchDAO.getFacetCounts(requestParams);
    }

    @RequestMapping(value={"occurrence/groups"}, method={RequestMethod.GET})
    @ResponseBody
    public List<GroupFacetResultDTO> getOccurrenceGroupDetails(SpatialSearchRequestParams requestParams, @RequestParam(value="apiKey", required=true) String apiKey, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        if (this.isValidKey(apiKey)) {
            return this.searchDAO.searchGroupedFacets(requestParams);
        }
        response.sendError(403, "An invalid API Key was provided.");
        return null;
    }

    @RequestMapping(value={"/images/taxon/**"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getImages(HttpServletRequest request) throws Exception {
        this.afterInitialisation();
        String guid = this.searchUtils.getGuidFromPath(request);
        SpatialSearchRequestParams srp = new SpatialSearchRequestParams();
        srp.setQ("lsid:" + guid);
        srp.setPageSize(Integer.valueOf(0));
        srp.setFacets(new String[]{"image_url"});
        SearchResultDTO results = this.searchDAO.findByFulltextSpatialQuery(srp, null);
        if (results.getFacetResults().size() > 0) {
            List fieldResults = ((FacetResultDTO)results.getFacetResults().iterator().next()).getFieldResult();
            ArrayList<String> images = new ArrayList<String>(fieldResults.size());
            for (FieldResultDTO fr : fieldResults) {
                images.add(fr.getLabel());
            }
            return images;
        }
        return Collections.EMPTY_LIST;
    }

    @RequestMapping(value={"/australian/taxon/**", "/native/taxon/**"}, method={RequestMethod.GET})
    @ResponseBody
    public NativeDTO isAustralian(HttpServletRequest request) throws Exception {
        String guid = this.searchUtils.getGuidFromPath(request);
        NativeDTO adto = new NativeDTO();
        if (guid != null) {
            adto = this.getIsAustraliaForGuid(guid);
        }
        return adto;
    }

    @RequestMapping(value={"/australian/taxa.json*", "/australian/taxa*", "/native/taxa.json*", "/native/taxa*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<NativeDTO> isAustralianForList(@RequestParam(value="guids", required=true) String guids) throws Exception {
        this.afterInitialisation();
        ArrayList<NativeDTO> nativeDTOs = new ArrayList<NativeDTO>();
        String[] guidArray = StringUtils.split((String)guids, (char)',');
        if (guidArray != null) {
            for (String guid : guidArray) {
                nativeDTOs.add(this.getIsAustraliaForGuid(guid));
                logger.debug((Object)("guid = " + guid));
            }
        }
        return nativeDTOs;
    }

    private NativeDTO getIsAustraliaForGuid(String guid) {
        SpatialSearchRequestParams requestParams = new SpatialSearchRequestParams();
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacets(new String[0]);
        String query = "lsid:" + guid + " AND (country:\"" + this.nativeCountry + "\" OR state:[* TO *]) AND geospatial_kosher:true";
        requestParams.setQ(query);
        NativeDTO adto = new NativeDTO();
        adto.setTaxonGuid(guid);
        SearchResultDTO results = this.searchDAO.findByFulltextSpatialQuery(requestParams, null);
        adto.setHasOccurrenceRecords(results.getTotalRecords() > 0L);
        adto.setIsNSL(this.getTaxonIDPattern().matcher(guid).matches());
        if (adto.isHasOccurrences()) {
            requestParams.setQ("lsid:" + guid + " AND (provenance:\"Published dataset\")");
            results = this.searchDAO.findByFulltextSpatialQuery(requestParams, null);
            adto.setHasCSOnly(results.getTotalRecords() == 0L);
        }
        return adto;
    }

    @RequestMapping(value={"/occurrences", "/occurrences/collections", "/occurrences/institutions", "/occurrences/dataResources", "/occurrences/dataProviders", "/occurrences/taxa", "/occurrences/dataHubs"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO listOccurrences(Model model) throws Exception {
        this.afterInitialisation();
        SpatialSearchRequestParams srp = new SpatialSearchRequestParams();
        srp.setQ("*:*");
        return this.occurrenceSearch(srp);
    }

    @RequestMapping(value={"/occurrences/taxon/**", "/occurrences/taxon/**", "/occurrences/taxa/**"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO occurrenceSearchByTaxon(SpatialSearchRequestParams requestParams, HttpServletRequest request) throws Exception {
        this.afterInitialisation();
        String guid = this.searchUtils.getGuidFromPath(request);
        requestParams.setQ("lsid:" + guid);
        SearchUtils.setDefaultParams((SearchRequestParams)requestParams);
        return this.occurrenceSearch(requestParams);
    }

    @RequestMapping(value={"/occurrences/taxon/source/**"}, method={RequestMethod.GET})
    @ResponseBody
    public List<OccurrenceSourceDTO> sourceByTaxon(SpatialSearchRequestParams requestParams, HttpServletRequest request) throws Exception {
        this.afterInitialisation();
        String guid = this.searchUtils.getGuidFromPath(request);
        requestParams.setQ("lsid:" + guid);
        Map sources = this.searchDAO.getSourcesForQuery(requestParams);
        return this.searchUtils.getSourceInformation(sources);
    }

    @RequestMapping(value={"/occurrences/collections/{uid}", "/occurrences/institutions/{uid}", "/occurrences/dataResources/{uid}", "/occurrences/dataProviders/{uid}", "/occurrences/dataHubs/{uid}"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO occurrenceSearchForUID(SpatialSearchRequestParams requestParams, @PathVariable(value="uid") String uid, Model model) throws Exception {
        this.afterInitialisation();
        SearchResultDTO searchResult = new SearchResultDTO();
        if (StringUtils.isEmpty((String)uid)) {
            return searchResult;
        }
        SearchUtils.setDefaultParams((SearchRequestParams)requestParams);
        this.searchUtils.updateCollectionSearchString((SearchRequestParams)requestParams, uid);
        logger.debug((Object)("solr query: " + requestParams));
        return this.occurrenceSearch(requestParams);
    }

    @RequestMapping(value={"/occurrences/searchByArea*"}, method={RequestMethod.GET})
    @Deprecated
    @ResponseBody
    public SearchResultDTO occurrenceSearchByArea(SpatialSearchRequestParams requestParams, Model model) throws Exception {
        this.afterInitialisation();
        SearchResultDTO searchResult = new SearchResultDTO();
        if (StringUtils.isEmpty((String)requestParams.getQ())) {
            return searchResult;
        }
        searchResult = this.searchDAO.findByFulltextSpatialQuery(requestParams, null);
        model.addAttribute("searchResult", (Object)searchResult);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning results set with: " + searchResult.getTotalRecords()));
        }
        return searchResult;
    }

    private SearchResultDTO occurrenceSearch(SpatialSearchRequestParams requestParams) throws Exception {
        return this.occurrenceSearch(requestParams, null, Boolean.valueOf(false), null, null);
    }

    @RequestMapping(value={"/occurrences/search.json*", "/occurrences/search*"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO occurrenceSearch(SpatialSearchRequestParams requestParams, @RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="im", required=false, defaultValue="false") Boolean lookupImageMetadata, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map map;
        this.afterInitialisation();
        SearchUtils.setDefaultParams((SearchRequestParams)requestParams);
        Map map2 = map = request != null ? SearchUtils.getExtraParams((Map)request.getParameterMap()) : null;
        if (map != null) {
            map.remove("apiKey");
        }
        logger.debug((Object)("occurrence search params = " + requestParams + " extra params = " + map));
        SearchResultDTO srtdto = null;
        srtdto = apiKey == null ? this.searchDAO.findByFulltextSpatialQuery(requestParams, map) : this.occurrenceSearchSensitive(requestParams, apiKey, request, response);
        if (srtdto.getTotalRecords() > 0L && lookupImageMetadata.booleanValue()) {
            ArrayList<String> occurrenceIDs = new ArrayList<String>();
            for (OccurrenceIndex oi : srtdto.getOccurrences()) {
                occurrenceIDs.add(oi.getUuid());
            }
            Map imageMap = this.imageMetadataService.getImageMetadataForOccurrences(occurrenceIDs);
            for (OccurrenceIndex oi : srtdto.getOccurrences()) {
                List imageMetadata = (List)imageMap.get(oi.getUuid());
                oi.setImageMetadata(imageMetadata);
            }
        }
        return srtdto;
    }

    @ResponseBody
    public SearchResultDTO occurrenceSearchSensitive(SpatialSearchRequestParams requestParams, @RequestParam(value="apiKey", required=true) String apiKey, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        if (this.shouldPerformOperation(apiKey, response, false)) {
            SearchUtils.setDefaultParams((SearchRequestParams)requestParams);
            Map map = SearchUtils.getExtraParams((Map)request.getParameterMap());
            if (map != null) {
                map.remove("apiKey");
            }
            logger.debug((Object)("occurrence search params = " + requestParams));
            SearchResultDTO searchResult = this.searchDAO.findByFulltextSpatialQuery(requestParams, true, map);
            return searchResult;
        }
        return null;
    }

    @RequestMapping(value={"/cache/refresh"}, method={RequestMethod.GET})
    @ResponseBody
    public String refreshCache() throws Exception {
        this.searchDAO.refreshCaches();
        new FacetThemes(this.facetConfig, this.searchDAO.getIndexedFields(), this.facetsMax.intValue(), this.facetsDefaultMax.intValue(), this.facetDefault.booleanValue());
        this.cacheManager.clearAll();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/occurrences/facets/download*"}, method={RequestMethod.GET})
    public void downloadFacet(DownloadRequestParams requestParams, @RequestParam(value="count", required=false, defaultValue="false") boolean includeCount, @RequestParam(value="lookup", required=false, defaultValue="false") boolean lookupName, @RequestParam(value="synonym", required=false, defaultValue="false") boolean includeSynonyms, @RequestParam(value="lists", required=false, defaultValue="false") boolean includeLists, @RequestParam(value="ip", required=false) String ip, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        if (requestParams.getFacets().length > 0) {
            ip = ip == null ? this.getIPAddress(request) : ip;
            DownloadDetailsDTO dd = this.downloadService.registerDownload(requestParams, ip, DownloadDetailsDTO.DownloadType.FACET);
            try {
                String filename = requestParams.getFile() != null ? requestParams.getFile() : requestParams.getFacets()[0];
                response.setHeader("Cache-Control", "must-revalidate");
                response.setHeader("Pragma", "must-revalidate");
                response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".csv");
                response.setContentType("text/csv");
                this.searchDAO.writeFacetToStream((SpatialSearchRequestParams)requestParams, includeCount, lookupName, includeSynonyms, includeLists, (OutputStream)response.getOutputStream(), dd);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.downloadService.unregisterDownload(dd);
            }
        }
    }

    @RequestMapping(value={"/occurrences/batchSearch"}, method={RequestMethod.POST}, params={"action=Download"})
    public void batchDownload(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="queries", required=true, defaultValue="") String queries, @RequestParam(value="field", required=true, defaultValue="") String field, @RequestParam(value="separator", defaultValue="\n") String separator, @RequestParam(value="title", required=false) String title) throws Exception {
        this.afterInitialisation();
        logger.info((Object)"/occurrences/batchSearch with action=Download Records");
        Long qid = this.getQidForBatchSearch(queries, field, separator, title);
        if (qid != null) {
            String webservicesRoot = request.getSession().getServletContext().getInitParameter("webservicesRoot");
            response.sendRedirect(webservicesRoot + "/occurrences/download?q=qid:" + qid);
        } else {
            response.sendError(400);
        }
    }

    @RequestMapping(value={"/occurrences/download/batchFile"}, method={RequestMethod.GET})
    public String batchDownload(HttpServletRequest request, @Valid DownloadRequestParams params, BindingResult result, @RequestParam(value="file", required=true) String filepath, @RequestParam(value="directory", required=true, defaultValue="/data/biocache-exports") String directory, @RequestParam(value="ip", required=false) String ip, Model model) throws Exception {
        this.afterInitialisation();
        if (result.hasErrors()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("validation failed  " + result.getErrorCount() + " checks"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)result.toString());
                }
            }
            model.addAttribute("errorMessage", (Object)this.getValidationErrorMessage(result));
            return this.VALIDATION_ERROR;
        }
        File file = new File(filepath);
        SpeciesLookupService mySpeciesLookupService = this.speciesLookupService;
        ip = ip == null ? this.getIPAddress(request) : ip;
        DownloadDetailsDTO dd = this.downloadService.registerDownload(params, ip, DownloadDetailsDTO.DownloadType.RECORDS_INDEX);
        if (file.exists()) {
            2 t = new /* Unavailable Anonymous Inner Class!! */;
            this.executor.submit((Runnable)t);
        }
        return null;
    }

    @RequestMapping(value={"/occurrences/batchSearch"}, method={RequestMethod.POST}, params={"action=Search"})
    public void batchSearch(HttpServletResponse response, @RequestParam(value="redirectBase", required=true, defaultValue="") String redirectBase, @RequestParam(value="queries", required=true, defaultValue="") String queries, @RequestParam(value="field", required=true, defaultValue="") String field, @RequestParam(value="separator", defaultValue="\n") String separator, @RequestParam(value="title", required=false) String title) throws Exception {
        this.afterInitialisation();
        logger.info((Object)"/occurrences/batchSearch with action=Search");
        Long qid = this.getQidForBatchSearch(queries, field, separator, title);
        if (qid != null && StringUtils.isNotBlank((String)redirectBase)) {
            response.sendRedirect(redirectBase + "?q=qid:" + qid);
        } else {
            response.sendError(400, "");
        }
    }

    private Long getQidForBatchSearch(String listOfNames, String field, String separator, String title) throws IOException, QidSizeException {
        String[] rawParts = listOfNames.split(separator);
        ArrayList<String> parts = new ArrayList<String>();
        for (String part : rawParts) {
            String normalised = StringUtils.trimToNull((String)part);
            if (normalised == null) continue;
            parts.add(field + ":\"" + normalised + "\"");
        }
        if (parts.isEmpty()) {
            return null;
        }
        String q = StringUtils.join((Object[])parts.toArray(new String[0]), (String)" OR ");
        title = title == null ? q : title;
        String qid = this.qidCacheDao.put(q, title, null, null, null, -1L, null);
        logger.info((Object)("batchSearch: qid = " + qid));
        return Long.parseLong(qid);
    }

    @RequestMapping(value={"/occurrences/taxaCount"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public Map<String, Integer> occurrenceSpeciesCounts(HttpServletResponse response, HttpServletRequest request, @RequestParam(defaultValue="\n") String separator) throws Exception {
        this.afterInitialisation();
        String listOfGuids = request.getParameter("guids");
        String[] filterQueries = request.getParameterValues("fq");
        String[] rawGuids = listOfGuids.split(separator);
        ArrayList<String> guids = new ArrayList<String>();
        for (String guid : rawGuids) {
            String normalised = StringUtils.trimToNull((String)guid);
            if (normalised == null) continue;
            guids.add(normalised);
        }
        return this.searchDAO.getOccurrenceCountsForTaxa(guids, filterQueries);
    }

    @RequestMapping(value={"/occurrences/download*"}, method={RequestMethod.GET})
    public String occurrenceDownload(@Valid DownloadRequestParams requestParams, BindingResult result, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="zip", required=false, defaultValue="true") Boolean zip, Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.afterInitialisation();
        if (result.hasErrors()) {
            logger.info((Object)("validation failed  " + result.getErrorCount() + " checks"));
            logger.debug((Object)result.toString());
            model.addAttribute("errorMessage", (Object)this.getValidationErrorMessage(result));
            return this.VALIDATION_ERROR;
        }
        String string = ip = ip == null ? this.getIPAddress(request) : ip;
        if (requestParams.getQ().isEmpty() && requestParams.getFormattedQuery().isEmpty()) {
            return null;
        }
        if (apiKey != null) {
            return this.occurrenceSensitiveDownload(requestParams, apiKey, ip, false, zip.booleanValue(), response, request);
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            this.downloadService.writeQueryToStream(requestParams, response, ip, (OutputStream)new CloseShieldOutputStream((OutputStream)out), false, false, zip.booleanValue(), this.executor);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"/occurrences/index/download*"}, method={RequestMethod.GET})
    public String occurrenceIndexDownload(@Valid DownloadRequestParams requestParams, BindingResult result, @RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="zip", required=false, defaultValue="true") Boolean zip, Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.afterInitialisation();
        if (result.hasErrors()) {
            logger.info((Object)("validation failed  " + result.getErrorCount() + " checks"));
            logger.debug((Object)result.toString());
            model.addAttribute("errorMessage", (Object)this.getValidationErrorMessage(result));
            return this.VALIDATION_ERROR;
        }
        String string = ip = ip == null ? this.getIPAddress(request) : ip;
        if (requestParams.getQ().isEmpty() && requestParams.getFormattedQuery().isEmpty()) {
            return null;
        }
        if (apiKey != null) {
            this.occurrenceSensitiveDownload(requestParams, apiKey, ip, true, zip.booleanValue(), response, request);
            return null;
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            this.downloadService.writeQueryToStream(requestParams, response, ip, (OutputStream)new CloseShieldOutputStream((OutputStream)out), false, true, zip.booleanValue(), this.executor);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String occurrenceSensitiveDownload(DownloadRequestParams requestParams, String apiKey, String ip, boolean fromIndex, boolean zip, HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.afterInitialisation();
        if (this.shouldPerformOperation(apiKey, response, false)) {
            String string = ip = ip == null ? this.getIPAddress(request) : ip;
            if (requestParams.getQ().isEmpty() && requestParams.getFormattedQuery().isEmpty()) {
                return null;
            }
            try {
                ServletOutputStream out = response.getOutputStream();
                this.downloadService.writeQueryToStream(requestParams, response, ip, (OutputStream)new CloseShieldOutputStream((OutputStream)out), true, fromIndex, zip, this.executor);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private String getIPAddress(HttpServletRequest request) {
        String forwardedFor = request.getHeader("X-Forwarded-For");
        return forwardedFor == null ? request.getRemoteAddr() : forwardedFor;
    }

    @RequestMapping(value={"/occurrences/nearest"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> nearestOccurrence(SpatialSearchRequestParams requestParams) throws Exception {
        this.afterInitialisation();
        logger.debug((Object)String.format("Received lat: %f, lon:%f, radius:%f", requestParams.getLat(), requestParams.getLon(), requestParams.getRadius()));
        if (requestParams.getLat() == null || requestParams.getLon() == null) {
            return new HashMap<String, Object>();
        }
        requestParams.setDir("asc");
        requestParams.setFacet(Boolean.valueOf(false));
        SearchResultDTO searchResult = this.searchDAO.findByFulltextSpatialQuery(requestParams, null);
        List ocs = searchResult.getOccurrences();
        if (!ocs.isEmpty()) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            OccurrenceIndex oc = (OccurrenceIndex)ocs.get(0);
            Double decimalLatitude = oc.getDecimalLatitude();
            Double decimalLongitude = oc.getDecimalLongitude();
            Double distance = this.distInMetres(Double.valueOf(requestParams.getLat().doubleValue()), Double.valueOf(requestParams.getLon().doubleValue()), decimalLatitude, decimalLongitude);
            results.put("distanceInMeters", distance);
            results.put("occurrence", oc);
            return results;
        }
        return new HashMap<String, Object>();
    }

    private Double distInMetres(Double lat1, Double lon1, Double lat2, Double lon2) {
        Double R = 6371000.0;
        Double dLat = Math.toRadians(lat2 - lat1);
        Double dLon = Math.toRadians(lon2 - lon1);
        Double lat1Rad = Math.toRadians(lat1);
        Double lat2Rad = Math.toRadians(lat2);
        Double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(lat1Rad) * Math.cos(lat2Rad);
        Double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return R * c;
    }

    @RequestMapping(value={"/occurrences/coordinates*"})
    public void dumpDistinctLatLongs(SearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        requestParams.setFacets(new String[]{"lat_long"});
        if (requestParams.getQ().length() < 1) {
            requestParams.setQ("*:*");
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            this.searchDAO.writeCoordinatesToStream(requestParams, (OutputStream)out);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/occurrence/compare/{uuid}.json", "/occurrence/compare/{uuid}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object showOccurrence(@PathVariable(value="uuid") String uuid) {
        this.afterInitialisation();
        Map values = OccurrenceUtils.getComparisonByUuid((String)uuid);
        if (values.isEmpty()) {
            values = OccurrenceUtils.getComparisonByUuid((String)uuid);
        }
        if (values.containsKey("Occurrence")) {
            List compareList = (List)values.get("Occurrence");
            ArrayList<ProcessedValue> newList = new ArrayList<ProcessedValue>();
            for (ProcessedValue pv : compareList) {
                if (pv.getName().equals("recordedBy")) {
                    logger.info((Object)pv);
                    String raw = this.authService.substituteEmailAddress(pv.getRaw());
                    String processed = this.authService.substituteEmailAddress(pv.getProcessed());
                    ProcessedValue newpv = new ProcessedValue("recordedBy", raw, processed);
                    newList.add(newpv);
                    continue;
                }
                newList.add(pv);
            }
            values.put("Occurrence", newList);
        }
        return values;
    }

    @RequestMapping(value={"/occurrence/compare*"}, method={RequestMethod.GET})
    @ResponseBody
    public Object compareOccurrenceVersions(@RequestParam(value="uuid", required=true) String uuid) {
        this.afterInitialisation();
        return this.showOccurrence(uuid);
    }

    @RequestMapping(value={"/occurrence/deleted"}, method={RequestMethod.GET})
    @ResponseBody
    public String[] getDeleteOccurrences(@RequestParam(value="date", required=true) String fromDate, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        String[] deletedRecords = new String[]{};
        try {
            Date date = DateUtils.parseDate((String)fromDate, (String[])new String[]{"yyyy-MM-dd"});
            deletedRecords = Store.getDeletedRecords((Date)date);
            if (deletedRecords == null) {
                deletedRecords = new String[]{};
            }
        }
        catch (ParseException e) {
            response.sendError(400, "Invalid date format.  Please provide date as yyyy-MM-dd.");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(500, "Problem retrieving details of deleted records.");
        }
        return deletedRecords;
    }

    @RequestMapping(value={"/occurrence/{dataResourceUid}"}, method={RequestMethod.POST})
    @ResponseBody
    public Object uploadSingleRecord(@PathVariable String dataResourceUid, @RequestParam(value="apiKey", required=true) String apiKey, @RequestParam(value="index", required=true, defaultValue="true") Boolean index, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        boolean apiKeyValid = this.shouldPerformOperation(request, response);
        if (!apiKeyValid) {
            return null;
        }
        try {
            ObjectMapper om = new ObjectMapper();
            Map properties = (Map)om.readValue((InputStream)request.getInputStream(), Map.class);
            List multimedia = (List)properties.remove("multimedia");
            HashMap darwinCore = new HashMap();
            for (Map.Entry entry : properties.entrySet()) {
                darwinCore.put(entry.getKey(), entry.getValue().toString());
            }
            FullRecord occurrence = Store.upsertRecord((String)dataResourceUid, darwinCore, (List)multimedia, (boolean)index);
            response.setContentType("application/json");
            response.setHeader("Location", this.webservicesRoot + "/occurrence/" + occurrence.getRowKey());
            response.setStatus(201);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("occurrenceID", occurrence.getRowKey());
            map.put("images", occurrence.getOccurrence().getImages());
            return map;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"/occurrence/{uuid:.+}", "/occurrences/{uuid:.+}", "/occurrence/{uuid:.+}.json", "/occurrences/{uuid:.+}.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Object showOccurrence(@PathVariable(value="uuid") String uuid, @RequestParam(value="apiKey", required=false) String apiKey, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="im", required=false) String im, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        String string = ip = ip == null ? this.getIPAddress(request) : ip;
        if (apiKey != null) {
            return this.showSensitiveOccurrence(uuid, apiKey, ip, im, request, response);
        }
        return this.getOccurrenceInformation(uuid, ip, im, request, false);
    }

    @RequestMapping(value={"/sensitive/occurrence/{uuid:.+}", "/sensitive/occurrences/{uuid:.+}", "/sensitive/occurrence/{uuid:.+}.json", "/senstive/occurrences/{uuid:.+}.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Object showSensitiveOccurrence(@PathVariable(value="uuid") String uuid, @RequestParam(value="apiKey", required=true) String apiKey, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="im", required=false) String im, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        String string = ip = ip == null ? this.getIPAddress(request) : ip;
        if (this.shouldPerformOperation(apiKey, response)) {
            return this.getOccurrenceInformation(uuid, ip, im, request, true);
        }
        return null;
    }

    private Object getOccurrenceInformation(String uuid, String ip, String im, HttpServletRequest request, boolean includeSensitive) throws Exception {
        SpatialSearchRequestParams srp;
        logger.debug((Object)("Retrieving occurrence record with guid: '" + uuid + "'"));
        FullRecord[] fullRecord = OccurrenceUtils.getAllVersionsByUuid((String)uuid, (Boolean)includeSensitive);
        if (fullRecord == null) {
            srp = new SpatialSearchRequestParams();
            srp.setQ("id:" + uuid);
            srp.setPageSize(Integer.valueOf(1));
            srp.setFacets(new String[0]);
            SearchResultDTO results = this.occurrenceSearch(srp);
            if (results.getTotalRecords() > 0L) {
                fullRecord = OccurrenceUtils.getAllVersionsByUuid((String)((OccurrenceIndex)results.getOccurrences().get(0)).getUuid(), (Boolean)includeSensitive);
            }
        }
        if (fullRecord == null) {
            srp = new SpatialSearchRequestParams();
            srp.setQ("occurrence_id:" + uuid);
            SearchResultDTO result = this.occurrenceSearch(srp);
            if (result.getTotalRecords() > 1L) {
                return result;
            }
            if (result.getTotalRecords() == 0L) {
                return new OccurrenceDTO();
            }
            fullRecord = OccurrenceUtils.getAllVersionsByUuid((String)((OccurrenceIndex)result.getOccurrences().get(0)).getUuid(), (Boolean)includeSensitive);
        }
        OccurrenceDTO occ = new OccurrenceDTO(fullRecord);
        if (fullRecord != null) {
            fullRecord[0].getOccurrence().setRecordedBy(this.authService.substituteEmailAddress(fullRecord[0].getOccurrence().getRecordedBy()));
            fullRecord[1].getOccurrence().setRecordedBy(this.authService.substituteEmailAddress(fullRecord[1].getOccurrence().getRecordedBy()));
            Map miscProps = fullRecord[0].miscProperties();
            for (Map.Entry entry : miscProps.entrySet()) {
                if (!((String)entry.getValue()).contains("@")) continue;
                entry.setValue(this.authService.substituteEmailAddress((String)entry.getValue()));
            }
            if (fullRecord[0].getOccurrence().getUserId() != null) {
                occ.setAlaUserName(this.authService.getDisplayNameFor(fullRecord[0].getOccurrence().getUserId()));
            } else if (fullRecord[1].getOccurrence().getUserId() != null) {
                occ.setAlaUserName(this.authService.getDisplayNameFor(fullRecord[1].getOccurrence().getUserId()));
            }
        }
        occ.setSystemAssertions(Store.getAllSystemAssertions((String)occ.getRaw().getRowKey()));
        occ.setUserAssertions(this.assertionUtils.getUserAssertions(occ));
        List soundDtos = this.getSoundDtos(occ);
        if (!soundDtos.isEmpty()) {
            occ.setSounds(soundDtos);
        }
        this.setupImageUrls(occ, im == null || !im.equalsIgnoreCase("false"));
        Config.mediaStore().convertPathsToUrls(occ.getRaw(), this.biocacheMediaUrl);
        Config.mediaStore().convertPathsToUrls(occ.getProcessed(), this.biocacheMediaUrl);
        this.logViewEvent(ip, occ, null, "Viewing Occurrence Record " + uuid);
        return occ;
    }

    private void logViewEvent(String ip, OccurrenceDTO occ, String email, String reason) {
        ConcurrentHashMap<String, AtomicInteger> uidStats = new ConcurrentHashMap<String, AtomicInteger>();
        if (occ.getProcessed() != null && occ.getProcessed().getAttribution() != null) {
            if (occ.getProcessed().getAttribution().getCollectionUid() != null) {
                uidStats.put(occ.getProcessed().getAttribution().getCollectionUid(), new AtomicInteger(1));
            }
            if (occ.getProcessed().getAttribution().getInstitutionUid() != null) {
                uidStats.put(occ.getProcessed().getAttribution().getInstitutionUid(), new AtomicInteger(1));
            }
            if (occ.getProcessed().getAttribution().getDataProviderUid() != null) {
                uidStats.put(occ.getProcessed().getAttribution().getDataProviderUid(), new AtomicInteger(1));
            }
            if (occ.getProcessed().getAttribution().getDataResourceUid() != null) {
                uidStats.put(occ.getProcessed().getAttribution().getDataResourceUid(), new AtomicInteger(1));
            }
        }
        if (uidStats != null) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String key : uidStats.keySet()) {
                if (((AtomicInteger)uidStats.get(key)).get() >= 0) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                uidStats.remove(key);
            }
        }
        LogEventVO vo = new LogEventVO(LogEventType.OCCURRENCE_RECORDS_VIEWED, email, reason, ip, uidStats);
        logger.log((Priority)RestLevel.REMOTE, (Object)vo);
    }

    private String getValidationErrorMessage(BindingResult result) {
        StringBuilder sb = new StringBuilder();
        List errors = result.getAllErrors();
        for (ObjectError error : errors) {
            logger.debug((Object)("Code: " + error.getCode()));
            logger.debug((Object)StringUtils.join((Object[])error.getCodes(), (String)"@#$^"));
            String code = error.getCodes() != null && error.getCodes().length > 0 ? error.getCodes()[0] : null;
            logger.debug((Object)("The code in use:" + code));
            sb.append(this.messageSource.getMessage(code, null, error.getDefaultMessage(), null)).append("<br/>");
        }
        return sb.toString();
    }

    private List<MediaDTO> getSoundDtos(OccurrenceDTO occ) {
        String[] sounds = occ.getProcessed().getOccurrence().getSounds();
        ArrayList<MediaDTO> soundDtos = new ArrayList<MediaDTO>();
        if (sounds != null && sounds.length > 0) {
            for (String soundFile : sounds) {
                MediaDTO m = new MediaDTO();
                Map mimeToUrl = Config.mediaStore().getSoundFormats(soundFile);
                for (String mimeType : mimeToUrl.keySet()) {
                    m.getAlternativeFormats().put(mimeType, mimeToUrl.get(mimeType));
                }
                soundDtos.add(m);
            }
        }
        return soundDtos;
    }

    private void setupImageUrls(OccurrenceDTO dto, boolean lookupImageMetadata) {
        String[] images = dto.getProcessed().getOccurrence().getImages();
        if (images != null && images.length > 0) {
            ArrayList<MediaDTO> ml = new ArrayList<MediaDTO>();
            HashMap<String, Map> metadata = new HashMap<String, Map>();
            if (lookupImageMetadata) {
                try {
                    String uuid = dto.getProcessed().getRowKey();
                    List list = (List)this.imageMetadataService.getImageMetadataForOccurrences(Arrays.asList(uuid)).get(uuid);
                    if (list != null) {
                        for (Map m : list) {
                            metadata.put(String.valueOf(m.get("imageId")), m);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (String fileNameOrID : images) {
                try {
                    MediaDTO m = new MediaDTO();
                    Map urls = Config.mediaStore().getImageFormats(fileNameOrID);
                    m.getAlternativeFormats().put("thumbnailUrl", urls.get("thumb"));
                    m.getAlternativeFormats().put("smallImageUrl", urls.get("small"));
                    m.getAlternativeFormats().put("largeImageUrl", urls.get("large"));
                    m.getAlternativeFormats().put("imageUrl", urls.get("raw"));
                    m.setFilePath(fileNameOrID);
                    m.setMetadataUrl(this.imageMetadataService.getUrlFor(fileNameOrID));
                    if (metadata != null && metadata.get(fileNameOrID) != null) {
                        m.setMetadata((Map)metadata.get(fileNameOrID));
                    }
                    ml.add(m);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Unable to get image data for " + fileNameOrID + ": " + ex.getMessage()));
                }
            }
            dto.setImages(ml);
        }
    }

    @RequestMapping(value={"occurrence/pivot"})
    @ResponseBody
    public List<FacetPivotResultDTO> searchPivot(SpatialSearchRequestParams searchParams, @RequestParam(value="apiKey", required=true) String apiKey, HttpServletResponse response) throws Exception {
        this.afterInitialisation();
        if (this.isValidKey(apiKey)) {
            return this.searchDAO.searchPivot(searchParams);
        }
        response.sendError(403, "An invalid API Key was provided.");
        return null;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ CountDownLatch access$100(OccurrenceController x0) {
        return x0.initialisationLatch;
    }
}

