/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.cas.util.AuthenticationUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocumentList;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DownloadController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(DownloadController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected PersistentQueueDAO persistentQueueDAO;
    @Inject
    protected AuthService authService;
    @Value(value="${webservices.root:http://localhost:8080/biocache-service}")
    protected String webservicesRoot;
    @Value(value="${download.url:http://biocache.ala.org.au/biocache-download}")
    protected String biocacheDownloadUrl;
    @Value(value="${download.dir:/data/biocache-download}")
    protected String biocacheDownloadDir;
    @Value(value="${download.auth.sensitive:false}")
    protected Boolean downloadAuthSensitive;
    @Value(value="${sensitiveAccessRoles:{\n\n\"ROLE_SDS_ACT\" : \"sensitive:\\\"generalised\\\" AND (cl927:\\\"Australian Captial Territory\\\" OR cl927:\\\"Jervis Bay Territory\\\") AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\"\n\"ROLE_SDS_NSW\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"New South Wales (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_NZ\" : \"sensitive:\\\"generalised\\\" AND (data_resource_uid:dr2707 OR data_resource_uid:dr812 OR data_resource_uid:dr814 OR data_resource_uid:dr808 OR data_resource_uid:dr806 OR data_resource_uid:dr815 OR data_resource_uid:dr802 OR data_resource_uid:dr805 OR data_resource_uid:dr813) AND -cl927:* AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_NT\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Northern Territory (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_QLD\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Queensland (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_SA\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"South Australia (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_TAS\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Tasmania (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_VIC\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Victoria (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_WA\" : \"sensitive:\\\"generalised\\\" AND cl927:\\\"Western Australia (including Coastal Waters)\\\" AND -(data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\",\n\"ROLE_SDS_BIRDLIFE\" : \"sensitive:\\\"generalised\\\" AND (data_resource_uid:dr359 OR data_resource_uid:dr571 OR data_resource_uid:dr570)\"\n\n}}")
    protected String sensitiveAccessRoles;
    @Value(value="${download.offline.max.url:http://downloads.ala.org.au}")
    protected String dowloadOfflineMaxUrl = "http://downloads.ala.org.au";
    @Value(value="${download.offline.max.size:100000000}")
    protected Integer dowloadOfflineMaxSize = 100000000;
    @Value(value="${download.offline.msg:Too many records requested. Bulk download files for Lifeforms are available.}")
    protected String downloadOfflineMsg = "Too many records requested. Bulk download files for Lifeforms are available.";

    @RequestMapping(value={"occurrences/offline/download/stats"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DownloadDetailsDTO> getCurrentDownloads(HttpServletResponse response, @RequestParam(value="apiKey", required=true) String apiKey) throws Exception {
        if (apiKey != null && this.shouldPerformOperation(apiKey, response, false)) {
            return this.persistentQueueDAO.getAllDownloads();
        }
        return null;
    }

    @RequestMapping(value={"occurrences/offline/{type}/download*"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Object occurrenceDownload(DownloadRequestParams requestParams, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="apiKey", required=false) String apiKey, @PathVariable(value="type") String type, HttpServletResponse response, HttpServletRequest request) throws Exception {
        DownloadDetailsDTO.DownloadType downloadType = "index".equals(type.toLowerCase()) ? DownloadDetailsDTO.DownloadType.RECORDS_INDEX : DownloadDetailsDTO.DownloadType.RECORDS_DB;
        return this.download(requestParams, ip, apiKey, response, request, downloadType);
    }

    @RequestMapping(value={"occurrences/offline/download*"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Object occurrenceDownload(DownloadRequestParams requestParams, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="apiKey", required=false) String apiKey, HttpServletResponse response, HttpServletRequest request) throws Exception {
        if (StringUtils.isEmpty((String)requestParams.getEmail())) {
            response.sendError(400, "Required parameter 'email' is not present");
        }
        boolean hasDBColumn = requestParams.getIncludeMisc();
        String fields = requestParams.getFields() + "," + requestParams.getExtra();
        if (fields.length() > 1) {
            Set indexedFields = this.searchDAO.getIndexedFields();
            for (String column : fields.split(",")) {
                for (IndexFieldDTO field : indexedFields) {
                    if (field.isStored() || field.getDownloadName() == null || !field.getDownloadName().equals(column)) continue;
                    hasDBColumn = true;
                    break;
                }
                if (hasDBColumn) break;
            }
        }
        DownloadDetailsDTO.DownloadType downloadType = hasDBColumn ? DownloadDetailsDTO.DownloadType.RECORDS_DB : DownloadDetailsDTO.DownloadType.RECORDS_INDEX;
        return this.download(requestParams, ip, apiKey, response, request, downloadType);
    }

    private Object download(DownloadRequestParams requestParams, String ip, String apiKey, HttpServletResponse response, HttpServletRequest request, DownloadDetailsDTO.DownloadType downloadType) throws Exception {
        boolean sensitive = false;
        if (apiKey != null) {
            if (this.shouldPerformOperation(apiKey, response, false)) {
                sensitive = true;
            }
        } else if (StringUtils.isEmpty((String)requestParams.getEmail())) {
            response.sendError(412, "Unable to perform an offline download without an email address");
        }
        String sensitiveFq = null;
        if (!sensitive) {
            sensitiveFq = this.getSensitiveFq(request);
        }
        ip = ip == null ? request.getRemoteAddr() : ip;
        DownloadDetailsDTO dd = new DownloadDetailsDTO(requestParams, ip, downloadType);
        dd.setIncludeSensitive(sensitive);
        dd.setSensitiveFq(sensitiveFq);
        requestParams.setPageSize(Integer.valueOf(0));
        requestParams.setFacet(Boolean.valueOf(false));
        SolrDocumentList result = this.searchDAO.findByFulltext((SpatialSearchRequestParams)requestParams);
        dd.setTotalRecords(result.getNumFound());
        LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
        DownloadDetailsDTO d = this.persistentQueueDAO.isInQueue(dd);
        if (d != null) {
            status.put("message", "Already in queue.");
            status.put("status", "inQueue");
            status.put("queueSize", this.persistentQueueDAO.getTotalDownloads());
            status.put("statusUrl", this.webservicesRoot + "/occurrences/offline/status/" + dd.getUniqueId());
        } else if (dd.getTotalRecords() >= (long)this.dowloadOfflineMaxSize.intValue()) {
            File file = new File(this.biocacheDownloadDir + File.separator + UUID.nameUUIDFromBytes(dd.getEmail().getBytes()) + File.separator + dd.getStartTime() + File.separator + "tooLarge");
            FileUtils.forceMkdir((File)file.getParentFile());
            FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8");
            status.put("status", "skipped");
            status.put("message", this.downloadOfflineMsg);
        } else {
            this.persistentQueueDAO.addDownloadToQueue(dd);
            status.put("status", "inQueue");
            status.put("queueSize", this.persistentQueueDAO.getTotalDownloads());
            status.put("statusUrl", this.webservicesRoot + "/occurrences/offline/status/" + dd.getUniqueId());
        }
        return status;
    }

    @RequestMapping(value={"occurrences/offline/status"}, method={RequestMethod.GET})
    @ResponseBody
    public Object allOccurrenceDownloadStatus() throws Exception {
        ArrayList allStatus = new ArrayList();
        Map userIdLookup = this.authService.getMapOfEmailToId();
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
            String id = dd.getUniqueId();
            if (dd.getFileLocation() == null) {
                status.put("status", "inQueue");
            } else {
                status.put("status", "running");
                status.put("records", dd.getRecordsDownloaded());
            }
            status.put("id", id);
            status.put("totalRecords", dd.getTotalRecords());
            status.put("downloadParams", dd.getDownloadParams());
            status.put("startDate", dd.getStartDateString());
            status.put("thread", dd.getProcessingThreadName());
            if (userIdLookup != null) {
                status.put("userId", this.authService.getMapOfEmailToId().get(dd.getEmail()));
            }
            status.put("statusUrl", this.webservicesRoot + "/occurrences/offline/status/" + id);
            this.setStatusIfEmpty(id, status);
            allStatus.add(status);
        }
        return allStatus;
    }

    @RequestMapping(value={"occurrences/offline/status/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object occurrenceDownloadStatus(@PathVariable(value="id") String id) throws Exception {
        LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            if (!id.equals(dd.getUniqueId())) continue;
            if (dd.getFileLocation() == null) {
                status.put("status", "inQueue");
            } else {
                status.put("status", "running");
                status.put("records", dd.getRecordsDownloaded());
            }
            status.put("totalRecords", dd.getTotalRecords());
            if (this.authService.getMapOfEmailToId() != null) {
                status.put("userId", this.authService.getMapOfEmailToId().get(dd.getEmail()));
            }
            status.put("statusUrl", this.webservicesRoot + "/occurrences/offline/status/" + id);
            break;
        }
        this.setStatusIfEmpty(id, status);
        return status;
    }

    private void setStatusIfEmpty(String id, Map<String, Object> status) throws UnsupportedEncodingException {
        if (!status.containsKey("status")) {
            int sep = id.lastIndexOf(45);
            File dir = new File(this.biocacheDownloadDir + File.separator + id.substring(0, sep) + File.separator + id.substring(sep + 1));
            if (dir.isDirectory() && dir.exists()) {
                for (File file : dir.listFiles()) {
                    if (file.isFile() && file.getPath().endsWith(".zip") && file.length() > 0L) {
                        status.put("status", "finished");
                        status.put("downloadUrl", this.biocacheDownloadUrl + File.separator + URLEncoder.encode(file.getPath().replace(this.biocacheDownloadDir + "/", ""), "UTF-8").replace("%2F", "/").replace("+", "%20"));
                    }
                    if (!file.isFile() || !"tooLarge".equals(file.getName())) continue;
                    status.put("status", "skipped");
                    status.put("message", this.downloadOfflineMsg);
                    status.put("downloadUrl", this.dowloadOfflineMaxUrl);
                }
                if (!status.containsKey("status")) {
                    status.put("status", "failed");
                }
            }
        }
        if (!status.containsKey("status")) {
            status.put("status", "invalidId");
        }
    }

    @RequestMapping(value={"occurrences/offline/cancel/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object occurrenceDownloadCancel(@PathVariable(value="id") String id, HttpServletResponse response, @RequestParam(value="apiKey", required=true) String apiKey) throws Exception {
        if (apiKey == null || !this.shouldPerformOperation(apiKey, response, false)) {
            return null;
        }
        LinkedHashMap<String, String> status = new LinkedHashMap<String, String>();
        List downloads = this.persistentQueueDAO.getAllDownloads();
        for (DownloadDetailsDTO dd : downloads) {
            if (!id.equals(dd.getUniqueId())) continue;
            this.persistentQueueDAO.removeDownloadFromQueue(dd);
            status.put("cancelled", "true");
            status.put("status", "notInQueue");
            break;
        }
        if (!status.containsKey("status")) {
            status.put("cancelled", "false");
            status.put("status", "notInQueue");
        }
        return status;
    }

    private String getSensitiveFq(HttpServletRequest request) throws ParseException {
        if (!this.isValidKey(request.getHeader("apiKey")) || !this.downloadAuthSensitive.booleanValue()) {
            return null;
        }
        String sensitiveFq = "";
        JSONParser jp = new JSONParser();
        JSONObject jo = (JSONObject)jp.parse(this.sensitiveAccessRoles);
        List roles = this.authService.getUserRoles(request.getHeader("X-ALA-userId"));
        for (Object role : jo.keySet()) {
            if (!roles.contains(role)) continue;
            if (sensitiveFq.length() > 0) {
                sensitiveFq = sensitiveFq + " OR ";
            }
            sensitiveFq = sensitiveFq + "(" + jo.get(role) + ")";
        }
        if (sensitiveFq.length() == 0) {
            return null;
        }
        logger.debug((Object)("sensitiveOnly download requested for user: " + AuthenticationUtils.getUserId((HttpServletRequest)request) + ", using fq: " + sensitiveFq));
        return sensitiveFq;
    }
}

