/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.dto.ContactDTO;
import au.org.ala.biocache.dto.OccurrenceDTO;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.ValidationRule;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.util.ContactUtils;
import au.org.ala.biocache.util.OccurrenceUtils;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component(value="assertionUtils")
public class AssertionUtils {
    @Inject
    protected AuthService authService;
    @Inject
    protected ContactUtils contactUtils;

    public List<QualityAssertion> getUserAssertions(String recordUuid) {
        FullRecord[] fr = OccurrenceUtils.getAllVersionsByUuid((String)recordUuid, (Boolean)false);
        OccurrenceDTO occ = new OccurrenceDTO(fr);
        return this.getUserAssertions(occ);
    }

    public ValidationRule[] getQueryAssertions(String recordUuid) {
        ValidationRule[] aqs;
        FullRecord[] fr = OccurrenceUtils.getAllVersionsByUuid((String)recordUuid, (Boolean)false);
        OccurrenceDTO occ = new OccurrenceDTO(fr);
        Map queryAssertionMap = occ.getProcessed().getQueryAssertions();
        for (ValidationRule ua : aqs = Store.getValidationRules((String[])queryAssertionMap.keySet().toArray(new String[0]))) {
            if (ua.getUserId() == null && ua.getUserName().contains("@")) {
                String email = ua.getUserName();
                String userId = (String)this.authService.getMapOfEmailToId().get(ua.getUserName());
                ua.setUserEmail(email);
                ua.setUserId(userId);
            }
            String userName = (String)this.authService.getMapOfAllUserNamesByNumericId().get(ua.getUserId());
            ua.setUserName(userName);
        }
        return aqs;
    }

    public List<QualityAssertion> getUserAssertions(OccurrenceDTO occ) {
        if (occ.getRaw() != null) {
            List userAssertions = Store.getUserAssertions((String)occ.getRaw().getRowKey());
            for (QualityAssertion ua : userAssertions) {
                if (!ua.getUserId().contains("@")) continue;
                String email = ua.getUserId();
                String userId = (String)this.authService.getMapOfEmailToId().get(email);
                ua.setUserEmail(email);
                ua.setUserId(userId);
            }
            for (QualityAssertion ua : userAssertions) {
                this.enhanceQA(occ, ua);
            }
            return userAssertions;
        }
        return null;
    }

    public QualityAssertion enhanceQA(OccurrenceDTO occ, QualityAssertion ua) {
        String email = ua.getUserEmail();
        ContactDTO contact = this.contactUtils.getContactForEmailAndUid(email, occ.getProcessed().getAttribution().getCollectionUid());
        if (contact != null) {
            ua.setUserRole(contact.getRole());
            ua.setUserEntityName(occ.getProcessed().getAttribution().getCollectionName());
            ua.setUserEntityUid(occ.getProcessed().getAttribution().getCollectionUid());
        }
        return ua;
    }

    public QualityAssertion enhanceQA(String recordUuid, QualityAssertion ua) {
        FullRecord[] fr = OccurrenceUtils.getAllVersionsByUuid((String)recordUuid, (Boolean)false);
        OccurrenceDTO occ = new OccurrenceDTO(fr);
        String email = ua.getUserEmail();
        ContactDTO contact = this.contactUtils.getContactForEmailAndUid(email, occ.getProcessed().getAttribution().getCollectionUid());
        if (contact != null) {
            ua.setUserRole(contact.getRole());
            ua.setUserEntityName(occ.getProcessed().getAttribution().getCollectionName());
            ua.setUserEntityUid(occ.getProcessed().getAttribution().getCollectionUid());
        }
        return ua;
    }

    public QualityAssertion getUserAssertion(String recordUuid, String assertionUuid) {
        QualityAssertion qa = Store.getUserAssertion((String)recordUuid, (String)assertionUuid);
        return this.enhanceQA(recordUuid, qa);
    }
}

