/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.EmailService;
import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.util.AlaFileUtils;
import au.org.ala.biocache.util.thread.DownloadControlThread;
import au.org.ala.biocache.util.thread.DownloadCreator;
import au.org.ala.biocache.writer.RecordWriterException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.ala.client.appender.RestLevel;
import org.ala.client.model.LogEventVO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="downloadService")
public class DownloadService
implements ApplicationListener<ContextClosedEvent> {
    protected static final Logger logger = Logger.getLogger(DownloadService.class);
    @Value(value="${concurrent.downloads.json:[{\"label\": \"smallSolr\", \"threads\": 4, \"maxRecords\": 50000, \"type\": \"index\", \"pollDelay\": 10, \"executionDelay\": 10, \"threadPriority\": 5}, {\"label\": \"largeSolr\", \"threads\": 1, \"maxRecords\": 100000000, \"type\": \"index\", \"pollDelay\": 100, \"executionDelay\": 100, \"threadPriority\": 1}, {\"label\": \"smallCassandra\", \"threads\": 1, \"maxRecords\": 50000, \"type\": \"db\", \"pollDelay\": 10, \"executionDelay\": 10, \"threadPriority\": 5}, {\"label\": \"defaultUnrestricted\", \"threads\": 1, \"pollDelay\": 1000, \"executionDelay\": 100, \"threadPriority\": 1}]}")
    protected String concurrentDownloadsJSON;
    @Inject
    protected PersistentQueueDAO persistentQueueDAO;
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected RestOperations restTemplate;
    @Inject
    protected ObjectMapper objectMapper;
    @Inject
    protected EmailService emailService;
    @Inject
    protected AbstractMessageSource messageSource;
    @Value(value="${webservices.root:http://localhost:8080/biocache-service}")
    protected String webservicesRoot = "http://localhost:8080/biocache-service";
    @Value(value="${citations.enabled:true}")
    protected Boolean citationsEnabled = Boolean.TRUE;
    @Value(value="${headings.enabled:true}")
    protected Boolean headingsEnabled = Boolean.TRUE;
    protected final Queue<DownloadDetailsDTO> currentDownloads = new LinkedBlockingQueue();
    @Value(value="${data.description.url:headings.csv}")
    protected String dataFieldDescriptionURL = "headings.csv";
    @Value(value="${registry.url:http://collections.ala.org.au/ws}")
    protected String registryUrl = "http://collections.ala.org.au/ws";
    @Value(value="${citations.url:http://collections.ala.org.au/ws/citations}")
    protected String citationServiceUrl = "http://collections.ala.org.au/ws/citations";
    @Value(value="${download.url:http://biocache.ala.org.au/biocache-download}")
    protected String biocacheDownloadUrl = "http://biocache.ala.org.au/biocache-download";
    @Value(value="${download.dir:/data/biocache-download}")
    protected String biocacheDownloadDir = "/data/biocache-download";
    @Value(value="${download.email.subject:ALA Occurrence Download Complete - [filename]}")
    protected String biocacheDownloadEmailSubject = "ALA Occurrence Download Complete - [filename]";
    @Value(value="${download.email.body:The download file has been generated on [date] via the search: [searchUrl]. Please download your file from [url]}")
    protected String biocacheDownloadEmailBody = "The download file has been generated on [date] via the search: [searchUrl]. Please download your file from [url]";
    @Value(value="${download.email.subject.failure:Occurrence Download Failed - [filename]}")
    protected String biocacheDownloadEmailSubjectError = "Occurrence Download Failed - [filename]";
    @Value(value="${download.email.body.error:The download has failed.}")
    protected String biocacheDownloadEmailBodyError = "The download has failed.";
    @Value(value="${download.readme.content:When using this download please use the following citation:<br><br><cite>Atlas of Living Australia occurrence download at <a href='[url]'>biocache</a> accessed on [date].</cite><br><br>Data contributed by the following providers:<br><br>[dataProviders]<br><br>More information can be found at <a href='http://www.ala.org.au/about-the-atlas/terms-of-use/citing-the-atlas/'>citing the ALA</a>.}")
    protected String biocacheDownloadReadme = "When using this download please use the following citation:<br><br><cite>Atlas of Living Australia occurrence download at <a href='[url]'>biocache</a> accessed on [date].</cite><br><br>Data contributed by the following providers:<br><br>[dataProviders]<br><br>More information can be found at <a href='http://www.ala.org.au/about-the-atlas/terms-of-use/citing-the-atlas/'>citing the ALA</a>.";
    @Value(value="${biocache.ui.url:http://biocache.ala.org.au}")
    protected String biocacheUiUrl = "http://biocache.ala.org.au";
    @Value(value="${download.offline.parallelquery.maxthreads:30}")
    protected Integer maxOfflineParallelQueryDownloadThreads = 30;
    @Value(value="${zip.file.size.mb.max:4000}")
    private Integer maxMB;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final CountDownLatch initialisationLatch = new CountDownLatch(1);
    private final Queue<Thread> runningDownloadControllers = new LinkedBlockingQueue();
    private final Queue<DownloadControlThread> runningDownloadControlRunnables = new LinkedBlockingQueue();
    private volatile ExecutorService offlineParallelQueryExecutor;

    protected final void afterInitialisation() {
        try {
            this.initialisationLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @PostConstruct
    public void init() {
        if (this.initialised.compareAndSet(false, true)) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    protected DownloadCreator getNewDownloadCreator() {
        return new DownloadCreatorImpl(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getOfflineThreadPoolExecutor() {
        ExecutorService nextExecutor = this.offlineParallelQueryExecutor;
        if (nextExecutor == null) {
            DownloadService downloadService = this;
            synchronized (downloadService) {
                nextExecutor = this.offlineParallelQueryExecutor;
                if (nextExecutor == null) {
                    nextExecutor = this.offlineParallelQueryExecutor = Executors.newFixedThreadPool(this.getMaxOfflineParallelDownloadThreads(), new ThreadFactoryBuilder().setNameFormat("biocache-query-offline-%d").setPriority(1).build());
                }
            }
        }
        return nextExecutor;
    }

    private int getMaxOfflineParallelDownloadThreads() {
        return this.maxOfflineParallelQueryDownloadThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextClosedEvent event) {
        this.afterInitialisation();
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.persistentQueueDAO.shutdown();
            }
            finally {
                DownloadControlThread nextToCloseRunnable = null;
                while ((nextToCloseRunnable = (DownloadControlThread)this.runningDownloadControlRunnables.poll()) != null) {
                    nextToCloseRunnable.shutdown();
                }
                Thread nextToCloseThread = null;
                ArrayList<Thread> toJoinThreads = new ArrayList<Thread>();
                while ((nextToCloseThread = (Thread)this.runningDownloadControllers.poll()) != null) {
                    if (!nextToCloseThread.isAlive()) continue;
                    nextToCloseThread.interrupt();
                    toJoinThreads.add(nextToCloseThread);
                }
                if (!toJoinThreads.isEmpty()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    public DownloadDetailsDTO registerDownload(DownloadRequestParams requestParams, String ip, DownloadDetailsDTO.DownloadType type) {
        this.afterInitialisation();
        DownloadDetailsDTO dd = new DownloadDetailsDTO(requestParams, ip, type);
        dd.setRequestParams(requestParams);
        this.currentDownloads.add(dd);
        return dd;
    }

    public void unregisterDownload(DownloadDetailsDTO dd) {
        this.afterInitialisation();
        this.currentDownloads.remove(dd);
        this.persistentQueueDAO.removeDownloadFromQueue(dd);
    }

    public List<DownloadDetailsDTO> getCurrentDownloads() {
        this.afterInitialisation();
        ArrayList result = new ArrayList(this.currentDownloads);
        return Collections.unmodifiableList(result);
    }

    @Deprecated
    public void writeQueryToStream(DownloadDetailsDTO dd, DownloadRequestParams requestParams, String ip, OutputStream out, boolean includeSensitive, boolean fromIndex, boolean limit, boolean zip) throws Exception {
        this.afterInitialisation();
        this.writeQueryToStream(dd, requestParams, ip, out, includeSensitive, fromIndex, limit, zip, this.getOfflineThreadPoolExecutor());
    }

    public void writeQueryToStream(DownloadDetailsDTO dd, DownloadRequestParams requestParams, String ip, OutputStream out, boolean includeSensitive, boolean fromIndex, boolean limit, boolean zip, ExecutorService parallelExecutor) throws Exception {
        block39: {
            this.afterInitialisation();
            String filename = requestParams.getFile();
            String originalParams = requestParams.toString();
            boolean shuttingDown = false;
            try (OptionalZipOutputStream sp = new OptionalZipOutputStream(zip ? OptionalZipOutputStream.Type.zipped : OptionalZipOutputStream.Type.unzipped, (OutputStream)new CloseShieldOutputStream(out), this.maxMB);){
                String suffix = requestParams.getFileType().equals("shp") ? "csv" : requestParams.getFileType();
                sp.putNextEntry(filename + "." + suffix);
                if ("all".equals(requestParams.getQa())) {
                    requestParams.setFacets(new String[]{"assertions", "data_resource_uid"});
                } else {
                    requestParams.setFacets(new String[]{"data_resource_uid"});
                }
                ConcurrentMap uidStats = null;
                uidStats = fromIndex ? this.searchDAO.writeResultsFromIndexToStream(requestParams, (OutputStream)sp, includeSensitive, dd, limit, parallelExecutor) : this.searchDAO.writeResultsToStream(requestParams, (OutputStream)sp, 100, includeSensitive, dd, limit);
                sp.closeEntry();
                if (uidStats == null || uidStats.isEmpty()) break block39;
                if (dd.getHeaderMap() != null) {
                    sp.putNextEntry("Shape-README.html");
                    sp.write("The name of features is limited to 10 characters. Listed below are the mappings of feature name to download field:".getBytes());
                    sp.write("<table><td><b>Feature</b></td><td><b>Download Field<b></td>".getBytes());
                    for (String key : dd.getHeaderMap().keySet()) {
                        sp.write(("<tr><td>" + key + "</td><td>" + (String)dd.getHeaderMap().get(key) + "</td></tr>").getBytes());
                    }
                    sp.write("</table>".getBytes());
                }
                ArrayList citationsForReadme = new ArrayList();
                if (this.citationsEnabled.booleanValue()) {
                    sp.putNextEntry("citation.csv");
                    try {
                        this.getCitations(uidStats, (OutputStream)sp, requestParams.getSep().charValue(), requestParams.getEsc().charValue(), citationsForReadme);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    sp.closeEntry();
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not adding citation. Enabled: " + this.citationsEnabled + " uids: " + uidStats));
                }
                if (dd.getRequestParams() == null) {
                    dd.setRequestParams(requestParams);
                }
                if (dd.getFileLocation() == null) {
                    dd.setFileLocation(this.generateSearchUrl(dd.getRequestParams()));
                }
                sp.putNextEntry("README.html");
                String dataProviders = "<ul><li>" + StringUtils.join(citationsForReadme, (String)"</li><li>") + "</li></ul>";
                String fileLocation = dd.getFileLocation().replace(this.biocacheDownloadDir, this.biocacheDownloadUrl);
                String readmeContent = this.biocacheDownloadReadme.replace("[url]", fileLocation).replace("[date]", dd.getStartDateString()).replace("[searchUrl]", this.generateSearchUrl(dd.getRequestParams())).replace("[dataProviders]", dataProviders);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)readmeContent);
                }
                sp.write(readmeContent.getBytes());
                sp.write(("For more information about the fields that are being downloaded please consult <a href='" + this.dataFieldDescriptionURL + "'>Download Fields</a>.").getBytes());
                sp.closeEntry();
                if (this.headingsEnabled.booleanValue()) {
                    sp.putNextEntry("headings.csv");
                    try {
                        this.getHeadings(uidStats, (OutputStream)sp, requestParams, dd.getMiscFields());
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    sp.closeEntry();
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not adding header. Enabled: " + this.headingsEnabled + " uids: " + uidStats));
                }
                sp.flush();
                String sourceUrl = originalParams.contains("qid:") ? this.webservicesRoot + "?" + requestParams.toString() : this.webservicesRoot + "?" + originalParams;
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String key : uidStats.keySet()) {
                    if (((AtomicInteger)uidStats.get(key)).get() >= 0) continue;
                    toRemove.add(key);
                }
                for (String key : toRemove) {
                    uidStats.remove(key);
                }
                LogEventVO vo = new LogEventVO(1002, requestParams.getReasonTypeId(), requestParams.getSourceTypeId(), requestParams.getEmail(), requestParams.getReason(), ip, null, uidStats, sourceUrl);
                logger.log((Priority)RestLevel.REMOTE, (Object)vo);
            }
            catch (RecordWriterException e) {
                logger.error((Object)e.getMessage());
            }
            catch (InterruptedException e) {
                shuttingDown = true;
                throw e;
            }
            finally {
                if (!shuttingDown) {
                    this.unregisterDownload(dd);
                }
            }
        }
    }

    @Deprecated
    public void writeQueryToStream(DownloadRequestParams requestParams, HttpServletResponse response, String ip, OutputStream out, boolean includeSensitive, boolean fromIndex, boolean zip) throws Exception {
        this.afterInitialisation();
        this.writeQueryToStream(requestParams, response, ip, out, includeSensitive, fromIndex, zip, this.getOfflineThreadPoolExecutor());
    }

    public void writeQueryToStream(DownloadRequestParams requestParams, HttpServletResponse response, String ip, OutputStream out, boolean includeSensitive, boolean fromIndex, boolean zip, ExecutorService parallelQueryExecutor) throws Exception {
        this.afterInitialisation();
        String filename = requestParams.getFile();
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        if (zip) {
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".zip");
            response.setContentType("application/zip");
        } else {
            response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".txt");
            response.setContentType("text/plain");
        }
        DownloadDetailsDTO.DownloadType type = fromIndex ? DownloadDetailsDTO.DownloadType.RECORDS_INDEX : DownloadDetailsDTO.DownloadType.RECORDS_DB;
        DownloadDetailsDTO dd = this.registerDownload(requestParams, ip, type);
        this.writeQueryToStream(dd, requestParams, ip, (OutputStream)new CloseShieldOutputStream(out), includeSensitive, fromIndex, true, zip, parallelQueryExecutor);
    }

    public void getCitations(ConcurrentMap<String, AtomicInteger> uidStats, OutputStream out, char sep, char esc, List<String> readmeCitations) throws IOException {
        if (this.citationsEnabled.booleanValue()) {
            this.afterInitialisation();
            if (uidStats == null || uidStats.isEmpty() || out == null) {
                logger.error((Object)"Unable to generate citations: keys and/or out is null!!");
                return;
            }
            try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(out), Charset.forName("UTF-8")), sep, '\"', esc);){
                List entities = (List)this.restTemplate.postForObject(this.citationServiceUrl, uidStats.keySet(), List.class, new Object[0]);
                if (entities.size() > 0) {
                    writer.writeNext(new String[]{this.messageSource.getMessage("citation.uid", null, "UID", null), this.messageSource.getMessage("citation.name", null, "Name", null), this.messageSource.getMessage("citation.doi", null, "DOI", null), this.messageSource.getMessage("citation.citation", null, "Citation", null), this.messageSource.getMessage("citation.rights", null, "Rights", null), this.messageSource.getMessage("citation.link", null, "More Information", null), this.messageSource.getMessage("citation.dataGeneralizations", null, "Data generalisations", null), this.messageSource.getMessage("citation.informationWithheld", null, "Information withheld", null), this.messageSource.getMessage("citation.downloadLimit", null, "Download limit", null), this.messageSource.getMessage("citation.count", null, "Number of Records in Download", null)});
                    for (Map record : entities) {
                        StringBuilder sb = new StringBuilder();
                        if (record != null) {
                            String count = ((AtomicInteger)uidStats.get(record.get("uid"))).toString();
                            String[] row = new String[]{this.getOrElse(record, "uid", ""), this.getOrElse(record, "name", ""), this.getOrElse(record, "DOI", ""), this.getOrElse(record, "citation", ""), this.getOrElse(record, "rights", ""), this.getOrElse(record, "link", ""), this.getOrElse(record, "dataGeneralizations", ""), this.getOrElse(record, "informationWithheld", ""), this.getOrElse(record, "downloadLimit", ""), count};
                            writer.writeNext(row);
                            if (readmeCitations == null) continue;
                            readmeCitations.add(row[2] + " (" + row[3] + "). " + row[4]);
                            continue;
                        }
                        logger.warn((Object)("A null record was returned from the collectory citation service: " + entities));
                    }
                }
                writer.flush();
            }
        }
    }

    public void getHeadings(ConcurrentMap<String, AtomicInteger> uidStats, OutputStream out, DownloadRequestParams params, String[] miscHeaders) throws Exception {
        if (this.headingsEnabled.booleanValue()) {
            this.afterInitialisation();
            if (out == null) {
                logger.error((Object)"Unable to generate headings info: out is null!!");
                return;
            }
            try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new CloseShieldOutputStream(out), Charset.forName("UTF-8")), params.getSep().charValue(), '\"', params.getEsc().charValue());){
                Set indexedFields = this.searchDAO.getIndexedFields();
                writer.writeNext(new String[]{"Column name", "Requested field", "DwC Name", "Field name", "Field description", "Download field name", "Download field description", "More information"});
                String[] fieldsRequested = null;
                String[] headerOutput = null;
                for (Map.Entry e : uidStats.entrySet()) {
                    if (((AtomicInteger)e.getValue()).get() == -1) {
                        fieldsRequested = ((String)e.getKey()).split(",");
                        continue;
                    }
                    if (((AtomicInteger)e.getValue()).get() != -2) continue;
                    headerOutput = ((String)e.getKey()).split(",");
                }
                if (fieldsRequested != null && headerOutput != null) {
                    for (int i = 1; i < fieldsRequested.length; ++i) {
                        IndexFieldDTO ifdto = null;
                        for (IndexFieldDTO f : indexedFields) {
                            if (!fieldsRequested[i].equalsIgnoreCase(f.getDownloadName())) continue;
                            ifdto = f;
                            break;
                        }
                        if (ifdto == null) {
                            for (IndexFieldDTO f : indexedFields) {
                                if (!fieldsRequested[i].equalsIgnoreCase(f.getName())) continue;
                                ifdto = f;
                                break;
                            }
                        }
                        if (ifdto != null && StringUtils.isNotEmpty((String)headerOutput[i])) {
                            writer.writeNext(new String[]{headerOutput[i], fieldsRequested[i], ifdto.getDwcTerm() != null ? ifdto.getDwcTerm() : "", ifdto.getName() != null ? ifdto.getName() : "", ifdto.getDescription() != null ? ifdto.getDescription() : "", ifdto.getDownloadName() != null ? ifdto.getDownloadName() : "", ifdto.getDownloadDescription() != null ? ifdto.getDownloadDescription() : "", ifdto.getInfo() != null ? ifdto.getInfo() : ""});
                            continue;
                        }
                        if (!StringUtils.isNotEmpty((String)headerOutput[i])) continue;
                        String info = this.messageSource.getMessage("description." + fieldsRequested[i], null, "", null);
                        writer.writeNext(new String[]{headerOutput[i], fieldsRequested[i], "", "", "", "", "", info != null ? info : ""});
                    }
                }
                if (miscHeaders != null) {
                    String defaultDescription = this.messageSource.getMessage("description.", null, "Raw field from data provider.", null);
                    for (int i = 0; i < miscHeaders.length; ++i) {
                        writer.writeNext(new String[]{miscHeaders[i], "", "", "", "", "", this.messageSource.getMessage("description." + miscHeaders[i], null, defaultDescription, null)});
                    }
                }
                writer.flush();
            }
        }
    }

    private String getOrElse(Map<String, Object> map, String key, String value) {
        if (map.containsKey(key)) {
            return map.get(key).toString();
        }
        return value;
    }

    private String generateSearchUrl(DownloadRequestParams params) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.biocacheUiUrl + "/occurrences/search?");
        if (params.getQId() != null) {
            try {
                sb.append("qid=").append(URLEncoder.encode("" + params.getQId(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (params.getQ() != null) {
            try {
                sb.append("&q=").append(URLEncoder.encode(params.getQ(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (params.getFq().length > 0) {
            for (String fq : params.getFq()) {
                if (!StringUtils.isNotEmpty((String)fq)) continue;
                try {
                    sb.append("&fq=").append(URLEncoder.encode(fq, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isNotEmpty((String)params.getQc())) {
            try {
                sb.append("&qc=").append(URLEncoder.encode(params.getQc(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)params.getWkt())) {
            try {
                sb.append("&wkt=").append(URLEncoder.encode(params.getWkt(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (params.getLat() != null && params.getLon() != null && params.getRadius() != null) {
            sb.append("&lat=").append(params.getLat());
            sb.append("&lon=").append(params.getLon());
            sb.append("&radius=").append(params.getRadius());
        }
        return sb.toString();
    }

    private void insertMiscHeader(DownloadDetailsDTO download) {
        if (download.getMiscFields() != null && download.getMiscFields().length > 0 && download.getRequestParams() != null) {
            try {
                File unzipDir = new File(download.getFileLocation() + ".dir" + File.separator);
                unzipDir.mkdirs();
                AlaFileUtils.unzip((String)unzipDir.getPath(), (String)download.getFileLocation());
                for (File f : unzipDir.listFiles()) {
                    if (!f.getName().endsWith(".csv") && !f.getName().endsWith(".tsv") || "headings.csv".equals(f.getName())) continue;
                    try (FileReader fileReader = new FileReader(f);
                         BufferedReader bufferedReader = new BufferedReader(fileReader);){
                        File fnew = new File(f.getPath() + ".new");
                        try (FileWriter fw = new FileWriter(fnew);){
                            String line;
                            int row = 0;
                            while ((line = bufferedReader.readLine()) != null) {
                                if (row == 0) {
                                    String[] miscHeader = download.getMiscFields();
                                    if ("csv".equals(download.getRequestParams().getFileType())) {
                                        CSVReader reader = new CSVReader((Reader)new StringReader(line));
                                        String[] header = reader.readNext();
                                        reader.close();
                                        String[] newHeader = new String[header.length + miscHeader.length];
                                        if (header.length > 0) {
                                            System.arraycopy(header, 0, newHeader, 0, header.length);
                                        }
                                        if (miscHeader.length > 0) {
                                            System.arraycopy(miscHeader, 0, newHeader, header.length, miscHeader.length);
                                        }
                                        StringWriter sw = new StringWriter();
                                        try (CSVWriter writer = new CSVWriter((Writer)sw, download.getRequestParams().getSep().charValue(), '\"', download.getRequestParams().getEsc().charValue());){
                                            writer.writeNext(newHeader);
                                        }
                                        line = sw.toString();
                                    } else {
                                        for (int i = 0; i < miscHeader.length; ++i) {
                                            line = line + '\t';
                                            line = line + miscHeader[i].replace("\r", "").replace("\n", "").replace("\t", "");
                                        }
                                        line = line + '\n';
                                    }
                                } else {
                                    fw.write("\n");
                                }
                                fw.write(line);
                                ++row;
                            }
                        }
                        FileUtils.copyFile((File)fnew, (File)f);
                        fnew.delete();
                    }
                }
                FileUtils.deleteQuietly((File)new File(download.getFileLocation()));
                AlaFileUtils.createZip((String)unzipDir.getPath(), (String)download.getFileLocation());
                FileUtils.deleteDirectory((File)unzipDir);
            }
            catch (Exception e) {
                logger.error((Object)"failed to append misc header", (Throwable)e);
            }
        }
    }

    static /* synthetic */ ExecutorService access$000(DownloadService x0) {
        return x0.getOfflineThreadPoolExecutor();
    }

    static /* synthetic */ Queue access$100(DownloadService x0) {
        return x0.runningDownloadControllers;
    }

    static /* synthetic */ Queue access$200(DownloadService x0) {
        return x0.runningDownloadControlRunnables;
    }

    static /* synthetic */ CountDownLatch access$300(DownloadService x0) {
        return x0.initialisationLatch;
    }

    static /* synthetic */ void access$500(DownloadService x0, DownloadDetailsDTO x1) {
        x0.insertMiscHeader(x1);
    }

    static /* synthetic */ String access$600(DownloadService x0, DownloadRequestParams x1) {
        return x0.generateSearchUrl(x1);
    }
}

