/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.FacetDTO;
import au.org.ala.biocache.dto.FacetTheme;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.service.RestartDataService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacetThemes {
    private static String[] allFacets = new String[0];
    private static String[] allFacetsLimited = new String[0];
    private static List<FacetTheme> allThemes = (List)RestartDataService.get((Object)new FacetThemes(false), (String)"allThemes", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, ArrayList.class);
    private static LinkedHashMap<String, FacetDTO> facetsMap = new LinkedHashMap();
    private static Integer facetsMax = 4;
    private static Integer facetsDefaultMax = 0;
    private static Boolean facetDefault = true;
    private static CountDownLatch initialised = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacetThemes(String configFilePath, Set<IndexFieldDTO> indexedFields, int facetsMax, int facetsDefaultMax, boolean facetDefault) throws IOException {
        try {
            FacetThemes.facetsMax = facetsMax;
            FacetThemes.facetsDefaultMax = facetsDefaultMax;
            FacetThemes.facetDefault = facetDefault;
            if (configFilePath != null && new File(configFilePath).exists()) {
                ArrayList<FacetTheme> newThemes = new ArrayList<FacetTheme>();
                ObjectMapper om = new ObjectMapper();
                List config = (List)om.readValue(new File(configFilePath), List.class);
                for (Map facetGroup : config) {
                    String title = (String)facetGroup.get("title");
                    List facetsConfig = (List)facetGroup.get("facets");
                    ArrayList<FacetDTO> facets = new ArrayList<FacetDTO>();
                    block4: for (Map facetsMap : facetsConfig) {
                        String name = (String)facetsMap.get("field");
                        String description = null;
                        String dwcTerm = null;
                        Boolean i18nValues = null;
                        if (indexedFields == null) continue;
                        for (IndexFieldDTO field : indexedFields) {
                            if (!field.getName().equalsIgnoreCase(name)) continue;
                            description = field.getDescription();
                            dwcTerm = field.getDwcTerm();
                            i18nValues = field.isI18nValues();
                            facets.add(new FacetDTO(name, (String)facetsMap.get("sort"), description, dwcTerm, i18nValues));
                            continue block4;
                        }
                    }
                    newThemes.add(new FacetTheme(title, facets));
                }
                if (newThemes.size() > 0) {
                    allThemes = newThemes;
                    FacetThemes.initAllFacets();
                }
            } else {
                this.defaultInit();
            }
        }
        finally {
            initialised.countDown();
        }
    }

    private static void afterInitialisation() {
        try {
            if (initialised.getCount() > 0L && allThemes.size() > 0) {
                FacetThemes.initAllFacets();
                initialised.countDown();
            } else {
                initialised.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String[] getAllFacetsLimited() {
        FacetThemes.afterInitialisation();
        return allFacetsLimited;
    }

    public static Integer getFacetsMax() {
        FacetThemes.afterInitialisation();
        return facetsMax;
    }

    public static LinkedHashMap<String, FacetDTO> getFacetsMap() {
        FacetThemes.afterInitialisation();
        return facetsMap;
    }

    public static Boolean getFacetDefault() {
        FacetThemes.afterInitialisation();
        return facetDefault;
    }

    public static List<FacetTheme> getAllThemes() {
        FacetThemes.afterInitialisation();
        return allThemes;
    }

    private static synchronized void initAllFacets() {
        LinkedHashMap<String, FacetDTO> map = new LinkedHashMap<String, FacetDTO>();
        for (FacetTheme theme : allThemes) {
            for (FacetDTO f : theme.getFacets()) {
                map.put(f.getField(), f);
            }
            facetsMap = map;
            allFacets = facetsMap.keySet().toArray(new String[0]);
            allFacetsLimited = allFacets != null && allFacets.length > facetsDefaultMax ? Arrays.copyOfRange(allFacets, 0, (int)facetsDefaultMax) : allFacets;
        }
    }

    public FacetThemes() {
        this.defaultInit();
        initialised.countDown();
    }

    public FacetThemes(boolean init) {
        if (init) {
            this.defaultInit();
            initialised.countDown();
        }
    }

    private void defaultInit() {
        allThemes.clear();
        allThemes.add(new FacetTheme("Taxonomic", new FacetDTO[]{new FacetDTO("taxon_name", "index", null, null, null), new FacetDTO("raw_taxon_name", "index", null, null, null), new FacetDTO("common_name", "index", null, null, null), new FacetDTO("subspecies_name", "index", null, null, null), new FacetDTO("species", "index", null, null, null), new FacetDTO("genus", "index", null, null, null), new FacetDTO("family", "index", null, null, null), new FacetDTO("order", "index", null, null, null), new FacetDTO("class", "index", null, null, null), new FacetDTO("phylum", "index", null, null, null), new FacetDTO("kingdom", "index", null, null, null), new FacetDTO("species_group", "index", null, null, null), new FacetDTO("rank", "count", null, null, null), new FacetDTO("interaction", "count", null, null, null), new FacetDTO("species_habitats", "count", null, null, null)}));
        allThemes.add(new FacetTheme("Geospatial", new FacetDTO[]{new FacetDTO("uncertainty", "index", null, null, null), new FacetDTO("sensitive", "count", null, null, null), new FacetDTO("state_conservation", "count", null, null, null), new FacetDTO("raw_state_conservation", "count", null, null, null), new FacetDTO("cl966", "count", null, null, null), new FacetDTO("cl959", "count", null, null, null), new FacetDTO("state", "count", null, null, null), new FacetDTO("country", "index", null, null, null), new FacetDTO("biogeographic_region", "count", null, null, null), new FacetDTO("ibra", "count", null, null, null), new FacetDTO("imcra", "count", null, null, null), new FacetDTO("cl1918", "count", null, null, null), new FacetDTO("cl617", "count", null, null, null), new FacetDTO("cl620", "count", null, null, null), new FacetDTO("geospatial_kosher", "count", null, null, null)}));
        allThemes.add(new FacetTheme("Temporal", new FacetDTO[]{new FacetDTO("month", "index", null, null, null), new FacetDTO("year", "index", null, null, null), new FacetDTO("decade", "index", null, null, null)}));
        allThemes.add(new FacetTheme("Record details", new FacetDTO[]{new FacetDTO("basis_of_record", "index", null, null, null), new FacetDTO("type_status", "index", null, null, null), new FacetDTO("multimedia", "count", null, null, null), new FacetDTO("collector", "index", null, null, null), new FacetDTO("occurrence_status_s", "index", null, null, null)}));
        allThemes.add(new FacetTheme("Attribution", new FacetDTO[]{new FacetDTO("alau_user_id", "count", null, null, null), new FacetDTO("data_provider_uid", "count", null, null, null), new FacetDTO("data_resource_uid", "count", null, null, null), new FacetDTO("institution_uid", "count", null, null, null), new FacetDTO("collection_uid", "count", null, null, null), new FacetDTO("provenance", "count", null, null, null)}));
        allThemes.add(new FacetTheme("Record assertions", new FacetDTO[]{new FacetDTO("assertions", "count", null, null, null), new FacetDTO("assertion_user_id", "index", null, null, null), new FacetDTO("outlier_layer", "count", null, null, null), new FacetDTO("outlier_layer_count", "count", null, null, null), new FacetDTO("taxonomic_issue", "count", null, null, null), new FacetDTO("duplicate_status", "count", null, null, null)}));
        FacetThemes.initAllFacets();
    }
}

