/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class DownloadDetailsDTO {
    private DownloadType downloadType;
    private Date startDate;
    private Date lastUpdate;
    private long totalRecords = 0L;
    private AtomicLong recordsDownloaded = new AtomicLong(0L);
    private String downloadParams;
    private String ipAddress;
    private String email;
    private DownloadRequestParams requestParams;
    private String fileLocation;
    private boolean includeSensitive = false;
    private Map<String, String> headerMap = null;
    private String[] miscFields = null;
    private String sensitiveFq = null;
    private AtomicBoolean interrupt = new AtomicBoolean(false);
    private String uniqueId = null;
    private String processingThreadName = null;

    public DownloadDetailsDTO() {
    }

    public DownloadDetailsDTO(String params, String ipAddress, DownloadType type) {
        this.downloadParams = params;
        this.ipAddress = ipAddress;
        this.downloadType = type;
        this.startDate = new Date();
        this.lastUpdate = new Date();
    }

    public DownloadDetailsDTO(DownloadRequestParams params, String ipAddress, DownloadType type) {
        this(params.getUrlParams(), ipAddress, type);
        this.requestParams = params;
        this.email = this.requestParams.getEmail();
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @JsonIgnore
    public long getStartTime() {
        return this.startDate.getTime();
    }

    public String getStartDateString() {
        return this.startDate.toString();
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public AtomicLong getRecordsDownloaded() {
        return this.recordsDownloaded;
    }

    public String getDownloadParams() {
        return this.downloadParams;
    }

    public void setDownloadParams(String downloadParams) {
        this.downloadParams = downloadParams;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public DownloadType getDownloadType() {
        return this.downloadType;
    }

    public void setDownloadType(DownloadType downloadType) {
        this.downloadType = downloadType;
    }

    public void updateCounts(int number) {
        this.recordsDownloaded.addAndGet(number);
        this.lastUpdate = new Date();
    }

    public void setTotalRecords(long total) {
        this.totalRecords = total;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public DownloadRequestParams getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(DownloadRequestParams requestParams) {
        this.requestParams = requestParams;
    }

    public boolean getIncludeSensitive() {
        return this.includeSensitive;
    }

    public void setIncludeSensitive(boolean includeSensitive) {
        this.includeSensitive = includeSensitive;
    }

    public void setMiscFields(String[] miscFields) {
        this.miscFields = miscFields;
    }

    public String[] getMiscFields() {
        return this.miscFields;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @JsonIgnore
    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public String getUniqueId() {
        this.uniqueId = UUID.nameUUIDFromBytes(this.getEmail().getBytes()) + "-" + this.getStartTime();
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public void setSensitiveFq(String sensitiveFq) {
        this.sensitiveFq = sensitiveFq;
    }

    public String getSensitiveFq() {
        return this.sensitiveFq;
    }

    public void setInterrupt(AtomicBoolean interrupt) {
        this.interrupt = interrupt;
    }

    public AtomicBoolean getInterrupt() {
        return this.interrupt;
    }

    public String getProcessingThreadName() {
        return this.processingThreadName;
    }

    public void setProcessingThreadName(String processingThreadName) {
        this.processingThreadName = processingThreadName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DownloadDetailsDTO [downloadType=").append(this.downloadType).append(", startDate=").append(this.startDate).append(", lastUpdate=").append(this.lastUpdate).append(", totalRecords=").append(this.totalRecords).append(", recordsDownloaded=").append(this.recordsDownloaded).append(", downloadParams=").append(this.downloadParams).append(", ipAddress=").append(this.ipAddress).append(", email=").append(this.email).append(", requestParams=").append(this.requestParams).append("]");
        return builder.toString();
    }
}

