/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.org.ala.biocache.stream.OptionalZipOutputStream;
import au.org.ala.biocache.writer.RecordWriterError;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSVRecordWriter
implements RecordWriterError {
    private static final Logger logger = LoggerFactory.getLogger(TSVRecordWriter.class);
    private final OutputStream outputStream;
    private final AtomicBoolean finalised = new AtomicBoolean(false);
    private final AtomicBoolean finalisedComplete = new AtomicBoolean(false);
    private boolean writerError = false;
    private String[] header;

    public TSVRecordWriter(OutputStream out, String[] header) {
        this.outputStream = out;
        this.header = header;
        this.write(header);
    }

    public void write(String[] record) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < record.length; ++i) {
            if (i > 0) {
                line.append('\t');
            }
            line.append(record[i].replace("\r", "").replace("\n", "").replace("\t", ""));
        }
        line.append("\n");
        try {
            String str = line.toString();
            byte[] bytes = str.getBytes("UTF-8");
            this.outputStream.write(bytes);
            if (this.outputStream instanceof OptionalZipOutputStream && ((OptionalZipOutputStream)this.outputStream).isNewFile((Object)this.outputStream, (long)bytes.length)) {
                this.write(this.header);
            }
        }
        catch (IOException e) {
            this.writerError = true;
        }
    }

    public void finalise() {
        if (this.finalised.compareAndSet(false, true)) {
            this.flush();
            this.finalisedComplete.set(true);
        }
    }

    public boolean finalised() {
        return this.finalisedComplete.get();
    }

    public boolean hasError() {
        return this.writerError;
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.writerError = true;
        }
    }
}

