/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RecordWriterException
extends IOException {
    private static final Logger logger = Logger.getLogger(RecordWriterException.class);

    public RecordWriterException() {
        super("RecordWriter Exception");
    }

    public RecordWriterException(String msg) {
        super("RecordWriter Exception: " + msg);
    }

    public static RecordWriterException newRecordWriterException(DownloadDetailsDTO dd, DownloadRequestParams downloadParams, boolean solr) {
        String msg = "";
        if (dd != null) {
            if (dd.getFileLocation() != null) {
                msg = msg + "Offline request: " + dd.getFileLocation();
                logger.error((Object)"msg");
            } else {
                msg = msg + "Online " + (solr ? "SOLR" : "Cassandra") + " download request: " + downloadParams.toString() + ", " + dd.getIpAddress();
            }
        } else if (downloadParams != null) {
            msg = msg + "Online " + (solr ? "SOLR" : "Cassandra") + "  download request: " + downloadParams.toString();
        }
        return new RecordWriterException(msg);
    }
}

