/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.model.DuplicateRecordDetails;
import au.org.ala.biocache.util.SearchUtils;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DuplicationController {
    private static final Logger logger = Logger.getLogger(DuplicationController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected SearchUtils searchUtils;

    @RequestMapping(value={"/duplicates/**"}, method={RequestMethod.GET})
    @ResponseBody
    public DuplicateRecordDetails getDuplicateStats(HttpServletRequest request) throws Exception {
        String guid = this.searchUtils.getGuidFromPath(request);
        try {
            return Store.getDuplicateDetails((String)guid);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get duplicate details for " + guid), (Throwable)e);
            return new DuplicateRecordDetails();
        }
    }

    @RequestMapping(value={"/stats/**"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, FieldStatsInfo> printStats(HttpServletRequest request) throws Exception {
        String guid = this.searchUtils.getGuidFromPath(request);
        SpatialSearchRequestParams searchParams = new SpatialSearchRequestParams();
        searchParams.setQ("*:*");
        searchParams.setFacets(new String[]{guid});
        return this.searchDAO.getStatistics(searchParams);
    }
}

