/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util.thread;

import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.util.thread.DownloadControlThread;
import au.org.ala.biocache.util.thread.DownloadCreator;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DownloadControlThread
implements Runnable {
    private final String name;
    private final Integer maxRecords;
    private final DownloadDetailsDTO.DownloadType downloadType;
    private final int concurrencyLevel;
    private final long pollDelay;
    private final long executionDelay;
    private final int threadPriority;
    private final DownloadServiceExecutor downloadServiceExecutor;
    private final AtomicBoolean shutdownFlag = new AtomicBoolean(false);
    private final Queue<DownloadDetailsDTO> currentDownloads;
    private final DownloadCreator downloadCreator;
    private final PersistentQueueDAO persistentQueueDAO;
    private final ExecutorService parallelQueryExecutor;

    public DownloadControlThread(String name, Integer maxRecords, DownloadDetailsDTO.DownloadType downloadType, int concurrencyLevel, Long pollDelayMs, Long executionDelayMs, Integer threadPriority, Queue<DownloadDetailsDTO> currentDownloads, DownloadCreator downloadCreator, PersistentQueueDAO persistentQueueDAO, ExecutorService parallelQueryExecutor) {
        this.name = name;
        this.maxRecords = maxRecords;
        this.downloadType = downloadType;
        this.concurrencyLevel = concurrencyLevel > 0 ? concurrencyLevel : 1;
        this.pollDelay = pollDelayMs != null && pollDelayMs >= 0L ? pollDelayMs : 10L;
        this.executionDelay = executionDelayMs != null && executionDelayMs >= 0L ? executionDelayMs : 0L;
        this.threadPriority = threadPriority != null && threadPriority >= 1 && threadPriority <= 10 ? threadPriority : 5;
        this.currentDownloads = currentDownloads;
        this.downloadCreator = downloadCreator;
        this.persistentQueueDAO = persistentQueueDAO;
        this.downloadServiceExecutor = this.createExecutor();
        this.parallelQueryExecutor = parallelQueryExecutor;
    }

    protected DownloadServiceExecutor createExecutor() {
        return new DownloadServiceExecutor(this, this.name, this.maxRecords, this.downloadType, this.concurrencyLevel, this.executionDelay, this.threadPriority, this.downloadCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DownloadDetailsDTO currentDownload = null;
        try {
            while (!this.shutdownFlag.get()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Thread.sleep(this.pollDelay);
                if (!this.downloadServiceExecutor.reserveCapacity(this.pollDelay, TimeUnit.MILLISECONDS)) continue;
                if (this.shutdownFlag.get()) return;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                currentDownload = this.persistentQueueDAO.getNextDownload(this.maxRecords, this.downloadType);
                if (currentDownload != null) {
                    currentDownload.setProcessingThreadName(this.name);
                    this.downloadServiceExecutor.submitDownload(currentDownload, this.parallelQueryExecutor);
                    continue;
                }
                this.downloadServiceExecutor.returnCapacity();
            }
            return;
        }
        catch (InterruptedException | RejectedExecutionException e) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            try {
                this.downloadServiceExecutor.shutdown();
                this.downloadServiceExecutor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.downloadServiceExecutor.shutdownNow();
            }
        }
    }

    public void shutdown() {
        this.shutdownFlag.set(true);
    }
}

