/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlaFileUtils {
    public static void createZip(String directoryPath, String zipPath) throws IOException {
        try (FileOutputStream fOut = new FileOutputStream(new File(zipPath));
             BufferedOutputStream bOut = new BufferedOutputStream(fOut);
             ZipArchiveOutputStream tOut = new ZipArchiveOutputStream((OutputStream)bOut);){
            File[] children = new File(directoryPath).listFiles();
            if (children != null) {
                for (File child : children) {
                    AlaFileUtils.addFileToZip((ZipArchiveOutputStream)tOut, (String)child.getPath(), (String)"");
                }
            }
            tOut.finish();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(String outputDirectoryPath, String srcZipPath) throws IOException {
        try (FileInputStream fis = new FileInputStream(srcZipPath);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)bis);){
            ZipArchiveEntry ze;
            while ((ze = zis.getNextZipEntry()) != null) {
                FileOutputStream fos;
                block59: {
                    fos = new FileOutputStream(outputDirectoryPath + File.separator + ze.getName());
                    Throwable throwable = null;
                    try {
                        try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
                            IOUtils.copy((InputStream)zis, (OutputStream)bos);
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block59;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }

    private static void addFileToZip(ZipArchiveOutputStream zOut, String path, String base) throws IOException {
        File f = new File(path);
        String entryName = base + f.getName();
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(f, entryName);
        zOut.putArchiveEntry((ArchiveEntry)zipEntry);
        if (f.isFile()) {
            try (FileInputStream fInputStream = new FileInputStream(f);){
                IOUtils.copy((InputStream)fInputStream, (OutputStream)zOut);
                zOut.closeArchiveEntry();
            }
        } else {
            zOut.closeArchiveEntry();
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    AlaFileUtils.addFileToZip((ZipArchiveOutputStream)zOut, (String)child.getAbsolutePath(), (String)(entryName + "/"));
                }
            }
        }
    }

    public static String reduceNameByVowels(String name, int requiredLength) {
        if (name.length() <= requiredLength) {
            return name;
        }
        if ((name = name.replaceAll("(?!^)[aeiou]", "")).length() > requiredLength) {
            name = name.substring(0, requiredLength);
        }
        return name;
    }

    public static Map<String, String> generateShapeHeader(String[] headers) {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
        int i = 0;
        for (String header : headers) {
            String newHeader = AlaFileUtils.reduceNameByVowels((String)header, (int)10);
            if (headerMap.containsKey(newHeader)) {
                newHeader = AlaFileUtils.reduceNameByVowels((String)header, (int)9) + i;
            }
            headerMap.put(newHeader, header);
            ++i;
        }
        return headerMap;
    }
}

