/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.model.RankType;
import au.org.ala.names.search.ALANameSearcher;
import au.org.ala.names.search.ExcludedNameException;
import au.org.ala.names.search.MisappliedException;
import au.org.ala.names.search.ParentSynonymChildException;
import au.org.ala.names.search.SearchResultException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.solr.client.solrj.util.ClientUtils;

public class ALANameSearcherExt
extends ALANameSearcher {
    private IndexSearcher identifierIdxSearcher = null;
    private IndexSearcher vernIdxSearcher = null;

    public ALANameSearcherExt(String path) throws IOException {
        super(path);
    }

    private IndexSearcher getIdentifierIdxSearcher() throws IOException {
        if (this.identifierIdxSearcher == null) {
            this.identifierIdxSearcher = this.getALANameSearcherSearcher("cbSearcher");
        }
        return this.identifierIdxSearcher;
    }

    private IndexSearcher getVernIdxSearcher() throws IOException {
        if (this.vernIdxSearcher == null) {
            this.vernIdxSearcher = this.getALANameSearcherSearcher("vernSearcher");
        }
        return this.vernIdxSearcher;
    }

    private IndexSearcher getALANameSearcherSearcher(String searcher) {
        try {
            Field field = ALANameSearcher.class.getDeclaredField(searcher);
            field.setAccessible(true);
            IndexSearcher value = (IndexSearcher)field.get(this);
            field.setAccessible(false);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void appendAutocompleteResults(Map<String, Map> output, TopDocs results, boolean includeSynonyms, boolean commonNameResults) throws IOException {
        for (ScoreDoc i : results.scoreDocs) {
            Map existing;
            NameSearchResult nsr;
            Document src = commonNameResults ? this.getVernIdxSearcher().doc(i.doc) : this.getIdentifierIdxSearcher().doc(i.doc);
            NameSearchResult nameSearchResult = nsr = commonNameResults ? this.searchForRecordByLsid(src.get("lsid")) : new NameSearchResult(src, null);
            if (nsr == null || nsr.getLeft() == null && !includeSynonyms) continue;
            Map m = this.formatAutocompleteNsr(i.score, nsr);
            if (commonNameResults) {
                m.put("commonname", src.get("common_orig"));
                m.put("match", "commonName");
            } else {
                m.put("match", "scientificName");
            }
            while (includeSynonyms && nsr != null && m != null && nsr.getAcceptedLsid() != null) {
                ArrayList<Map> list;
                if (output.containsKey(nsr.getAcceptedLsid())) {
                    list = (ArrayList<Map>)output.get(nsr.getAcceptedLsid()).get("synonymMatch");
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(m);
                    output.get(nsr.getAcceptedLsid()).put("synonymMatch", list);
                    m = null;
                    nsr = null;
                    continue;
                }
                if ((nsr = this.searchForRecordByLsid(nsr.getAcceptedLsid())) == null) continue;
                list = new ArrayList<Map>();
                list.add(m);
                m = this.formatAutocompleteNsr(i.score, nsr);
                m.put("synonymMatch", list);
            }
            if ((nsr == null || nsr.getAcceptedLsid() != null) && !includeSynonyms || m == null) continue;
            if (m.get("name").toString().equals("Acacia")) {
                int list = 4;
            }
            if ((existing = output.get(m.get("lsid").toString())) == null) {
                output.put(m.get("lsid").toString(), m);
                continue;
            }
            if (!(((Float)m.get("score")).floatValue() > ((Float)existing.get("score")).floatValue())) continue;
            output.put(m.get("lsid").toString(), m);
        }
    }

    private Query buildAutocompleteQuery(String field, String q, boolean allSearches) {
        TermQuery fq1 = new TermQuery(new Term(field, q));
        fq1.setBoost(12.0f);
        WildcardQuery fq5 = new WildcardQuery(new Term(field, q + "*"));
        WildcardQuery fq6 = new WildcardQuery(new Term(field, "* " + q + "*"));
        WildcardQuery fq7 = new WildcardQuery(new Term(field, "*" + q + "*"));
        BooleanQuery o = new BooleanQuery();
        o.add((Query)fq1, BooleanClause.Occur.SHOULD);
        o.add((Query)fq5, BooleanClause.Occur.SHOULD);
        o.add((Query)fq6, BooleanClause.Occur.SHOULD);
        o.add((Query)fq7, BooleanClause.Occur.SHOULD);
        return o;
    }

    private String getPreferredGuid(String taxonConceptGuid) throws Exception {
        TermQuery qGuid = new TermQuery(new Term("guid", taxonConceptGuid));
        TermQuery qOtherGuid = new TermQuery(new Term("otherGuid", taxonConceptGuid));
        BooleanQuery fullQuery = new BooleanQuery(true);
        fullQuery.add((Query)qGuid, BooleanClause.Occur.SHOULD);
        fullQuery.add((Query)qOtherGuid, BooleanClause.Occur.SHOULD);
        TopDocs topDocs = this.getIdentifierIdxSearcher().search((Query)fullQuery, 1);
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        int n = scoreDocArray.length;
        int n2 = 0;
        if (n2 < n) {
            ScoreDoc scoreDoc = scoreDocArray[n2];
            Document doc = this.getIdentifierIdxSearcher().doc(scoreDoc.doc);
            return doc.get("guid");
        }
        return taxonConceptGuid;
    }

    private boolean isKingdom(String name) {
        try {
            LinnaeanRankClassification lc = new LinnaeanRankClassification(name, null);
            NameSearchResult nsr = this.searchForRecord(lc, false);
            return nsr != null && nsr.getRank() == RankType.KINGDOM;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String[] extractComponents(String in) {
        int lastClose;
        String[] retArray = new String[2];
        int lastOpen = in.lastIndexOf("(");
        if (lastOpen < (lastClose = in.lastIndexOf(")"))) {
            String potentialKingdom = in.substring(lastOpen + 1, lastClose);
            if (this.isKingdom(potentialKingdom)) {
                retArray[0] = in.substring(0, lastOpen);
                retArray[1] = potentialKingdom;
            } else {
                retArray[0] = in;
            }
        } else {
            retArray[0] = in;
        }
        return retArray;
    }

    private String getLsidByNameAndKingdom(String parameter) {
        String lsid = null;
        String name = null;
        String kingdom = null;
        String[] parts = this.extractComponents(parameter);
        name = parts[0];
        name = name.replaceAll("_", " ");
        name = name.replaceAll("\\+", " ");
        kingdom = parts[1];
        if (kingdom != null) {
            LinnaeanRankClassification cl = new LinnaeanRankClassification(kingdom, null);
            cl.setScientificName(name);
            try {
                lsid = this.searchForLSID(cl.getScientificName(), cl, null);
            }
            catch (ExcludedNameException e) {
                lsid = e.getNonExcludedName() != null ? e.getNonExcludedName().getLsid() : e.getExcludedName().getLsid();
            }
            catch (ParentSynonymChildException e) {
                lsid = e.getChildResult().getLsid();
            }
            catch (MisappliedException e) {
                if (e.getMisappliedResult() != null) {
                    lsid = e.getMatchedResult().getLsid();
                }
            }
            catch (SearchResultException searchResultException) {
                // empty catch block
            }
        }
        if (lsid == null || lsid.length() < 1) {
            try {
                lsid = this.searchForLSID(name, true, true);
            }
            catch (ExcludedNameException e) {
                lsid = e.getNonExcludedName() != null ? e.getNonExcludedName().getLsid() : e.getExcludedName().getLsid();
            }
            catch (ParentSynonymChildException e) {
                lsid = e.getChildResult().getLsid();
            }
            catch (MisappliedException e) {
                if (e.getMisappliedResult() != null) {
                    lsid = e.getMatchedResult().getLsid();
                }
            }
            catch (SearchResultException searchResultException) {
                // empty catch block
            }
        }
        if (lsid == null || lsid.length() < 1) {
            lsid = this.searchForLSIDCommonName(name);
        }
        if (lsid == null || lsid.length() < 1) {
            lsid = this.findLSIDByConcatName(name);
        }
        return lsid;
    }

    private String concatName(String name) {
        String patternA = "[^a-zA-Z]";
        String patternB = "\\b\\s{2,}\\b";
        String cleanQuery = "";
        if (name != null) {
            cleanQuery = ClientUtils.escapeQueryChars((String)name);
            cleanQuery = cleanQuery.toLowerCase();
            cleanQuery = cleanQuery.replaceAll(patternA, "");
            cleanQuery = cleanQuery.replaceAll(patternB, "");
            cleanQuery = cleanQuery.trim();
        }
        return cleanQuery;
    }

    private String findLSIDByConcatName(String name) {
        try {
            ScoreDoc[] scoreDocArray;
            int n;
            int n2;
            String concatName = this.concatName(name);
            TermQuery query = new TermQuery(new Term("concat_name", concatName));
            TopDocs topDocs = this.getIdentifierIdxSearcher().search((Query)query, 2);
            if (topDocs != null && topDocs.totalHits == 1 && (n2 = 0) < (n = (scoreDocArray = topDocs.scoreDocs).length)) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = this.getIdentifierIdxSearcher().doc(scoreDoc.doc);
                return doc.get("guid");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<String> getGuidsForTaxa(List<String> taxaQueries) {
        ArrayList<String> guids = new ArrayList<String>();
        for (int i = 0; i < taxaQueries.size(); ++i) {
            String scientificName = taxaQueries.get(i);
            String lsid = this.getLsidByNameAndKingdom(scientificName);
            if (lsid != null && lsid.length() > 0) {
                String guid = null;
                try {
                    guid = this.getExtendedTaxonConceptByGuid(lsid, true, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                guids.add(guid);
            }
            if (guids.size() >= i + 1) continue;
            guids.add(null);
        }
        return guids;
    }

    private String getExtendedTaxonConceptByGuid(String guid, boolean checkPreferred, boolean checkSynonym) throws Exception {
        boolean hasAccepted;
        NameSearchResult nsr = this.searchForRecordByLsid(guid);
        boolean bl = hasAccepted = nsr != null && nsr.getAcceptedLsid() == null;
        if (checkPreferred && !hasAccepted) {
            guid = this.getPreferredGuid(guid);
        }
        if (checkSynonym && !hasAccepted && nsr != null && nsr.isSynonym()) {
            guid = nsr.getAcceptedLsid();
        }
        return guid;
    }

    public List<Map> autocomplete(String q, int max, boolean includeSynonyms) {
        try {
            HashMap output = new HashMap();
            String lq = q.toLowerCase();
            String uq = q.toUpperCase();
            Query fq = this.buildAutocompleteQuery("name", lq, false);
            BooleanQuery b = new BooleanQuery();
            b.add(fq, BooleanClause.Occur.MUST);
            b.add((Query)new WildcardQuery(new Term("left", "*")), includeSynonyms ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST);
            TopDocs results = this.getIdentifierIdxSearcher().search((Query)b, max);
            this.appendAutocompleteResults(output, results, includeSynonyms, false);
            uq = this.concatName(uq).toUpperCase();
            fq = this.buildAutocompleteQuery("common", uq, true);
            results = this.getVernIdxSearcher().search(fq, max);
            this.appendAutocompleteResults(output, results, includeSynonyms, true);
            return new ArrayList<Map>(output.values());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Map formatAutocompleteNsr(float score, NameSearchResult nsr) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("score", Float.valueOf(score));
        m.put("lsid", nsr.getLsid());
        m.put("left", nsr.getLeft());
        m.put("right", nsr.getRight());
        m.put("rank", nsr.getRank());
        m.put("rankId", nsr.getRank() != null ? nsr.getRank().getId() : 10000);
        m.put("cl", nsr.getRankClassification());
        m.put("name", nsr.getRankClassification() != null ? nsr.getRankClassification().getScientificName() : null);
        m.put("acceptedLsid", nsr.getAcceptedLsid());
        m.put("commonname", this.getCommonNameForLSID(nsr.getLsid()));
        m.put("commonnames", this.getCommonNamesForLSID(nsr.getLsid(), 1000));
        return m;
    }
}

