/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.SpeciesCountDTO;
import au.org.ala.biocache.service.SpeciesCountsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

class UpdateThread
extends Thread {
    private static final Logger logger = Logger.getLogger(UpdateThread.class);
    SpeciesCountsService speciesCountsService;
    int hashCode;
    SpatialSearchRequestParams params;

    public UpdateThread(SpeciesCountsService speciesCountsService, int hashCode, SpatialSearchRequestParams params) {
        this.speciesCountsService = speciesCountsService;
        this.hashCode = hashCode;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.speciesCountsService.updatelock;
        synchronized (object) {
            Object object2 = this.speciesCountsService.cacheLock;
            synchronized (object2) {
                if (this.speciesCountsService.cache.get((Object)this.hashCode) != null) {
                    Object object3 = this.speciesCountsService.updatingLock;
                    synchronized (object3) {
                        this.speciesCountsService.updatingList.remove(this.hashCode);
                    }
                    return;
                }
            }
            try {
                logger.debug((Object)("updating species counts for query: " + this.params.toString()));
                SearchResultDTO qr = this.speciesCountsService.searchDAO.findByFulltextSpatialQuery(this.params, null);
                HashMap<Long, Long> map = new HashMap<Long, Long>();
                for (FacetResultDTO fr : qr.getFacetResults()) {
                    for (FieldResultDTO r : fr.getFieldResult()) {
                        if (!StringUtils.isNotEmpty((String)r.getLabel())) continue;
                        map.put(Long.parseLong(r.getLabel()), r.getCount());
                    }
                }
                long[] left = new long[map.size()];
                ArrayList keys = new ArrayList(map.keySet());
                for (int i = 0; i < left.length; ++i) {
                    left[i] = (Long)keys.get(i);
                }
                Arrays.sort(left);
                long[] leftCount = new long[map.size()];
                for (int i = 0; i < leftCount.length; ++i) {
                    leftCount[i] = (Long)map.get(left[i]);
                }
                SpeciesCountDTO counts = new SpeciesCountDTO(left, leftCount, this.speciesCountsService.searchDAO.getIndexVersion(Boolean.valueOf(false)).longValue());
                Object object4 = this.speciesCountsService.cacheLock;
                synchronized (object4) {
                    this.speciesCountsService.cache.put((Object)this.hashCode, (Object)counts);
                }
            }
            catch (Exception e) {
                logger.error((Object)("failed to update species counts for : " + this.params.toString()));
            }
        }
        object = this.speciesCountsService.updatingLock;
        synchronized (object) {
            this.speciesCountsService.updatingList.remove(this.hashCode);
        }
    }
}

