/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.Config;
import au.org.ala.biocache.dto.SpeciesCountDTO;
import au.org.ala.biocache.dto.SpeciesImageDTO;
import au.org.ala.biocache.service.ImageMetadataService;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.ListsService;
import au.org.ala.biocache.service.SpeciesCountsService;
import au.org.ala.biocache.service.SpeciesImageService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.ALANameSearcherExt;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.search.ExcludedNameException;
import au.org.ala.names.search.MisappliedException;
import au.org.ala.names.search.ParentSynonymChildException;
import au.org.ala.names.search.SearchResultException;
import com.mockrunner.util.common.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.context.support.AbstractMessageSource;

public class SpeciesLookupIndexService
implements SpeciesLookupService {
    private static final Logger logger = Logger.getLogger(SpeciesLookupIndexService.class);
    private AbstractMessageSource messageSource;
    @Inject
    protected SpeciesCountsService speciesCountsService;
    @Inject
    protected SpeciesImageService speciesImageService;
    @Inject
    protected ImageMetadataService imageMetadataService;
    @Inject
    protected ListsService listsService;
    @Inject
    protected LayersService layersService;
    protected String nameIndexLocation;
    private ALANameSearcherExt nameIndex = null;

    private ALANameSearcherExt getNameIndex() throws RuntimeException {
        if (this.nameIndex == null) {
            try {
                this.nameIndex = new ALANameSearcherExt(this.nameIndexLocation);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.nameIndex;
    }

    public String getGuidForName(String name) {
        String lsid = null;
        try {
            lsid = this.getNameIndex().searchForLSID(name);
        }
        catch (ExcludedNameException e) {
            lsid = e.getNonExcludedName() != null ? e.getNonExcludedName().getLsid() : e.getExcludedName().getLsid();
        }
        catch (ParentSynonymChildException e) {
            lsid = e.getChildResult().getLsid();
        }
        catch (MisappliedException e) {
            if (e.getMisappliedResult() != null) {
                lsid = e.getMatchedResult().getLsid();
            }
        }
        catch (SearchResultException searchResultException) {
            // empty catch block
        }
        return lsid;
    }

    public String getAcceptedNameForGuid(String guid) {
        NameSearchResult nsr = this.getNameIndex().searchForRecordByLsid(guid);
        if (nsr != null) {
            return nsr.getRankClassification() != null ? nsr.getRankClassification().getScientificName() : null;
        }
        return null;
    }

    public List<String> getNamesForGuids(List<String> guids) {
        ArrayList<String> results = new ArrayList<String>(guids.size());
        int idx = 0;
        for (String guid : guids) {
            results.add(idx, this.getAcceptedNameForGuid(guid));
            ++idx;
        }
        return results;
    }

    public List<String[]> getSpeciesDetails(List<String> guids, List<Long> counts, boolean includeCounts, boolean includeSynonyms, boolean includeLists) {
        ArrayList<String[]> results = new ArrayList<String[]>(guids.size());
        int idx = 0;
        for (String guid : guids) {
            NameSearchResult nsr = this.getNameIndex().searchForRecordByLsid(guid);
            if (nsr == null) {
                String lsid = this.getNameIndex().searchForLsidById(guid);
                if (lsid != null) {
                    nsr = this.getNameIndex().searchForRecordByLsid(lsid);
                } else if (guid != null && StringUtil.countMatches((String)guid, (String)"|") == 4) {
                    if (guid.startsWith("\"") && guid.endsWith("\"") && guid.length() > 2) {
                        guid = guid.substring(1, guid.length() - 1);
                    }
                    lsid = guid.split("\\|", 6)[1];
                    nsr = this.getNameIndex().searchForRecordByLsid(lsid);
                }
            }
            Object[] result = null;
            ArrayList<String> lsids = new ArrayList<String>();
            if (nsr != null) {
                LinnaeanRankClassification classification = nsr.getRankClassification();
                lsids.add(classification.getGid());
                lsids.add(classification.getFid());
                lsids.add(classification.getSid());
                result = new String[]{classification.getScientificName(), classification.getAuthorship(), classification.getKingdom(), classification.getPhylum(), classification.getKlass(), classification.getOrder(), classification.getFamily(), classification.getGenus(), classification.getSpecies(), classification.getSubspecies()};
            } else if (StringUtil.countMatches((String)guid, (String)"|") == 4) {
                if (guid.startsWith("\"") && guid.endsWith("\"") && guid.length() > 2) {
                    guid = guid.substring(1, guid.length() - 1);
                }
                String[] split = guid.split("\\|", 6);
                lsids.add(split[1]);
                result = new String[]{split[0], "", split[3], "", "", "", split[4], "", "", ""};
            } else {
                result = new String[]{"unmatched", "", "", "", "", "", "", "", "", ""};
            }
            if (includeCounts) {
                result = (String[])ArrayUtils.add((Object[])result, (Object)counts.get(idx).toString());
            }
            if (includeLists) {
                List types = this.listsService.getTypes();
                String[] row = new String[result.length + types.size()];
                System.arraycopy(result, 0, row, 0, result.length);
                HashSet matches = new HashSet();
                for (int j = 0; j < types.size(); ++j) {
                    matches.clear();
                    for (String lsid : lsids) {
                        Set found = this.listsService.get(types.get(j).toString(), lsid);
                        if (found == null) continue;
                        matches.addAll(found);
                    }
                    result[result.length - types.size() + j] = "";
                    for (String match : matches) {
                        if (((String)result[result.length - types.size() + j]).length() > 0) {
                            int n = result.length - types.size() + j;
                            result[n] = (String)result[n] + "|";
                        }
                        int n = result.length - types.size() + j;
                        result[n] = (String)result[n] + match;
                    }
                }
                result = row;
            }
            results.add((String[])result);
            ++idx;
        }
        return results;
    }

    public String[] getHeaderDetails(String field, boolean includeCounts, boolean includeSynonyms) {
        Object[] baseHeader = new String[]{this.messageSource.getMessage("species.name", null, "Species Name", null), this.messageSource.getMessage("species.author", null, "Scientific Name Author", null), this.messageSource.getMessage("species.kingdom", null, "Kingdom", null), this.messageSource.getMessage("species.phylum", null, "Phylum", null), this.messageSource.getMessage("species.class", null, "Class", null), this.messageSource.getMessage("species.order", null, "Order", null), this.messageSource.getMessage("species.family", null, "Family", null), this.messageSource.getMessage("species.genus", null, "Genus", null), this.messageSource.getMessage("species.species", null, "Species", null), this.messageSource.getMessage("species.subspecies", null, "Subspecies", null)};
        if (includeCounts) {
            return (String[])ArrayUtils.add((Object[])baseHeader, (Object)this.messageSource.getMessage("species.count", null, "Number of Records", null));
        }
        return baseHeader;
    }

    public List<String> getGuidsForTaxa(List<String> taxaQueries) {
        return this.getNameIndex().getGuidsForTaxa(taxaQueries);
    }

    public void setMessageSource(AbstractMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setNameIndexLocation(String nameIndexLocation) {
        this.nameIndexLocation = nameIndexLocation;
    }

    public Map search(String query, String[] filterQuery, int max, boolean includeSynonyms, boolean includeAll, boolean counts) {
        int maxFind = includeAll ? max : max + 1000;
        List results = this.getNameIndex().autocomplete(query, maxFind, includeSynonyms);
        ArrayList<Object> output = new ArrayList<Object>();
        SpeciesCountDTO countlist = counts ? this.speciesCountsService.getCounts(filterQuery) : null;
        Collections.sort(results, new /* Unavailable Anonymous Inner Class!! */);
        for (int i = 0; i < results.size() && output.size() < max; ++i) {
            Map nsr = (Map)results.get(i);
            try {
                long l;
                long l2 = l = counts ? this.speciesCountsService.getCount(countlist, Long.parseLong(nsr.get("left").toString()), Long.parseLong(nsr.get("right").toString())) : 0L;
                if (this.speciesCountsService.isEnabled() && l <= 0L && !includeAll) continue;
                if (counts) {
                    nsr.put("count", l);
                    nsr.put("distributionsCount", this.layersService.getDistributionsCount(nsr.get("lsid").toString()));
                    nsr.put("checklistsCount", this.layersService.getChecklistsCount(nsr.get("lsid").toString()));
                    nsr.put("tracksCount", this.layersService.getTracksCount(nsr.get("lsid").toString()));
                }
                nsr.put("images", this.speciesImageService.get(Long.parseLong((String)nsr.get("left")), Long.parseLong((String)nsr.get("right"))));
                output.add(nsr);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<Map> formatted = new ArrayList<Map>();
        for (Map map : output) {
            formatted.add(this.format(map, query));
        }
        HashMap<String, Object> wrapper = new HashMap<String, Object>();
        wrapper.put("pageSize", max);
        wrapper.put("startIndex", 0);
        wrapper.put("totalRecords", results.size());
        wrapper.put("sort", "score");
        wrapper.put("dir", "desc");
        wrapper.put("status", "OK");
        wrapper.put("query", query);
        wrapper.put("results", formatted);
        HashMap<String, HashMap<String, Object>> hashMap = new HashMap<String, HashMap<String, Object>>();
        hashMap.put("searchResults", wrapper);
        return hashMap;
    }

    private Map format(Map m, String searchTerm) {
        int pos;
        String highlight;
        HashMap<String, Object> formatted = new HashMap<String, Object>();
        String guid = (String)m.get("lsid");
        formatted.put("guid", guid);
        formatted.put("linkIdentifier", guid);
        formatted.put("name", m.get("name"));
        formatted.put("idxType", "TAXON");
        formatted.put("score", m.get("score"));
        formatted.put("left", m.get("left"));
        formatted.put("right", m.get("right"));
        LinnaeanRankClassification cl = (LinnaeanRankClassification)m.get("cl");
        String parentUid = null;
        if (cl != null) {
            if (guid.equals(cl.getSid())) {
                parentUid = cl.getGid();
            }
            if (guid.equals(cl.getGid())) {
                parentUid = cl.getFid();
            }
            if (guid.equals(cl.getFid())) {
                parentUid = cl.getOid();
            }
            if (guid.equals(cl.getOid())) {
                parentUid = cl.getCid();
            }
            if (guid.equals(cl.getCid())) {
                parentUid = cl.getPid();
            }
            if (guid.equals(cl.getPid())) {
                parentUid = cl.getKid();
            }
            formatted.put("parentGuid", parentUid);
            formatted.put("kingdom", cl.getKingdom());
            formatted.put("phylum", cl.getPhylum());
            formatted.put("classs", cl.getKlass());
            formatted.put("order", cl.getOrder());
            formatted.put("family", cl.getFamily());
            formatted.put("genus", cl.getGenus());
            formatted.put("author", cl.getAuthorship());
        }
        formatted.put("hasChildren", false);
        formatted.put("rank", m.get("rank").toString().toLowerCase());
        formatted.put("rankId", m.get("rankId"));
        formatted.put("rawRank", m.get("rank"));
        formatted.put("isAustralian", "recorded");
        boolean scientificNameMatch = "scientificName".equals(m.get("match"));
        String string = highlight = scientificNameMatch ? (String)m.get("name") : (String)m.get("commonname");
        if (highlight == null) {
            Map syn;
            Iterator iterator = ((List)m.get("synonymMatch")).iterator();
            while (iterator.hasNext() && (highlight = (scientificNameMatch = "scientificName".equals((syn = (Map)iterator.next()).get("match"))) ? (String)syn.get("name") : (String)syn.get("commonname")) == null) {
            }
        }
        if (highlight != null && (pos = highlight.toLowerCase().indexOf(searchTerm.toLowerCase())) >= 0) {
            highlight = highlight.substring(0, pos) + "<strong>" + highlight.substring(pos, pos + searchTerm.length()) + "</strong>" + highlight.substring(pos + searchTerm.length(), highlight.length());
        }
        formatted.put("highlight", highlight);
        if (m.get("commonname") == null) {
            m.put("commonname", this.nameIndex.getCommonNameForLSID((String)m.get("lsid")));
            m.put("commonnames", this.nameIndex.getCommonNamesForLSID((String)m.get("lsid"), 1000));
        }
        if (m.get("commonname") != null) {
            formatted.put("commonName", m.get("commonnames"));
            formatted.put("commonNameSingle", m.get("commonname"));
        }
        formatted.put("nameComplete", m.get("name"));
        formatted.put("occCount", m.get("count"));
        formatted.put("distributionsCount", m.get("distributionsCount"));
        formatted.put("checklistsCount", m.get("checklistsCount"));
        formatted.put("tracksCount", m.get("tracksCount"));
        SpeciesImageDTO speciesImage = (SpeciesImageDTO)m.get("images");
        if (speciesImage != null && speciesImage.getImage() != null) {
            try {
                Map im = Config.mediaStore().getImageFormats(speciesImage.getImage());
                formatted.put("imageSource", speciesImage.getDataResourceUid());
                formatted.put("imageCount", speciesImage.getCount());
                formatted.put("image", im.get("raw"));
                formatted.put("thumbnail", im.get("thumbnail"));
                formatted.put("imageUrl", im.get("raw"));
                formatted.put("smallImageUrl", im.get("small"));
                formatted.put("largeImageUrl", im.get("large"));
                formatted.put("thumbnailUrl", im.get("thumbnail"));
                formatted.put("imageMetadataUrl", this.imageMetadataService.getUrlFor(speciesImage.getImage()));
            }
            catch (Exception ex) {
                logger.warn((Object)("Unable to get image formats for " + speciesImage.getImage() + ": " + ex.getMessage()));
                formatted.put("imageCount", 0);
            }
        } else {
            formatted.put("imageCount", 0);
        }
        formatted.put("isExcluded", false);
        return formatted;
    }
}

