/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.RestartDataService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="authService")
public class AuthService {
    private static final Logger logger = Logger.getLogger(AuthService.class);
    @Inject
    protected RestOperations restTemplate;
    @Value(value="${auth.user.details.url}")
    protected String userDetailsUrl = null;
    @Value(value="${auth.user.names.id.path:getUserList}")
    protected String userNamesForIdPath = null;
    @Value(value="${auth.usernames.for.numeric.id.path:getUserListWithIds}")
    protected String userNamesForNumericIdPath = null;
    @Value(value="${auth.usernames.full.path:getUserList}")
    protected String userNamesFullPath = null;
    @Value(value="${auth.user.details.path:getUserDetails}")
    protected String userDetailsPath = null;
    @Value(value="${auth.startup.initialise:false}")
    protected boolean startupInitialise = false;
    @Value(value="${caches.auth.enabled:true}")
    protected Boolean enabled = true;
    protected Map<String, String> userNamesById = (Map)RestartDataService.get((Object)this, (String)"userNamesById", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    protected Map<String, String> userNamesByNumericIds = (Map)RestartDataService.get((Object)this, (String)"userNamesByNumericIds", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);
    protected Map<String, String> userEmailToId = (Map)RestartDataService.get((Object)this, (String)"userEmailToId", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, HashMap.class);

    public AuthService() {
        logger.info((Object)("Instantiating AuthService: " + this));
        if (this.startupInitialise) {
            logger.info((Object)"Loading auth caches now");
            this.reloadCaches();
        }
    }

    public Map<String, String> getMapOfAllUserNamesById() {
        return this.userNamesById;
    }

    public Map<String, String> getMapOfAllUserNamesByNumericId() {
        return this.userNamesByNumericIds;
    }

    public Map<String, String> getMapOfEmailToId() {
        return this.userEmailToId;
    }

    public String getDisplayNameFor(String value) {
        String displayName = value;
        if (value != null) {
            displayName = this.userNamesById.containsKey(value) ? (String)this.userNamesById.get(value) : (this.userNamesByNumericIds.containsKey(value) ? (String)this.userNamesByNumericIds.get(value) : displayName.replaceAll("\\@\\w+", "@.."));
        }
        return displayName;
    }

    public String substituteEmailAddress(String raw) {
        return raw == null ? raw : raw.replaceAll("\\@\\w+", "@..");
    }

    private void loadMapOfAllUserNamesById() {
        String jsonUri = this.userDetailsUrl + this.userNamesForIdPath;
        try {
            logger.info((Object)("authCache requesting: " + jsonUri));
            Map m = (Map)this.restTemplate.postForObject(jsonUri, null, Map.class, new Object[0]);
            if (m != null && m.size() > 0) {
                this.userNamesById = m;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error for " + jsonUri + ": " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void loadMapOfAllUserNamesByNumericId() {
        String jsonUri = this.userDetailsUrl + this.userNamesForNumericIdPath;
        try {
            logger.info((Object)("authCache requesting: " + jsonUri));
            Map m = (Map)this.restTemplate.postForObject(jsonUri, null, Map.class, new Object[0]);
            if (m != null && m.size() > 0) {
                this.userNamesByNumericIds = m;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error for " + jsonUri + ": " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void loadMapOfEmailToUserId() {
        String jsonUri = this.userDetailsUrl + this.userNamesFullPath;
        try {
            logger.info((Object)("authCache requesting: " + jsonUri));
            Map m = (Map)this.restTemplate.postForObject(jsonUri, null, Map.class, new Object[0]);
            if (m != null && m.size() > 0) {
                this.userEmailToId = m;
            }
            logger.info((Object)("authCache userEmail cache: " + this.userEmailToId.size()));
            if (this.userEmailToId.size() > 0) {
                String email = (String)this.userEmailToId.keySet().iterator().next();
                String id = (String)this.userEmailToId.get(email);
                logger.info((Object)("authCache userEmail example: " + email + " -> " + id));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error for " + jsonUri + ": " + ex.getMessage()), (Throwable)ex);
        }
    }

    @Scheduled(fixedDelay=600000L)
    public void reloadCaches() {
        4 thread = new /* Unavailable Anonymous Inner Class!! */;
        if (this.userDetailsPath.length() > 0) {
            thread.start();
        } else {
            thread.run();
        }
    }

    public List getUserRoles(String userId) {
        List roles = new ArrayList();
        try {
            String jsonUri = this.userDetailsUrl + this.userDetailsPath + "?userName=" + userId;
            logger.info((Object)("authCache requesting: " + jsonUri));
            roles = (List)((Map)this.restTemplate.postForObject(jsonUri, null, Map.class, new Object[0])).get("roles");
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
        }
        return roles;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ void access$100(AuthService x0) {
        x0.loadMapOfAllUserNamesById();
    }

    static /* synthetic */ void access$200(AuthService x0) {
        x0.loadMapOfAllUserNamesByNumericId();
    }

    static /* synthetic */ void access$300(AuthService x0) {
        x0.loadMapOfEmailToUserId();
    }
}

