/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.ValidationRuleDTO;
import au.org.ala.biocache.model.ValidationRule;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.AssertionUtils;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.biocache.web.AssertionController;
import java.io.InputStream;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocumentList;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ValidationRuleController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(AssertionController.class);
    @Inject
    protected AssertionUtils assertionUtils;
    @Inject
    protected AuthService authService;
    @Inject
    protected SpeciesLookupService speciesLookupService;
    @Inject
    protected SearchDAO searchDAO;

    @RequestMapping(value={"/validation/rules", "/validation/rules/", "/assertions/queries", "/assertions/queries/"}, method={RequestMethod.GET})
    @ResponseBody
    public ValidationRule[] getValidationRules() throws Exception {
        return Store.getValidationRules();
    }

    @RequestMapping(value={"/validation/rule/{uuid}", "/validation/rule/{uuid}/", "/assertions/query/{uuid}", "/assertions/query/{uuid}/"}, method={RequestMethod.GET})
    @ResponseBody
    public ValidationRule getValidationRule(@PathVariable(value="uuid") String uuid, HttpServletRequest request) throws Exception {
        String apiKey = request.getParameter("apiKey");
        if (apiKey != null) {
            return Store.getValidationRule((String)(apiKey + "|" + uuid));
        }
        return Store.getValidationRule((String)uuid);
    }

    @RequestMapping(value={"/validation/rules/{uuids}", "/validation/rules/{uuids}/", "/assertions/queries/{uuids}", "/assertions/queries/{uuids}/"}, method={RequestMethod.GET})
    @ResponseBody
    public ValidationRule[] getValidationRules(@PathVariable(value="uuids") String uuids, HttpServletRequest request) throws Exception {
        ValidationRule[] aqs;
        String apiKey = request.getParameter("apiKey");
        for (ValidationRule aq : aqs = apiKey != null ? Store.getValidationRules((String[])(apiKey + "|" + uuids.replaceAll(",", "," + apiKey + "|")).split(",")) : Store.getValidationRules((String[])uuids.split(","))) {
            aq.setUserName(this.authService.getDisplayNameFor(aq.getUserName()));
        }
        return aqs;
    }

    @RequestMapping(value={"/assertions/query/{uuid}/apply", "/assertions/query/{uuid}/apply/", "/validation/rule/{uuid}/apply", "/validation/rule/{uuid}/apply/"}, method={RequestMethod.GET})
    @ResponseBody
    public String applyValidationRule(@PathVariable(value="uuid") String uuid, HttpServletRequest request) throws Exception {
        String apiKey = request.getParameter("apiKey");
        if (apiKey != null) {
            Store.applyValidationRule((String)(apiKey + "|" + uuid));
        } else {
            Store.applyValidationRule((String)uuid);
        }
        return "Success";
    }

    @RequestMapping(value={"/validation/rules/rematch"})
    public void reinitialiseRules(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectMapper om = new ObjectMapper();
        if (this.shouldPerformOperation(request, response)) {
            int count = 0;
            int changed = 0;
            int notfound = 0;
            for (ValidationRule vr : Store.getValidationRules()) {
                String rawValue = vr.getRawAssertion();
                ValidationRuleDTO validationRuleDTO = (ValidationRuleDTO)om.readValue(rawValue, ValidationRuleDTO.class);
                if (validationRuleDTO == null || validationRuleDTO.getSpecies() == null) continue;
                ++count;
                String guid = this.speciesLookupService.getGuidForName(validationRuleDTO.getSpecies());
                if (guid != null) {
                    if (vr.getRawQuery().contains(guid)) continue;
                    logger.warn((Object)("GUID has changed OLD:" + vr.getRawQuery() + " new : " + guid));
                    ++changed;
                    vr.setWkt(validationRuleDTO.getArea());
                    vr.setRawQuery(this.getRawQuery(null, guid, vr.getWkt()));
                    Store.addValidationRule((ValidationRule)vr);
                    continue;
                }
                logger.warn((Object)("Unable to find species " + validationRuleDTO.getSpecies()));
                ++notfound;
            }
            logger.info((Object)("Finished rematching the validation rules to species. Total records checked: " + count + ". Changed: " + changed + " . Not found: " + notfound));
        }
    }

    @RequestMapping(value={"/assertions/query/add", "/validation/rule/add"}, method={RequestMethod.POST})
    public void addValidationRule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block9: {
            try {
                String rawValue = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
                logger.debug((Object)("The raw value :" + rawValue));
                try {
                    ObjectMapper om = new ObjectMapper();
                    ValidationRuleDTO validationRuleDTO = (ValidationRuleDTO)om.readValue(rawValue, ValidationRuleDTO.class);
                    if (!this.shouldPerformOperation(validationRuleDTO.getApiKey(), response)) break block9;
                    if (validationRuleDTO.getStatus().equals("deleted")) {
                        Store.deleteValidationRule((String)(validationRuleDTO.getApiKey() + "|" + validationRuleDTO.getId()), (Date)validationRuleDTO.getLastModified());
                        break block9;
                    }
                    String guid = this.speciesLookupService.getGuidForName(validationRuleDTO.getSpecies());
                    if ((guid != null || validationRuleDTO.getQuery() != null) && validationRuleDTO.getId() != null) {
                        SpatialSearchRequestParams ssr = new SpatialSearchRequestParams();
                        String query = guid != null ? "lsid:" + guid : validationRuleDTO.getQuery();
                        ssr.setQ(query);
                        ssr.setWkt(validationRuleDTO.getArea());
                        ssr.setFacet(Boolean.valueOf(false));
                        try {
                            SolrDocumentList list = this.searchDAO.findByFulltext(ssr);
                            Long recordCount = list.getNumFound();
                            logger.debug((Object)("Validation rule should apply to records: " + recordCount));
                            ValidationRule validationRule = new ValidationRule();
                            validationRule.setId(validationRuleDTO.getId().toString());
                            validationRule.setApiKey(validationRuleDTO.apiKey);
                            validationRule.setRawAssertion(rawValue);
                            validationRule.setWkt(validationRuleDTO.area);
                            validationRule.setComment(validationRuleDTO.getComment());
                            String userId = (String)this.authService.getMapOfEmailToId().get(validationRuleDTO.user.getEmail());
                            validationRule.setUserId(userId);
                            validationRule.setUserEmail(validationRuleDTO.user.getEmail());
                            validationRule.setAuthority(validationRuleDTO.user.getAuthority().toString());
                            validationRule.setRawQuery(this.getRawQuery(validationRuleDTO.getQuery(), guid, validationRuleDTO.getArea()));
                            if (validationRuleDTO.getStatus().equals("new")) {
                                validationRule.setCreatedDate(validationRuleDTO.getLastModified());
                            }
                            Store.addValidationRule((ValidationRule)validationRule);
                        }
                        catch (Exception e) {
                            response.sendError(400, "Unable to construct a valid validation rule from the provided information. " + validationRuleDTO.getId());
                            logger.error((Object)"Error constructing query or adding to datastore", (Throwable)e);
                        }
                        break block9;
                    }
                    response.sendError(400, "Unable to locate species " + validationRuleDTO.getSpecies() + " for validation rule " + validationRuleDTO.getId());
                }
                catch (Exception e) {
                    response.sendError(400, e.getMessage());
                    logger.error((Object)"Unable to resolve message to known type", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                response.sendError(400);
            }
        }
    }

    private String getRawQuery(String query, String guid, String wkt) {
        StringBuilder sb = new StringBuilder("?q=");
        if (guid != null) {
            sb.append("lsid:").append(guid);
        } else if (query != null) {
            sb.append(query);
        } else {
            sb.append("*:*");
        }
        if (wkt != null) {
            sb.append("&wkt=").append(wkt);
        }
        return sb.toString();
    }

    @RequestMapping(value={"/occurrences/{recordUuid}/validationRules", "/occurrences/{recordUuid}/validationRules/", "/occurrences/{recordUuid}/assertionQueries", "/occurrences/{recordUuid}/assertionQueries/"}, method={RequestMethod.GET})
    @ResponseBody
    public ValidationRule[] getValidationRules(@PathVariable(value="recordUuid") String recordUuid) throws Exception {
        return this.assertionUtils.getQueryAssertions(recordUuid);
    }

    public void setAssertionUtils(AssertionUtils assertionUtils) {
        this.assertionUtils = assertionUtils;
    }

    public void setAuthService(AuthService authService) {
        this.authService = authService;
    }

    public void setSpeciesLookupService(SpeciesLookupService speciesLookupService) {
        this.speciesLookupService = speciesLookupService;
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }
}

